function a = probdist_alpha(varargin)
% PROBDIST_ALPHA Create a new probability distribution with coefficients
% for damped adaptation of values
%

% (c) Antti Honkela 1999-2000

% Prefer mathematical operations of alpha_probdist over those of probdist
inferiorto('mprobdist')
superiorto('probdist')

% Do our best depending on the number of input arguments
switch nargin
 case 0
  b = probdist(0, 1);
  a.malpha = 0;
  a.valpha = 0;
  a.msign = 0;
  a.vsign = 0;
  a = class(a, 'probdist_alpha', b);
 case 1
  if (isa(varargin{1}, 'probdist_alpha'))
    a = varargin{1};
  else
    b = probdist(varargin{1});
    a.malpha = ones(size(b));
    a.valpha = ones(size(b));
    a.msign = zeros(size(b));
    a.vsign = zeros(size(b));
    a = class(a, 'probdist_alpha', b);
  end
 case 2
  b = probdist(varargin{1}, varargin{2});
  a.malpha = ones(size(b));
  a.valpha = ones(size(b));
  a.msign = zeros(size(b));
  a.vsign = zeros(size(b));
  a = class(a, 'probdist_alpha', b);
 case 3
  error('probdist_alpha: Bad number of arguments for initialization')
 case 4
  b = probdist(varargin{1}, varargin{2});
  a.malpha = varargin{3};
  a.valpha = varargin{4};
  a.msign = zeros(size(b));
  a.vsign = zeros(size(b));
  a = class(a, 'probdist_alpha', b);
 case 6
  b = probdist(varargin{1}, varargin{2});
  a.malpha = varargin{3};
  a.valpha = varargin{4};
  a.msign = varargin{5};
  a.vsign = varargin{6};
  a = class(a, 'probdist_alpha', b);
end
