function b = subsref(a, index)
% SUBSREF implement subscripted reference for probdists

% Antti Honkela 1999

switch index(1).type
 case '.'
  switch index(1).subs
   case 'e'
    b = a.expection;
   case 'var'
    b = a.variance;
  end
 case '()'
  b = probdist(a.expection(index(1).subs{:}), ...
	       a.variance(index(1).subs{:}));
 otherwise
  error('Unsupperted function')
end

% Handle possible other references recursively
if length(index) > 1
  b = subsref(b, index(2:end));
end
