/*
 * Copyright (c) 2000, 2001, 2002 by Gustavo Broos.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.0
 * of the License, or (at your option) any later version.
 *
 * VKBInputToProcess.h: File to be parsed by gcc to generate pilrc files for
 * hack or stand alone versions of the program.
 *
 */

//** do not forget to update version if necessary **
#define sversion "2.6b"

#ifdef HACK
#define verbosever "Version 2.6b Hack"
#else
#define verbosever "Version 2.6b SE"
#endif

//some strings for the about box
#define sweb "GNU GPL 2.0 licensed."
#define smail "Contact me: gbroos@email.com"

//app name
#define appName "VirtualKB"

#ifdef HACK

TRAP ID keyboardTrap 0xA2E2 //sysTrapSysKeyboardDialog, the Palm trap for the keyboard

APPLICATIONICONNAME ID 3000 appName

#else //for stand alone build

APPLICATIONICONNAME ID appIconName appName

ICONFAMILY "../data/icons/idkb1.bmp" "" "" "../data/icons/idkb8.bmp" TRANSPARENT 255 255 255

SMALLICONFAMILY "../data/icons/isdkb1.bmp" "" "" "../data/icons/isdkb8.bmp" TRANSPARENT 255 255 255

APPLICATION ID 1 "D-KB" //evidence that VKB has evolved to replace DKB o)

#endif

VERSION ID 1 sversion

//main form

FORM ID VKBFrm AT (0 0 widthScreen heightScreen)

MODAL

DEFAULTBTNID doneBtn

BEGIN

  BUTTON "Find" ID findFindBtn AT (RIGHT@widthScreen-margin margin+1 widthBtn heightBtn) NONUSABLE

  FIELD ID findFld AT (0 PREVTOP PREVLEFT-margin2 heightLine+1) NONUSABLE UNDERLINED MAXCHARS 20

  BUTTON "Replace" ID rplcBtn AT (RIGHT@widthScreen-margin PREVBOTTOM+margin2 3*widthBtn/2 heightBtn) NONUSABLE

  FIELD ID rplcFld AT (0 PREVTOP PREVLEFT-margin2 heightLine+1) NONUSABLE UNDERLINED MAXCHARS 20

  BUTTON "Replace All" ID rplcABtn AT (RIGHT@widthScreen-margin PREVBOTTOM+margin2 2*widthBtn heightBtn) NONUSABLE

  BUTTON "Done" ID findDoneBtn AT (margin PREVTOP widthBtn heightBtn) NONUSABLE

  CHECKBOX "exact" ID findExactCheck AT (PREVRIGHT+10 PREVTOP widthBtn+10 heightBtn) NONUSABLE

  LABEL "Text:" ID sctextLbl AT (margin margin+1) NONUSABLE

  FIELD ID sctextFld AT (PREVRIGHT+margin2 PREVTOP widthBtn*4 2*heightLine+1) NONUSABLE UNDERLINED MULTIPLELINES MAXCHARS 45

  LABEL "Name:" ID scnameLbl AT (margin PREVBOTTOM+margin2) NONUSABLE

  FIELD ID scnameFld AT (PREVRIGHT+margin2 PREVTOP widthBtn+33 heightLine+1) NONUSABLE UNDERLINED MAXCHARS 8

  BUTTON "Cancel" ID sccancelBtn AT (RIGHT@widthScreen-margin PREVTOP widthBtn-1 heightBtn) NONUSABLE

  BUTTON "Add" ID scaddBtn AT (RIGHT@PREVLEFT-margin2-1 PREVTOP widthBtn-12 heightBtn) NONUSABLE

  BUTTON "Done" ID doneBtn AT (margin BOTTOM@heightScreen-margin-1 widthBtn heightBtn)

  PUSHBUTTON "abc" ID abcPush AT (PREVRIGHT+(2*margin)+1 PREVTOP widthBtn/2+1 heightBtn) GROUP 1

  PUSHBUTTON "123" ID numPush AT (PREVRIGHT+1 PREVTOP widthBtn/2+1 heightBtn) GROUP 1

  CHECKBOX "Int'l" ID intlCheck AT (PREVRIGHT+(2*margin)+1 PREVTOP widthBtn heightBtn)

  BUTTON "\002" ID leftBtn AT (PREVRIGHT+(2*margin) PREVTOP-margin hRBtn+margin2 wRBtn) NOFRAME FONT 4

  BUTTON "\003" ID rightBtn AT (PREVRIGHT-margin PREVTOP PREVWIDTH PREVHEIGHT) NOFRAME FONT 4

  FIELD ID textFld AT (0 heightTitle widthScreen-wScroll heightLine*5+1) NONUSABLE UNDERLINED MULTIPLELINES MAXCHARS 1

  SCROLLBAR ID kbScroll AT (RIGHT@widthScreen PREVTOP wScroll PREVHEIGHT) VALUE 0 MIN 0 MAX 0 PAGESIZE 0

  GADGET ID VKBGdt AT (0 PREVBOTTOM+(2*margin) widthScreen heightScreen-PREVHEIGHT-heightTitle-heightBtn-(5*margin))

  REPEATBUTTON "\001" ID upRBtn AT (RIGHT@widthScreen-1 PREVBOTTOM+margin-1 wRBtn hRBtn+margin) NOFRAME FONT 5

  REPEATBUTTON "\002" ID downRBtn AT (PREVLEFT PREVBOTTOM PREVWIDTH PREVHEIGHT) NOFRAME FONT 5

  GRAFFITISTATEINDICATOR AT (RIGHT@widthScreen-(2*wRBtn)+5 heightScreen-heightBtn-2)

END

//main menu

MENU ID VKBMenu
BEGIN

  PULLDOWN "Edit"
  BEGIN

    MENUITEM "Undo" ID undoMItem "U"
    MENUITEM "Cut" ID cutMItem "X"
    MENUITEM "Copy" ID copyMItem "C"
    MENUITEM "Paste" ID pasteMItem "P"
    MENUITEM "Select All" ID selectAllMItem "S"
    MENUITEM "Find" ID searchMItem "F"
    MENUITEM "Go to Top" ID startMItem "T"
    MENUITEM "Go to Bottom" ID endMItem "B"

  END

  PULLDOWN "Shortcuts"
  BEGIN

    MENUITEM "New shortcut" ID newMacroMItem "N"
    MENUITEM "Date stamp" ID dsMItem "D"
    MENUITEM "Date and Time Stamp" ID dtsMItem "A"
    MENUITEM "Time Stamp" ID tsMItem "H"

  END

END

//setup form

FORM ID setupFrm AT (0 0 widthScreen heightScreen)
HELPID setupHelp
DEFAULTBTNID setupDoneBtn
MENUID optionsMenu

BEGIN

  TITLE "                           "

#ifdef HACK

  BUTTON "Done" ID setupDoneBtn AT (margin2 BOTTOM@heightScreen-margin-1 widthBtn heightBtn)

  BUTTON "Read Me" ID setupHelpBtn AT (PREVRIGHT+margin2+1 PREVTOP widthBtn+(widthBtn/2) heightBtn)

#else

  BUTTON "Read Me" ID setupHelpBtn AT (margin2 BOTTOM@heightScreen-margin-1 widthBtn+(widthBtn/2) heightBtn)

#endif

  FORMBITMAP AT (0 heightTitle2) BITMAP logoBitmap

#ifndef HACK

  CHECKBOX "Enable VirtualKB" ID setupEnableCheck AT (8*margin2 heightTitle2+6  widthBtn*3 heightBtn)

  CHECKBOX "Int'l at start" ID setupIntlCheck AT (margin2 PREVBOTTOM+margin2 widthBtn*2+4 heightBtn)

#else

  CHECKBOX "Int'l at start" ID setupIntlCheck AT (margin2 PREVBOTTOM+12 widthBtn*2+4 heightBtn)

#endif

  CHECKBOX "123 at start" ID setup123Check AT (PREVRIGHT+margin2 PREVTOP widthBtn*2+4 heightBtn)

  CHECKBOX "KB undo" ID setupSysUndoCheck AT (margin2 PREVBOTTOM+margin2 widthBtn*2+4 heightBtn)

  CHECKBOX "No click" ID setupNoSoundCheck AT (PREVRIGHT+margin2 PREVTOP widthBtn*2+6 heightBtn)

  CHECKBOX "AShift lock" ID setupAutoshiftLockCheck AT (margin2 PREVBOTTOM+margin2 widthBtn*2+4 heightBtn)

  CHECKBOX "Fast keys" ID setupPenUpCheck AT (PREVRIGHT+margin2 PREVTOP widthBtn*2+10 heightBtn)

  CHECKBOX "Fixed width" ID setupWidthCheck AT (margin2 PREVBOTTOM+margin2 widthBtn*2+4 heightBtn)

  CHECKBOX "Abc unused" ID setupAbcCheck AT (PREVRIGHT+margin2 PREVTOP widthBtn*2+10 heightBtn)

  CHECKBOX "Key repeat" ID setupRepeatCheck AT (margin2 PREVBOTTOM+margin2 widthBtn*2+4 heightBtn)

  LABEL "Color:" ID kbcolorLbl AT (margin2+margin PREVTOP+heightBtn+margin2)

  POPUPTRIGGER "            " ID colorPopUp AT (PREVRIGHT+margin2 PREVTOP widthBtn+15 heightBtn) LEFTANCHOR

  LIST "Default" "White" "Gray" "Black" "Yellow" "Green" "Blue" "Red"  ID colorList AT (PREVLEFT PREVTOP widthBtn+15 1) VISIBLEITEMS 4 NONUSABLE

  POPUPLIST ID colorPopUp colorList

END

BITMAPFAMILY ID logoBitmap "../data/icons/idkb1.bmp" "" "" "../data/icons/idkb8.bmp" TRANSPARENT 255 255 255

STRING ID setupHelp FILE "../data/text/help.txt"

//about form

FORM ID aboutFrm AT (margin margin widthScreen-(2*margin) heightScreen-(2*margin))
DEFAULTBTNID aboutOkBtn
MODAL

BEGIN

  TITLE "About VirtualKB"

  BUTTON "OK" ID aboutOkBtn AT (margin2 BOTTOM@heightScreen-margin2-3 widthBtn heightBtn)

  FORMBITMAP AT (0 heightTitle2) BITMAP logoBitmap

  LABEL "VirtualKB" ID AUTOID AT (8*margin2+margin PREVTOP+margin2) FONT 1

  LABEL verbosever ID AUTOID AT (PREVLEFT PREVBOTTOM+margin2) FONT 1

  LABEL "FREE SOFTWARE" ID AUTOID AT (PREVLEFT PREVBOTTOM+margin2) FONT 1

  LABEL "Copyright \251 2002 Gustavo Broos." ID AUTOID AT (margin2 PREVBOTTOM+(5*margin2))

  LABEL sweb ID AUTOID AT (margin2 PREVBOTTOM+margin2)

  LABEL smail ID AUTOID AT (margin2 PREVBOTTOM+margin2)

END

MENU ID optionsMenu
BEGIN

  PULLDOWN "Options"
  BEGIN

    MENUITEM "About VirtualKB" ID aboutMItem

  END

END

//alerts

ALERT ID searchEnded

DEFAULTBUTTON 0
ERROR

BEGIN

  TITLE "End of text reached"

  MESSAGE "Press the button again to start from the beginning."

  BUTTONS "OK"

END

ALERT ID macroNotEnteredAlert

DEFAULTBUTTON 0
ERROR

BEGIN

  TITLE "Shortcut not added"

  MESSAGE "The shortcut conflicts with an already present one: ^1."

  BUTTONS "OK"

END

ALERT ID macroNotEnteredAlert1

DEFAULTBUTTON 0
ERROR

BEGIN

  TITLE "Shortcut not added"

  MESSAGE "Error while trying to add shortcut."

  BUTTONS "OK"

END

ALERT ID macroNotEnteredAlert2

DEFAULTBUTTON 0
ERROR

BEGIN

  TITLE "Shortcut not added"

  MESSAGE "Name or text missing."

  BUTTONS "OK"

END

ALERT ID replaceEmptyAlert

DEFAULTBUTTON 0
WARNING

BEGIN

  TITLE "Replace field empty"

  MESSAGE "The search string will be erased, OK to continue ?"

  BUTTONS "Cancel" "OK"

END

ALERT ID replaceAskAlert

DEFAULTBUTTON 0
WARNING

BEGIN

  TITLE "Confirmation"

  MESSAGE "Replace this ?"

  BUTTONS "Yes" "No" "Stop"

END

ALERT ID replaceEndAlert

DEFAULTBUTTON 0
INFORMATION

BEGIN

  TITLE "Done replacing"

  MESSAGE "^1 replace(s) made."

  BUTTONS "OK"

END

ALERT ID noOverlay

DEFAULTBUTTON 0
INFORMATION

BEGIN

  TITLE "No overlay loaded"

  MESSAGE "Please exit the keyboard, then install a layout overlay file (such as the included palm.pdb)."

  BUTTONS "OK"

END

//more critical alerts

ALERT ID databaseAlert

DEFAULTBUTTON 0
ERROR

BEGIN

  TITLE "Database error"

  MESSAGE "The device may be low on memory."

  BUTTONS "OK"

END

ALERT ID installAlert

DEFAULTBUTTON 0
ERROR

BEGIN

  TITLE "Enable/Disable error"

  MESSAGE "Please report."

  BUTTONS "OK"

END

ALERT ID RomIncompatibleAlert

DEFAULTBUTTON 0
ERROR

BEGIN

  TITLE "Rom incompatible"

  MESSAGE "This application needs PalmOS 2.0 or later."

  BUTTONS "OK"

END

//customizable alert

ALERT ID customErrorAlert

DEFAULTBUTTON 0
ERROR

BEGIN

  TITLE "Error"

  MESSAGE "^1"

  BUTTONS "OK"

END

//strings

//do not make len < 12 (for non-text, only ID, error output)
//check buffer used in each case
//less verbose critical errors
//                                                 1         2         3         4         5
//                                        12345678901234567890123456789012345678901234567890
STRING ID cantStart                      "VK:Cannot start."
STRING ID notEnoughMemory                "VK:No Memory."
STRING ID cantLockCode1                  "VK:Cannot lock code."
STRING ID cantUnsetTrap                  "VK:Cannot unset trap."
STRING ID cantProtectDatabase            "VK:Cannot protect database."
STRING ID switchToSysUndo                "VK:Switching to system undo."
STRING ID extUndError                    "VK:Please disable KB undo."
STRING ID errorLoadingOverlay            "VK:Error loading layout."

//title
STRING ID titleNormal                    "VirtualKB setup"

//toolbar icons
BITMAP ID undoBmp  "../data/icons/undo.bmp"
BITMAP ID redoBmp  "../data/icons/redo.bmp"
BITMAP ID cutBmp  "../data/icons/cut.bmp"
BITMAP ID copyBmp  "../data/icons/copy.bmp"
BITMAP ID pasteBmp  "../data/icons/paste.bmp"
BITMAP ID findBmp  "../data/icons/find.bmp"
BITMAP ID infoBmp  "../data/icons/info.bmp"
BITMAP ID shortcutBmp  "../data/icons/shortcut.bmp"
BITMAP ID sallBmp  "../data/icons/sall.bmp"
