/*
 * Copyright (c) 2000, 2001, 2002 by Gustavo Broos.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.0
 * of the License, or (at your option) any later version.
 *
 * VKBInput.h: Keyborad trap structures and configuration constants, etc.
 *
 */

#ifndef _VKBH_
#define _VKBH_

//application constants
//type and creator
#ifdef HACK
#define appType 'HACK'
#else
#define appType 'appl'
#endif
#define appCreator 'D-KB'
//main resources
#define vkbInitForm 65535
#define vkbInitMenu 65534
#define showHelp 65533
#define CARD 0

//accents
#define noAcc 0
#define acuteAcc 1
#define graveAcc 2
#define circumflexAcc 3
#define diaeresisAcc 4
#define tildeAcc 5

//refresh/repaint operations
#define refreshing 8
#define refreshShift 1
#define refreshAcc 2
#define accKey 4
#define accKeyAux 16

//options
#define resetOptions 0U		//intended for default options, test if changed
#define intlStart 8U 		//start with international keypad
#define numStart 16U		//start with numeric keypad
#define kbEnabled 32U		//for stand-alone version
#define leaveSetup 64U		//auxiliary
#define oprepeat 128U		//key repeat option
#define kbUndo 1024U		//use extended undo
#define noSound 2048U		//do not make key clicks
#define autoshiftLock 4096U	//autoshift lock

//color options
#define fcol1 8192U
#define fcol2 16384U
#define fcol3 32768U
#define colorMask (fcol1+fcol2+fcol3)
#define color1 0U
#define color2 fcol1
#define color3 fcol2
#define color4 fcol2+fcol1
#define color5 fcol3
#define color6 fcol3+fcol1
#define color7 fcol3+fcol2
#define color8 fcol3+fcol2+fcol1

#define opendown 1U		//fast keys
#define wide  2U		//use max field width
#define noabc 4U		//do not react to abc tap, launch previous keyboard

//draw operations
#define kbRead 1	//perform key action
#define kbInvert 2	//handle virtual keys visual feedback
#define kbDrawIntl 3	//refresh international keypad
#define kbDrawAll 4	//refresh active keypads
#define kbDraw123 5	//refresh numeric keypad
#define kbDrawAlpha 6	//refresh alphabetic keypad

//operation flags
#define spNone 0U		//clear operation flags
#define setShift 32U		//used for tracking autoshift
#define keyInvert 64U		//used for keys visual feedback
#define resize 256U		//resize text field
#define numUp 512U		//numeric keypad is up
#define intlUp 1024U		//international keypad is up
#define extendedOn 2048U	//mini-dialogs are on
#define kbshortcut 16384U	//used for tracking autoshift
//new special flags
#define accentedChars 4U	//allow accented chars
#define oneByte 16U		//try to work according to charset char width
#define spExtUndo 32U		//extended undo is on
#define spNoSound 64U		//not making key clicks
#define forceNoTrans 128U	//auxiliary for extended undo

//intl keypad dimensions
#define intlCharsX 16

//features
#define prevTrap 1000	//previous trap
#define kbOptions 1	//setup options
#define kbParams 2	//hack globals
#define kbRunning 3	//ignore multiple calls
#define swidb 5		//information database
#define VKBdb 7		//main code and resources database
#define noClose 8	//do not close main database if we found it open
#define hackConfReset 9	//unexpected error occurred during hack manager configuration

//extended undo trap features
#define fUndDel 1001
#define fUndIns 1002
#define fUndUnd 1003
#define fUndHan 1004
#define fUndPtr 1005
#define fUndHev 1006

//some records
#define iOptions 0 //user options to be stored in a db to survive resets
#define swidbNumRecords 1 //see applicationStart on VKBShared.c

//databases
#define SWINFO 'SWIN'
#define swInfoName "D-KB-sWInfo" //sWInfo was shareware info, now holds some preferences
#define EXUND 'EUND'
#define undoDBName "D-KB-ExUnd" //extended undo database (Palm data bases are fast enough)

//keyboard components dimensions
#define totalLines 11	//total lines reserved for text (in standard font)
#define intlLines 1	//international keypad lines

//toolbar configuration
#define separation 18  //length of a toolbar icon plus margins
#define iconLength 15  //length of a toolbar icon
#define iconoffset ((separation-iconLength)/2) //auxiliary, margin
#define direc 0        //horizontal or vertical (theoretical, only horizontal is used)
#define skipx 0        //left margin
#define skipy 2        //top margin
#define startindex 1
#define numicons 9     //number of maximum toolbar icons
#define lastoffset (1*separation) //separation from main icons to help or info icon

//ext undo
//errors
#define UndCantErr 8	//fatal error
#define UndEmpty 7	//undo list empty
#define UndNoMore 6	//cannot undo any more
#define UndGenErr 5	//other error
#define UndNoErr 0	//no error

//who is doing undo
#define UndTRedo 1	//type doing redo
#define UndTUndo 0	//type doing undo
#define UndTNormal 2	//type editing

//operation
#define UndZero 0	//a value
#define UndOne 1	//a value
#define UndTrans 3	//a value
#define UndAddO 0	//add operation default
#define UndAddT 3	//add operation transaction mark

#define UndTran 2	//values greater are transactional, lower are default

#define UndRemO 1	//remove operation default
#define UndRemT 4	//remove operation transaction mark

//type of character
#define UndCN 0		//none
#define UndCD 1		//delete character
#define UndCA 2		//character to add

//limits
#define UndDepth 128	//undo steps depth
#define UndMFree 2	//how many kb should be free for the ext. undo to operate (heuristic)

//strings
#define fieldFullAlert "Cannot replace because field is full."
//wide international chars
#define internationalChars \
	"\0\264\0`\0^\0\0~\0\0\0\346\0\370\0\345\0\337\0\273\0\0\200\0\243\0\245\0\0\265\0\203\0\247"

//undo header structure
typedef struct undstr {
  short uType;
  UInt16 textPos;
} UndOp;

//into the heap variables, this try to save some stack at heap cost
//temporal initialization variables
typedef struct st2 {
  FormPtr aForm;
  Word index,kbTextIndex,tsize,tempShift,inspt,start,end,maxc,font,scrollp;
  Handle text,textaux;
  FieldPtr kbText,appText;
  FieldAttrType attrs;
  RectangleType bounds;
  Boolean numLock,capsLock,autoShift;
  DWord setupdw;
  short extentX;
} LoadLocals;

//intended to be reusable variables, are created after disposing LoadLocals.
//this are intended to keep low stack use in the main keyboard functions.
//this can be as big as the LoadLocals, since that space is already checked to exist.
typedef struct st3 {
  //this are global reusable variables, their content can change
  //after subroutine calls, so this are potential sources for obscure
  //errors if not used with extreme care
  FormPtr aForm;
  FieldPtr aField;
  Word w1;
  Boolean bo1,bo2,bo3,bo4;
  Int16 i1,i2;
} CommonGlobals;

//Globals for hack
typedef struct st1 {
  Boolean 	shift, //shift is on
  		cap, //caps lock is on
		keyNotPainted, //track if a key is inverted
		kbDown, //tracks if a virtual key is being pushed
		running, //prevent running multiple program instances
		OS35, //there is color!
  		atpenup, //enter keys after pen is up (slow keys)
		toolb, //tells that the key being pressed is a toolbar key
		keyauto, //we are repeating keys
		scStart, //we are entering a shortcut
		blockTrack; //for tracking an undo character block
  DmOpenRef 	VKBLayout, //reference to layout database
  		VKBProg, //reference to main code and resources database
		undDB; //reference to extended undo database
  UInt16 	special, //various operation parameters and options
  		special2, //various operation parameters and options
		shortcutpos, //position where shortcut operation starts
		shortcutend, //position where shortcut operation ends
		offset, //offset into the text the keyboard is editing
		blockStart, //start of an undo character block
		blockEnd, //end of an undo character block
		undMIx; //index which marks the position at which the redo items begin
  Int16 	keyRepeatInterval; //base timer resolution for key repeat
  short 	accent, //accent selected
   		gdtLinesa, //number of standard font text lines the alphabetic layout spans
		gdtLinesn, //number of standard font text lines the numeric layout spans
		undUType, //tell if undo is normal or transaction point
		refresh; //various keyboard refresh states
  WChar 	_shortcutStrokeChr,keychar; //the PalmOS shortcut char for the current OS version
  WChar* 	intl; //characters for the international keypad
  unsigned char	* stra, //characters for the alphabetic layout
  		* strb,	//characters for the numeric layout
		* markpos, //auxiliary, marks positions while scanning the layout definition
		* blockBuffer; //undo character block buffer (only used for deletes)
  BitmapType	* bmp, //image to show for the alphabetic layout
  		* bmps, //image to show for the alphabetic shifted layout
		* bmpc, //image to show for the alphabetic layout in caps mode
		* bmpsc, //image to show for the alphabetic layout in shifted caps mode
		* bmpn; //image to show for the numeric layout
  FieldPtr 	undFld, //main text field, currently used for undo checks
  		prevField; //the calling app. field
  FormPtr 	prevForm; //the calling app. form
  VoidPtr
  		extra1; //event holder
  RectangleType
  		key; //an inverted key
  UInt32 	txtaux;
  LoadLocals*
  		l1; //temporal local variables
  CommonGlobals*
  		m2; //intended to be reused variables
} KeyboardParams;

//code sections (for future use)
#define sectrap
#define secsetuph
#define secshared
#define secalone

//functions
//for keyboard trap
void LoadVKB(KeyboardType kbdType) sectrap;
Boolean VKBInputHandler(EventPtr aEvent) sectrap;
DWord MainResource(Word code) sectrap;
inline short centerChr(short cellW,char* holder) sectrap;
void  toNormal(void) sectrap;
Boolean KeyboardCall(short operation,KeyboardParams* params) sectrap;
inline void InvertButton3(short TLX,short TLY,short cellW,short cellH,short x1,short y1,
		  short width,short height,short fix1,short fix2,short fixy) sectrap;
inline void InvertButton4(RectanglePtr area) sectrap;
inline void InvertButton41(short TLX,short TLY,short cellW,short cellH,KeyboardParams* params) sectrap;
inline void InvertButton5(RectanglePtr area,KeyboardParams* params) sectrap;
inline void refreshRButtons(void) sectrap;
inline void TextScroll(DirectionType direction) sectrap;
void TextScroll1(DirectionType direction,Boolean page) sectrap;
void KeyboardLoop(void) sectrap;
inline Word Vocal(Word aChar) sectrap;
inline Boolean ReadKeyboardAll(KeyboardParams* params) sectrap;

inline void DrawKeyboardAlpha(KeyboardParams* params) sectrap;
inline void DrawKeyboardAlpha1(KeyboardParams* params,short skipv) sectrap;
inline void DrawKeyboardAlpha2(KeyboardParams* params,short skipv,short numpad) sectrap;

inline Boolean ReadKeyboardAlpha(KeyboardParams* params) sectrap;
inline Boolean ReadKeyboardAlpha1(KeyboardParams* params,short skipv) sectrap;
Boolean ReadKeyboardAlpha2(KeyboardParams* params,short skipv,short numpad) sectrap;

inline void DrawKeyboard123(KeyboardParams* params) sectrap;
void DrawKeyboard1231(KeyboardParams* params,short skipv) sectrap;

inline Boolean ReadKeyboard123(KeyboardParams* params) sectrap;
Boolean ReadKeyboard1231(KeyboardParams* params,short skipv) sectrap;

inline void DrawKeyboardIntl(KeyboardParams* params) sectrap;
void DrawKeyboardIntl1(KeyboardParams* params,short skipv) sectrap;

inline Boolean ReadKeyboardIntl(KeyboardParams* params) sectrap;
inline Boolean ReadKeyboardIntl2(KeyboardParams* params,short unAcc) sectrap;
Boolean ReadKeyboardIntl3(KeyboardParams* params,short unAcc,short skipv) sectrap;

void freeParams(KeyboardParams* params) sectrap;
inline Word RVocal(Word aChar) sectrap;
Word RVocal1(Word aChar,Word shift) sectrap;
void paintToolbar(KeyboardParams* params) sectrap;
Boolean readToolbar(KeyboardParams* params) sectrap;
inline void updateScroll(FormPtr aForm,FieldPtr kbText,RectanglePtr bounds) sectrap;
Boolean findText(Boolean sensitive,FieldType* aField,Char* texta,Char* textc,Word lenc,
	      Word len_remain,Word* end) sectrap;
void replaceText(FieldType* aField,Char* replacetext) sectrap;
Word lookMacro(KeyboardParams* params,CharPtr target, Byte tsize, Boolean* close, Boolean* got,
	       CharPtr* macro) sectrap;
void replaceText1(Boolean warn,FieldType* aField,Char* replacetext) sectrap;
inline void MSndPlaySystemSound(SndSysBeepType beepID) sectrap;
void CopySelection(FieldType* aField) sectrap;
void Color(void) sectrap;
void Color1(Boolean toolbar) sectrap;
void FldObjectDisable (FormType * formP, UInt16 objIndex) sectrap;

//Extended undo manager
Boolean UndInit(void) sectrap;
void UndEnd(void) sectrap;
void UndUndo(FieldType* aField) sectrap;
void UndRedo(FieldType* aField) sectrap;
short Und(FieldType* aField,Boolean redo) sectrap;
short Und1(FieldType* aField,Boolean redo,Boolean peek) sectrap;
UInt16 UndCheckDeleted(UndOp* uop,Char* text,UInt16 len,short utype,KeyboardParams* params) sectrap;
UInt16 UndCheckAdded(UndOp* uop,UInt16 len,short utype,KeyboardParams* params) sectrap;
inline Boolean UndCheck(void* data, UInt16 len,UInt16 atP,KeyboardParams* params) sectrap;
Boolean UndEraseLast(KeyboardParams* params,Boolean redo) sectrap;
inline Boolean UndEraseOld(KeyboardParams* params) sectrap;
inline Boolean UndCleanDB(KeyboardParams* params) sectrap;
void UndFldCut(FieldType* fldP) sectrap;
void UndFldDelete(FieldType* fldP,UInt16 start,UInt16 end) sectrap;
Boolean UndFldInsert(FieldType* fldP,Char* text,UInt16 len) sectrap;
void UndFldPaste(FieldType* fldP) sectrap;
void UndFldUndo(FieldType* fldP) sectrap;
void UndFldSetTextHandle(FieldType* fldP,MemHandle TextHandle) sectrap;
void UndFldSetTextPtr(FieldType* fldP,Char* TextPtr) sectrap;
void UndSwitch() sectrap;
inline Boolean UndOk(FieldType* fldP) sectrap;
inline Boolean UndOk2(KeyboardParams* params,FieldType* fldP) sectrap;
Boolean UndFldHandleEvent(FieldType* fldP,EventType* aEvent) sectrap;
void UndMarkTrans(KeyboardParams* params) sectrap;
void UndNoTrans(KeyboardParams* params) sectrap;
void UndToogleForceNoTrans(KeyboardParams* params) sectrap;
Boolean UndCheckBlock(KeyboardParams* params) sectrap;
Boolean ToBlock(Char aChar,KeyboardParams* params) sectrap;

//shared (always used, be it in the trap or in the configuration)
DWord startApplication(void) secshared;
void stopApplication(void) secshared;
Err RomVersionCompatible(DWord requiredVersion, Word launchFlags) secshared;
Word ShowError1(Word alertID) secshared;
Word ShowError(Word alertID,CharPtr msg1,CharPtr msg2,CharPtr msg3) secshared;
Int featureToIndex(Word feature) secshared;
void ToDatabase(Word feature,DWord value) secshared;
DWord FromDatabase(Word feature) secshared;
DWord ToFromDatabaseSub(Word feature,DmOpenRef open,DWord value) secshared;
CharPtr getString(CharPtr buffer,Int tSTRID,DmOpenRef db) secshared;

//stand-alone only
#ifndef HACK
DWord setTrap(void) secalone;
void unSetTrap(void) secalone;
void setupEventLoop(void) secalone;
Boolean AppHandleEvent(EventPtr event) secalone;
DWord lockCode1(Boolean lock) secalone;
DWord lockCode1000(Boolean lock,VoidPtr* check) secalone;
#endif

//setup handler
Boolean setupHandler(EventPtr aEvent) secsetuph;
Boolean registration(CharPtr name,CharPtr key) secsetuph;
void setupSetupForm() secsetuph;
void initArray(char* dest,const char* src,short len) secsetuph;

#ifdef HACK

//hack version dummy definitions (trap is handled by HackMaster)

#define unSetTrap() ;
#define setTrap() false

#endif


#endif
