/*
 * Copyright (c) 2000, 2001, 2002 by Gustavo Broos.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.0
 * of the License, or (at your option) any later version.
 *
 * VKBInput.c: Code to replace the Palm keyboard trap.
 *
 * This was coded before I had access to the PalmOS source code, so this is substantially
 * different from the PalmOS keyboard and may show some code that can be optimized with
 * internal knowledge of the PalmOS, but since this does not assume much about internals,
 * I hope it will survive some PalmOS new releases.
 *
 * This code implements a lot of tricks and wrappers around the PalmOS, it has suffered
 * a lot of changes from an original keyboard hack I coded, it has the usual resource
 * restrictions of a PalmIII program plus the restrictions of a hack, so this is not pretty,
 * and may show some dead code.  It is being released under the GNU GPL because the program
 * still seems useful to Palm users after Palm OS 4.0 release, and because I do not have much
 * time to work on this; that is one of the reasons why I do not clean or re-write the code
 * thoroughly.
 *
 * I like extreme programming, it has allowed me to evolve this code in little time and with
 * few major bugs.  Open Source and free software have additional advantages that practically
 * guarantee good code in all aspects (if evolving on those environments from the beginning, or
 * given enough time, but free software is philosophically preferable in my opinion).
 * I hope this is useful to you.
 *
 */

#include "VKBIncludeAll.h"
#define NON_INTERNATIONAL
#include <CharLatin.h>

//The KeyboardParams structure is used to hold some global variables
//for this hack.
//The structure is accessed through the kbParams feature.
#define aForm (params->l1->aForm)
#define index (params->l1->index)
#define kbTextIndex (params->l1->kbTextIndex)
#define tsize (params->l1->tsize)
#define tempShift (params->l1->tempShift)
#define inspt (params->l1->inspt)
#define start (params->l1->start)
#define end (params->l1->end)
#define maxc (params->l1->maxc)
#define font (params->l1->font)
#define text (params->l1->text)
#define textaux (params->l1->textaux)
#define kbText (params->l1->kbText)
#define appText (params->l1->appText)
#define attrs (params->l1->attrs)
#define bounds (params->l1->bounds)
#define numLock (params->l1->numLock)
#define capsLock (params->l1->capsLock)
#define autoshift (params->l1->autoShift)
#define insDate (params->l1->insDate)
#define extentX (params->l1->extentX)
#define scrollp (params->l1->scrollp)
#define setupdw (params->l1->setupdw)

/*
 * Entry point to the new keyboard trap. Setups the keyboard form,
 * calls the KeyboardLoop, calls toNormal to return to the calling app.
 *
 */
void LoadVKB(KeyboardType kbdType)
{
    KeyboardParams *params = NULL;
    DWord running = NULL, dwaux = NULL, options = NULL, aux = NULL;
    Boolean tryUndo = false;

    //check rom version, if not 2.0 or later, then call previous trap
    if (RomVersionCompatible
	(sysMakeROMVersion(2, 0, 0, sysROMStageRelease, 0), NULL)) {

#ifdef HACK

	if (!FtrGet(appCreator, 1000, &aux)) {
	    ((void (*)(KeyboardType)) aux) (kbdType);
	    return;
	}
#else

	if (!FtrGet(appCreator, prevTrap, &aux)) {
	    ((void (*)(KeyboardType)) aux) (kbdType);
	    return;
	}
#endif

    }
    //ignore double call to keyboard
    if (!FtrGet(appCreator, kbRunning, &running))
	return;

    //set value to ignore double call to keyboard
    FtrSet(appCreator, kbRunning, (DWord) true);

    //get options
#ifndef HACK

    FtrGet(appCreator, kbOptions, &options);

#else

    if (FtrGet(appCreator, kbOptions, &options)) {
	options = FromDatabase(kbOptions);
	if (!options)
	    options = resetOptions;
	FtrSet(appCreator, kbOptions, options);
    }
#endif

    //check for noabc option
    if (options & noabc) {

	if (kbdType == kbdAlpha) {

#ifdef HACK

	    if (!FtrGet(appCreator, 1000, &aux)) {
		((void (*)(KeyboardType)) aux) (kbdType);
		FtrUnregister(appCreator, kbRunning);
		return;
	    }
#else

	    if (!FtrGet(appCreator, prevTrap, &aux)) {
		((void (*)(KeyboardType)) aux) (kbdType);
		FtrUnregister(appCreator, kbRunning);
		return;
	    }
#endif

	} else {
	    if (kbdType == kbdNumbersAndPunc)
		kbdType = kbdAlpha;
	}


    }

    aux = NULL;

    //allocate keyboard params
    params = (KeyboardParams *) MemPtrNew(sizeof(KeyboardParams));
    if (params)
	params->l1 = (LoadLocals *) MemPtrNew(sizeof(LoadLocals));

    if (!params || !params->l1) {
	SndPlaySystemSound(sndError);
	freeParams(params);
	//this can reset the system
	unSetTrap();
	FtrUnregister(appCreator, kbRunning);
	return;
    }
    FtrSet(appCreator, kbParams, (DWord) params);

    //initialize keyboard globals
    params->running = true;

    params->VKBLayout = NULL;
    params->VKBProg = NULL;

    params->key.topLeft.x = 0;
    params->key.topLeft.y = 0;
    params->key.extent.x = 0;
    params->key.extent.y = 0;

    params->gdtLinesa = NULL;
    params->gdtLinesn = NULL;
    params->stra = NULL;
    params->strb = NULL;
    params->markpos = NULL;
    params->bmp = NULL;
    params->bmps = NULL;
    params->bmpc = NULL;
    params->bmpsc = NULL;
    params->bmpn = NULL;

    params->intl = NULL;

    params->offset = 0;
    params->prevForm = NULL;
    params->prevField = NULL;

    params->shortcutpos = 0;
    params->shortcutend = 0;
    params->scStart = false;

    params->special = spNone;
    params->special2 = spNone;

    params->toolb = false;

    params->refresh = 0;

    params->undDB = NULL;
    params->undMIx = 0;
    params->undFld = NULL;
    params->blockStart = 0;
    params->blockEnd = 0;
    params->blockBuffer = NULL;
    params->blockTrack = false;

    params->keychar = NULL;
    params->keyauto = false;

    params->m2 = NULL;

        //determine keyrepeat option
    if (options & oprepeat) {
	//resolution of key repeat timer. look for the actual key repeat intervals
	//at the KeyboardLoop function
	params->keyRepeatInterval = SysTicksPerSecond() / 20 + 1;
    } else
	params->keyRepeatInterval = evtWaitForever;

    dwaux = NULL;
    //trying to detect fully supported encodings
    FtrGet(sysFtrCreator, sysFtrNumEncoding, &dwaux);
    switch (dwaux) {
    case NULL:
    case charEncodingISO8859_1:
    case charEncodingCP1252:
    case charEncodingPalmLatin:
    case charEncodingAscii:
	params->special2 |= accentedChars;
	params->special2 |= oneByte;
    }

    //determine if to try extended undo
    if (options & kbUndo) {
	if (!(params->special2 & oneByte)) {
	    options &= ~kbUndo;
	    FtrSet(appCreator, kbOptions, options);
	} else
	    tryUndo = true;
    }

    dwaux = NULL;
    //determine which is the shortcut char
    FtrGet(sysFtrCreator, sysFtrNumROMVersion, &dwaux);
    params->_shortcutStrokeChr = '\236';
    if (dwaux > (UInt32) 0x03003000)
	params->_shortcutStrokeChr = '\027';

    //determine if the preference is to enter keys at pen up or pen down (fast keys)
    if (options & opendown) {
	params->atpenup = false;
    } else {
	params->atpenup = true;
	//at pen up does not repeat keys
	params->keyRepeatInterval = evtWaitForever;
    }

    //color options
    dwaux = NULL;
    FtrGet(sysFtrCreator, sysFtrNumROMVersion, &dwaux);
    if (dwaux >= (UInt32) 0x03503000)
	params->OS35 = true;
    else
	params->OS35 = false;

    //sound options
    if (options & noSound)
	params->special2 |= spNoSound;

    //load locals initialization
    //the load locals structure holds some temporal initialization variables
    aForm = NULL;
    index = 0, kbTextIndex = 0, tsize = 0, tempShift = 0, inspt = 0,
	start = 0, end = 0, maxc = 0, font = 0, scrollp = 0;
    text = NULL, textaux = NULL;
    kbText = NULL, appText = NULL;
    numLock = false, capsLock = false, autoshift = false;
    extentX = 0;

    //look for a field with focus
    aForm = FrmGetActiveForm();
    index = FrmGetFocus(aForm);
    if (index == noFocus) {
	freeParams(params);
	FtrUnregister(appCreator, kbRunning);
	return;
    }
    //try to get a text field
    switch (FrmGetObjectType(aForm, index)) {

    case frmFieldObj:
	appText = (FieldPtr) FrmGetObjectPtr(aForm, index);
	break;

    case frmTableObj:
	appText = (FieldPtr) TblGetCurrentField((TablePtr)
						FrmGetObjectPtr(aForm,
								index));
	if (!appText) {
	    freeParams(params);
	    FtrUnregister(appCreator, kbRunning);
	    return;
	}
	break;

    default:
	freeParams(params);
	FtrUnregister(appCreator, kbRunning);
	return;

    }

    //get current form parameters
    FldGetAttributes(appText, &attrs);

    //return if not usable
    if (attrs.usable == false || attrs.editable == false) {
	freeParams(params);
	FtrUnregister(appCreator, kbRunning);
	return;
    }

    text = FldGetTextHandle(appText);
    //get the offset of the text
    if (text) {
	params->offset =
	    FldGetTextPtr(appText) -
	    (CharPtr) MemHandleLock((VoidHand) text);
	MemHandleUnlock((VoidHand) text);
    }
    //get other parameters
    tsize = FldGetTextAllocatedSize(appText);
    inspt = FldGetInsPtPosition(appText);
    scrollp = FldGetScrollPosition(appText);
    FldGetSelection(appText, &start, &end);
    maxc = FldGetMaxChars(appText);
    font = FldGetFont(appText);
    FldGetBounds(appText, &bounds);

    //set the field width according to preferences
    if (options & wide)
	extentX = widthScreen;
    else
	extentX = bounds.extent.x;

    //remove text from the calling app (so that we later re-insert it,
    //and keep the lock count)
    FldSetTextHandle(appText, NULL);

    params->prevForm = aForm;
    params->prevField = appText;

    ErrTry {

	GrfGetState(&capsLock, &numLock, &tempShift, &autoshift);

	//open main database, enable keyboard form
	params->VKBProg =
	    DmOpenDatabaseByTypeCreator(appType, appCreator,
					dmModeReadWrite);
	FtrSet(appCreator, VKBdb, (UInt32) params->VKBProg);
	if (!params->VKBProg)
	    ErrThrow(0);

	aForm = (FormPtr) MainResource(vkbInitForm);
	if (!aForm)
	    ErrThrow(0);

	FrmSetActiveForm(aForm);
	FrmSetEventHandler(aForm, VKBInputHandler);
	FrmDrawForm(aForm);

	kbTextIndex = FrmGetObjectIndex(aForm, textFld);
	kbText = (FieldPtr) FrmGetObjectPtr(aForm, kbTextIndex);

	//paranoid, but remove any allocated memory in the keyboard field
	textaux = FldGetTextHandle(kbText);
	FldSetTextHandle(kbText, NULL);
	if (textaux)
	    MemHandleFree((VoidHand) textaux);

	//start options
	CtlSetValue(FrmGetObjectPtr
		    (aForm, FrmGetObjectIndex(aForm, abcPush)), true);
	//see if we have to start with numeric or intl
	if ((options & intlStart || kbdType == kbdAccent)
	    && params->special2 & accentedChars) {
	    CtlSetValue(FrmGetObjectPtr
			(aForm, FrmGetObjectIndex(aForm, intlCheck)),
			true);
	    params->special |= intlUp;
	}
	if (attrs.numeric || options & numStart
	    || kbdType == kbdNumbersAndPunc || (numLock
						&& kbdType ==
						kbdDefault)) {
	    CtlSetValue(FrmGetObjectPtr
			(aForm, FrmGetObjectIndex(aForm, numPush)), true);
	    CtlSetValue(FrmGetObjectPtr
			(aForm, FrmGetObjectIndex(aForm, abcPush)), false);
	    params->special |= numUp;
	}
	//copy all app field parameters to kb field
	FldSetMaxChars(kbText, maxc);
	FldSetFont(kbText, font);
	attrs.dynamicSize = false;
	if (options & autoshiftLock)
	    attrs.autoShift = true;
	FldSetAttributes(kbText, &attrs);
	FldGetBounds(kbText, &bounds);
	bounds.extent.x = extentX;
	FldSetBounds(kbText, &bounds);

	//use text handle to edit in kb form
	FldSetText(kbText, (VoidHand) text, params->offset, tsize);
	FldSetTextAllocatedSize(kbText, tsize);

	//set some kb parameters
	GrfSetState(false, false, false);
	params->shift = (tempShift == grfTempShiftUpper)
	    || (FldGetTextLength(kbText) == 0 && options & autoshiftLock);
	params->cap = capsLock;
	params->accent = noAcc;
	params->extra1 = NULL;
	params->keyNotPainted = true;
	params->kbDown = false;

	//draw keyboard form
	WinDrawLine(0, 0, widthScreen, 0);
	WinDrawLine(0, heightScreen - 1, widthScreen, heightScreen - 1);
	FrmHideObject(aForm, kbTextIndex);
	FldSetScrollPosition(kbText, scrollp);
	FldSetInsPtPosition(kbText, inspt);
	FldSetSelection(kbText, start, end);
	FldSetUsable(kbText, true);
	FrmSetFocus(aForm, kbTextIndex);
	refreshRButtons();

	MemPtrFree((VoidPtr) params->l1);
	params->l1 = NULL;

	params->m2 = (CommonGlobals *) MemPtrNew(sizeof(CommonGlobals));

	if (!params->m2) {
	    Char buffer[15];

	    ShowError(customErrorAlert,
		      getString(buffer, notEnoughMemory, params->VKBProg),
		      NULL, NULL);
	    toNormal();
	    //this can reset the system
	    unSetTrap();
	    FtrUnregister(appCreator, kbRunning);
	    return;
	}

    }
    ErrCatch(inErr) {

	//theoretical precautions
	FldSetTextHandle(kbText, NULL);
	FldSetText(appText, (VoidHand) text, params->offset, tsize);
	SndPlaySystemSound(sndError);
	FrmSetActiveForm(params->prevForm);
	FrmDrawForm(FrmGetActiveForm());
	freeParams(params);
	//this can reset the system
	unSetTrap();
	FtrUnregister(appCreator, kbRunning);

	return;

    }
    ErrEndCatch;

    ErrTry {

	//try the extended undo manager
	if (tryUndo) {

	    if (!UndInit()) {
		UndEnd();
		UndSwitch();
	    } else
		params->special2 |= spExtUndo;

	}

    }
    ErrCatch(inErr) {
	//theoretical precautions
	Char buffer[30];

	ShowError(customErrorAlert,
		  getString(buffer, extUndError, params->VKBProg), NULL,
		  NULL);
	toNormal();
	FtrUnregister(appCreator, kbRunning);
	return;

    }
    ErrEndCatch;

    ErrTry {
	{
	    //load the overlay or skin database
	    MemHandle layout = NULL;
	    CharPtr data = NULL;
	    DWord aux = 0;

	    //look for overlay database, and open resources
	    params->VKBLayout =
		DmOpenDatabaseByTypeCreator('VKBO', appCreator,
					    dmModeReadWrite);
	    if (DmNextOpenResDatabase(NULL) != params->VKBLayout) {
		ShowError1(noOverlay);
		ErrThrow(0);
	    }
	    //error messages cause errors here!, it is because resources can be
	    //half loaded, and there is no variable to track that

	    //get lines span alphabetic
	    layout = DmGet1Resource('tSTR', 100);
	    if (layout)
		data = (Char *) MemHandleLock(layout);
	    if (data)
		params->gdtLinesa = StrAToI(data);
	    else
		ErrThrow(1);

	    MemHandleUnlock(layout);
	    DmReleaseResource(layout);

	    //get lines span numeric
	    layout = DmGet1Resource('tSTR', 101);
	    if (layout)
		data = (Char *) MemHandleLock(layout);
	    if (data)
		params->gdtLinesn = StrAToI(data);
	    else
		ErrThrow(1);

	    MemHandleUnlock(layout);
	    DmReleaseResource(layout);

	    //get keyboard bitmaps
	    layout = DmGet1Resource('Tbmp', 100);
	    if (layout)
		params->bmp = (BitmapType *) MemHandleLock(layout);
	    if (!params->bmp)
		ErrThrow(1);

	    layout = DmGet1Resource('Tbmp', 101);
	    if (layout)
		params->bmps = (BitmapType *) MemHandleLock(layout);
	    if (!params->bmps)
		ErrThrow(1);

	    layout = DmGet1Resource('Tbmp', 102);
	    if (layout)
		params->bmpc = (BitmapType *) MemHandleLock(layout);
	    if (!params->bmpc)
		ErrThrow(1);

	    layout = DmGet1Resource('Tbmp', 103);
	    if (layout)
		params->bmpsc = (BitmapType *) MemHandleLock(layout);
	    if (!params->bmpsc)
		ErrThrow(1);

	    layout = DmGet1Resource('Tbmp', 104);
	    if (layout)
		params->bmpn = (BitmapType *) MemHandleLock(layout);
	    if (!params->bmpn)
		ErrThrow(1);

	    layout = DmGet1Resource('tSTR', 200);
	    if (layout)
		params->stra = (Char *) MemHandleLock(layout);
	    if (!params->stra)
		ErrThrow(1);

	    layout = DmGet1Resource('tSTR', 201);
	    if (layout)
		params->strb = (Char *) MemHandleLock(layout);
	    if (!params->strb)
		ErrThrow(1);

	}

	//paint toolbar
	paintToolbar(params);

	//paint keyboard
	params->special |= resize;
	KeyboardCall(kbDrawAll, params);

	GrfSetState(false, false, false);

	//catch events, we need to set things to normal if an appStopEvent is received
	KeyboardLoop();

    }
    ErrCatch(inErr) {
	DmOpenRef VKBLayout = params->VKBLayout;

	if (inErr == 1) {
	    Char buffer[30];
	    params->VKBLayout = NULL;
	    ShowError(customErrorAlert,
		      getString(buffer, errorLoadingOverlay,
				params->VKBProg), NULL, NULL);
	    params->VKBLayout = VKBLayout;
	}

	toNormal();

	FtrUnregister(appCreator, kbRunning);

	return;

    }
    ErrEndCatch;

    //refresh the calling form, normal exit
    toNormal();

    //keyboard not running anymore
    FtrUnregister(appCreator, kbRunning);

}

#undef aForm
#undef index
#undef kbTextIndex
#undef tsize
#undef tempShift
#undef inspt
#undef start
#undef end
#undef maxc
#undef font
#undef text
#undef textaux
#undef kbText
#undef appText
#undef attrs
#undef bounds
#undef numLock
#undef capsLock
#undef autoshift
#undef insDate
#undef extentX
#undef scrollp
#undef setupdw

/*
 * Handles events for the keyboard form. Helps to process shortcuts and to
 * synchronize graffiti shift with the keyboard shift.
 *
 */
void KeyboardLoop()
{
    EventType aEvent;
    DWord aDWord = 0;
    KeyboardParams *params = NULL;
    Boolean marktrans = false, prevmarktrans = false;
    UInt16 posnow = 0, posprev = 0;
    Word auxchar = NULL;
    FormPtr aForm = FrmGetActiveForm();
    FieldPtr aField =
	FrmGetObjectPtr(aForm, FrmGetObjectIndex(aForm, textFld));
    //time to wait between repeating keys
    //TODO: should be user configurable
    UInt16 repeatTick = 0;
    UInt32 ticks = 0;
    short bytes = 0;

    FtrGet(appCreator, kbParams, &aDWord);
    params = (KeyboardParams *) aDWord;

    //init some variables
    repeatTick = params->keyRepeatInterval * 15;
    posprev = FldGetInsPtPosition(aField);
    bytes = (params->special2 & oneByte) ? 1 : 2;

    //main keyboard loop
    while (true) {

	EvtGetEvent(&aEvent, params->keyRepeatInterval);

	//stop event dequeued, re-queue event and stop keyboard
	if (aEvent.eType == appStopEvent) {
	    params->running = false;
	    EvtAddEventToQueue(&aEvent);
	    break;
	}
#define evtNil (params->m2->bo2)

	//do not bother jumping into handlers if event is nil for key repeats
	evtNil = aEvent.eType == nilEvent;

	if (evtNil || !SysHandleEvent(&aEvent)) {
	    if (evtNil
		|| !MenuHandleEvent(NULL, &aEvent, (Word *) & aDWord)) {
		//application handled events

		//process key before field handles it, the processing here uses
		//local loop variables to track changes (see also keyDownEvent in the
		//form handler, for similar processing)
		if (aEvent.eType == keyDownEvent) {
		    //do not process arrow and command characters
		    Boolean keyOK =
			(aEvent.data.keyDown.chr < (Word) '\034'
			 || aEvent.data.keyDown.chr > (Word) '\037')
			&& !(aEvent.data.keyDown.modifiers ==
			     commandKeyMask
			     || ((aEvent.data.keyDown.modifiers) &
				 ~shiftKeyMask & ~capsLockMask &
				 ~numLockMask));

		    //reset autorepeat initial wait
		    if (!params->keyauto)
			ticks = TimGetTicks();

		    //process the following only for the main text field
		    if (FrmGetFocus(aForm) ==
			FrmGetObjectIndex(aForm, textFld)) {
			if (keyOK) {

			    //new key, and cursor moved (the last condition is for:
			    //a_character left_arrow a_character),
			    //start a new undo transaction
			    posnow = FldGetInsPtPosition(aField);
			    if (posnow + bytes < posprev
				|| posnow > posprev + bytes
				|| posnow == posprev)
				UndMarkTrans(params);
			    posprev = posnow;

			    //key is '\b' and previous was not, start a new undo transaction
			    if (aEvent.data.keyDown.chr == (Word) '\b'
				&& auxchar != (Word) '\b')
				UndMarkTrans(params);
			    //key is not '\b' and previous was, start a new undo transaction
			    else if (aEvent.data.keyDown.chr != (Word) '\b'
				     && auxchar == (Word) '\b')
				UndMarkTrans(params);

			    //key is shortcut char, start new transaction
			    if (aEvent.data.keyDown.chr ==
				params->_shortcutStrokeChr) {
				UndMarkTrans(params);
			    }
			    //stop previous undo transaction on some characters (sentences)
			    prevmarktrans = marktrans;
			    marktrans = (auxchar == (Word) '\n'
					 || auxchar == (Word) '.'
					 || auxchar == (Word) '!'
					 || auxchar == (Word) '?');
			    if (marktrans && !prevmarktrans)
				UndMarkTrans(params);

			}

		    }

		}
#define px (params->m2->i1)
#define py (params->m2->i2)
#define pendown (params->m2->bo1)

		px = 0;
		py = 0;
		pendown = false;

		//send auto repeat keys
		if (params->keyRepeatInterval != -1
		    && (TimGetTicks() - ticks >= repeatTick)
		    && params->keychar
		    && params->kbDown) {

		    EvtGetPen(&px, &py, &pendown);
		    if (pendown) {
			//time to wait between repeating keys
			//TODO: should be user configurable
			SysTaskDelay(params->keyRepeatInterval);
			EvtEnqueueKey(params->keychar, 0, 0);
			MSndPlaySystemSound(sndClick);
			ticks = 0;
			params->keyauto = true;
		    } else {
			params->keychar = NULL;
			EvtFlushKeyQueue();
		    }

#undef pendown
#undef px
#undef py

		}

		if (!evtNil)
		    FrmDispatchEvent(&aEvent);

#undef evtNil

		//events handled after dispatch

		//done button pressed, stop keyboard
		if (!params->running)
		    break;

		if (aEvent.eType == keyDownEvent) {
		    auxchar = aEvent.data.keyDown.chr;

		    refreshRButtons();

		    //if the insertion point moved, cancel shortcut
		    if (params->scStart) {
			Int diff =
			    FldGetInsPtPosition(aField) -
			    params->shortcutend;

			if (diff < -bytes || diff > bytes) {
			    params->shortcutpos = 0;
			    params->shortcutend = 0;
			    params->scStart = false;
			    params->special &= ~kbshortcut;
			}

		    }
		    //process shortcut
		    if (params->scStart) {
			char *macro = NULL;

#define got (params->m2->bo1)
#define close (params->m2->bo2)
#define blen (params->m2->w1)

			got = false;
			close = false;
			blen = 0;

			params->shortcutend = FldGetInsPtPosition(aField);

			blen =
			    lookMacro(params,
				      FldGetTextPtr(aField) +
				      params->shortcutpos,
				      params->shortcutend -
				      params->shortcutpos, &close, &got,
				      &macro);

			//if determined that there is or not a macro, delete the macro name,
			//and reset macro processing
			if (!close || got) {
			    if (params->shortcutend > params->shortcutpos - 1)
			        FldDelete(aField, params->shortcutpos - 1,
				          params->shortcutend);
			    params->shortcutpos = 0;
			    params->shortcutend = 0;
			    params->scStart = 0;
			    params->special &= ~kbshortcut;
			}
			//if there is a macro, insert it
			if (macro && got)
			    FldInsert(aField, macro, blen);

#undef got
#undef close
#undef blen
			//release memory
			if (macro)
			    MemPtrFree(macro);

		    } else if (aEvent.data.keyDown.chr ==
			       params->_shortcutStrokeChr
			       && (params->special & kbshortcut)) {
			params->shortcutend = params->shortcutpos =
			    FldGetInsPtPosition(aField);
			params->scStart = true;
		    }
#undef aForm
#undef aField

		}

	    }

	}
	//synchronize graffiti shift
	if (aEvent.eType != nilEvent) {

#define caps (params->m2->bo1)
#define num (params->m2->bo2)
#define ashift (params->m2->bo3)
#define tshift (params->m2->w1)

	    caps = false;
	    num = false;
	    ashift = false;
	    tshift = 0;

	    GrfGetState(&caps, &num, &tshift, &ashift);

	    //if there is a shift state in the shift indicator
	    if (tshift == grfTempShiftUpper) {

		if (ashift) {
		    //go to autoshift mode
		    params->special |= setShift;
		    params->shift = true;
		} else if (!params->cap) {
		    if (!params->shift) {
			//if we are normal turn to shift
			params->shift = true;
			params->cap = false;
		    } else {
			//if we are shift turn to caps mode
			params->shift = false;
			params->cap = true;
		    }
		} else {
		    if (!params->shift) {
			//if we are in caps mode turn to shift-caps
			params->shift = true;
			params->cap = true;
		    } else {
			//if we are in shift-caps turn to normal
			params->shift = false;
			params->cap = false;
		    }
		}

		//repaint keyboard
		if (!params->atpenup)
		    //needed for fast keys
                    params->keyNotPainted=true;
		KeyboardCall(kbDrawAll, params);

	    }
	    //work with the keyboard indicators only (graffiti indicator is not used, mostly)
	    if (caps || tshift == grfTempShiftUpper)
		GrfSetState(false, num, false);

#undef caps
#undef num
#undef ashift
#undef tshift

	}

    }

}

/*
 * Returns to the application that called the keyboard, makes text changes visible
 * and releases resources.
 * This uses a lot of stack
 */
void toNormal()
{
    FormPtr active = NULL;
    FieldPtr aField = NULL;
    DWord params = 0;
    Word inspt = 0, tsize = 0, start = 0, end = 0, scrollp = 0;
    Handle textHandle = 0;
    MenuBarPtr menuPtr = NULL;
    KeyboardParams *parameters = NULL;
    FieldAttrType attrs;
    MemHandle auxh = NULL;

    if (FtrGet(appCreator, kbParams, &params))
	return;

    parameters = (KeyboardParams *) params;

    //close layout database
    if (parameters->VKBLayout) {
	if (parameters->bmp) {
	    MemHandleUnlock(auxh = MemPtrRecoverHandle(parameters->bmp));
	    if (auxh)
		DmReleaseResource(auxh);
	}

	if (parameters->bmps) {
	    MemHandleUnlock(auxh = MemPtrRecoverHandle(parameters->bmps));
	    if (auxh)
		DmReleaseResource(auxh);
	}

	if (parameters->bmpc) {
	    MemHandleUnlock(auxh = MemPtrRecoverHandle(parameters->bmpc));
	    if (auxh)
		DmReleaseResource(auxh);
	}

	if (parameters->bmpsc) {
	    MemHandleUnlock(auxh = MemPtrRecoverHandle(parameters->bmpsc));
	    if (auxh)
		DmReleaseResource(auxh);
	}

	if (parameters->bmpn) {
	    MemHandleUnlock(auxh = MemPtrRecoverHandle(parameters->bmpn));
	    if (auxh)
		DmReleaseResource(auxh);
	}

	if (parameters->stra) {
	    MemHandleUnlock(auxh = MemPtrRecoverHandle(parameters->stra));
	    if (auxh)
		DmReleaseResource(auxh);
	}

	if (parameters->strb) {
	    MemHandleUnlock(auxh = MemPtrRecoverHandle(parameters->strb));
	    if (auxh)
		DmReleaseResource(auxh);
	}

	DmCloseDatabase(parameters->VKBLayout);
	parameters->VKBLayout = NULL;
    }
    //stop extended undo
    if (parameters->undDB)
	UndEnd();

    //get kb textfield values
    active = FrmGetActiveForm();
    aField =
	(FieldPtr) FrmGetObjectPtr(active,
				   FrmGetObjectIndex(active, textFld));
    textHandle = FldGetTextHandle(aField);

    inspt = FldGetInsPtPosition(aField);
    scrollp = FldGetScrollPosition(aField);
    tsize = FldGetTextAllocatedSize(aField);
    FldGetSelection(aField, &start, &end);

    //remove text link from kb field
    FldSetTextHandle(aField, NULL);

    //dispose kb menu
    menuPtr = MenuGetActiveMenu();
    MenuSetActiveMenu(NULL);
    if (menuPtr)
	MenuDispose(menuPtr);

    //restore app field
    aField = parameters->prevField;
    FldSetText(aField, (VoidHand) textHandle, parameters->offset, tsize);
    FldSetTextAllocatedSize(aField, tsize);

    //put back previous form
    FrmReturnToForm(FrmGetFormId(parameters->prevForm));

    //close main database
    DmCloseDatabase(parameters->VKBProg);
    FtrUnregister(appCreator, VKBdb);

    //reset graffiti shift
    if (parameters->cap)
	GrfSetState(true, false, false);
    else if (parameters->shift)
	GrfSetState(false, false, true);
    else
	GrfSetState(false, false, false);

    FldSetDirty(aField, true);

    FldGetAttributes(aField, &attrs);

    //make changes visible
    if (attrs.dynamicSize) {
	RectangleType bounds;
	short lHeightStd = 0, lHeightCurr = 0, maxL = 0, suggestedL = 0;
	FontID prevfont = NULL;
	Boolean hchange = false;

	FldGetBounds(aField, &bounds);

	//get standard line height
	prevfont = FntSetFont(stdFont);
	lHeightStd = FntLineHeight();
	FntSetFont(prevfont);

	//get current line height
	lHeightCurr = FntLineHeight();

	//paranoid avoid division by zero
	if (lHeightCurr <= 0)
	    lHeightCurr = lHeightStd;
	if (lHeightCurr <= 0)
	    lHeightCurr = 11;

	//determine max number of lines of field in current font
	maxL = (maxFieldLines * lHeightStd) / lHeightCurr;

	//get the lines that the text could have
	suggestedL =
	    FldCalcFieldHeight(FldGetTextPtr(aField), bounds.extent.x);

	//if the lines that the text could have is less than the maximum
	//lines for the field, then have it
	if (suggestedL < maxL)
	    maxL = suggestedL;

	//paranoid do not use height == 0
	if (maxL == 0)
	    maxL = 1;

	//calculate new height
	bounds.extent.y = lHeightCurr * maxL;

	//notify height change if necessary
	hchange = FldGetVisibleLines(aField) < maxL;
	if (hchange)
	    FldSendHeightChangeNotification(aField, inspt, maxL);

	//redraw field
	FldDrawField(aField);

	//if there is height change, the insertion point will be enabled, and this
	//can cause an inconsistency.  for now, if height changes, then leave all
	//further processing to the height changed event
	if (!hchange) {

	    FldSetInsPtPosition(aField, inspt);

	    if (start == end)
		InsPtEnable(true);
	    else
		InsPtEnable(false);

	    FldSetSelection(aField, start, end);

	}

    } else {

	//update insertion point and redraw
	FldSetScrollPosition(aField, scrollp);

	FldDrawField(aField);

	//this is needed
	FldSetInsPtPosition(aField, inspt);

	if (start == end)
	    InsPtEnable(true);
	else
	    InsPtEnable(false);

	FldSetSelection(aField, start, end);

    }

    //notify changes
    FldSendChangeNotification(aField);

    //return memory used
    freeParams((VoidPtr) params);

}

/*
 * This hack globals structure is freed.
 *
 */
void freeParams(KeyboardParams * params)
{

    if (params) {
	if (params->m2) {
	    MemPtrFree((VoidPtr) (params->m2));
	    params->m2 = NULL;
	}
	if (params->l1) {
	    MemPtrFree((VoidPtr) (params->l1));
	    params->l1 = NULL;
	}
	MemPtrFree((VoidPtr) params);
    }

    FtrUnregister(appCreator, kbParams);

}

/*
 * Helps to handle the keyboard form events, process keyDownEvents,
 * shows and hides form objects to implement the mini shortcut and find dialogs, ...
 *
 */
#define handled (params->m2->bo1)
#define parameters params
Boolean VKBInputHandler(EventPtr aEvent)
{
    Int callType = NULL;
    DWord aux = 0;
    KeyboardParams *params = NULL;

    FtrGet(appCreator, kbParams, &aux);
    params = (KeyboardParams *) aux;

    handled = false;

    if (!params)
	return handled;

    switch (aEvent->eType) {

    case frmUpdateEvent:
	if (aEvent->data.frmUpdate.updateCode == frmRedrawUpdateCode
			&& aEvent->data.frmUpdate.formID == VKBFrm && params->VKBLayout) {	//paranoid check

	    //refresh form
	    FrmDrawForm(FrmGetActiveForm());

	    //redraw lines
	    WinDrawLine(0, 0, widthScreen, 0);
	    WinDrawLine(0, heightScreen - 1, widthScreen,
			heightScreen - 1);

	    //redraw bitmaps
	    KeyboardCall(kbDrawAll, params);
	    paintToolbar(params);

	    GrfSetState(false, false, false);

	    handled = true;
	}
	break;

    case fldChangedEvent:
	//refresh scrolls
	if (aEvent->data.fldChanged.fieldID == textFld) {	//only for the main field
	    updateScroll(FrmGetActiveForm(),
			 aEvent->data.fldChanged.pField, NULL);
	    refreshRButtons();
	}
	break;

    case sclRepeatEvent:{

#define delta (params->m2->i1)
#define aForm (params->m2->aForm)

	    //scroll text
	    DirectionType direction = 0;
	    delta =
		aEvent->data.sclRepeat.newValue -
		aEvent->data.sclRepeat.value;
	    direction = delta > 0 ? down : up;
	    aForm = FrmGetActiveForm();

	    if (delta < 0)
		delta *= -1;

	    if (delta) {
		FldScrollField(FrmGetObjectPtr
			       (aForm, FrmGetObjectIndex(aForm, textFld)),
			       delta, direction);
		refreshRButtons();

#undef delta
#undef aForm

	    }


	    break;

	}

	//process characters. handles in part (see main loop): auto shift, key repeat, shift and accents, ...
    case keyDownEvent:{

#define done (params->m2->bo2)
#define chaux (params->m2->w1)

	    Word kdchar = (Word) aEvent->data.keyDown.chr;
	    chaux = 0;
	    done = false;

	    switch (kdchar) {
	    case pageUpChr:
		TextScroll1(up, true);
		done = true;
		handled = true;
		break;
	    case pageDownChr:
		TextScroll1(down, true);
		done = true;
		handled = true;
		break;
	    default:
		break;
	    }

	    //page up and down; shift, caps and numlock; and command characters need no further processing
	    if (done || aEvent->data.keyDown.modifiers == commandKeyMask ||
		((aEvent->data.keyDown.
		  modifiers) & ~shiftKeyMask & ~capsLockMask &
		 ~numLockMask))
		break;


	    //save key entered for key repeat
	    params->keychar = kdchar;

	    //test for autoshift end
	    if ((params->special & setShift) && kdchar != (Word) ' '
		&& kdchar != (Word) '\n' && kdchar != (Word) '\t'
		&& kdchar != (Word) '\b')
		params->special &= ~setShift;

	    //test for shift fix
	    chaux = RVocal(kdchar);
	    if (chaux >= 'a' && chaux <= 'z'
		&& (params->shift != params->cap))
		kdchar -= ' ';

	    //check for vocal fix
	    kdchar = Vocal(kdchar);

	    if (kdchar != (Word) aEvent->data.keyDown.chr)
		aEvent->data.keyDown.chr = kdchar;

	    //check accent spent
	    if (params->accent) {
		if (!params->kbDown	//for graffiti keys, refresh right away
		        || params->atpenup) {
		    ReadKeyboardIntl2(params, params->accent);
		    params->accent = noAcc;
		} else
		    //refresh at penup for fast keys
		    params->refresh |= refreshAcc;
	    }

	    //check shift spent
	    if (!(params->special & setShift) && (params->shift)) {
		params->shift = false;
		if (!params->kbDown	//for graffiti keys, refresh right away
		        || params->atpenup)
		    KeyboardCall(kbDrawAll, params);
		else
		    //refresh at penup for fast keys
		    params->refresh |= refreshShift;
	    }

	    break;

#undef done
#undef chaux

	}

    case winEnterEvent:{

	    //paranoid check
	    if (!params->running)
		break;

	    //handle menu manually
	    if (aEvent->data.winEnter.enterWindow ==
		(WinHandle) FrmGetFormPtr(VKBFrm)) {
		//enable menu if not active
		if (!MenuGetActiveMenu()) {
		    MenuBarPtr kbmenu =
			(MenuBarPtr) MainResource(vkbInitMenu);
		    if (!kbmenu)
			ErrThrow(0);
		    MenuSetActiveMenu(kbmenu);
		}

		GrfSetState(false, false, false);
	    }

	    break;
	}

	//menu events
    case menuEvent:{

#define aForm (params->m2->aForm)
#define aField (params->m2->aField)

	    aForm = FrmGetActiveForm();
	    aField =
		FrmGetObjectPtr(aForm, FrmGetObjectIndex(aForm, textFld));

	    handled = true;

	    switch (aEvent->data.menu.itemID) {

		//edit options
	    case undoMItem:
		FldUndo(aField);
		break;

	    case redoMItem:
		if (params->special2 & spExtUndo)
		    UndRedo(aField);
		else
		    SndPlaySystemSound(sndError);
		break;

	    case cutMItem:
		FldCut(aField);
		break;

	    case copyMItem:
		FldCopy(aField);
		break;

	    case pasteMItem:
		FldPaste(aField);
		break;

	    case selectAllMItem:
		FldSetSelection(aField, 0, FldGetTextLength(aField));
		break;

		//if this are moved, care about the enclosing defines
		//show search mini dialog
	    case searchMItem:{
		    RectangleType aRec;

		    //do not allow more than one mini-dialog
		    if (params->special & extendedOn)
			break;

		    //erase toolbar
		    aRec.topLeft.x = 0;
		    aRec.extent.x = widthScreen;
		    aRec.topLeft.y = 0;
		    aRec.extent.y = heightTitle;
		    WinEraseRectangle(&aRec, 0);

		    params->special |= resize;
		    params->special |= extendedOn;

		    //repaint resized
		    KeyboardCall(kbDrawAll, parameters);
		    WinDrawLine(0, 0, widthScreen, 0);

		    //show dialog
		    FrmShowObject(aForm,
				  FrmGetObjectIndex(aForm, findFld));
		    FrmShowObject(aForm,
				  FrmGetObjectIndex(aForm, findFindBtn));
		    FrmShowObject(aForm,
				  FrmGetObjectIndex(aForm,
						    findExactCheck));
		    FrmShowObject(aForm,
				  FrmGetObjectIndex(aForm, findDoneBtn));
		    FrmShowObject(aForm,
				  FrmGetObjectIndex(aForm, rplcBtn));
		    FrmShowObject(aForm,
				  FrmGetObjectIndex(aForm, rplcFld));
		    FrmShowObject(aForm,
				  FrmGetObjectIndex(aForm, rplcABtn));

		    //copy selection to find field
		    CopySelection((FieldType *)
				  FrmGetObjectPtr(aForm,
						  FrmGetObjectIndex(aForm,
								    findFld)));

		    break;
		}

		//goto to beginning of text
	    case startMItem:{

#define findex (params->m2->w1)

		    findex = FrmGetObjectIndex(aForm, textFld);

		    FrmHideObject(aForm, findex);
		    FldSetScrollPosition(aField, 0);
		    FldSetInsPtPosition(aField, 0);
		    FrmShowObject(aForm, findex);

		    FldSendChangeNotification(aField);
		    refreshRButtons();

		    break;

#undef findex

		}

		//go to end of text
	    case endMItem:{

#define findex (params->m2->w1)

		    findex = FrmGetObjectIndex(aForm, textFld);

		    FrmHideObject(aForm, findex);
		    FldSetInsPtPosition(aField,
					StrLen(FldGetTextPtr(aField)));
		    FrmShowObject(aForm, findex);

		    FldSendChangeNotification(aField);
		    refreshRButtons();

		    break;

#undef findex

		}

		//shortcuts and time stamps
		//show shortcuts mini dialog
	    case newMacroMItem:{
		    RectangleType aRec;

		    //do not allow more than one mini-dialog
		    if (params->special & extendedOn)
			break;

		    //erase toolbar
		    aRec.topLeft.x = 0;
		    aRec.extent.x = widthScreen;
		    aRec.topLeft.y = 0;
		    aRec.extent.y = heightTitle;
		    WinEraseRectangle(&aRec, 0);

		    params->special |= resize;
		    params->special |= extendedOn;

		    //repaint resized
		    KeyboardCall(kbDrawAll, parameters);
		    WinDrawLine(0, 0, widthScreen, 0);

		    //show dialog
		    FrmShowObject(aForm,
				  FrmGetObjectIndex(aForm, scnameLbl));
		    FrmShowObject(aForm,
				  FrmGetObjectIndex(aForm, sctextLbl));
		    FrmShowObject(aForm,
				  FrmGetObjectIndex(aForm, scnameFld));
		    FrmShowObject(aForm,
				  FrmGetObjectIndex(aForm, sctextFld));
		    FrmShowObject(aForm,
				  FrmGetObjectIndex(aForm, scaddBtn));
		    FrmShowObject(aForm,
				  FrmGetObjectIndex(aForm, sccancelBtn));

		    //copy selection to text field
		    CopySelection((FieldType *)
				  FrmGetObjectPtr(aForm,
						  FrmGetObjectIndex(aForm,
								    sctextFld)));

		    break;
		}

		//insert date stamp
	    case dsMItem:
		UndMarkTrans(params);
		params->special |= kbshortcut;
		EvtEnqueueKey(params->_shortcutStrokeChr, 0, 0);
		EvtEnqueueKey('d', 0, 0);
		EvtEnqueueKey('s', 0, 0);
		break;

		//insert date and time stamp
	    case dtsMItem:
		UndMarkTrans(params);
		params->special |= kbshortcut;
		EvtEnqueueKey(params->_shortcutStrokeChr, 0, 0);
		EvtEnqueueKey('d', 0, 0);
		EvtEnqueueKey('t', 0, 0);
		EvtEnqueueKey('s', 0, 0);
		break;

		//insert time stamp
	    case tsMItem:
		UndMarkTrans(params);
		params->special |= kbshortcut;
		EvtEnqueueKey(params->_shortcutStrokeChr, 0, 0);
		EvtEnqueueKey('t', 0, 0);
		EvtEnqueueKey('s', 0, 0);
		break;

	    default:
		handled = false;
		break;

	    }

	    break;

#undef aForm
#undef aField

	}

	//done with menus,
	//now to controls

	//scroll the text
    case ctlRepeatEvent:

	handled = false;

	switch (aEvent->data.ctlRepeat.controlID) {

	case upRBtn:
	    TextScroll(up);
	    break;

	case downRBtn:
	    TextScroll(down);
	    break;

	}

	refreshRButtons();

	break;

    case ctlSelectEvent:

	switch (aEvent->data.ctlSelect.controlID) {

	    //left and right cursor keys
	case leftBtn:
	    EvtEnqueueKey('\034', 0, 0);
	    break;

	case rightBtn:
	    EvtEnqueueKey('\035', 0, 0);
	    break;

	    //return to calling app
	case doneBtn:
	    params->running = false;
	    handled = true;
	    break;

#define aForm (params->m2->aForm)
#define aField (params->m2->aField)

	    //close find mini dialog
	case findDoneBtn:{

#define start (params->m2->w1)

		Word end = 0;
		start = 0;

		aForm = FrmGetActiveForm();
		aField =
		    FrmGetObjectPtr(aForm,
				    FrmGetObjectIndex(aForm, textFld));

		FldGetSelection(aField, &start, &end);

		//hide objects
		FrmHideObject(aForm, FrmGetObjectIndex(aForm, findFld));
		FrmHideObject(aForm,
			      FrmGetObjectIndex(aForm, findFindBtn));
		FrmHideObject(aForm,
			      FrmGetObjectIndex(aForm, findExactCheck));
		FrmHideObject(aForm,
			      FrmGetObjectIndex(aForm, findDoneBtn));
		FrmHideObject(aForm, FrmGetObjectIndex(aForm, rplcBtn));
		FrmHideObject(aForm, FrmGetObjectIndex(aForm, rplcFld));
		FrmHideObject(aForm, FrmGetObjectIndex(aForm, rplcABtn));

		//repaint resized
		params->special &= ~extendedOn;
		params->special |= resize;
		KeyboardCall(kbDrawAll, parameters);

		FrmSetFocus(aForm, FrmGetObjectIndex(aForm, textFld));

		paintToolbar(params);
		WinDrawLine(0, 0, widthScreen, 0);

		if (start != end)
		    InsPtEnable(false);
		else
		    InsPtEnable(true);

		break;

#undef start

	    }

	    //replace all
	    //this uses too much stack. it will be great to re-write this.
	    //this constructs the replaced text off-field, otherwise it was too slow.
	case rplcABtn:{
		Word end = 0, aux = 0, maxchars = 0, spanr = 0, start = 0;
		Boolean pdown = false, sensitive = false, got =
		    false, first = true;
		Char tnum[8];
		DWord rplccount = 0;
		UInt16 px = 0, py = 0, tlen = 0, currlen = 0, itext =
		    0, rlen = 0, lbaux = 0;
		FieldPtr bField = NULL;
		CharPtr texta = NULL, textt = NULL, textr = NULL;
		VoidHand space = NULL;
		VoidPtr pspace = NULL;

		tnum[0] = '\0';

		aForm = FrmGetActiveForm();
		itext = FrmGetObjectIndex(aForm, textFld);
		aField = FrmGetObjectPtr(aForm, itext);
		bField =
		    FrmGetObjectPtr(aForm,
				    FrmGetObjectIndex(aForm, findFld));

		//get a handle to construct replaced text
		maxchars = FldGetMaxChars(aField);

		//try to create a memory handle on the keyboard databases,
		//or where memory is available (has not caused problems)
		{
		    DmOpenRef current = NULL;
		    short max = 5;

		    do
			if (!(current = DmNextOpenResDatabase(current)))
			    break;
		    while (!(space = DmNewHandle(current, maxchars))
			   && max--);

		    if (space)
			pspace = MemHandleLock(space);
		    else {
			Char buffer[15];
			ShowError(customErrorAlert,
				  getString(buffer, notEnoughMemory,
					    params->VKBProg), NULL, NULL);
			break;
		    }

		}

		//where to start
		FldGetSelection(aField, &start, &end);
		//no selection
		if (start == end)
		    //ensure we get the insertion point
		    end = FldGetInsPtPosition(aField);
		//start from past the current selection
		start = end;

		//main text field
		texta = FldGetTextPtr(aField);
		//target string to search for
		textt = FldGetTextPtr(bField);
		//new text or replace text
		textr =
		    FldGetTextPtr(FrmGetObjectPtr
				  (aForm,
				   FrmGetObjectIndex(aForm, rplcFld)));

		//if parameters are present and non-empty ...
		if (texta && textt) {
		    if (*texta && *textt) {

			//get text lengths
			tlen = StrLen(textt);
			if (textr)
			    rlen = StrLen(textr);
			else
			    //the replace text can be empty, that means we are erasing
			    //the target string
			    rlen = 0;

			//length of main text from where we are
			currlen = StrLen(texta + end);

			//if we have space for at least a new replace
			//(replacelen <= maxlen - total_len + prevtext_todelete_len)
			if (rlen <= maxchars - (end + currlen) + tlen) {

			    //determine if we want an exact search
			    sensitive =
				CtlGetValue(FrmGetObjectPtr
					    (aForm,
					     FrmGetObjectIndex(aForm,
							       findExactCheck)));

			    //cancel selection
			    FldSetSelection(aField, 0, 0);
			    //disable main text while operating
			    FldObjectDisable(aForm, itext);

			    //proceed to replace all
			    while (true) {

				//cancel operation on pen down
				EvtGetPen(&px, &py, &pdown);
				if (pdown) {
				    rplccount = 0;
				    break;
				}
				//find target text on remaining main text
				aux = end;
				got =
				    findText(sensitive, aField, texta,
					     textt, tlen, currlen, &aux);

				if (!got) {
				    //no more matches found.
				    //replace the subset of the main text which contains the target
				    //string with the constructed replaced text

				    //if we have to delete something ...
				    if (start != end) {
					UndMarkTrans(params);
					FldDelete(aField, start, end);
				    }
				    //if we have to insert something
				    if (spanr) {
					if (start == end)
					    UndMarkTrans(params);
					else
					    //the user does not care about this operation details,
					    //force no transaction
					    UndToogleForceNoTrans(NULL);
					FldInsert(aField, pspace, spanr);
					if (start != end)
					    UndToogleForceNoTrans(NULL);
				    }
				    break;
				} else {
				    //construct the replaced text.
				    //determine the length of the text between target instances
				    lbaux = aux - end;

				    currlen -= lbaux + tlen;

				    //for the first replace, adjust the beginning of target strings,
				    //also warn if the operation is to delete the target text
				    if (first) {
					start = aux;
					if (!rlen)
					    if (!ShowError1
						(replaceEmptyAlert))
						break;
				    }
				    //check if we have space for other insert
				    //(replacelen > maxlen - (len_before_target + len_after_target))
				    if (rlen >
					maxchars - (start + spanr +
						    currlen)) {
					ShowError(customErrorAlert,
						  fieldFullAlert, "", "");
					rplccount = 0;
					break;
				    }
				    //write the text between targets to constructed text
				    if (lbaux && !first) {
					DmWrite(pspace, spanr, texta + end,
						lbaux);
					spanr += lbaux;
				    }
				    //write new text, if non-empty, to constructed text
				    if (rlen) {
					DmWrite(pspace, spanr, textr,
						rlen);
					spanr += rlen;
				    }

				    if (first)
					first = false;

				    //update start of remaining to search text
				    end = aux + tlen;

				    //update replace count
				    rplccount++;

				}

			    }

			    //show the field again after operation,
			    //move to the beginning so that the user can
			    //continue replacing from there
			    FldSetScrollPosition(aField, 0);
			    FrmShowObject(aForm, itext);
			    FldSetSelection(aField, 0, 0);
			    FldSetInsPtPosition(aField, 0);

			} else
			    //there was not enough space for even a single replace
			    ShowError(customErrorAlert, fieldFullAlert, "",
				      "");

			//release working memory
			if (space) {
			    MemHandleUnlock(space);
			    MemHandleFree(space);
			}
			//show replace count
			if (rplccount <= (DWord) 99999)
			    StrIToA(tnum, rplccount);
			else
			    //theoretic
			    initArray(tnum, ">100k\0", 6);
			ShowError(replaceEndAlert, tnum, "", "");

			//refresh things
			FldSendChangeNotification(aField);
			refreshRButtons();

		    }

		}

		break;

	    }

	    //replace
	    //this uses too much stack, it will be great to re-write this
	case rplcBtn:{
		Word end = 0;
		UInt16 tlen = 0, auxlen = 0, itext = 0, aresult =
		    0, start = 0;
		FieldPtr bField = NULL;
		CharPtr texta = NULL, textt = NULL, textr = NULL;
		Boolean sensitive = false, got = false, rfirst = true;
		Char tnum[8];
		DWord rplccount = 0;
		RectangleType auxrect;

		aForm = FrmGetActiveForm();
		itext = FrmGetObjectIndex(aForm, textFld);
		aField =
		    FrmGetObjectPtr(aForm,
				    FrmGetObjectIndex(aForm, textFld));
		bField =
		    FrmGetObjectPtr(aForm,
				    FrmGetObjectIndex(aForm, findFld));

		//main text field
		texta = FldGetTextPtr(aField);
		//target to search for
		textt = FldGetTextPtr(bField);
		//new text to replace
		textr =
		    FldGetTextPtr(FrmGetObjectPtr
				  (aForm,
				   FrmGetObjectIndex(aForm, rplcFld)));

		//if parameters are present and non-empty ...
		if (texta && textt) {
		    if (*texta && *textt) {

			//get target length
			tlen = StrLen(textt);

			//see if the search must be exact
			sensitive =
			    CtlGetValue(FrmGetObjectPtr
					(aForm,
					 FrmGetObjectIndex(aForm,
							   findExactCheck)));

			while (true) {
			    UInt16 aux1 = 0, aux2 = 0;
			    //since we first set the insertion point, this cannot be much
			    Int8 lscroll = 0;
			    Boolean scrolling = true;

			    //start at insertion point or end of selection
			    FldGetSelection(aField, &start, &end);
			    if (start == end)
				end = FldGetInsPtPosition(aField);

			    //length of text to search
			    auxlen = StrLen(texta + end);

			    //start searching at the end of selection, or at the insertion point,
			    //look for a match (result returned in the end variable)
			    got =
				findText(sensitive, aField, texta, textt,
					 tlen, auxlen, &end);

			    //cancel selection and disable field before operating
			    FldSetSelection(aField, 0, 0);
			    FldObjectDisable(aForm, itext);

			    if (got) {
				//set insertion point after found target
				FldSetInsPtPosition(aField, end + tlen);

				//determine if the confirmation dialog is going to obstruct lines
				FldGetBounds(aField, &auxrect);
				aux1 =
				    FldCalcFieldHeight(texta +
						       FldGetScrollPosition
						       (aField),
						       auxrect.extent.x);
				aux2 =
				    FldCalcFieldHeight(texta +
						       FldGetInsPtPosition
						       (aField),
						       auxrect.extent.x);

				if (aux1 > aux2) {
				    //lines_to_scroll = (number of lines to the insertion point)
				    //- (only 3 lines are left visible after the mini dialog
				    //and the confirmation dialog)
				    lscroll = aux1 - aux2 + 1 - 3;
				    while (lscroll-- > 0)
					//scroll a line
					TextScroll(down);
				    //no scrolling update when we have blank lines
				    //(not necessary if the field is small, or
				    //not useful when we are trying to show obstructed lines)
				    if (FldGetNumberOfBlankLines(aField))
					scrolling = false;
				}
				//show found target
				FrmShowObject(aForm, itext);
				FldSetSelection(aField, end, end + tlen);

				//ask to replace
				aresult = ShowError1(replaceAskAlert);
				if (aresult == 0) {
				    //we must replace at current location
				    replaceText1(rfirst, aField, textr);
				    //only ask for empty replace the first time
				    rfirst = false;
				    FldGetSelection(aField, &start, &end);
				    //if replace failed and not deleting,
				    //field must be full (or in some rare case, not responding)
				    if (start != end) {
					if (textr && *textr) {
					    ShowError(customErrorAlert,
						      fieldFullAlert, "",
						      "");
					    //field is full, break
					    break;
					} else
					    //deletion canceled, break
					    break;
				    } else
					//increase replace count
					rplccount++;
				} else if (aresult == 2)
				    //no more replaces required
				    break;
			    } else {
				//no match found, set the scroll position at the beginning, so that the
				//user can continue with the operation; make field visible again
				FldSetScrollPosition(aField, 0);
				FrmShowObject(aForm, itext);
				FldSetSelection(aField, 0, 0);
				FldSetInsPtPosition(aField, 0);
				break;
			    }

			    //refresh things
			    if (scrolling) {
				refreshRButtons();
				updateScroll(aForm, aField, NULL);
			    }

			}

			//show replace count
			if (rplccount <= (DWord) 99999)
			    StrIToA(tnum, rplccount);
			else
			    //theoretic
			    initArray(tnum, ">100k\0", 6);

			ShowError(replaceEndAlert, tnum, "", "");

			//refresh things
			FldSendChangeNotification(aField);
			refreshRButtons();
			updateScroll(aForm, aField, NULL);

		    }

		}

		break;

	    }

	    //find in text
	    //this uses a lot of stack
	case findFindBtn:{
		Word end = 0;
		UInt16 tlen = 0, auxlen = 0, itext = 0;
		FieldPtr bField = NULL;
		CharPtr texta = NULL, textt = NULL;
		Boolean sensitive = false, got = false;

		aForm = FrmGetActiveForm();
		itext = FrmGetObjectIndex(aForm, textFld);
		aField =
		    FrmGetObjectPtr(aForm,
				    FrmGetObjectIndex(aForm, textFld));
		bField =
		    FrmGetObjectPtr(aForm,
				    FrmGetObjectIndex(aForm, findFld));

		//start at insertion point or end of selection
		{
		    Word start = 0;

		    FldGetSelection(aField, &start, &end);
		    if (start == end)
			end = FldGetInsPtPosition(aField);
		}

		//main text
		texta = FldGetTextPtr(aField);
		//target text
		textt = FldGetTextPtr(bField);

		//if parameters are present and non-empty ...
		if (texta && textt) {
		    if (*texta && *textt) {

			tlen = StrLen(textt);
			auxlen = StrLen(texta + end);

			//see if exact is requested
			sensitive =
			    CtlGetValue(FrmGetObjectPtr
					(aForm,
					 FrmGetObjectIndex(aForm,
							   findExactCheck)));

			//find target in main text
			got =
			    findText(sensitive, aField, texta, textt, tlen,
				     auxlen, &end);

			//disable field before proceeding
			FldSetSelection(aField, 0, 0);
			FldObjectDisable(aForm, itext);

			if (got) {
			    //we got a match, show it
			    FldSetInsPtPosition(aField, end + tlen);
			    FrmShowObject(aForm, itext);
			    FldSetSelection(aField, end, end + tlen);
			} else {
			    //no match, go to beginning of text
			    //so that the user can continue searching
			    FldSetScrollPosition(aField, 0);
			    FrmShowObject(aForm, itext);
			    FldSetSelection(aField, 0, 0);
			    FldSetInsPtPosition(aField, 0);
			}

			//refresh things
			FldSendChangeNotification(aField);
			refreshRButtons();

		    }

		}

		break;

	    }

	    //shortcuts
	    //add a shortcut, close the dialog if successful
	case scaddBtn:{
		FieldPtr bField = NULL;
		char *sctext = NULL, *scname = NULL;

		aForm = FrmGetActiveForm();
		aField =
		    FrmGetObjectPtr(aForm,
				    FrmGetObjectIndex(aForm, scnameFld));
		bField =
		    FrmGetObjectPtr(aForm,
				    FrmGetObjectIndex(aForm, sctextFld));

		sctext = FldGetTextPtr(bField);
		scname = FldGetTextPtr(aField);
		if (sctext && scname) {
		    if (*sctext && *scname) {

			CharPtr macro = NULL;
			Boolean close = false;

			//look for already present macro
			lookMacro(params, scname, StrLen(scname), &close,
				  NULL, &macro);

			if (!close) {

			    //ok to add new macro
			    if (GrfAddMacro
				(scname, sctext, StrLen(sctext)))
				ShowError1(macroNotEnteredAlert1);

			} else {
			    //macro conflicts with present one
			    ShowError(macroNotEnteredAlert, macro, NULL,
				      NULL);
			    //release memory
			    if (macro)
				MemPtrFree(macro);
			    break;
			}

			//release memory
			if (macro)
			    MemPtrFree(macro);

		    } else {
			//missing parameters
			ShowError1(macroNotEnteredAlert2);
			break;
		    }
		} else {
		    //missing parameters
		    ShowError1(macroNotEnteredAlert2);
		    break;
		}

	    }

	    //cancel adding a shortcut
	case sccancelBtn:
	    aForm = FrmGetActiveForm();

	    //hide objects
	    FrmHideObject(aForm, FrmGetObjectIndex(aForm, scnameLbl));
	    FrmHideObject(aForm, FrmGetObjectIndex(aForm, sctextLbl));
	    FrmHideObject(aForm, FrmGetObjectIndex(aForm, scnameFld));
	    FrmHideObject(aForm, FrmGetObjectIndex(aForm, sctextFld));
	    FrmHideObject(aForm, FrmGetObjectIndex(aForm, scaddBtn));
	    FrmHideObject(aForm, FrmGetObjectIndex(aForm, sccancelBtn));

	    //repaint resized
	    params->special &= ~extendedOn;
	    params->special |= resize;
	    KeyboardCall(kbDrawAll, parameters);

	    FrmSetFocus(aForm, FrmGetObjectIndex(aForm, textFld));

	    paintToolbar(params);
	    WinDrawLine(0, 0, widthScreen, 0);

	    break;

#undef aForm
#undef aField

	    //keyboard selectors
	case abcPush:
	    callType = kbDrawAlpha;
	    aEvent->data.ctlSelect.on = false;

	case numPush:
	    if (!callType)
		callType = kbDraw123;

	case intlCheck:
	    //reset accents
	    params->accent = noAcc;

	    if (!callType) {
		//international keypad selected/unselected
		callType = kbDrawIntl;

		if (aEvent->data.ctlSelect.on)
		    params->special |= intlUp;
		else
		    params->special &= ~intlUp;

	    } else if (callType == kbDraw123)
		//numeric keypad selected
		params->special |= numUp;
	    else
		//alphabetic keypad selected
		params->special &= ~numUp;

	    //recalculate form layout
	    parameters->special |= resize;

	    //if requesting international keypad, but not available, then disable it
	    if (callType == kbDrawIntl
		&& !(params->special2 & accentedChars)) {
		FormPtr aForm = FrmGetActiveForm();

		CtlSetValue(FrmGetObjectPtr
			    (aForm, FrmGetObjectIndex(aForm, intlCheck)),
			    false);
		params->special &= ~intlUp;
	    }
	    //redraw for requested keypad
	    KeyboardCall(kbDrawAll, parameters);

	    break;

	}

	break;

	//events to simulate keyboard keys on-screen
    case penMoveEvent:{

#define auxin (params->m2->bo2)
//frame defines how many pixels inside another key this key is accepted, for atpenup or slow keys
#define frame 3

	    //track pen position relative to key being hold down (for atpenup or slow keys)
	    if (params->atpenup) {
		if (params->kbDown) {

	    	    //are we in the key?
	            auxin =
		        aEvent->screenX >= params->key.topLeft.x - frame &&
		        aEvent->screenX <= params->key.topLeft.x + params->key.extent.x + frame &&
		        aEvent->screenY >= params->key.topLeft.y - frame &&
		        aEvent->screenY <= params->key.topLeft.y + params->key.extent.y + frame;

		    //we are out of the key, and the key is painted, then un-paint it
		    if (!auxin && !params->keyNotPainted) {
			InvertButton4(&(params->key));
			params->keyNotPainted = true;
		    }
		    //we are in the key, and the key is not painted, then paint it
		    if (auxin && params->keyNotPainted) {
			InvertButton4(&(params->key));
			params->keyNotPainted = false;
		    }

		}
	    }

	    break;

	}

    case penDownEvent:
	//pendown on a key requires inverting (painting) it
	callType = kbInvert;
	//assume for now that this is not a toolbar key
	params->toolb = false;
	//reset key painting tracking
	parameters->keyNotPainted = true;

    case penUpEvent:{

	    //on penup the the keys should not be inverted
	    parameters->special &= ~keyInvert;

	    //handle a penup event
	    if (callType == NULL) {

		//disable auto repeat keys
		params->keychar = NULL;
		params->keyauto = false;

		//no key was being hold, just return
		if (!parameters->kbDown)
		    break;

		//key is no longer being hold
		parameters->kbDown = false;

		//reset accent un-selection auxiliary
		params->refresh &= ~accKeyAux;

		callType = kbRead;

		//invert at penup for non-accent keys
		if (!(params->refresh & accKey)) {
		    //if key is painted, then it should not be
		    if (!parameters->keyNotPainted)
			InvertButton4(&(parameters->key));
	    	    parameters->keyNotPainted = true;
		} else
		    params->refresh &= ~accKey;

		if (params->refresh & refreshShift) {
		    //repaint keyboard request (for fast keys)
		    KeyboardCall(kbDrawAll, params);
		    params->refresh &= ~refreshShift;
		}

		if (params->refresh & refreshAcc) {
		    //un-paint accent request (for fast keys)
		    ReadKeyboardIntl2(params, params->accent);
		    params->accent = noAcc;
		    params->refresh &= ~refreshAcc;
		}

		//did we lift the pen in the key bounds?
		auxin =
		    aEvent->screenX >= params->key.topLeft.x - frame &&
		    aEvent->screenX <=
		    params->key.topLeft.x + params->key.extent.x + frame
		    && aEvent->screenY >= params->key.topLeft.y - frame
		    && aEvent->screenY <=
		    params->key.topLeft.y + params->key.extent.y + frame;

		//for peunp keys: we are not in the key, do not do any action; or
		//we are handling fast keys: do not do any further action
		if (!auxin || (!params->atpenup && !params->toolb)) {
		    //on penup or fast keys, the layout data marker should be initialized
		    //at this point, the key was already processed
		    params->markpos = NULL;
		    //this was a penup, we can no longer be tracking toolbar keys
		    params->toolb = false;
		    break;
		}
		//this was a penup, we can no longer be tracking toolbar keys
		params->toolb = false;

		//since the key is accepted in its bounds plus frame, ensure consistency
		aEvent->screenX =
		    params->key.topLeft.x + params->key.extent.x / 2;
		aEvent->screenY =
		    params->key.topLeft.y + params->key.extent.y / 2;

	    } else
		//on pen down, the keys should be inverted
		parameters->special |= keyInvert;

	    //save the event for the keyboard call
	    parameters->extra1 = aEvent;
	    //try to read or invert keys
	    if (handled = KeyboardCall(callType, parameters)) {

		//if we actually handled a key being pushed, signal that
		if (callType == kbInvert)
		    parameters->kbDown = true;

	    }

	    break;

	}

    }

    return handled;
}

#undef handled
#undef parameters
#undef auxin
#undef frame

/*
 * Helper functions for the implementation of the replace part of the find mini dialog.
 *
 */
void replaceText(FieldType * aField, Char * replacetext)
{
    replaceText1(true, aField, replacetext);
}

void replaceText1(Boolean warn, FieldType * aField, Char * replacetext)
{
    Boolean doit = false;

    //helps to interact with user while replacing
    if (replacetext) {
	if (*replacetext)
	    //replace text non-empty
	    FldInsert(aField, replacetext, StrLen(replacetext));
	else {
	    if (warn)
		//warn that replace text is empty, deleting
		doit = !ShowError1(replaceEmptyAlert);
	    //ok to delete
	    if (!doit)
		FldCut(aField);
	}
    } else {
	if (warn)
	    //warn that replace text is empty, deleting
	    doit = !ShowError1(replaceEmptyAlert);
	//ok to delete
	if (!doit)
	    FldCut(aField);
    }

}

/*
 * Helper function for the implementation of the find mini dialog
 * (this is not an efficient search implementation, but Palm memos are small).
 *
 */
Boolean findText(Boolean sensitive, FieldType * aField, Char * texta, Char * textt, Word lent,
		Word len_remain,	//this is StrLen(texta + end)
		 Word * _end)
{
    CharPtr textb = NULL;
    Word end = *_end;
    DWord ix = NULL;

    if (sensitive)
	//exact is easy
	textb = StrStr(texta + end, textt);
    else {
	//non-exact

	//relative target index
	ix = NULL;

	//size of remaining text
	if (len_remain >= lent)
	    len_remain -= lent - 1;
	else
	    //we will never find it
	    len_remain = 0;

	//search in ~o((lenmain-lentarget)*lentarget) steps
	while (len_remain - ix) {
	    if (!StrNCaselessCompare(texta + end + ix, textt, lent)) {
		//signal that we found it, but position is in terms of ix
		textb = (Char *) 1;
		break;
	    }
	    ix++;
	}

    }

    //we found it
    if (textb) {
	if (sensitive)
	    //found it after texta, at textb, determine last target position directly
	    end = textb - texta;
	else
	    //found it at last position plus target index
	    end += ix;
	//update last target position
	*_end = end;
	return true;
    } else {
	//no more matches
	ShowError1(searchEnded);
	*_end = 0;
	return false;
    }

}

/*
 * Helper functions to scroll the text field by lines or pages.
 *
 */
void TextScroll(DirectionType direction)
{
    TextScroll1(direction, false);
}

void TextScroll1(DirectionType direction, Boolean page)
{
    FormPtr aForm = NULL;
    FieldPtr aField = NULL;
    //lines to scroll
    short lines = 1;

    aForm = FrmGetActiveForm();
    aField =
	(FieldPtr) FrmGetObjectPtr(aForm,
				   FrmGetObjectIndex(aForm, textFld));

    //if requested to scroll by page, then scroll by visible lines - 1
    if (page) {
	lines = FldGetVisibleLines(aField) - 1;
	if (lines < 1)
	    lines = 1;
    }
    //scroll text
    FldScrollField(aField, lines, direction);
    FldSendChangeNotification(aField);

}

/*
 * Synchronizes the scroll bar with the traditional keyboard scroll buttons.
 * This uses some stack
 */
void refreshRButtons()
{
    FormPtr aForm = NULL;
    FieldPtr aField = NULL;
    Word index1 = 0, index2 = 0;
    Boolean rbvisible = false;
    ControlType *control1 = NULL;

    aForm = FrmGetActiveForm();
    aField =
	(FieldPtr) FrmGetObjectPtr(aForm,
				   FrmGetObjectIndex(aForm, textFld));

    //get refresh buttons indexes
    index1 = FrmGetObjectIndex(aForm, upRBtn);
    index2 = FrmGetObjectIndex(aForm, downRBtn);

    control1 = (ControlType *) FrmGetObjectPtr(aForm, index1);
    rbvisible = control1->attr.visible;

    //enable or disable scrollers
    FrmUpdateScrollers(aForm, index1, index2, FldScrollable(aField, up),
		       FldScrollable(aField, down));

    //we assume that the repeat buttons are both hidden or shown,
    //if they just changed state, then ....
    if (control1->attr.visible != rbvisible) {
	if (control1->attr.visible) {
	    //setup the scroll bar
	    RectangleType abounds;

	    FldGetBounds(aField, &abounds);
	    updateScroll(aForm, aField, &abounds);

	} else
	    //no repeat buttons, then no scroll bar
	    SclSetScrollBar(FrmGetObjectPtr
			    (aForm, FrmGetObjectIndex(aForm, kbScroll)), 0,
			    0, 0, 0);
    }

}

/*
 * Helper scroll function
 */
void updateScroll(FormPtr aForm, FieldPtr kbText, RectanglePtr bounds)
{
    FieldAttrType attrs;
    Boolean pos = false;

    FldGetAttributes(kbText, &attrs);

    if (attrs.hasScrollBar) {
	Word iscroll = FrmGetObjectIndex(aForm, kbScroll), spos = 0, th =
	    0, fh = 0;
	ScrollBarPtr ptrscroll = FrmGetObjectPtr(aForm, iscroll);
	DWord lhack = NULL;

	//adapt behavior if left hack is found
	FtrGet('Left', 1000, &lhack);

	//position the scroll bar next to the text field
	if (bounds) {
	    SWord exx = bounds->extent.x;

	    //if there is enough space for the scroll bar ...
	    if (widthScreen - exx >= wScroll) {
		//we have positioned
		pos = true;
		//the horizontal margin to position the scrollbar
		//it is just after the field, or if left hack present, then
		//it is tricky
		exx += bounds->topLeft.x - (lhack ? wScroll + 1 : 0);
		bounds->topLeft.x = exx;
		//set the width of the scrollbar
		bounds->extent.x = wScroll;
		//hide and resize the scrollbar ...
		SclSetScrollBar(FrmGetObjectPtr(aForm, iscroll), 0, 0, 0,
				0);
		FrmSetObjectBounds(aForm, iscroll, bounds);
	    } else
		//there is not enough space for the scrollbar
		SclSetScrollBar(FrmGetObjectPtr(aForm, iscroll), 0, 0, 0,
				0);

	}
	//if we positioned the scrollbar or the scrollbar is showing ...
	if (pos || ptrscroll->attr.visible && ptrscroll->attr.shown) {
	    UInt16 numbl = FldGetNumberOfBlankLines(kbText);
	    //if there are blank lines showing, then try to fill them up
	    if (numbl)
		FldScrollField(kbText, numbl, up);
	    //we have to check this to be robust for possible layout databases
	    if (FldGetVisibleLines(kbText) > 1) {
		//set scrollbar values
		FldGetScrollValues(kbText, &spos, &th, &fh);
		SclSetScrollBar(ptrscroll, spos, 0,
				th > fh ? th - fh : (spos ? spos : 0),
				fh - 1);
	    }
	}

    }

}

/*
 * Handles keyboard gadget input and display
 */
Boolean KeyboardCall(short operation, KeyboardParams * params)
{
    DWord dwaux = NULL;
    Word heightcln = 0;
    FontID fntaux = NULL;

    if (!params->VKBLayout)
	return false;

    //The characters for the international keypad are here
    params->intl = (WChar *) internationalChars;

    //dynamic resizing of the keyboard form
    if (params->special & resize) {
	FormPtr aForm = FrmGetActiveForm();
	Word igdt = FrmGetObjectIndex(aForm, VKBGdt), prevy = 0, prevh =
	    0, start = 0, end = 0, ipaux = 0;
	FieldPtr kbText =
	    FrmGetObjectPtr(aForm, FrmGetObjectIndex(aForm, textFld));
	short skipv = 0, fpix = 0;
	RectangleType bounds;

	//determine lines of text used by layout
	if (params->special & numUp)
	    skipv = params->gdtLinesn;
	else
	    skipv = params->gdtLinesa;

	if ((params->special & intlUp) && !(params->special & numUp))
	    skipv += intlLines;

	//get current line height of main text field
	fntaux = FntGetFont();
	FntSetFont(FldGetFont(kbText));
	heightcln = FntLineHeight();
	FntSetFont(fntaux);

	//pixels available for text field
	//look for heightLine in the resource header files
	fpix = (totalLines - skipv) * heightLine;

	//clean current gadget area
	FrmGetObjectBounds(aForm, igdt, &bounds);
	bounds.topLeft.y--;
	bounds.extent.y++;
	WinEraseRectangle(&bounds, 0);
	bounds.topLeft.y++;
	bounds.extent.y--;
	//calculate gadget space
	bounds.topLeft.y = fpix + heightTitle + 1;
	bounds.extent.y = skipv * heightLine + 5;
	FrmSetObjectBounds(aForm, igdt, &bounds);

	//calculate text field space
	FldGetBounds(kbText, &bounds);
	//take into account the space used by the toolbar (1) or mini dialog (4)
	//look for margin2 in the resource header files
	prevy = bounds.topLeft.y;
	bounds.topLeft.y =
	    heightLine * (params->special & extendedOn ? 4 : 1) + margin2;
	//take into account space used by the mini-dialogs (toolbar is hidden)
	prevh = bounds.extent.y;
	bounds.extent.y =
	    fpix - (params->special & extendedOn ? 3 : 0) * heightLine;
	//put the field height in terms of full lines (of current font)
	bounds.extent.y -= bounds.extent.y % heightcln;
	//do changes if needed
	if (prevy != bounds.topLeft.y || prevh != bounds.extent.y) {

	    //hide before adjusting
	    FrmHideObject(aForm, FrmGetObjectIndex(aForm, textFld));

	    //save selection/insertion
	    FldGetSelection(kbText, &start, &end);
	    FldSetSelection(kbText, 0, 0);
	    ipaux = FldGetInsPtPosition(kbText);
	    FldSetInsertionPoint(kbText, 0);

	    //resize and position field
	    FldSetBounds(kbText, &bounds);
	    //refresh field
	    FrmShowObject(aForm, FrmGetObjectIndex(aForm, textFld));

	    //goto selection/insertion
	    FldSetInsPtPosition(kbText, ipaux);
	    FldSetSelection(kbText, start, end);
	    if (start == end)
		InsPtEnable(true);
	    else
		InsPtEnable(false);

	    //refresh scrollers
	    updateScroll(aForm, kbText, &bounds);
	    FldSendChangeNotification(kbText);
	    refreshRButtons();
	}
	//done resizing
	params->special &= ~resize;

    }

    switch (operation) {

	//draw or refresh all
    case kbDrawAll:{

            //refreshing
            params->refresh |= refreshing;

	    //draw alphabetic if selected
	    KeyboardCall(kbDrawAlpha, params);

	    //draw numeric if selected
	    KeyboardCall(kbDraw123, params);

	    //draw intl if selected
	    KeyboardCall(kbDrawIntl, params);

            params->refresh &= ~refreshing;

	    break;

	}

    case kbDrawAlpha:{

#define active (params->m2->aForm)

	    active = FrmGetActiveForm();

	    //only if user wants to paint this ...
	    if (!CtlGetValue((ControlPtr)
			     FrmGetObjectPtr(active,
					     FrmGetObjectIndex(active,
							       numPush))))
	    {

		if (params->special & intlUp)
		    //leave space for international keypad
		    DrawKeyboardAlpha1(params, 1);
		else
		    DrawKeyboardAlpha(params);
		break;

	    }
#undef active

	}

    case kbDrawIntl:{

#define active (params->m2->aForm)

	    active = FrmGetActiveForm();

	    //if in alphabetic mode and only if user wants to paint this ...
	    if (!(params->special & numUp))
		if (CtlGetValue((ControlPtr)
				FrmGetObjectPtr(active,
						FrmGetObjectIndex(active,
								  intlCheck))))
		    DrawKeyboardIntl(params);

	    break;

#undef active

	}

    case kbDraw123:{

#define active (params->m2->aForm)

	    active = FrmGetActiveForm();

	    //only if user wants to paint this ...
	    if (CtlGetValue((ControlPtr)
			    FrmGetObjectPtr(active,
					    FrmGetObjectIndex(active,
							      numPush))))
		DrawKeyboard123(params);

	    break;

#undef active

	}

    case kbInvert:

    case kbRead:

	//handle keys
	if (params->extra1 != NULL)
	    return ReadKeyboardAll(params);

	return false;

    default:
	//operation not handled
	return false;

    }

    return true;

}

#define handled (params->m2->bo4)
#define auxIntl (params->m2->i1)
#define auxNum (params->m2->i2)

/*
 * Read keyboard input, and draw keyboard layout functions
 */
//this uses a lot of stack
Boolean ReadKeyboardAll(KeyboardParams * params)
{

    handled = false;

    auxIntl = params->special & intlUp;
    auxNum = params->special & numUp;

    if (auxNum)
	//read numeric keys
	handled = ReadKeyboard123(params);
    else
	//read alphabetic keys taking into account if intl keypad is up (keys
	//are lower in the gadget)
	handled = ReadKeyboardAlpha1(params, auxIntl ? 1 : 0);

    //if not already read a key and intl may be up, then read international keys
    if (!handled)
	if (!auxNum && auxIntl)
	    handled = ReadKeyboardIntl(params);

    //if still not read a key, then try to read toolbar keys
    if (!handled)
	handled = readToolbar(params);

    return handled;
}

#undef handled
#undef auxIntl
#undef auxNum

/*
 * Functions for drawing the installed layout
 */
void DrawKeyboardAlpha(KeyboardParams * params)
{
    DrawKeyboardAlpha1(params, 0);
}

void DrawKeyboardAlpha1(KeyboardParams * params, short skipv)
{
    DrawKeyboardAlpha2(params, skipv, 0);
}

void DrawKeyboardAlpha2(KeyboardParams * params, short skipv, short numpad)
{
    FormPtr aForm = FrmGetActiveForm();
    RectangleType bounds;
    DWord aux = NULL;
    DmOpenRef VKBProg = NULL;
    short cellH = 0;
    BitmapType *bitmap = NULL;

    if (!params->VKBLayout)
	return;

    //geometry parameters
    FntSetFont(stdFont);
    cellH = FntLineHeight();

    //get gadget bounds
    FrmGetObjectBounds(aForm, FrmGetObjectIndex(aForm, VKBGdt), &bounds);

    //skip lines (useful when intl keypad is up)
    skipv *= cellH;

    //set selected background color
    if (params->OS35) {
	WinPushDrawState();
	Color();
    }
    //clean gadget
    WinEraseRectangle(&bounds, 0);

    //choose alphabetic keypad bitmap according to shift and caps state
    if (!numpad) {
	if (params->shift) {
	    if (params->cap)
		bitmap = params->bmpsc;
	    else
		bitmap = params->bmps;
	} else {
	    if (params->cap)
		bitmap = params->bmpc;
	    else
		bitmap = params->bmp;
	}
	//numeric keypad is selected
    } else
	bitmap = params->bmpn;

    //set vertical position and draw selected keypad
    bounds.topLeft.y += skipv + 1;
    WinDrawBitmap(bitmap, bounds.topLeft.x, bounds.topLeft.y);

    if (params->OS35)
	WinPopDrawState();

}

/*
 * Functions for performing the installed layout actions (input characters, strings, etc.)
 */
Boolean ReadKeyboardAlpha(KeyboardParams * params)
{
    return ReadKeyboardAlpha1(params, 0);
}

Boolean ReadKeyboardAlpha1(KeyboardParams * params, short skipv)
{
    return ReadKeyboardAlpha2(params, skipv, 0);
}

Boolean ReadKeyboardAlpha2(KeyboardParams * params, short skipv,
			   short numpad)
{
    RectangleType bounds, area;
    EventPtr aEvent = (EventPtr) params->extra1;
    short cellH = 0;
    FormPtr aForm = FrmGetActiveForm();
    Boolean handled = false, readrect = true, kinvert = false, inbounds =
	false, inaux = false, abort = false;
    unsigned short laux = 0, narea = 0;
    unsigned char *data = NULL, *maux = 0;	//for marking positions
    WChar toupper = '\0', adata = '\0',	//the character to input,
					//or the x dimension (in keys) of the input area
     bdata = '\0',		//shift (or caps) character,
				//or the y dimension (in keys) of the input area
     type = '\0';		//area type

    if (!params->VKBLayout)
	return false;

    //get gadget bounds
    FrmGetObjectBounds(aForm, FrmGetObjectIndex(aForm, VKBGdt), &bounds);

    //skip lines (useful when intl keypad is up)
    FntSetFont(stdFont);
    cellH = FntLineHeight();
    skipv *= cellH;
    bounds.topLeft.y += skipv + 1;

    //should we invert the keys
    kinvert = params->special & keyInvert;

    //select keypad definition string, according to main keypad being used
    if (numpad)
	data = params->strb;
    else
	data = params->stra;

    //we are not inverting the key, but actually performing its action,
    //use the saved position into the keypad definition string, to save some key processing
    if (!kinvert) {
	if (params->markpos) {
	    data = params->markpos;
	    //try to ensure consistency
	    params->markpos = NULL;
	    //do not test key geometry again
	    readrect = false;
	}
    }

    if (readrect)
	//test each key
	narea = *(data++);
    else
	//we are just returning to perform the key action
	narea = 1;

    inbounds = RctPtInRectangle(aEvent->screenX, aEvent->screenY, &bounds);

    //if we are returning or in the main keypad bounds
    if (!readrect || inbounds)
	while (narea--) {

	    //read area rectangle (if returning we need this anyway)
	    area.topLeft.x = bounds.topLeft.x + *(data++);
	    area.topLeft.y = bounds.topLeft.y + *(data++);
	    area.extent.x = *(data++);
	    area.extent.y = *(data++);

	    if (readrect) {
		//see if we are in the key
		inaux =
		    aEvent->screenX > area.topLeft.x &&
		    aEvent->screenX <= area.topLeft.x + area.extent.x &&
		    aEvent->screenY > area.topLeft.y &&
		    aEvent->screenY <= area.topLeft.y + area.extent.y;
	    } else
		//we are returning to perform action
		inaux = true;

	    //mark this point (after key geometry)
	    maux = data;

	    //now we can read ...
	    //the area type
	    type = *(data);
	    //adata
	    adata = *(data + 1);
	    //bdata
	    bdata = *(data + 2);

	    //assume a not shifted character
	    toupper = '\0';

	    //the current key was tapped
	    while (inaux) {

		//no further key definitions need to be processed
		handled = true;

		//for atpenup keys: perform action if key was already inverted,
		//  but always enter for a and b types (we need to calculate the key bounds)
		//or for fast keys: perform action right away
		if (!kinvert || type == 'a' || type == 'b'
		    || !params->atpenup)
		    switch (type) {

			//here are processed the area types supported

			//a An area divided into rows and columns to use for shift
			//affected characters.
		    case 'a':
			//b An area divided into rows and columns used for alphabetic
			//characters.
		    case 'b':{
			    unsigned short cx = 0, cy = 0, x = 0, y = 0;

			    //set dimensions
			    x = adata;
			    y = bdata;

			    //tuning
			    if (x > 1)
				area.extent.x++;
			    if (y > 1)
				area.extent.y++;

			    //set extents to pixels per key
			    area.extent.y = area.extent.y / y;
			    area.extent.x = area.extent.x / x;

			    //determine character to input indexes
			    //area has more than one row
			    if (y > 1) {
				//vertical pixels into the keypad area
				cy = (aEvent->screenY - area.topLeft.y);
				//we are exactly in a key separating line ...
				if (cy % area.extent.y == 0) {
				    //do not invert, enter, or handle key
				    kinvert = NULL;
				    adata = NULL;
				    abort = true;
				    break;
				}
				//key character index in y
				cy /= area.extent.y;
				//do not allow indexes beyond declared dimensions
				if (cy >= y)
				    cy = y - 1;
			    } else
				//area has only one row
				cy = 0;

			    //area has more than one column
			    if (x > 1) {
				//horizontal pixels into the keypad area
				cx = (aEvent->screenX - area.topLeft.x);
				//we are exactly in a key separating line ...
				if (cx % area.extent.x == 0) {
				    //do not invert, enter, or handle key
				    kinvert = NULL;
				    adata = NULL;
				    abort = true;
				    break;
				}
				//key character index in x
				cx /= area.extent.x;
				//do not allow indexes beyond declared dimensions
				if (cx >= x)
				    cx = x - 1;
			    } else
				//area has only one column
				cx = 0;

			    //now that we know the character indexes into this area,
			    //set the top-left point of the selected key
			    area.topLeft.y += area.extent.y * cy;
			    area.topLeft.x += area.extent.x * cx;

			    //tuning
			    if (x > 1)
				area.extent.x--;

			    if (y > 1)
				area.extent.y--;

			    //advance keyboard layout definition to point to the area characters
			    data += 3;

			    //for type a areas, if we are shifted, then we must offset past the
			    //first set of (x*y) characters, to reach the shift characters
			    if (params->shift && type == 'a')
				data += x * y + x * cy + cx;
			    //get the character to be entered
			    //advance cy rows, then select character cx in current row
			    else
				data += x * cy + cx;

			    //type b areas shift the characters in a standard way
			    if (type == 'b')
				if (params->shift != params->cap)
				    toupper = ' ';

			    //apply standard shift to the character if needed
			    adata = *data - toupper;

			    break;

			}

			//c An area for a single shift affected key.
		    case 'c':
			if (params->shift)
			    adata = bdata;
			break;

			//f An area for a single shift-caps affected key.
		    case 'f':
			if (params->shift || params->cap)
			    adata = bdata;
			break;

			//d An area for a single alphabetic key.
		    case 'd':
			if (params->shift != params->cap)
			    toupper = ' ';
			adata -= toupper;
			break;

			//e An area for multiple character input.
		    case 'e':{
			    unsigned short length =
				(unsigned short) adata, ix = 0;

			    UndMarkTrans(params);

			    while (length - ix)
				//3 is for the area type, length, and '\0' characters
				EvtEnqueueKey(data[3 + ix++], 0, 0);
			    MSndPlaySystemSound(sndClick);
			    //nothing else has to be entered
			    adata = '\0';

			    break;

			}

			//s The area is a shift key.
		    case 's':
			//set shift
			params->shift = !(params->shift);
			//refresh keyboard (shift key is already painted in the layouts)
			KeyboardCall(kbDrawAll, params);
			MSndPlaySystemSound(sndClick);
			//nothing else has to be entered
			adata = '\0';
			break;

			//p The area is a caps lock key.
		    case 'p':
			//set caps state
			params->cap = !(params->cap);
			params->shift = false;
			//refresh keyboard (shift and caps keys are already painted in the layouts)
			KeyboardCall(kbDrawAll, params);
			MSndPlaySystemSound(sndClick);
			//nothing else to be entered
			adata = '\0';
			break;

		    }
		//invert (paint) the key
		if (kinvert) {

		    if (params->keyNotPainted) {
			InvertButton41(area.topLeft.x, area.topLeft.y,
				       area.extent.x, area.extent.y,
				       params);
                        params->keyNotPainted = false;
		    }

		    //for atpenup keys, mark the current key for returning to perform action
		    if (params->atpenup) {
			params->markpos = maux - 4;
			break;
		    }

		}
		//insert key character into the field
		if (adata) {
		    EvtEnqueueKey(adata, 0, 0);
		    MSndPlaySystemSound(sndClick);
		}

		break;

	    }

	    //done
	    if (handled)
		break;

	    //advance the keypad definition string to the next area,
	    //according to the type of area that was processed (see overlay.txt)
	    switch (type) {

	    case 'a':
		data = maux + adata * bdata * 2 + 3;
		break;
	    case 'e':
	    case 'b':
		data = maux + adata * bdata + 3;
		break;
	    case 'c':
	    case 'f':
		data = maux + 3;
		break;
	    case 'd':
		data = maux + 2;
		break;
	    case 's':
	    case 'p':
		data = maux + 1;
		break;

	    }

	}
    //key not handled or aborted
    if (!handled || abort)
	handled = false;

    return handled;

}

/*
 * The numeric keypad is handled in the same way as is the alphabetic keypad
 */
void DrawKeyboard123(KeyboardParams * params)
{
    DrawKeyboard1231(params, 0);
}

void DrawKeyboard1231(KeyboardParams * params, short skipv)
{
    DrawKeyboardAlpha2(params, skipv, 104);
}

Boolean ReadKeyboard123(KeyboardParams * params)
{
    return ReadKeyboard1231(params, 0);
}

Boolean ReadKeyboard1231(KeyboardParams * params, short skipv)
{

    return ReadKeyboardAlpha2(params, skipv, 1);

}

/*
 * Functions for drawing the international keypad (some chars can be changed in VKBInput.h)
 */
void DrawKeyboardIntl(KeyboardParams * params)
{
    DrawKeyboardIntl1(params, 0);
}

void DrawKeyboardIntl1(KeyboardParams * params, short skipv)
{
    short cellH = 0, cellW = 0, cx = 0, x = 0, posy = 0;
    RectangleType bounds;
    char holder[2] = { '\0', '\0' };
    FormPtr aForm = FrmGetActiveForm();

    if (!params->VKBLayout)
	return;

    //draw with standard font
    WinSetUnderlineMode(noUnderline);
    FntSetFont(stdFont);

    //set draw parameters
    FrmGetObjectBounds(aForm, FrmGetObjectIndex(aForm, VKBGdt), &bounds);
    cellH = FntLineHeight() - 1;
    cellW = bounds.extent.x / intlCharsX;

    //set selected color
    if (params->OS35) {
	WinPushDrawState();
	Color();
    }
    //skip some cells from the beginning of the gadget
    skipv *= cellH;

    //set dimensions
    bounds.topLeft.y += skipv;
    bounds.extent.y = cellH;

    //clean
    WinEraseRectangle(&bounds, 0);

    //draw intl keys
    posy = bounds.topLeft.y + bounds.extent.y;
    for (cx = 0, x = bounds.topLeft.x; cx < intlCharsX; cx++, x += cellW) {
	//draw line separating international characters
	WinDrawLine(x, bounds.topLeft.y, x, posy);

	//case sensitive keys
	if (cx < 10 && cx > 4) {
	    if (params->cap != params->shift)
		holder[0] = params->intl[cx] - ' ';
	    else
		holder[0] = params->intl[cx];
	    //keys that do not shift or not shifted keys
	} else if (cx < 5 || cx == 10 || !params->shift)
	    holder[0] = params->intl[cx];
	//the << key
	else if (cx == 11)
	    holder[0] = params->intl[cx] - 16;
	//last four characters shifted
	else
	    holder[0] = params->intl[cx + 4];

	//draw intl character (put the  one pixel lower)
	WinDrawChars(holder, 1, x + centerChr(cellW, holder) + 1,
		     bounds.topLeft.y - (cx == 6 ? 1 : 0));

    }

    //draw last vertical line
    WinDrawLine(x - 1, bounds.topLeft.y - 1, x - 1, posy);

    //close bounds frame
    WinDrawLine(bounds.topLeft.x, posy, bounds.topLeft.x + bounds.extent.x,
		posy);
    posy = bounds.topLeft.y - 1;
    WinDrawLine(bounds.topLeft.x, posy, bounds.topLeft.x + bounds.extent.x,
		posy);

    //paint the selected accent
    if (params->accent != noAcc)
	ReadKeyboardIntl2(params, params->accent);

    //restore color state
    if (params->OS35)
	WinPopDrawState();

}

/*
 * Functions for performing the intl keypad actions (input characters, set accents, etc.)
 */
Boolean ReadKeyboardIntl(KeyboardParams * params)
{
    return ReadKeyboardIntl2(params, 0);
}

Boolean ReadKeyboardIntl2(KeyboardParams * params, short acc)
{
    return ReadKeyboardIntl3(params, acc, 0);
}

Boolean ReadKeyboardIntl3(KeyboardParams * params, short acc, short skipv)
{
    EventPtr aEvent = (EventPtr) params->extra1;
    short cellW = 0, cellH = 0;
    unsigned short cx = 0;
    RectangleType area, bounds;
    FormPtr aForm = FrmGetActiveForm();
    Boolean same = false;

    if (!params->VKBLayout)
	return false;

    //geometry parameters
    FrmGetObjectBounds(aForm, FrmGetObjectIndex(aForm, VKBGdt), &bounds);
    FntSetFont(stdFont);
    cellH = FntLineHeight();
    cellW = bounds.extent.x / intlCharsX;

    //skip some cells from the beginning of the gadget
    skipv *= cellH;

    //read intl key taps
    //set the intl keypad bounds
    area.topLeft.x = bounds.topLeft.x;
    area.topLeft.y = bounds.topLeft.y + skipv;
    area.extent.x = bounds.extent.x;
    area.extent.y = cellH;

    //if we are in bounds, or are just painting the accent selection
    if (RctPtInRectangle(aEvent->screenX, aEvent->screenY, &area) || acc) {

	if (!acc)
	    //determine the the key that was tapped
	    cx = (aEvent->screenX - area.topLeft.x) / cellW;
	else
	    //the accent selection was passed, determine the index
	    cx = acc - 1;

	//paranoid, do not allow selection past the international characters string
	if (cx >= intlCharsX)
	    cx = intlCharsX - 1;

	//selecting the current accent
	same = params->accent == cx + 1;

	//if we should just invert the key ...
	if ((params->special & keyInvert) || acc) {

	    //invert intl keys
            params->keyNotPainted = true;
 	    if (same && !(params->refresh & refreshing))
	        //un-painting the current selected accent
                params->keyNotPainted = false;
	    InvertButton3(area.topLeft.x, area.topLeft.y, cellW, cellH, cx,
			  0, 1, 1, 1, 1, 1);
            params->keyNotPainted = false;

	    //for at penup keys, if user inverting current selection,
	    //key behaves inversely
	    if (params->atpenup && same && !acc)
	        params->refresh |= accKeyAux;

	    //do not invert accent keys at penup event
	    if (cx < 5 && (!acc
	        //needed for fast keys (select-accent shift)
	        || (!params->atpenup
		    && (params->refresh & refreshing) && (params->special & keyInvert))))

		params->refresh |= accKey;

	    //no further processing
	    if (params->atpenup || acc)
		return true;
	}

	//key click
	MSndPlaySystemSound(sndClick);

	//select accent
	if (cx < 5) {
	    Boolean set = true;

	    //accent already selected ...
	    if (params->accent) {
		//if accent being selected is different from current one, then
		//erase the previous accent
		if (!same) {
		    //key should be painted
                    params->keyNotPainted = false;
		    ReadKeyboardIntl2(params, params->accent);
		    //it is no longer painted
                    params->keyNotPainted = true;
		} else
		    //current accent was unselected
		    set = false;
	    }

	    if (set)
		//set accent
		params->accent = cx + 1;
	    else
		//reset accent
		params->accent = noAcc;

	    //enter case sensitive international keys
	} else if (cx < 10)
	    EvtEnqueueKey(params->intl[cx] -
			  (params->shift != params->cap ? ' ' : 0), 0, 0);
	//non case sensitive
	else if (cx == 10)
	    EvtEnqueueKey(params->intl[cx], 0, 0);
	//the >> and << keys
	else if (cx == 11)
	    EvtEnqueueKey(params->intl[cx] - (params->shift ? 16 : 0), 0,
			  0);
	//the last four shift affected keys
	else
	    EvtEnqueueKey(params->intl[cx + (params->shift ? 4 : 0)], 0,
			  0);

	//handled
	return true;
    }
    //not handled
    return false;

}

/*
 * Function for painting the toolbar icons
 */
void paintToolbar(KeyboardParams * params)
{
    short icon = 0, coord = 0;
    VoidHand hicon = NULL;
    BitmapPtr bicon = NULL;

    //horizontal or vertical, theoretical
    if (direc)
	coord = skipy + iconoffset;
    else
	coord = skipx + iconoffset;

    if (params->OS35) {
	//draw selected background color
	RectangleType bounds;

	bounds.topLeft.x = 0;
	bounds.topLeft.y = 2;
	bounds.extent.x = widthScreen;
	bounds.extent.y = heightTitle - 5;

	WinPushDrawState();
	Color1(true);
	WinEraseRectangle(&bounds, 0);
    }

    for (icon = startindex; numicons >= icon;
	 //at last icon use lastoffset instead of separation
	 coord += (numicons - 1 == icon) ? lastoffset : separation, icon++) {

	//do not paint redo button if no extended undo
	if (!(params->special2 & spExtUndo)) {
	    if (icon == startindex + 1) {
		coord -= separation;
		continue;
	    }
	}

	hicon =
	    DmGetResourceIndex(params->VKBProg,
			       DmFindResource(params->VKBProg, 'Tbmp',
					      icon, NULL));
	if (hicon) {
	    bicon = (BitmapPtr) MemHandleLock(hicon);

	    //paint the icon
	    if (direc)
		WinDrawBitmap(bicon, skipx, coord);
	    else
		WinDrawBitmap(bicon, coord, skipy);

	    MemHandleUnlock(hicon);
	    DmReleaseResource(hicon);
	}
	//add white space at end if no extended undo
	if (!(params->special2 & spExtUndo)) {
	    if (icon == startindex + 7)
		coord += separation;
	}

    }

    if (params->OS35)
	WinPopDrawState();

}

/*
 * Function for performing the toolbar actions
 */
Boolean readToolbar(KeyboardParams * params)
{
    EventPtr aEvent = (EventPtr) params->extra1;
    short cellW = 0, cellH = 0, last = 0;
    unsigned short cx = 0;
    RectangleType area;
    FormPtr aForm = FrmGetActiveForm();

    //no processing while mini-dialogs are up
    if (params->special & extendedOn)
	return false;

    //geometry parameters
    cellH = 11;
    cellW = separation;

    //setup toolbar area for vertical or horizontal, theoretical
    if (direc) {
	area.topLeft.x = skipx;
	area.topLeft.y = skipy + iconoffset;
	area.extent.x = cellW;
	area.extent.y = (numicons - 1) * cellH + lastoffset;
    } else {
	area.topLeft.x = skipx + iconoffset;
	area.topLeft.y = skipy;
	area.extent.x = (numicons - 1) * cellW + lastoffset;
	area.extent.y = cellH;
    }

    //determine the position of the last function icon
    if (params->special2 & spExtUndo)
	last = 7;
    else
	last = 6;

    //we are in the toolbar area ...
    if (RctPtInRectangle(aEvent->screenX, aEvent->screenY, &area)) {

	//determine tapped icon index
	cx = (aEvent->screenX - area.topLeft.x) / cellW;
	if (cx == 8) {

	    //last icon action, show info
	    if (params->special & keyInvert) {
		params->toolb = true;
		InvertButton3(area.topLeft.x, area.topLeft.y, cellW, cellH,
			      cx, 0, 1, 1, 0, separation - iconLength, 0);
		params->keyNotPainted = false;
		return true;
	    }
	    params->toolb = false;

	    MainResource(showHelp);
	    return true;

	//the last function icon (not taking into account the info icon)
	} else if (cx == last) {

	    if (params->special & keyInvert) {
		params->toolb = true;
		InvertButton3(area.topLeft.x, area.topLeft.y, cellW, cellH,
			      cx, 0, 1, 1, 0, separation - iconLength, 0);
		params->keyNotPainted = false;
		return true;
	    }
	    params->toolb = false;

	    //shortcut
	    EvtEnqueueKey(params->_shortcutStrokeChr, 0, 0);
	    params->special |= kbshortcut;
	    return true;

	//all other function icon actions
	} else if (cx < last) {
	    EventType menuevent;

	    if (params->special & keyInvert) {
		params->toolb = true;
		InvertButton3(area.topLeft.x, area.topLeft.y, cellW, cellH,
			      cx, 0, 1, 1, 0, separation - iconLength, 0);
   	        params->keyNotPainted = false;
		return true;
	    }
    	    params->toolb = false;

	    //special case when using system undo (no redo button)
	    if (!(params->special2 & spExtUndo))
		if (cx > 0)
		    cx++;

	    //all this icons are found at the menu, and we actually use a menu event
	    //to call this actions
	    menuevent.eType = menuEvent;
	    menuevent.penDown = false;
	    menuevent.screenX = 0;
	    menuevent.screenY = 0;

	    menuevent.data.menu.itemID = cx;
	    EvtAddEventToQueue(&menuevent);
	    return true;

	}

    }
    //no toolbar icon handled
    params->toolb = false;

    return false;

}

/*
 * The invert key functions,
 * this invert the keys when tapped.
 */

/*
 * Invert a keyboard cell. (x1,y1) is the cell coordinate.
 * the fix parameters where more useful in previous versions.
 */
void InvertButton3(short TLX, short TLY, short cellW, short cellH,
		   short x1, short y1, short width, short height,
		   short fix1, short fix2, short fixy)
{
    RectangleType area;
    short aux = 0;

    //fix1 is for moving a cell a bit more to the right
    area.topLeft.x = TLX + cellW * x1 + fix1;
    area.topLeft.y = TLY + cellH * y1;
    //fix2 is for making a cell a bit less wide
    area.extent.x = cellW * width - fix2;
    //fixy is for making a cell a bit more higher
    area.extent.y = cellH * height - fixy;

    //do not allow keys outside the screen right margin
    if ((aux = area.topLeft.x + area.extent.x - (heightScreen - 1)) > 0) {
	if (area.extent.x > aux)
	    area.extent.x -= aux;
	else
	    area.extent.x = 0;
    }

    InvertButton4(&area);

}

/*
 * The same as InvertButton5, but we do not have
 * the keyboard parameters (globals) pointer at hand
 */
void InvertButton4(RectanglePtr area)
{
    InvertButton5(area, NULL);
}

/*
 * Invert a keyboard cell
 */
void InvertButton41(short TLX, short TLY, short cellW, short cellH,
		    KeyboardParams * params)
{
    RectangleType area;
    short aux = 0;

    area.topLeft.x = TLX;
    area.topLeft.y = TLY;
    area.extent.x = cellW;
    area.extent.y = cellH;

    //do not allow keys outside the screen right margin
    if ((aux = TLX + cellW - (widthScreen - 1)) > 0) {
	if (area.extent.x > aux)
	    area.extent.x -= aux;
	else
	    area.extent.x = 0;
    }

    InvertButton5(&area, params);

}

/*
 * Invert a rectangle
 */
void InvertButton5(RectanglePtr area, KeyboardParams * params)
{
    UInt32 ui32aux;
    Boolean reverse = false;

    FtrGet(appCreator, kbOptions, &ui32aux);

    if (params == NULL) {
	DWord parameters = 0;

	FtrGet(appCreator, kbParams, &parameters);
	params = (KeyboardParams *) parameters;
    }
    //remember key area
    RctCopyRectangle(area, &(params->key));

    reverse = !params->keyNotPainted;
    //penup keys: user unselecting current accent
    if (params->refresh & accKeyAux)
        reverse = !reverse;

    //invert
    if (params->OS35
        && (ui32aux & colorMask) == color1) {	//using system colors

	WinPushDrawState();

	WinSetDrawMode(winSwap);
	WinSetPatternType(blackPattern);

	if (params->toolb) {

	    //toolbar effect
	    if (!reverse) {
                WinSetBackColor(UIColorGetTableEntryIndex(UIMenuFill));
                WinSetForeColor(UIColorGetTableEntryIndex(UIMenuSelectedFill));
	        WinPaintRectangle(area, 3);
	        //test for monochrome conditions
	        if (UIColorGetTableEntryIndex(UIMenuSelectedFill)
	                != UIColorGetTableEntryIndex(UIMenuForeground)) {

                    WinSetBackColor(UIColorGetTableEntryIndex(UIMenuForeground));
                    WinSetForeColor(UIColorGetTableEntryIndex(UIMenuSelectedForeground));
	            WinPaintRectangle(area, 3);

	        }
	    //invert in inverse order
	    } else {
	        //test for monochrome conditions  (un-inverting)
	        if (UIColorGetTableEntryIndex(UIMenuSelectedFill)
	                != UIColorGetTableEntryIndex(UIMenuForeground)) {

                    WinSetBackColor(UIColorGetTableEntryIndex(UIMenuForeground));
                    WinSetForeColor(UIColorGetTableEntryIndex(UIMenuSelectedForeground));
	            WinPaintRectangle(area, 3);

	        }
                WinSetBackColor(UIColorGetTableEntryIndex(UIMenuFill));
                WinSetForeColor(UIColorGetTableEntryIndex(UIMenuSelectedFill));
	        WinPaintRectangle(area, 3);
	    }

	} else {

	    if (!reverse) {
	        //keyboard effect
                WinSetBackColor(UIColorGetTableEntryIndex(UIObjectFill));
                WinSetForeColor(UIColorGetTableEntryIndex(UIObjectSelectedFill));
	        WinPaintRectangle(area, 0);
	        //test for monochrome conditions
	        if (UIColorGetTableEntryIndex(UIObjectSelectedFill)
	                != UIColorGetTableEntryIndex(UIObjectForeground)) {

                    WinSetBackColor(UIColorGetTableEntryIndex(UIObjectForeground));
                    WinSetForeColor(UIColorGetTableEntryIndex(UIObjectSelectedForeground));
	            WinPaintRectangle(area, 0);

	        }
	    //invert in inverse order (un-inverting)
	    } else {
	        //test for monochrome conditions
	        if (UIColorGetTableEntryIndex(UIObjectSelectedFill)
	                != UIColorGetTableEntryIndex(UIObjectForeground)) {

                    WinSetBackColor(UIColorGetTableEntryIndex(UIObjectForeground));
                    WinSetForeColor(UIColorGetTableEntryIndex(UIObjectSelectedForeground));
	            WinPaintRectangle(area, 0);

	        }
	        //keyboard effect
                WinSetBackColor(UIColorGetTableEntryIndex(UIObjectFill));
                WinSetForeColor(UIColorGetTableEntryIndex(UIObjectSelectedFill));
	        WinPaintRectangle(area, 0);
	    }

	}

	WinPopDrawState();

    } else {

	if (params->toolb)
	    //rounded corners for toolbar buttons
	    WinInvertRectangle(area, 3);
	else
	    WinInvertRectangle(area, 0);

    }

}

/*
 * Extended undo manager
 * The undo manager sets traps during the execution of the keyboard form
 * (this are not handled by hackmaster).
 * This increases the stack load.
 */

/*
 * Start extended undo
 */
Boolean UndInit()
{
    UInt32 dwparams = NULL, free = 0, max = 0, sum = 0;
    KeyboardParams *params = NULL;
    UInt16 i = 0, auxa = 0;
    FormType *aForm = FrmGetActiveForm();
    LocalID udbid = NULL;
    MemHandle mh = NULL;

    FtrGet(appCreator, kbParams, &dwparams);
    params = (KeyboardParams *) dwparams;

    if (!params->undDB) {

	//calculate free memory
	auxa = MemNumHeaps(CARD);
	for (i = 0; i < auxa; i++) {

	    MemHeapFreeBytes(MemHeapID(CARD, i), &free, &max);
	    sum += free;

	}

	//to kb
	sum /= 1024;
	if (sum < UndMFree)
	    return false;

	//create undo database
	if (udbid = DmFindDatabase(CARD, undoDBName))
	    DmDeleteDatabase(CARD, udbid);

	if (DmCreateDatabase(CARD, undoDBName, appCreator, EXUND, false))
	    return false;

	if (!
	    (params->undDB =
	     DmOpenDatabaseByTypeCreator(EXUND, appCreator,
					 dmModeReadWrite)))
	    return false;

	//create block buffer record, keep open
	mh = DmNewHandle(params->undDB, UndDepth + 1);
	if (!mh)
	    return false;

	params->blockBuffer = (unsigned char *) MemHandleLock(mh);
	if (!params->blockBuffer)
	    return false;

	//write a terminating '\0' in the buffer
	auxa = 0;
	if (DmWrite(params->blockBuffer, UndDepth, &auxa, 1))
	    return false;

	//set traps
	FtrSet(appCreator, fUndDel,
	       (UInt32) SysGetTrapAddress(sysTrapFldDelete));
	FtrSet(appCreator, fUndIns,
	       (UInt32) SysGetTrapAddress(sysTrapFldInsert));
	FtrSet(appCreator, fUndUnd,
	       (UInt32) SysGetTrapAddress(sysTrapFldUndo));
	FtrSet(appCreator, fUndHan,
	       (UInt32) SysGetTrapAddress(sysTrapFldSetTextHandle));
	FtrSet(appCreator, fUndPtr,
	       (UInt32) SysGetTrapAddress(sysTrapFldSetTextPtr));
	params->txtaux = (UInt32) SysGetTrapAddress(sysTrapFldHandleEvent);
	FtrSet(appCreator, fUndHev, params->txtaux);

	SysSetTrapAddress(sysTrapFldDelete, UndFldDelete);
	SysSetTrapAddress(sysTrapFldInsert, UndFldInsert);
	SysSetTrapAddress(sysTrapFldUndo, UndFldUndo);
	SysSetTrapAddress(sysTrapFldSetTextHandle, UndFldSetTextHandle);
	SysSetTrapAddress(sysTrapFldSetTextPtr, UndFldSetTextPtr);
	SysSetTrapAddress(sysTrapFldHandleEvent, UndFldHandleEvent);

	//set values
	params->undFld =
	    FrmGetObjectPtr(aForm, FrmGetObjectIndex(aForm, textFld));
	params->undMIx = 0;
	params->undUType = 0;

	return true;

    } else
	return false;

}

/*
 * Shut down extended undo
 */
void UndEnd()
{
    UInt32 dwparams = NULL, faux = NULL;
    KeyboardParams *params = NULL;
    LocalID undId = NULL;

    if (FtrGet(appCreator, kbParams, &dwparams))
	return;
    params = (KeyboardParams *) dwparams;

    //unset traps
    if (!FtrGet(appCreator, fUndDel, &faux)) {
	SysSetTrapAddress(sysTrapFldDelete, (void *) faux);
	FtrUnregister(appCreator, fUndDel);
    }

    if (!FtrGet(appCreator, fUndIns, &faux)) {
	SysSetTrapAddress(sysTrapFldInsert, (void *) faux);
	FtrUnregister(appCreator, fUndIns);
    }

    if (!FtrGet(appCreator, fUndUnd, &faux)) {
	SysSetTrapAddress(sysTrapFldUndo, (void *) faux);
	FtrUnregister(appCreator, fUndUnd);
    }

    if (!FtrGet(appCreator, fUndHan, &faux)) {
	SysSetTrapAddress(sysTrapFldSetTextHandle, (void *) faux);
	FtrUnregister(appCreator, fUndHan);
    }

    if (!FtrGet(appCreator, fUndPtr, &faux)) {
	SysSetTrapAddress(sysTrapFldSetTextPtr, (void *) faux);
	FtrUnregister(appCreator, fUndPtr);
    }

    if (!FtrGet(appCreator, fUndHev, &faux)) {
	SysSetTrapAddress(sysTrapFldHandleEvent, (void *) faux);
	FtrUnregister(appCreator, fUndHev);
    }
    //delete undo database
    if (params->undDB) {
	MemHandle mh = NULL;

	//release block buffer record
	if (params->blockBuffer) {
	    mh = MemPtrRecoverHandle(params->blockBuffer);
	    if (mh) {
		MemHandleUnlock(mh);
		MemHandleFree(mh);
	    }
	}
	//dispose database
	DmOpenDatabaseInfo(params->undDB, &undId, NULL, NULL, NULL, NULL);
	DmCloseDatabase(params->undDB);
	DmDeleteDatabase(CARD, undId);

	params->undDB = NULL;

    }

}

/*
 * Undo/redo various steps
 * (extended undo can be manually configured to handle more
 * or less details in the undo operations, see the transaction functions)
 */
void UndUndo(FieldType * aField)
{
    Boolean result = false, baux = false;
    FormPtr aForm = FrmGetActiveForm();

    //check character block for undo
    if (UndCheckBlock(NULL)) {
	UndSwitch();
	return;
    }
    //do not allow editing
    FldObjectDisable(aForm, FrmGetObjectIndex(aForm, textFld));

    //do undo while transaction point not found, or no error
    //the peek operation prevents the error sound
    while ((result = Und1(aField, false, baux)) < UndTran)
	baux = true;

    //restore field
    FrmShowObject(aForm, FrmGetObjectIndex(aForm, textFld));

    if (result == UndCantErr)
	UndSwitch();

}

void UndRedo(FieldType * aField)
{
    Boolean result = false;
    FormPtr aForm = FrmGetActiveForm();

    //do not allow editing
    FldObjectDisable(aForm, FrmGetObjectIndex(aForm, textFld));

    //always redo a step
    if ((result = Und1(aField, true, false)) < UndGenErr)
	//continue doing redo until UndTran result is output from the peek
	//operation (second true parameter), or while no error
	while ((result = Und1(aField, true, true)) != UndTran
	       && result < UndGenErr);

    //restore field
    FrmShowObject(aForm, FrmGetObjectIndex(aForm, textFld));

    if (result == UndCantErr)
	UndSwitch();

}

/*
 * Undo/redo a single step
 */
short Und(FieldType * aField, Boolean redo)
{
    return Und1(aField, redo, false);
}

short Und1(FieldType * aField, Boolean redo, Boolean peek	//the peek operation is used to prevent
								   //operations or sounds from executing
    )
{

    UInt32 dwparams = NULL, prev = NULL;
    KeyboardParams *params = NULL;
    VoidHand undop = NULL, unddata = NULL;
    VoidPtr pundop = NULL, punddata = NULL;
    UndOp *aUndOp = NULL;
    UndOp bUndOp;
    UInt16 ix = 0, dbnumrec = 0, laux = 0;
    short result = 0;

    FtrGet(appCreator, kbParams, &dwparams);
    params = (KeyboardParams *) dwparams;

    //cannot undo or redo any more, db empty, play sound
    if ((dbnumrec = DmNumRecords(params->undDB)) < 2) {
	//do not play sound on transaction
	if (!peek)
	    SndPlaySystemSound(sndError);
	return UndEmpty;
    }

    if (redo) {
	if (dbnumrec == params->undMIx) {
	    //there is no more redo data, play sound,
	    //do not play sound on transaction
	    if (!peek)
		SndPlaySystemSound(sndError);
	    return UndNoMore;
	} else
	    //the last (or latest) redo item is at the database end ...
	    ix = dbnumrec - 2;
    } else {
	if ((Int32) params->undMIx - 2 < 0) {
	    //there is no more undo data, play sound,
	    //do not play sound on transaction
	    if (!peek)
		SndPlaySystemSound(sndError);
	    return UndNoMore;
	} else
	    //the last (or latest) undo item is before the middle index ...
	    ix = params->undMIx - 2;
    }

    //get the undo item header
    undop = DmQueryRecord(params->undDB, ix);
    //get the undo item data
    unddata = DmQueryRecord(params->undDB, ix + 1);

    if (!undop || !unddata)
	return UndGenErr;

    pundop = MemHandleLock(undop);
    punddata = MemHandleLock(unddata);

    //assign header data to suitable pointer
    aUndOp = (UndOp *) pundop;

    //copy header pointer to editable (local) structure
    bUndOp.textPos = aUndOp->textPos;
    result = bUndOp.uType = aUndOp->uType;

    //if redo peek operation, and next undo item is
    //going to be transaction, then signal UndTran
    if (peek && redo && aUndOp->uType > UndTran) {
	MemHandleUnlock(undop);
	MemHandleUnlock(unddata);
	return UndTran;
    }
    //we have a transaction header, translate to default or normal
    //operation types to facilitate processing (transactional operations are
    //just normal operations marked (+3) as transactions)
    if (bUndOp.uType > UndOne) {
	bUndOp.uType -= UndTrans;
	UndMarkTrans(params);
    }
    //something was added, we have delete that
    if (bUndOp.uType == UndAddO) {
	FtrGet(appCreator, fUndDel, &prev);

	laux = *(UInt16 *) punddata;
	//check for undo what we are deleting
	UndCheckDeleted(&bUndOp, FldGetTextPtr(aField) + aUndOp->textPos,
			laux, redo ? UndTRedo : UndTUndo, params);

	//delete
	if (laux) {
	    if (aUndOp->textPos < FldGetTextLength(aField))
		(*((void (*)(FieldType *, UInt16, UInt16)) prev)) (aField,
								   aUndOp->
								   textPos,
								   aUndOp->
								   textPos
								   + laux);
	} else
	    //not expected error (or if dummy markers will be used, modify this)
	    result = UndGenErr;

	//something was deleted, we have to add that
    } else {
	FormType *aForm = FrmGetActiveForm();
	UInt16 fix = FrmGetObjectIndex(aForm, textFld);

	FtrGet(appCreator, fUndIns, &prev);

	//get length of text to be added
	if ((Char *) punddata && *(Char *) punddata)
	    laux = StrLen((Char *) punddata);
	//check for undo what we are adding
	UndCheckAdded(&bUndOp, laux, redo ? UndTRedo : UndTUndo, params);
	//move to appropriate location
	FldSetInsPtPosition(aField, aUndOp->textPos);
//much defines the distance considered to much, so that field scrolling will take place
#define much (laux>200)
	//add
	if (laux) {
	    if (much)
		FldObjectDisable(aForm, fix);
	    (*((Boolean(*)(FieldType *, Char *, UInt16)) prev)) (aField,
								 (Char *)
								 punddata,
								 laux);
	    if (much)
		FrmShowObject(aForm, fix);
	} else
	    //not expected error (or if dummy markers will be used, modify this)
	    result = UndGenErr;

    }
#undef much

    MemHandleUnlock(undop);
    MemHandleUnlock(unddata);

    //remove the undo item we just used
    UndEraseLast(params, redo);

    return result;

}

/*
 * Track a text that has been deleted
 */
UInt16 UndCheckDeleted(UndOp * uop, Char * text, UInt16 len, short utype,
		       KeyboardParams * params)
{
    UInt16 ix = 0;
    Boolean result = false;

    if (!params) {
	UInt32 dwparams = NULL;

	FtrGet(appCreator, kbParams, &dwparams);
	params = (KeyboardParams *) dwparams;
    }
    //type=transaction type+base type
    //transaction type = 0|3, 0=aggregate or normal, 3=transaction or stop point
    //base type=0|1, 0=add, 1=remove
    uop->uType = params->undUType + UndRemO;

    //if editing, do housekeeping. erase all redo data.
    //this undo type from the parameters is either UndTNormal,
    //UndTUndo or UndTRedo (see VKBInput.h)
    if (utype == UndTNormal)
	if (!UndCleanDB(params))
	    return UndGenErr;

    if (utype)
	//if checking undo editing or redo items, they go to to the end
	//of the undo list, or before the middle index
	ix = params->undMIx;
    else
	//if checking undo an undo operation, it goes to the redo list,
	//or to the end of the database
	ix = DmNumRecords(params->undDB);

    //insert undo item header structure
    if (!UndCheck(uop, sizeof(UndOp), ix, params))
	return UndCantErr;

    //insert undo item data, in this case, deleted characters
    while (true) {
	VoidHand nh = NULL;
	UInt16 atP = ix + 1;
	VoidPtr pnh = NULL;
	Byte zero = 0;

	//create the record
	if (!(nh = DmNewRecord(params->undDB, &atP, len + 1))) {
	    result = false;
	    break;
	}

	pnh = MemHandleLock(nh);

	//write the characters
	if (len > 0)
	    if (DmWrite(pnh, 0, text, len)) {
		MemHandleUnlock(nh);
		DmReleaseRecord(params->undDB, atP, false);
		result = false;
		break;
	    }
	//write a terminating zero
	if (DmWrite(pnh, len, &zero, 1)) {
	    MemHandleUnlock(nh);
	    DmReleaseRecord(params->undDB, atP, false);
	    result = false;
	    break;
	}

	MemHandleUnlock(nh);
	DmReleaseRecord(params->undDB, atP, false);

	result = true;
	break;
    }

    //if an error occurred while writing
    if (!result) {
	if (DmRemoveRecord(params->undDB, ix))
	    //error occurred, we must disable undo feature immediately
	    return UndCantErr;
	else
	    //some error occurred, but we can continue
	    return UndGenErr;
    }
    //if editing or doing redo, the undo list grows an item
    if (utype)
	params->undMIx += 2;

    return UndNoErr;

}

/*
 * Track a text that has been added
 */
UInt16 UndCheckAdded(UndOp * uop, UInt16 len, short utype,
		     KeyboardParams * params)
{
    UInt16 ix = 0;

    if (!params) {
	UInt32 dwparams = NULL;

	FtrGet(appCreator, kbParams, &dwparams);
	params = (KeyboardParams *) dwparams;
    }
    //type=transaction type+base type
    //transaction type = 0|3, 0=aggregate or normal, 3=transaction or stop point
    //base type=0|1, 0=add, 1=remove
    uop->uType = params->undUType + UndAddO;

    //if editing, do housekeeping. erase all redo data.
    //this undo type from the parameters is either UndTNormal,
    //UndTUndo or UndTRedo (see VKBInput.h)
    if (utype == UndTNormal)
	if (!UndCleanDB(params))
	    return UndGenErr;

    if (utype)
	//if checking undo editing or redo items, they go to to the end
	//of the undo list, or before the middle index
	ix = params->undMIx;
    else
	//if checking undo an undo operation, it goes to the redo list,
	//or to the end of the database
	ix = DmNumRecords(params->undDB);

    //insert undo item header structure
    if (!UndCheck(uop, sizeof(UndOp), ix, params))
	return UndCantErr;

    //insert undo item data, in this case, length of insertion
    if (!UndCheck(&len, sizeof(UInt16), ix + 1, params)) {
	if (DmRemoveRecord(params->undDB, ix))
	    //error occurred, we must disable undo feature immediately
	    return UndCantErr;
	else
	    //some error occurred, but we can continue
	    return UndGenErr;
    }
    //if editing or doing redo, the undo list grows an item
    if (utype)
	params->undMIx += 2;

    return UndNoErr;

}

/*
 * Write some undo action parameters into the list
 */
Boolean UndCheck(void *data, UInt16 len, UInt16 atP,
		 KeyboardParams * params)
{
    VoidHand nh = NULL;

    //create new record
    if (!(nh = DmNewRecord(params->undDB, &atP, len)))
	return false;

    //write the requested data
    if (DmWrite(MemHandleLock(nh), 0, data, len)) {
	MemHandleUnlock(nh);
	DmReleaseRecord(params->undDB, atP, false);
	return false;
    }

    MemHandleUnlock(nh);
    DmReleaseRecord(params->undDB, atP, false);

    //reset transaction (the transaction marks a return point,
    //we do not want each undo item to be an individual stop point).
    //each add operation undo item calls this function twice,
    //but only the call for the header is affected by the next line.
    UndNoTrans(params);

    return true;
}

/*
 * Erase last undo item
 */
Boolean UndEraseLast(KeyboardParams * params, Boolean redo)
{
    Boolean result = true;
    UInt16 ix = 0, dbnumrec = 0;
    UInt32 dwparams = NULL;

    if (!params) {
	FtrGet(appCreator, kbParams, &dwparams);
	params = (KeyboardParams *) dwparams;
    }
    //if no records, return
    if ((dbnumrec = DmNumRecords(params->undDB)) == 0)
	return true;

    if (redo) {
	if (dbnumrec == params->undMIx)
	    //no more redo items to delete (there are only undo items)
	    return true;
	else
	    //the last redo item is at the end of the database, set index to it
	    ix = dbnumrec - 2;
    } else {
	if (params->undMIx < 2)
	    //no more undo items to delete (there are only redo items)
	    return true;
	else
	    //the last undo item is before the middle index, set the index to it
	    ix = params->undMIx -= 2;
    }

    //erase the last item, account for errors
    result = result && !DmRemoveRecord(params->undDB, ix);
    result = result && !DmRemoveRecord(params->undDB, ix);

    return result;

}

/*
 * Erase oldest undo items
 */
Boolean UndEraseOld(KeyboardParams * params)
{
    UInt16 nrec = 0;
    Boolean result = true;

    do {

	nrec = DmNumRecords(params->undDB);

	//undo entries come in pairs, if there is at least a pair,
	//then delete it. oldest undo records start at 0
	if (nrec > 1) {
	    result = result && !DmRemoveRecord(params->undDB, 0);
	    result = result && !DmRemoveRecord(params->undDB, 0);
	} else
	    //nothing more to delete
	    break;

	//since an item was deleted, decrease middle index
	if (params->undMIx >= 2)
	    params->undMIx -= 2;
	else
	    //unexpected error
	    return false;

	//while number of records is greater than configured maximum depth
    } while (nrec > (UndDepth << 1) && result);

    return result;

}

/*
 * House keeping
 */
Boolean UndCleanDB(KeyboardParams * params)
{
    UInt32 size = 0;
    UInt16 maxr = 10, caux = 0, raux = 0;

    //clean the redo buffer
    raux = DmNumRecords(params->undDB);
    caux = raux - params->undMIx;
    while (caux--)
	if (!UndEraseLast(params, true))
	    return false;

    //check that the database is not to big
    if (raux > (UndDepth << 1))
	if (!UndEraseOld(params))
	    return false;

    return true;

}

/*
 * Dynamic traps
 */
void UndFldDelete(FieldType * fldP, UInt16 start, UInt16 end)
{
    UndOp aundop;
    UInt16 lix = FldGetTextLength(fldP), span = 0;
    Boolean bundok = UndOk(fldP);
    Int32 dele = 0;
    UInt32 prev = NULL;

    FtrGet(appCreator, fUndDel, &prev);

    //do something if thing to delete is inside limits
    if (start < lix) {

	if (bundok) {

	    if (end < start || end > lix)
		//this was by testing behavior
		span = lix - start;
	    else
		span = end - start;

	    if (span) {

		aundop.textPos = start;

		//mark transaction point
		UndMarkTrans(NULL);
		if (UndCheckDeleted
		    (&aundop, FldGetTextPtr(fldP) + start, span,
		     UndTNormal, NULL)) {
		    (*((void (*)(FieldType *, UInt16, UInt16)) prev))
			(fldP, start, end);
		    UndSwitch();
		    return;
		}

	    }

	}

    }

    (*((void (*)(FieldType *, UInt16, UInt16)) prev)) (fldP, start, end);

    if (start < lix) {

	if (bundok) {

	    dele = lix - FldGetTextLength(fldP);

	    //check if delete was not ok
	    if (dele == 0) {
		//it was assumed that something was deleted
		if (span != 0) {
		    if (!UndEraseLast(NULL, false))
			UndSwitch();
		}
		//check if deleted was different than assumed
	    } else if (dele != span)
		UndSwitch();
	}

    } else {
	//this case used to generate errors, somehow we are here,
	//but it is not handled
	if (bundok)
	  UndSwitch();
    }


}

Boolean UndFldInsert(FieldType * fldP, Char * text, UInt16 len)
{
    UndOp aundop;
    Boolean ok = false;
    UInt16 start = 0, end = 0;
    Boolean bundok = UndOk(fldP), dele = false;
    UInt32 prev = NULL;

    FtrGet(appCreator, fUndIns, &prev);

    if (bundok) {
	FldGetSelection(fldP, &start, &end);

	//insert is new transaction point
	UndMarkTrans(NULL);

	if (start == end)
	    //prepare to check an insertion with no current selection
	    start = FldGetInsPtPosition(fldP);
	else {

	    //check current selection that is going to be deleted
	    aundop.textPos = start;
	    if (UndCheckDeleted
		(&aundop, FldGetTextPtr(fldP) + start, end - start,
		 UndTNormal, NULL))
		UndSwitch();
	    dele = true;

	}

    }
    //call original trap
    if (ok =
	(*((Boolean(*)(FieldType *, Char *, UInt16)) prev)) (fldP, text,
							     len)) {

	if (bundok) {

	    //check for undo the text being inserted
	    aundop.textPos = start;
	    if (UndCheckAdded(&aundop, len, UndTNormal, NULL))
		UndSwitch();

	}
	//could not insert, but deletion of selected text was assumed,
	//erase that from the undo list
    } else if (dele)
	if (!UndEraseLast(NULL, false))
	    UndSwitch();

    return ok;

}

Boolean UndFldHandleEvent(FieldType * fldP, EventType * aEvent)
{
    UInt16 undChT = NULL, undCh = NULL;
    Boolean bundok = false, result = false;
    UInt32 dwparams = NULL;
    KeyboardParams *params = NULL;
    UInt16 start = 0, end = 0;

    if (!FtrGet(appCreator, kbParams, &dwparams)) {
	params = (KeyboardParams *) dwparams;
	bundok = aEvent->eType == keyDownEvent && UndOk2(params, fldP);
    }

    if (bundok) {
	UndOp uop;

	undChT = UndCN;

	//extended undo
	FldGetSelection(fldP, &start, &end);

	//handle backspace
	if (aEvent->data.keyDown.chr == (UInt16) '\b') {

	    //if there is something to delete
	    if (FldGetTextLength(fldP) > 0 && (start != end	//if there is a selection to delete
				       || FldGetInsPtPosition(fldP) > 0)) {	//or if there is at least a
										//character to delete
		if (start == end) {
		    //a character is going to be deleted, save character
		    undChT = UndCD;
		    undCh =
			*(FldGetTextPtr(fldP) + FldGetInsPtPosition(fldP) -
			  1);
		} else {
		    //a region is going to be deleted, check for undo
		    uop.textPos = start;
		    if (UndCheckDeleted
			(&uop, FldGetTextPtr(fldP) + start, end - start,
			 UndTNormal, params)) {
			result = (*((Boolean(*)(FieldType *, EventType *))
				    params->txtaux)) (fldP, aEvent);
			UndSwitch();
			return result;
		    }
		}
	    }
	    //handle the other characters
	} else {

	    //if there is room to input a character
	    if (FldGetTextLength(fldP) < FldGetMaxChars(fldP)) {

		//a character is going to be input, no region is going to be deleted
		//in current PalmOS if a region is deleted it is going to be handled
		//by FldDelete, not here
		if (start == end) {
		    undChT = UndCA;
		    undCh = aEvent->data.keyDown.chr;
		}

	    }

	}

	//call the original trap
	result = (*((Boolean(*)(FieldType *, EventType *)) params->txtaux))
	    (fldP, aEvent);

    } else {
	UInt32 prev = NULL;

	FtrGet(appCreator, fUndHev, &prev);

	//call the original trap, no added functionality
	result =
	    (*((Boolean(*)(FieldType *, EventType *)) prev)) (fldP,
							      aEvent);

    }

    if (bundok && result) {

	//extended undo
	UndOp undop;

	if (undChT == UndCD) {

	    //start tracking character block
	    if (!params->blockTrack) {
		params->blockStart = params->blockEnd =
		    FldGetInsPtPosition(fldP) + 1;
		params->blockTrack = true;
	    }
	    //check for undo a character to be deleted
	    if (!ToBlock(undCh, params))
		UndSwitch();
	    //do not handle single character deletes here,
	    //character deletes are aggregated to a block
	    params->blockEnd--;

	} else if (undChT == UndCA) {

	    //check for undo a character to be added
	    undop.textPos = FldGetInsPtPosition(fldP) - 1;
	    //do not check for arrow characters
	    if (undCh > (Word) '\037' || undCh < (Word) '\034') {
		//if we are overwriting a region ...
		if (start != end) {
		    //check character for undo
		    if (UndCheckAdded(&undop, 1, UndTNormal, params))
			UndSwitch();
		} else {
		    //start tracking character block
		    if (!params->blockTrack) {
			params->blockStart = params->blockEnd =
			    FldGetInsPtPosition(fldP) - 1;
			params->blockTrack = true;
		    }
		    //do not handle single character inserts here,
		    //character inserts are aggregated to a block
		    params->blockEnd++;
		}

	    }

	}

    }

    return result;

}

void UndFldUndo(FieldType * fldP)
{
    UInt32 prev = NULL;
    short result = 0;

    FtrGet(appCreator, fUndUnd, &prev);

    if (UndOk(fldP))
	UndUndo(fldP);
    else
	(*((void (*)(FieldType *)) prev)) (fldP);

}

/*
 * This just call to disable kb undo, changing the text handle
 * or pointer is  not supported
 */
void UndFldSetTextHandle(FieldType * fldP, MemHandle TextHandle)
{
    UInt32 prev = NULL;

    FtrGet(appCreator, fUndHan, &prev);

    if (UndOk(fldP))
	UndSwitch();

    (*((void (*)(FieldType *, MemHandle)) prev)) (fldP, TextHandle);
}

void UndFldSetTextPtr(FieldType * fldP, Char * TextPtr)
{
    UInt32 prev = NULL;

    FtrGet(appCreator, fUndPtr, &prev);

    if (UndOk(fldP))
	UndSwitch();

    (*((void (*)(FieldType *, Char *)) prev)) (fldP, TextPtr);
}

/*
 * Undo transactions
 */

/*
 * Marks a undo stop point
 */
void UndMarkTrans(KeyboardParams * params)
{
    UndOp aundop;

    if (!params) {
	UInt32 dwparams = NULL;

	FtrGet(appCreator, kbParams, &dwparams);
	params = (KeyboardParams *) dwparams;
    }
    //check previous character block when new transaction is requested
    if ((params->special2 & spExtUndo) && UndCheckBlock(params))
	UndSwitch();

    if (!(params->special2 & forceNoTrans))
	params->undUType = UndTrans;

}

/*
 * Lets subsequent undo steps to be added as a single step
 */
void UndNoTrans(KeyboardParams * params)
{

    if (!params) {
	UInt32 dwparams = NULL;

	FtrGet(appCreator, kbParams, &dwparams);
	params = (KeyboardParams *) dwparams;
    }

    params->undUType = UndZero;

}

/*
 * Prevents any subsequent transaction call
 */
void UndToogleForceNoTrans(KeyboardParams * params)
{

    if (!params) {
	UInt32 dwparams = NULL;

	FtrGet(appCreator, kbParams, &dwparams);
	params = (KeyboardParams *) dwparams;
    }

    params->special2 = params->special2 ^ forceNoTrans;

}

/*
 * Check current character block (when user inputs many characters
 * or deletes many characters) for undo.
 * Every automated insert or delete operation should call this,
 * or mark a transaction.
 */
Boolean UndCheckBlock(KeyboardParams * params)
{
    UndOp undop;
    Int32 diff = 0;
    Boolean result = false;
    UInt16 offset = 0;

    if (!params) {
	UInt32 dwparams = NULL;

	FtrGet(appCreator, kbParams, &dwparams);
	params = (KeyboardParams *) dwparams;
    }
    //do only if tracking character block ...
    if (params->blockTrack) {

	diff = (Int32) params->blockEnd - params->blockStart;

	if (diff > 0) {

	    //check for undo an added region
	    undop.textPos = params->blockStart;
	    result = UndCheckAdded(&undop, diff, UndTNormal, params);

	    //character block checked for undo, not tracking block any more
	    params->blockTrack = false;

	} else if (diff < 0) {
	    //check for undo a deleted region
	    undop.textPos = params->blockEnd;
	    offset = UndDepth + (UInt16) diff;
	    result = UndCheckDeleted(&undop, params->blockBuffer + offset,
				     StrLen(params->blockBuffer + offset),
				     UndTNormal, params);

	    //character block checked for undo, not tracking block any more
	    params->blockTrack = false;

	}

    }

    return result;

}

/*
 * Write a character into the block buffer
 * (only used for repeated backspace characters)
 */
Boolean ToBlock(Char aChar, KeyboardParams * params)
{
    Char saux[2];
    Int32 diff = 0, offset = 0;

    if (!params) {
	UInt32 dwparams = NULL;

	FtrGet(appCreator, kbParams, &dwparams);
	params = (KeyboardParams *) dwparams;
    }
    //do only if tracking character block ...
    if (params->blockTrack) {

	saux[0] = aChar;
	saux[1] = '\0';

	//determine position in buffer
	diff = (Int32) params->blockEnd - params->blockStart;
	if (diff < 0)
	    diff = -diff;

	offset = UndDepth - diff - 1;
	if (offset < 0) {
	    //buffer full, flush buffer, reset character block
	    if (UndCheckBlock(params))
		return false;
	    params->blockStart = params->blockEnd;
	    params->blockTrack = true;
	    offset = UndDepth - 1;
	}
	//write the character in the buffer, we write from the end of the memory to the start
	//since this is currently only used for deleted chars. subtract one to leave a place for '\0'
	if (DmWrite(params->blockBuffer, offset, saux, 1))
	    return false;
	else
	    return true;

    } else
	return false;

}

/*
 * Check if it is ok to do kb undo, only allows operations for main text field
 */
Boolean UndOk(FieldType * fldP)
{
    UInt32 dwparams = NULL;
    KeyboardParams *params = NULL;

    if (FtrGet(appCreator, kbParams, &dwparams))
	return false;

    params = (KeyboardParams *) dwparams;

    return (fldP == params->undFld) && (params->special2 & spExtUndo);
}

Boolean UndOk2(KeyboardParams * params, FieldType * fldP)
{
    return (fldP == params->undFld) && (params->special2 & spExtUndo);
}

/*
 * Emergency, disable kb undo, notify user
 */
void UndSwitch()
{
    UInt32 dwparams = NULL;
    KeyboardParams *params = NULL;
    Char buffer[32];
    RectangleType aRec;

    FtrGet(appCreator, kbParams, &dwparams);
    params = (KeyboardParams *) dwparams;

    params->special2 &= ~spExtUndo;
    ShowError(customErrorAlert,
	      getString(buffer, switchToSysUndo, params->VKBProg), "", "");

    //refresh toolbar
    aRec.topLeft.x = 0;
    aRec.extent.x = widthScreen;
    aRec.topLeft.y = 0;
    aRec.extent.y = heightTitle;
    WinEraseRectangle(&aRec, 0);

    paintToolbar(params);
    WinDrawLine(0, 0, widthScreen, 0);

}

/*
 * Miscellaneous helpful functions
 */

/*
 * Helps to process a shortcut command. Tells if a group of characters are close to or match
 * a defined shortcut. Returns the matching expanded shortcut in the macro parameter.  Returns
 * the size that could be allocated for the expanded shortcut.  If got is NULL, this is used
 * to check for conflicts on macros to add.
 *
 */
Word lookMacro(KeyboardParams * params, CharPtr target, Byte tsize,
	       Boolean * close, Boolean * got, CharPtr * macro)
{
    char *name = NULL;
    Word len = 200;
    Int16 saux = tsize;

    name = MemPtrNew(20);

    //try to allocate len+1 bytes or less (len+1-20n) according
    //to memory available
    while (!(*macro = MemPtrNew(len + 1))) {
	len -= 20;
	if (len == 0)
	    break;
    }

    //when memory is ready
    if (*macro && name) {
	Word i = 0;

	while (true) {

	    //no more shortcuts, break
	    if (GrfGetMacroName(i, name))
		break;

	    //do not handle those hidden macros
	    if (*name == '.') {
		i++;
		continue;
	    }
	    //if looking for close matches,
	    //then size to compare tsize=min(len(name),tsize),
	    //that is, if our target starts as some other macro,
	    //we are close; if other macro starts as our target we are
	    //close also, to be close means conflicting macros
	    if (!got) {
		tsize = StrLen(name);
		if (tsize > saux)
		    tsize = saux;
	    }
	    //compare a macro and the target
	    if (!StrNCompare(name, target,
			     tsize /
			     ((params->special2 & oneByte) ? 1 : 2))) {
		//we are close to a match
		*close = true;

		//we have an exact match
		if (StrLen(name) == tsize && got) {
		    *got = true;
		    break;
		    //only checking for close matches, we are done
		} else if (!got)
		    break;

	    }

	    i++;

	}

	//return the shortcut text expanded if we got it,
	//or the name we where close to, in the macro parameter
	if (got) {
	    if (*got)
		//expand shortcut, and set its len to return
		*got = !GrfGetAndExpandMacro(name, *macro, &len);
	} else if (close) {
	    if (*close)
		//copy the shortcut name we got close to, and set its len to return
		StrNCopy(*macro, name, (len = StrLen(name)) + 1);
	}

    }
    //release name memory
    if (name)
	MemPtrFree(name);

    return len;

}

/*
 * Some accent helper functions that surely can be done better, specially smaller
 */
Word RVocal(Word aChar)
{
    return RVocal1(aChar, 0);
}

/*
 * Receives an accented vocal, and returns it unaccented.
 * Shift can be zero for lowercase, or 32 for uppercase.
 */
Word RVocal1(Word aChar, Word shift)
{
    Word aux = aChar + shift;

    if (aux >= lowAGraveChr && aux <= lowARingChr)
	return (Word) 'a' - shift;
    else if (aux >= lowEGraveChr && aux <= lowEDiaeresisChr)
	return (Word) 'e' - shift;
    else if (aux >= lowIGraveChr && aux <= lowIDiaeresisChr)
	return (Word) 'i' - shift;
    else if (aux >= lowOGraveChr && aux <= lowODiaeresisChr)
	return (Word) 'o' - shift;
    else if (aux >= lowUGraveChr && aux <= lowUDiaeresisChr)
	return (Word) 'u' - shift;
    else if (aux == lowYAcuteChr)
	return (Word) 'y' - shift;

    return aChar;

}

#define auxchar (params->m2->w1)

/*
 * Adds the selected accent to a vocal
 */
Word Vocal(Word aChar)
{
    DWord paramsPtr = 0;
    KeyboardParams *params = NULL;

    FtrGet(appCreator, kbParams, &paramsPtr);
    params = (KeyboardParams *) paramsPtr;

    auxchar = aChar;

    if (params->accent != noAcc) {

	//start with lower case
	if (auxchar >= (Word) 'A' && auxchar <= (Word) 'Z')
	    auxchar += ' ';

	//only if character is alphabetic,
	//apply selected accent according to character constants
	if (auxchar >= (Word) 'a' && auxchar <= (Word) 'z') {
	    switch (auxchar) {

	    case (Word) 'a':
		switch (params->accent) {

		case graveAcc:
		    return aChar + lowAGraveChr - (Word) 'a';

		case acuteAcc:
		    return aChar + lowAAcuteChr - (Word) 'a';

		case circumflexAcc:
		    return aChar + lowACircumflexChr - (Word) 'a';

		case diaeresisAcc:
		    return aChar + lowADiaeresisChr - (Word) 'a';

		case tildeAcc:
		    return aChar + lowATildeChr - (Word) 'a';

		}
		break;

	    case (Word) 'o':
		switch (params->accent) {

		case graveAcc:
		    return aChar + lowOGraveChr - (Word) 'o';

		case acuteAcc:
		    return aChar + lowOAcuteChr - (Word) 'o';

		case circumflexAcc:
		    return aChar + lowOCircumflexChr - (Word) 'o';

		case diaeresisAcc:
		    return aChar + lowODiaeresisChr - (Word) 'o';

		case tildeAcc:
		    return aChar + lowOTildeChr - (Word) 'o';

		}
		break;

	    case (Word) 'e':
	    case (Word) 'i':
		switch (params->accent) {

		case graveAcc:
		    return aChar + lowEGraveChr - (Word) 'e';

		case acuteAcc:
		    return aChar + lowEAcuteChr - (Word) 'e';

		case circumflexAcc:
		    return aChar + lowECircumflexChr - (Word) 'e';

		case diaeresisAcc:
		    return aChar + lowEDiaeresisChr - (Word) 'e';

		}
		break;

	    case (Word) 'u':
		switch (params->accent) {

		case graveAcc:
		    return aChar + lowUGraveChr - (Word) 'u';

		case acuteAcc:
		    return aChar + lowUAcuteChr - (Word) 'u';

		case circumflexAcc:
		    return aChar + lowUCircumflexChr - (Word) 'u';

		case diaeresisAcc:
		    return aChar + lowUDiaeresisChr - (Word) 'u';

		}
		break;

	    case (Word) 'y':

		if (params->accent == acuteAcc)
		    return aChar + lowYAcuteChr - (Word) 'y';
		else if (params->accent == diaeresisAcc) {
		    if (aChar == 'y')
			return lowYDiaeresisChr;
		    else
			return upYDiaeresisChr;
		}

		break;

	    case (Word) 'n':

		if (params->accent == tildeAcc) {
		    if (aChar == 'n')
			return lowNTildeChr;
		    else
			return upNTildeChr;
		}

		break;

	    }

	}

    }

    return aChar;

}

#undef auxchar

/*
 * Returns main form resources.
 *
 */
DWord MainResource(Word code)
{
    DWord result = NULL;

    switch (code) {

    case vkbInitForm:
	result = (DWord) FrmInitForm(VKBFrm);
	break;

    case vkbInitMenu:
	result = (DWord) MenuInit(VKBMenu);
	break;

    case showHelp:
	FrmHelp(setupHelp);
	result = true;
	break;

    }

    return result;

}

/*
 * Set drawing colors according to preferences
 */
void Color(void)
{
  Color1(false);
}

void Color1(Boolean toolbar)
{
    UInt32 ui32aux = NULL;
    Int32 color = 0;
    RGBColorType rgbc;

    rgbc.index = 0;
    rgbc.r = 0;
    rgbc.g = 0;
    rgbc.b = 0;

    FtrGet(appCreator, kbOptions, &ui32aux);

    switch (ui32aux & colorMask) {

    default:
    case color1:
	color = -1;		//default color
	break;

    case color2:		//white
	rgbc.r = 255;
	rgbc.g = 255;
	rgbc.b = 255;
	break;

    case color3:		//pale gray
	rgbc.r = 204;
	rgbc.g = 204;
	rgbc.b = 204;
	break;

    case color4:		//black
	rgbc.r = 0;
	rgbc.g = 0;
	rgbc.b = 0;
	break;

    case color5:		//pale weak yellow
	rgbc.r = 255;
	rgbc.g = 255;
	rgbc.b = 204;
	break;

    case color6:		//pale weak green
	rgbc.r = 204;
	rgbc.g = 255;
	rgbc.b = 204;
	break;

    case color7:		//pale weak blue
	rgbc.r = 204;
	rgbc.g = 204;
	rgbc.b = 255;
	break;

    case color8:		//pale weak red
	rgbc.r = 255;
	rgbc.g = 204;
	rgbc.b = 204;
	break;

    }

    if (!color)
	color = WinRGBToIndex(&rgbc);
    else {
        //default to system color
	if (toolbar) {
            WinSetForeColor(UIColorGetTableEntryIndex(UIMenuForeground));
	    color = UIColorGetTableEntryIndex(UIMenuFill);
	} else {
	    //for keyboard
            WinSetForeColor(UIColorGetTableEntryIndex(UIObjectForeground));
	    color = UIColorGetTableEntryIndex(UIObjectFill);
	}
	WinIndexToRGB(color, &rgbc);
    }

    WinSetBackColor(color);
    //for black (or dark colors) the forecolors must be white
    if (rgbc.r + rgbc.g + rgbc.b < 300) {
	WinSetForeColor(0);
	WinSetTextColor(0);
    }

}

/*
 * Play or not a system sound according to preferences
 */
void MSndPlaySystemSound(SndSysBeepType beepID)
{
    UInt32 dwparams = NULL;
    KeyboardParams *params = NULL;
    Boolean dosound = true;

    FtrGet(appCreator, kbParams, &dwparams);
    params = (KeyboardParams *) dwparams;

    if (params)
	if (params->special2 & spNoSound)
	    dosound = false;

    if (dosound)
	SndPlaySystemSound(beepID);
}

/*
 * Disable a field object (similar to FrmHideObject, does not erase field)
 */
void FldObjectDisable(FormType * formP, UInt16 objIndex)
{
    FieldPtr fldP = FrmGetObjectPtr(formP, objIndex);
    FieldAttrType fattr;

    InsPtEnable(false);
    FldReleaseFocus(fldP);
    FldSetUsable(fldP, false);
    FldGetAttributes(fldP, &fattr);
    fattr.visible = false;
    FldSetAttributes(fldP, &fattr);

}

/*
 * Copy current main field selection to another field
 */
void CopySelection(FieldType * aField)
{
    FormType *aForm = FrmGetActiveForm();
    FieldType *bField = (FieldType *) FrmGetObjectPtr(aForm,
						      FrmGetObjectIndex
						      (aForm, textFld));
    UInt16 start = 0, end = 0;

    FldGetSelection(bField, &start, &end);

    if (start != end) {
	FldSetTextHandle(aField, NULL);

	FldCopy(bField);
	FldSetSelection(aField, 0, FldGetTextLength(aField));
	FldPaste(aField);
	FldSetSelection(aField, 0, 0);

    }

}

/*
 * Calculate margin to center a character on a cell.
 */
short centerChr(short cellW, char *holder)
{
    return (cellW - FntCharWidth(holder[0])) / 2;
}
