/*
 * Copyright (c) 2000, 2001, 2002 by Gustavo Broos.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.0
 * of the License, or (at your option) any later version.
 *
 * VKBStandAlone.c: Code to install the keyboard trap in absence of a helper utility.
 *
 * This was coded before I had access to the PalmOS source code, so this is substantially
 * different from the PalmOS keyboard and may show some code that can be optimized with
 * internal knowledge of the PalmOS, but since this does not assume much about internals,
 * I hope it will survive some PalmOS new releases.
 *
 * This code implements a lot of tricks and wrappers around the PalmOS, it has suffered
 * a lot of changes from an original keyboard hack I coded, it has the usual resource
 * restrictions of a PalmIII program plus the restrictions of a hack, so this is not pretty,
 * and may show some dead code.  It is being released under the GNU GPL because the program
 * still seems useful to Palm users after Palm OS 4.0 release, and because I do not have much
 * time to work on this; that is one of the reasons why I do not clean or re-write the code
 * thoroughly.
 *
 * I like extreme programming, it has allowed me to evolve this code in little time and with
 * few major bugs.  Open Source and free software have additional advantages that practically
 * guarantee good code in all aspects (if evolving on those environments from the beginning, or
 * given enough time, but free software is philosophically preferable in my opinion).
 * I hope this is useful to you.
 *
 */

#include "VKBIncludeAll.h"

#ifndef standAlone
#define standAlone

#ifndef HACK

/*
 * PilotMain for the stand-alone version
 */
DWord PilotMain(Word cmd, Ptr cmdPBP, Word launchFlags)
{
    DWord error = 0;

    switch (cmd) {
    case sysAppLaunchCmdNormalLaunch:

	//check rom required
	if (error =
	    RomVersionCompatible(sysMakeROMVersion
				 (2, 0, 0, sysROMStageRelease, 0),
				 launchFlags))
	    return error;

	//tell keyboard is not running (in case not unregistered by error)
	FtrUnregister(appCreator, kbRunning);

	if (error = startApplication()) {
	    return error;
	}

	FrmGotoForm(setupFrm);

	setupEventLoop();

	stopApplication();

	FrmCloseAllForms();

	break;

    default:
	break;

    }

    return false;
}

/*
 * Some stand-alone version functions
 */
void setupEventLoop(void)
{
    EventType event;
    Word error = 0;
    DWord options = resetOptions;

    do {
	EvtGetEvent(&event, -1);

	if (!SysHandleEvent(&event))
	    if (!MenuHandleEvent(NULL, &event, &error))
		if (!AppHandleEvent(&event))
		    FrmDispatchEvent(&event);

	FtrGet(appCreator, kbOptions, &options);
	if (options & leaveSetup)
	    break;

    } while (event.eType != appStopEvent);

}

Boolean AppHandleEvent(EventPtr event)
{

    switch (event->eType) {

    case frmLoadEvent:{
	    FormPtr aForm = NULL;
	    Word fID = 0;

	    fID = event->data.frmLoad.formID;

	    aForm = FrmInitForm(fID);
	    FrmSetActiveForm(aForm);

	    switch (fID) {

	    case setupFrm:
		FrmSetEventHandler(aForm, setupHandler);
		return true;
		break;

	    }

	    break;
	}

    }

    return false;

}


/*
 * This functions try to do  something similar to what HackMaster does,
 * for the stand-alone version (see also VKBShared.c)
 */

/*
 * Set the new keyboard trap
 */
DWord setTrap(void)
{
    VoidPtr prevTrapPtr = NULL, test = NULL, check = NULL;
    DWord error = 0, taux = 0;

    if (!FtrGet(appCreator, prevTrap, &taux))
	return NULL;

    //get current kb trap
    prevTrapPtr = SysGetTrapAddress(sysTrapSysKeyboardDialog);

    //lock code 1000
    error = lockCode1000(true, &check);
    if (error)
	return (DWord) error;

    //check if new trap already set
    if (prevTrapPtr == check) {

	FtrSet(appCreator, prevTrap, (DWord) prevTrapPtr);

	error = lockCode1(false);
	if (error)
	    return (DWord) error;

	return NULL;
    }
    //set new trap
    SysSetTrapAddress(sysTrapSysKeyboardDialog, check);

    //check if trap was set
    test = SysGetTrapAddress(sysTrapSysKeyboardDialog);
    if (test != check) {

	ShowError1(installAlert);

	return (DWord) installAlert;
    }

    FtrSet(appCreator, prevTrap, (DWord) prevTrapPtr);

    return NULL;

}

#endif

#endif
