/*
 * Copyright (c) 2000, 2001, 2002 by Gustavo Broos.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.0
 * of the License, or (at your option) any later version.
 *
 * VKBShared.c: Code shared by the keyboard trap code and the program setup code.
 *
 * This was coded before I had access to the PalmOS source code, so this is substantially
 * different from the PalmOS keyboard and may show some code that can be optimized with
 * internal knowledge of the PalmOS, but since this does not assume much about internals,
 * I hope it will survive some PalmOS new releases.
 *
 * This code implements a lot of tricks and wrappers around the PalmOS, it has suffered
 * a lot of changes from an original keyboard hack I coded, it has the usual resource
 * restrictions of a PalmIII program plus the restrictions of a hack, so this is not pretty,
 * and may show some dead code.  It is being released under the GNU GPL because the program
 * still seems useful to Palm users after Palm OS 4.0 release, and because I do not have much
 * time to work on this; that is one of the reasons why I do not clean or re-write the code
 * thoroughly.
 *
 * I like extreme programming, it has allowed me to evolve this code in little time and with
 * few major bugs.  Open Source and free software have additional advantages that practically
 * guarantee good code in all aspects (if evolving on those environments from the beginning, or
 * given enough time, but free software is philosophically preferable in my opinion).
 * I hope this is useful to you.
 *
 */

#include "VKBIncludeAll.h"

#ifndef vkbShared
#define vkbShared

//include code borrowed from the Palm SDK examples
#include "romcheck.c"

/*
 * Helpers, shows an error message
 */
Word ShowError1(Word alertID)
{
    return ShowError(alertID, NULL, NULL, NULL);
}

Word ShowError(Word alertID, CharPtr msg1, CharPtr msg2, CharPtr msg3)
{
    DWord dwAux = NULL;

    FtrGet(appCreator, VKBdb, &dwAux);

    if (dwAux) {
	if (msg1 == NULL)
	    dwAux = FrmAlert(alertID);
	else
	    dwAux = FrmCustomAlert(alertID, msg1, msg2, msg3);
    } else
	//if database not available, only beep
	SndPlaySystemSound(sndError);

    return (Word) dwAux;
}

/*
 * Functions to deal with saved preferences.
 */
DWord FromDatabase(Word feature)
{
    DWord sdb = NULL;

    FtrGet(appCreator, swidb, &sdb);

    if (sdb)
	return ToFromDatabaseSub(feature, (DmOpenRef) sdb, NULL);
    else
	return ToFromDatabaseSub(feature, NULL, NULL);
}

void ToDatabase(Word feature, DWord value)
{
    DWord sdb = NULL;

    FtrGet(appCreator, swidb, &sdb);

    if (sdb)
	ToFromDatabaseSub(feature, (DmOpenRef) sdb, value);
    else
	ToFromDatabaseSub(feature, NULL, value);
}

DWord ToFromDatabaseSub(Word feature, DmOpenRef open, DWord value)
{
    DmOpenRef sWIDB = NULL;
    DWord result = NULL;

    //open the information database if necessary
    if (!open) {
	sWIDB =
	    DmOpenDatabaseByTypeCreator(SWINFO, appCreator,
					dmModeReadWrite);
	if (!sWIDB)
	    return result;
    } else
	sWIDB = open;

    if (sWIDB) {
	VoidHand aRecord = NULL;
	VoidPtr pRecord = NULL;
	Int index = featureToIndex(feature);

	//if all expected records are present
	if (!(DmNumRecords(sWIDB) < swidbNumRecords)) {

	    //if feature is recognized
	    if (index != -1) {

		if (value) {
		    //write value
		    DmWrite(MemHandleLock
			    (aRecord =
			     DmGetRecord(sWIDB, index)), 0, &value, 4);
		    MemHandleUnlock(aRecord);
		    DmReleaseRecord(sWIDB, index, false);
		    result = true;
		} else {
		    //read value
		    result = *(DWordPtr) MemHandleLock(aRecord =
						       DmQueryRecord(sWIDB,
								     index));
		    MemHandleUnlock(aRecord);
		}

	    }

	}

    }
    //close database if necessary
    if (!open)
	DmCloseDatabase(sWIDB);

    return result;

}

/*
 * Used to translate between features and indexes in the information db
 */
Int featureToIndex(Word feature)
{
    Int index = -1;

    switch (feature) {

    case kbOptions:
	index = iOptions;
	break;

    }

    return index;
}

/*
 * Start, stop functions
 */
DWord startApplication(void)
{
    UInt card = 0, ix = 0;
    VoidPtr aPtr = NULL;
    VoidHand auxHand;
    LocalID dbID = NULL, dbIDComp = NULL;
    DmOpenRef sWIDB = NULL, VKBProg = NULL, orAux = NULL, orFirst = NULL;
    DmSearchStateType searchptr;
    UInt32 dbftr = NULL;

    //return if both databases are already open and registered
    if (!FtrGet(appCreator, VKBdb, &dbftr)
	&& !FtrGet(appCreator, swidb, &dbftr))
	return NULL;

    //get some info of the main database
    DmGetNextDatabaseByTypeCreator(true, &searchptr, appType, appCreator,
				   false, &card, &dbID);

    //assuming for now that we are going to open the main database
    FtrUnregister(appCreator, noClose);

    //look for open main database (for better compatibility in different hack managers)
    orFirst = orAux = DmNextOpenResDatabase(orAux);
    while (orAux) {
	DmOpenDatabaseInfo(orAux, &dbIDComp, NULL, NULL, NULL, NULL);
	if (dbIDComp == dbID) {
            FtrSet(appCreator, noClose, 1);
	    VKBProg = orAux;
	    break;
	}
	orAux = DmNextOpenResDatabase(orAux);
	if (orAux == orFirst)
	    break;
    }

    //open if we need to
    if (!VKBProg) {
        //open main database
        VKBProg =
	    DmOpenDatabaseByTypeCreator(appType, appCreator, dmModeReadWrite);
        if (!VKBProg)
	    return databaseAlert;
    }

    FtrSet(appCreator, VKBdb, (DWord) VKBProg);

    //open or create the info database
    if (!
	(sWIDB =
	 DmOpenDatabaseByTypeCreator(SWINFO, appCreator,
				     dmModeReadWrite))) {

	DmCreateDatabase(CARD, swInfoName, appCreator, SWINFO, false);
	if (!
	    (sWIDB =
	     DmOpenDatabaseByTypeCreator(SWINFO, appCreator,
					 dmModeReadWrite))) {
	    ShowError1(databaseAlert);
	    return databaseAlert;
	}

    }

    //erase previous records if there are more records than swidbNumRecords
    //TODO: a record showing the version should be checked to see if we
    //have to delete some previous records
    if (DmNumRecords(sWIDB)>swidbNumRecords)
      while(DmNumRecords(sWIDB))
        DmRemoveRecord(sWIDB, 0);

    //initialize new records (for new versions mainly)
    if ((ix = swidbNumRecords - DmNumRecords(sWIDB)) > 0) {
	Int i = 0, j = 0, k = 0, l = 0;
	Int sizes[swidbNumRecords];

	//insert here new sizes when increasing swidbNumRecords
	sizes[0] = 4;

	//create new records at database end
	for (j = swidbNumRecords - ix, i = 0; i < ix; i++, j++) {

	    //create record according to sizes
	    auxHand = DmNewRecord(sWIDB, &j, sizes[j]);
	    if (!auxHand) {
		ShowError1(databaseAlert);
		return databaseAlert;
	    }
	    aPtr = MemHandleLock(auxHand);

	    //fill new record with zeros
	    for (k = 0; k < sizes[j]; k++)
		DmWrite(aPtr, k, &l, 1);

	    MemHandleUnlock(auxHand);
	    DmReleaseRecord(sWIDB, j, false);

	}


    }

    FtrSet(appCreator, swidb, (DWord) sWIDB);

    return NULL;

}

void stopApplication(void)
{
    DWord options = resetOptions, saux = 0;
    DmOpenRef DB = NULL;

#ifndef HACK
    //handle trap patching in stand-alone version
    FtrGet(appCreator, kbOptions, &options);

    if (!(options & kbEnabled))
	unSetTrap();
#endif

    //close information db
    if (!FtrGet(appCreator, swidb, &saux)) {
	DB = (DmOpenRef) saux;
	DmCloseDatabase(DB);
    }

    //close main db if we opened it
    if (FtrGet(appCreator, noClose, &saux)) {
        if (!FtrGet(appCreator, VKBdb, &saux)) {
	    DB = (DmOpenRef) saux;
	    DmCloseDatabase(DB);
        }
    }

    //dispose db features
    FtrUnregister(appCreator, swidb);
    FtrUnregister(appCreator, VKBdb);
    FtrUnregister(appCreator, noClose);

}

#ifndef HACK

/*
 * This functions try to do  something similar to what HackMaster does,
 * for the stand-alone version (see also VKBStandAlone.c).
 * This are shared between the setup and hack parts of the stand-alone version.
 */

/*
 * Set back the original keyboard trap
 */
void unSetTrap(void)
{
    DWord prevTrapPtr = NULL;
    VoidPtr test = NULL;
    Char buffer[28];
    UInt32 vkbdb = NULL;

    if (FtrGet(appCreator, prevTrap, &prevTrapPtr))
	return;

    FtrGet(appCreator, VKBdb, &vkbdb);

    if (prevTrapPtr != NULL) {

	SysSetTrapAddress(sysTrapSysKeyboardDialog,
			  (FormEventHandlerPtr) prevTrapPtr);

	//paranoid, check if trap was set
	test = SysGetTrapAddress(sysTrapSysKeyboardDialog);
	if ((DWord) test != prevTrapPtr) {

	    ShowError1(installAlert);

	    return;
	}

	FtrUnregister(appCreator, prevTrap);

	//unlock code 1000
	if (lockCode1(false)) {
	    ShowError(customErrorAlert,
		      getString(buffer, cantLockCode1, (DmOpenRef) vkbdb),
		      NULL, NULL);
	    SysReset();
	}

    } else {
	ShowError(customErrorAlert,
		  getString(buffer, cantUnsetTrap, (DmOpenRef) vkbdb),
		  NULL, NULL);
	SysReset();
    }

}

/*
 * This functions lock and protect the new trap code
 */
DWord lockCode1(Boolean lock)
{
    VoidPtr check = NULL;

    return lockCode1000(lock, &check);
}

DWord lockCode1000(Boolean lock, VoidPtr * check)
{
    UInt card = 0;
    LocalID dbID = NULL, dbIDComp = NULL;
    DmOpenRef orAux = NULL, orFirst = NULL;
    VoidHand code1 = NULL;
    Boolean dbo = false;
    DmSearchStateType searchptr;
    Char buffer[38];

    //lock the code 1000 resource
    DmGetNextDatabaseByTypeCreator(true, &searchptr, appType, appCreator,
				   false, &card, &dbID);

    //look for open main database
    orFirst = orAux = DmNextOpenResDatabase(orAux);
    while (orAux) {
	DmOpenDatabaseInfo(orAux, &dbIDComp, NULL, NULL, NULL, NULL);
	if (dbIDComp == dbID)
	    break;
	orAux = DmNextOpenResDatabase(orAux);
	if (orAux == orFirst)
	    break;
    }

    //if it is not open try to open it
    if (!(dbIDComp == dbID)) {

	orAux =
	    DmOpenDatabaseByTypeCreator(appType, appCreator,
					dmModeReadWrite);

	if (orAux)
	    dbo = true;
	else
	    return errorAlert;

    }
    //get the code 1000 resource
    code1 =
	DmGetResourceIndex(orAux,
			   DmFindResource(orAux, 'code', 1000, NULL));

    //lock or unlock handle
    if (lock)
	*check = MemHandleLock(code1);
    else
	MemHandleUnlock(code1);

    //protect or unprotect the main database
    if (DmDatabaseProtect(card, dbID, lock)) {
	ShowError(customErrorAlert,
		  getString(buffer, cantProtectDatabase, orAux), NULL,
		  NULL);
	if (dbo)
	    DmCloseDatabase(orAux);
	return errorAlert;
    }
    //close the database if opened
    if (dbo)
	DmCloseDatabase(orAux);

    return false;

}

#endif

/*
 * Helper functions
 */

/*
 * Get resource string, it also constructs an error string if db is NULL
 */
CharPtr getString(CharPtr buffer, Int tSTRID, DmOpenRef db)
{
    VoidHand aString = NULL;
    UInt32 aux = NULL;

    if (db) {
	aString =
	    DmGetResourceIndex((DmOpenRef) db,
			       DmFindResource((DmOpenRef) db, 'tSTR',
					      tSTRID, NULL));

	StrCopy(buffer, (CharPtr) MemHandleLock(aString));

	MemHandleUnlock(aString);
	DmReleaseResource(aString);
    } else {
	//error getting string, maybe db reference was lost
	StrCopy(buffer, "Error: ");
	StrIToA(buffer + StrLen(buffer), tSTRID);
    }

    return buffer;
}

/*
 * Intended to init different types of arrays from a source
 */
void initArray(char *dest, const char *src, short len)
{
    short x = 0;

    for (x = 0; x < len; x++)
	dest[x] = src[x];

}

#endif
