/*
 * Copyright (c) 2000, 2001, 2002 by Gustavo Broos.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.0
 * of the License, or (at your option) any later version.
 *
 * VKBSetupHandler.c: Code that handles the user's preferences.
 *
 * This was coded before I had access to the PalmOS source code, so this is substantially
 * different from the PalmOS keyboard and may show some code that can be optimized with
 * internal knowledge of the PalmOS, but since this does not assume much about internals,
 * I hope it will survive some PalmOS new releases.
 *
 * This code implements a lot of tricks and wrappers around the PalmOS, it has suffered
 * a lot of changes from an original keyboard hack I coded, it has the usual resource
 * restrictions of a PalmIII program plus the restrictions of a hack, so this is not pretty,
 * and may show some dead code.  It is being released under the GNU GPL because the program
 * still seems useful to Palm users after Palm OS 4.0 release, and because I do not have much
 * time to work on this; that is one of the reasons why I do not clean or re-write the code
 * thoroughly.
 *
 * I like extreme programming, it has allowed me to evolve this code in little time and with
 * few major bugs.  Open Source and free software have additional advantages that practically
 * guarantee good code in all aspects (if evolving on those environments from the beginning, or
 * given enough time, but free software is philosophically preferable in my opinion).
 * I hope this is useful to you.
 *
 */

#include "VKBIncludeAll.h"

/*
 * Handle user preferences settings
 */
Boolean setupHandler(EventPtr aEvent)
{
    DWord options = resetOptions, vkbdb = NULL, dwAux = NULL;
    Boolean handled = false;
    DmOpenRef sWIDB = NULL;
    Char buffer[24];

#ifdef HACK

    //simulate application start
    if (startApplication()) {
	FtrGet(appCreator, VKBdb, &vkbdb);
	//otherwise the next message may repeat many times, and we risk further errors
	if (!FtrGet(appCreator, hackConfReset, &dwAux))
	    SysReset();
	//unexpected error, try to warn user
	ShowError(customErrorAlert,
		  getString(buffer, cantStart, (DmOpenRef) vkbdb), NULL,
		  NULL);
        FtrSet(appCreator, hackConfReset, 1);
    }

#endif

    FtrGet(appCreator, VKBdb, &vkbdb);

    //if setup is called, the keyboard can not be running,
    //so anyway clear the flag in case there was an error
    FtrUnregister(appCreator, kbRunning);

    if (FtrGet(appCreator, kbOptions, &options)) {
	options = FromDatabase(kbOptions) & ~kbEnabled;
	if (!options)
	    options = resetOptions;
    }

    switch (aEvent->eType) {

    case menuEvent:
	switch (aEvent->data.menu.itemID) {

	case aboutMItem:{
		FormPtr aForm = FrmInitForm(aboutFrm);

		FrmDoDialog(aForm);
		FrmDeleteForm(aForm);

		break;
	    }

	}

	break;

    case frmOpenEvent:
	setupSetupForm();
	FtrGet(appCreator, kbOptions, &options);
	FrmDrawForm(FrmGetActiveForm());
	handled = true;
	break;

    case ctlSelectEvent:

	switch (aEvent->data.ctlSelect.controlID) {

	case setupHelpBtn:
	    FrmHelp(setupHelp);
	    handled = true;
	    break;

#ifdef HACK

	case setupDoneBtn:
	    FrmGotoForm(9000);
	    break;

#endif

#ifndef HACK
	case setupEnableCheck:
	    options ^= kbEnabled;
	    if (options & kbEnabled) {
		if (setTrap()) {
		    options ^= kbEnabled;
		    options |= leaveSetup;
		    ShowError1(installAlert);
		    FrmDrawForm(FrmGetActiveForm());
		}
	    }

	    handled = true;
	    break;
#endif

	case setupIntlCheck:
	    options ^= intlStart;
	    handled = true;
	    break;

	case setup123Check:
	    options ^= numStart;
	    handled = true;
	    break;

	case setupSysUndoCheck:
	    options ^= kbUndo;
	    handled = true;
	    break;

	case setupNoSoundCheck:
	    options ^= noSound;
	    handled = true;
	    break;

	case setupAutoshiftLockCheck:
	    options ^= autoshiftLock;
	    handled = true;
	    break;

	case setupPenUpCheck:{
		FormPtr auxform = NULL;

		options ^= opendown;

		auxform = FrmGetActiveForm();
		if (options & opendown)
		    FrmShowObject(auxform,
				  FrmGetObjectIndex(auxform,
						    setupRepeatCheck));
		else
		    FrmHideObject(auxform,
				  FrmGetObjectIndex(auxform,
						    setupRepeatCheck));

		handled = true;
		break;
	    }

	case setupWidthCheck:
	    options ^= wide;
	    handled = true;
	    break;

	case setupAbcCheck:
	    options ^= noabc;
	    handled = true;
	    break;

	case setupRepeatCheck:
	    options ^= oprepeat;
	    handled = true;
	    break;

	}

	break;

    case popSelectEvent:

	switch (aEvent->data.popSelect.controlID) {

	case colorPopUp:
	    options &= ~colorMask;
	    //color options are saved in upper bits
	    options |= aEvent->data.popSelect.selection << 13;
	    break;

	}

	break;

    }

    FtrSet(appCreator, kbOptions, options);
    ToDatabase(kbOptions, options);

#ifdef HACK
    //simulate application stop
    stopApplication();

#endif

    return handled;

}

/*
 * Set up the preferences form
 */
void setupSetupForm()
{
    DWord options = resetOptions, dbaux = 0;
    VoidPtr aControl = NULL, bControl = NULL;
    FormPtr aForm = FrmGetActiveForm();
    DmOpenRef sWIDB = NULL;
    Char buffer[28];

    FtrGet(appCreator, swidb, &dbaux);
    sWIDB = (DmOpenRef) dbaux;

    FtrGet(appCreator, VKBdb, &dbaux);

    //take care of preferences
    FtrGet(appCreator, kbOptions, &options);

    options &= ~leaveSetup;

#ifndef HACK

    if (options & kbEnabled) {
	aControl =
	    FrmGetObjectPtr(aForm,
			    FrmGetObjectIndex(aForm, setupEnableCheck));
	CtlSetValue((ControlPtr) aControl, true);
    }
#endif

    FtrSet(appCreator, kbOptions, options);

    if (options & intlStart) {
	aControl =
	    FrmGetObjectPtr(aForm,
			    FrmGetObjectIndex(aForm, setupIntlCheck));
	CtlSetValue((ControlPtr) aControl, true);
    }

    if (options & numStart) {
	aControl =
	    FrmGetObjectPtr(aForm,
			    FrmGetObjectIndex(aForm, setup123Check));
	CtlSetValue((ControlPtr) aControl, true);
    }

    if (options & kbUndo) {
	aControl =
	    FrmGetObjectPtr(aForm,
			    FrmGetObjectIndex(aForm, setupSysUndoCheck));
	CtlSetValue((ControlPtr) aControl, true);
    }

    if (options & noSound) {
	aControl =
	    FrmGetObjectPtr(aForm,
			    FrmGetObjectIndex(aForm, setupNoSoundCheck));
	CtlSetValue((ControlPtr) aControl, true);
    }

    if (options & autoshiftLock) {
	aControl =
	    FrmGetObjectPtr(aForm,
			    FrmGetObjectIndex(aForm,
					      setupAutoshiftLockCheck));
	CtlSetValue((ControlPtr) aControl, true);
    }

    if (options & opendown) {
	aControl =
	    FrmGetObjectPtr(aForm,
			    FrmGetObjectIndex(aForm, setupPenUpCheck));
	CtlSetValue((ControlPtr) aControl, true);

	FrmShowObject(aForm, FrmGetObjectIndex(aForm, setupRepeatCheck));
    } else
	FrmHideObject(aForm, FrmGetObjectIndex(aForm, setupRepeatCheck));

    if (options & wide) {
	aControl =
	    FrmGetObjectPtr(aForm,
			    FrmGetObjectIndex(aForm, setupWidthCheck));
	CtlSetValue((ControlPtr) aControl, true);
    }

    if (options & noabc) {
	aControl =
	    FrmGetObjectPtr(aForm,
			    FrmGetObjectIndex(aForm, setupAbcCheck));
	CtlSetValue((ControlPtr) aControl, true);
    }

    if (options & oprepeat) {
	aControl =
	    FrmGetObjectPtr(aForm,
			    FrmGetObjectIndex(aForm, setupRepeatCheck));
	CtlSetValue((ControlPtr) aControl, true);
    }
    //color prefs
    {
	//the color preferences are in upper bits
	Byte color = (options & colorMask) >> 13;
	UInt32 dwaux = 0;

	FtrGet(sysFtrCreator, sysFtrNumROMVersion, &dwaux);

	if (dwaux >= (UInt32) 0x03500000) {
	    aControl =
		FrmGetObjectPtr(aForm,
				FrmGetObjectIndex(aForm, colorList));
	    LstSetSelection((ListPtr) aControl, color);
	    bControl =
		FrmGetObjectPtr(aForm,
				FrmGetObjectIndex(aForm, colorPopUp));
	    CtlSetLabel(bControl, LstGetSelectionText(aControl, color));
	} else {
	    FrmHideObject(aForm, FrmGetObjectIndex(aForm, colorPopUp));
	    FrmHideObject(aForm, FrmGetObjectIndex(aForm, kbcolorLbl));
	}

    }

    FrmCopyTitle(aForm, getString(buffer, titleNormal, (DmOpenRef) dbaux));

}
