/*
 * Preferences.java
 *
 * Copyright 2002 Steve Held,
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package makedocjr.editor;

import java.awt.Color;
import java.io.File;
import java.io.Serializable;

public class Preferences implements Serializable, Cloneable {

	final static String PREFS = "prefs.ser";
	final static String[] FONTS = { "Serif", "Sans-serif", "Monospaced",
									"Dialog", "DialogInput" };

	int font;
	int fontSize;
	boolean bold;
	boolean italic;
	Color foreground;
	Color background;
	int tabSize;
	File textFileStart;
	File docFileStart;

	public Preferences() {
		font = 1;
		fontSize = 12;
		bold = false;
		italic = false;
		foreground = Color.black;
		background = Color.white;
		tabSize = 4;
		textFileStart = new File(System.getProperty("user.dir"));
		docFileStart = new File(System.getProperty("user.dir"));
	}
	public int getFont() {
		return font;
	}
	public void setFont(int font) {
		this.font = font;
	}
	public int getFontSize() {
		return fontSize;
	}
	public void setFontSize(int fontSize) {
		this.fontSize = fontSize;
	}
	public boolean getBold() {
		return bold;
	}
	public void setBold(boolean bold) {
		this.bold = bold;
	}
	public boolean getItalic() {
		return italic;
	}
	public void setItalic(boolean italic) {
		this.italic = italic;
	}
	public Color getForeground() {
		return foreground;
	}
	public void setForeground(Color foreground) {
		this.foreground = foreground;
	}
	public Color getBackground() {
		return background;
	}
	public void setBackground(Color background) {
		this.background = background;
	}
	public int getTabSize() {
		return tabSize;
	}
	public void setTabSize(int tabSize) {
		this.tabSize = tabSize;
	}
	public File getTextFileStart() {
		return textFileStart;
	}
	public void setTextFileStart(File textFileStart) {
		this.textFileStart = textFileStart;
	}
	public File getDocFileStart() {
		return docFileStart;
	}
	public void setDocFileStart(File docFileStart) {
		this.docFileStart = docFileStart;
	}
	public Object clone() {
		Preferences prefs = new Preferences();
		prefs.font = this.font;
		prefs.fontSize = this.fontSize;
		prefs.bold = this.bold;
		prefs.italic = this.italic;
		prefs.foreground = new Color( this.foreground.getRGB());
		prefs.background = new Color( this.background.getRGB());
		prefs.tabSize= this.tabSize;
		prefs.textFileStart = new File(this.textFileStart.getPath());
		prefs.docFileStart = new File(this.docFileStart.getPath());
		return prefs;
	}

}