/*
 * FindReplaceDialog.java
 *
 * Copyright 2002, 2003 Steve Held,
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package makedocjr.editor;

import javax.swing.*;
import java.awt.*;
import javax.swing.border.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;

public class FindReplaceDialog extends JDialog {
	static final byte CANCEL = 0;
	static final byte FIND = 1;
	static final byte REPLACE = 2;
	static final byte BOOKMARK_ALL = 3;
	private static final int MAX_LIST_SIZE = 5;
	JPanel leftPanel = new JPanel();
	JPanel buttonsPanel = new JPanel();
	GridBagLayout gridBagLayout3 = new GridBagLayout();
	JButton findButton = new JButton();
	JPanel optionsPanel = new JPanel();
	TitledBorder titledBorder1;
	JCheckBox ignoreCaseCheckBox = new JCheckBox();
	JPanel searchPanel = new JPanel();
	String[] lastTextToReplace = {""};
	JComboBox replaceTextField = new JComboBox(lastTextToReplace);;
	String[] lastTextToFind = {""};
	JComboBox findTextField = new JComboBox(lastTextToFind);
	JLabel replaceLabel = new JLabel();
	GridBagLayout gridBagLayout1 = new GridBagLayout();
	JLabel findLabel = new JLabel();
	GridBagLayout gridBagLayout2 = new GridBagLayout();
	GridBagLayout gridBagLayout4 = new GridBagLayout();
	JButton replaceButton = new JButton();
	JButton bookmarkAllButton = new JButton();
	Component component1;
	Component component2;
	JButton cancelButton = new JButton();
	boolean ignoreCase;
	boolean searchSelectedText;
	boolean searchFromTop;
	byte buttonPressed;
	JButton regexHelpButton = new JButton();
	Component component3;
	JRadioButton jRadioSearchStart = new JRadioButton();
	JRadioButton jRadioSearchCursor = new JRadioButton();
	JRadioButton jRadioSearchSelected = new JRadioButton();
	ButtonGroup buttonGroupSearch = new ButtonGroup();

	public FindReplaceDialog(Frame frame, boolean modal) {
		super(frame, modal);
		try {
			jbInit();
		}
		catch(Exception e) {
			e.printStackTrace();
		}
	}

	public FindReplaceDialog(Dialog dialog, boolean modal) {
		super(dialog, modal);
		try {
			jbInit();
		}
		catch(Exception e) {
			e.printStackTrace();
		}
	}
	private void jbInit() throws Exception {
		titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white,new Color(134, 134, 134)),"Options");
		component1 = Box.createVerticalStrut(8);
		component2 = Box.createVerticalStrut(8);
		component3 = Box.createVerticalStrut(8);
		buttonsPanel.setLayout(gridBagLayout3);
		findButton.setPreferredSize(new Dimension(107, 27));
		findButton.setSelected(true);
		findButton.setText("Find");
		findButton.setDefaultCapable(true);
		findButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				findButton_actionPerformed(e);
			}
		});
		optionsPanel.setBorder(titledBorder1);
		optionsPanel.setLayout(gridBagLayout4);
		ignoreCaseCheckBox.setText("Ignore case");
		searchPanel.setLayout(gridBagLayout1);
		replaceLabel.setText("Replace with:");
		findLabel.setText("RegEx to find:");
		leftPanel.setLayout(gridBagLayout2);
		replaceButton.setPreferredSize(new Dimension(107, 27));
		replaceButton.setText("Replace...");
		replaceButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				replaceButton_actionPerformed(e);
			}
		});
		bookmarkAllButton.setText("Bookmark All");
		bookmarkAllButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				bookmarkAllButton_actionPerformed(e);
			}
		});
		this.setModal(true);
		this.setTitle("Find/Replace");
		cancelButton.setPreferredSize(new Dimension(107, 27));
		cancelButton.setText("Close");
		cancelButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				cancelButton_actionPerformed(e);
			}
		});
		findTextField.setPreferredSize(new Dimension(200, 21));
		findTextField.setEditable(true);
		replaceTextField.setPreferredSize(new Dimension(200, 21));
		replaceTextField.setEditable(true);
		regexHelpButton.setPreferredSize(new Dimension(107, 27));
		regexHelpButton.setText("RegEx Help");
		regexHelpButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				regexHelpButton_actionPerformed(e);
			}
		});
		jRadioSearchStart.setText("Search from start of file");
		jRadioSearchCursor.setText("Search from cursor postion");
		jRadioSearchSelected.setText("Search only selected text");
		leftPanel.add(searchPanel,     new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
			,GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
		searchPanel.add(findLabel,     new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
			,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
		searchPanel.add(findTextField,  new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
		searchPanel.add(replaceLabel,  new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
		searchPanel.add(replaceTextField,  new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
		leftPanel.add(optionsPanel,  new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0
			,GridBagConstraints.NORTH, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
		optionsPanel.add(ignoreCaseCheckBox,           new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
			,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
		optionsPanel.add(jRadioSearchStart,            new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
			,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 5, 0, 0), 0, 0));
		optionsPanel.add(jRadioSearchCursor,        new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0
			,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 5, 0, 0), -8, 0));
		optionsPanel.add(jRadioSearchSelected,    new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0
			,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 5, 0, 0), 0, 0));
		this.getContentPane().add(buttonsPanel, BorderLayout.CENTER);
		buttonsPanel.add(findButton,                    new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
			,GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(5, 5, 0, 5), 0, 0));
		buttonsPanel.add(replaceButton,             new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
			,GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(0, 5, 0, 5), 0, 0));
		buttonsPanel.add(bookmarkAllButton,          new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0
			,GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(5, 5, 0, 5), 0, 0));
		buttonsPanel.add(component1,         new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 7, 0), 0, 0));
		buttonsPanel.add(component2,         new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 8, 0), 0, 0));
		buttonsPanel.add(cancelButton,        new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0
			,GridBagConstraints.SOUTH, GridBagConstraints.NONE, new Insets(0, 5, 5, 5), 0, 0));
		buttonsPanel.add(regexHelpButton,     new GridBagConstraints(0, 8, 1, 1, 0.0, 1.0
			,GridBagConstraints.SOUTH, GridBagConstraints.NONE, new Insets(0, 5, 5, 5), 0, 0));
		buttonsPanel.add(component3,    new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 46, 0), 0, 0));
		this.getContentPane().add(leftPanel, BorderLayout.WEST);
		this.getRootPane().setDefaultButton(findButton);
		buttonGroupSearch.add(jRadioSearchCursor);
		buttonGroupSearch.add(jRadioSearchStart);
		buttonGroupSearch.add(jRadioSearchSelected);
	}
	public String getTextToFind() {
		return (String) findTextField.getItemAt(0);
	}
	public void setTextToFind(String textToFind) {
		findTextField.getEditor().setItem(textToFind);
	}
	public String getReplacementText() {
		return (String) replaceTextField.getItemAt(0);
	}
	public void setReplacementText(String replacementText) {
		replaceTextField.getEditor().setItem(replacementText);
	}
	public boolean getIgnoreCase() {
		return ignoreCaseCheckBox.isSelected();
	}
	public void setIgnoreCase(boolean ignoreCase) {
		ignoreCaseCheckBox.setSelected(ignoreCase);
	}
	public boolean getSearchSelectedText() {
		return jRadioSearchSelected.isSelected();
	}
	public void setSearchSelectedText(boolean searchSelectedText) {
		jRadioSearchSelected.setEnabled(searchSelectedText);
		jRadioSearchSelected.setSelected(searchSelectedText);
	}
	public boolean getSearchFromTop() {
		return jRadioSearchStart.isSelected();
	}
	public void setSearchFromTop(boolean searchFromTop) {
		jRadioSearchStart.setSelected(searchFromTop);
	}
	public void setSearchFromCursor(boolean searchFromCursor) {
		jRadioSearchCursor.setSelected(searchFromCursor);
	}
	public byte getButtonPressed() {
		return buttonPressed;
	}
	void cancelButton_actionPerformed(ActionEvent e) {
		buttonPressed = CANCEL;
		hide();
	}

	void regexHelpButton_actionPerformed(ActionEvent e) {
		String s = null;
		URL helpURL = null;
		JEditorPane regexHelpPane = null;
		try {
			s = "file:"
				+ System.getProperty("user.dir")
				+ System.getProperty("file.separator")
				+ "regexsyntax.html";
			helpURL = new URL(s);
			regexHelpPane = new JEditorPane(helpURL);
			regexHelpPane.setEditable(false);
			JScrollPane editorScrollPane = new JScrollPane(regexHelpPane);
			editorScrollPane.setVerticalScrollBarPolicy(
					JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
			JDialog jd = new JDialog(this, "RegEx Help", false);
			jd.getContentPane().add(editorScrollPane);
			jd.setSize(new Dimension(450, 400));
			jd.setVisible(true);
		}
		catch (Exception ex) { // malformed url or io
			JOptionPane.showMessageDialog(this,
						"Could not find the file \"regexsyntax.html\"",
						"Missing help file.", JOptionPane.ERROR_MESSAGE);
		}
	}

	void findButton_actionPerformed(ActionEvent e) {
		if (!validateSearchText())
			return;
		buttonPressed = FindReplaceDialog.FIND;
		this.hide();
	}

	void replaceButton_actionPerformed(ActionEvent e) {
		if (!validateSearchText())
			return;
		updateReplaceList();
		buttonPressed = FindReplaceDialog.REPLACE;
		this.hide();
	}

	void bookmarkAllButton_actionPerformed(ActionEvent e) {
		if (!validateSearchText())
			return;
		updateReplaceList();
		buttonPressed = FindReplaceDialog.BOOKMARK_ALL;
		this.hide();
	}

	private boolean validateSearchText() {
		String searchText = (String) findTextField.getEditor().getItem();
		if (searchText == null || searchText.equals("")) {
			JOptionPane.showMessageDialog(this,
					"Cannot search for a blank regex.",
					"Search Error", JOptionPane.ERROR_MESSAGE);
			return false;
		} else {
			findTextField.removeItem(searchText);
			findTextField.insertItemAt(searchText, 0);
			if (findTextField.getItemCount() > MAX_LIST_SIZE) {
				findTextField.removeItemAt(MAX_LIST_SIZE);
			}
			return true;
		}
	}

	private void updateReplaceList() {
		String replaceText = (String) replaceTextField.getEditor().getItem();
		replaceTextField.removeItem(replaceText);
		replaceTextField.insertItemAt(replaceText, 0);
		if (replaceTextField.getItemCount() > MAX_LIST_SIZE) {
			replaceTextField.removeItemAt(MAX_LIST_SIZE);
		}
	}

}