/*
 * EncodeDialog.java
 *
 * Copyright 2002 Steve Held,
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package makedocjr.editor;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.io.*;
import javax.swing.text.*;
import makedocjr.*;
import net.onza.op.upswing.utilityfields.*;


public class EncodeDialog extends JDialog {

	public final static byte MAX_TITLE_LENGTH = 31;
	JPanel jPanel1 = new JPanel();
	GridBagLayout gridBagLayout1 = new GridBagLayout();
	JLabel fileLabel = new JLabel();
	SingleLineTextField fileTextfield = new SingleLineTextField();
	JButton browseButton = new JButton();
	JLabel titleLabel = new JLabel();
	FiniteTextField titleTextfield = new FiniteTextField();
	JButton optionsButton = new JButton();
	Component component1;
	Component component4;
	Component component5;
	JButton okButton = new JButton();
	JButton cancelButton = new JButton();
	Component component2;
	MakeDocJr makeDoc;
	JFileChooser jFileChooser;
	String fileName;
	String docTitle;
	boolean okay;

	public EncodeDialog( Frame frame, boolean modal, MakeDocJr makeDoc,
						 JFileChooser jFileChooser) {
		super(frame, modal);
		this.makeDoc = makeDoc;
		this.jFileChooser = jFileChooser;
		try {
			jbInit();
		}
		catch(Exception e) {
			e.printStackTrace();
		}
	}

	public EncodeDialog( Dialog dialog, boolean modal, MakeDocJr makeDoc,
						 JFileChooser jFileChooser) {
		super(dialog, modal);
		this.makeDoc = makeDoc;
		this.jFileChooser = jFileChooser;
		try {
			jbInit();
		}
		catch(Exception e) {
			e.printStackTrace();
		}
	}

	private void jbInit() throws Exception {
		titleTextfield.setMaxLength(EncodeDialog.MAX_TITLE_LENGTH);
		component1 = Box.createVerticalStrut(8);
		component4 = Box.createVerticalStrut(8);
		component5 = Box.createHorizontalStrut(8);
		component2 = Box.createHorizontalStrut(8);
		jPanel1.setLayout(gridBagLayout1);
		fileLabel.setText("File Name: ");
		fileTextfield.setMinimumSize(new Dimension(180, 21));
		fileTextfield.setPreferredSize(new Dimension(180, 21));
		fileTextfield.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				fileTextfield_actionPerformed(e);
			}
		});
		browseButton.setText("Browse...");
		browseButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				browseButton_actionPerformed(e);
			}
		});
		titleLabel.setText("Title: ");
		optionsButton.setText("Options");
		optionsButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				optionsButton_actionPerformed(e);
			}
		});
		titleTextfield.setMinimumSize(new Dimension(180, 21));
		titleTextfield.setPreferredSize(new Dimension(180, 21));
		titleTextfield.setText(makeDoc.getTitle());
		titleTextfield.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				titleTextfield_actionPerformed(e);
			}
		});
		this.setTitle("Export");
		this.setModal(true);
		okButton.setSelected(true);
		okButton.setText("OK");
		okButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				okButton_actionPerformed(e);
			}
		});
		cancelButton.setText("Cancel");
		cancelButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				cancelButton_actionPerformed(e);
			}
		});
		jPanel1.setMaximumSize(new Dimension(376, 171));
		jPanel1.setMinimumSize(new Dimension(376, 171));
		jPanel1.setPreferredSize(new Dimension(376, 171));
		jPanel1.add(titleTextfield,            new GridBagConstraints(1, 3, 3, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(titleLabel,           new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0
			,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(component1,        new GridBagConstraints(1, 2, 3, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 19, 0), 0, 0));
		jPanel1.add(component4,       new GridBagConstraints(5, 4, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 27, 0), 0, 0));
		jPanel1.add(component5,    new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(browseButton,    new GridBagConstraints(5, 0, 1, 3, 0.0, 0.0
			,GridBagConstraints.NORTHEAST, GridBagConstraints.NONE, new Insets(-1, 0, 1, 0), 0, 0));
		jPanel1.add(fileTextfield,     new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0
			,GridBagConstraints.SOUTH, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(okButton,     new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 19, 0));
		jPanel1.add(optionsButton,  new GridBagConstraints(5, 5, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(component2, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(cancelButton, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0
			,GridBagConstraints.SOUTHWEST, GridBagConstraints.NONE, new Insets(0, -1, 0, 1), 0, 0));
		jPanel1.add(fileLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
			,GridBagConstraints.NORTHEAST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		this.getContentPane().add(jPanel1, BorderLayout.CENTER);
	}

	void optionsButton_actionPerformed(ActionEvent e) {
		EncodeOptionsDialog eod = new EncodeOptionsDialog(this, true, makeDoc);
		eod.pack();
		Dimension dlgSize = eod.getSize();
		Dimension frmSize = this.getSize();
		Point loc = this.getLocation();
		eod.setLocation((frmSize.width - dlgSize.width) / 2 +
						loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
		eod.setVisible(true);
	}

	void cancelButton_actionPerformed(ActionEvent e) {
		this.dispose();
	}

	void okButton_actionPerformed(ActionEvent e) {
		okayAction();
	}

	void browseButton_actionPerformed(ActionEvent e) {
		if (JFileChooser.APPROVE_OPTION == jFileChooser.showSaveDialog(this)) {
			fileTextfield.setText(appendDocExtension(
									jFileChooser.getSelectedFile().getPath()));
			this.repaint();
			if (!titleTextfield.getText().equals(""))
				titleTextfield.requestFocus();
			else
				okButton.requestFocus();
		}
	}

	private void okayAction() {
		if (titleTextfield.getText() == null ||
				titleTextfield.getText().equals("") ||
				fileTextfield.getText() == null ||
				fileTextfield.getText().trim().equals("")) {
			return;
		}
		fileName = appendDocExtension(fileTextfield.getText().trim());
		docTitle = titleTextfield.getText();
		okay = true;
		this.hide();
	}

	void titleTextfield_actionPerformed(ActionEvent e) {
		if (fileTextfield.getText().equals(""))
			fileTextfield.requestFocus();
		else okayAction();
	}

	void fileTextfield_actionPerformed(ActionEvent e) {
		if (titleTextfield.getText().equals(""))
			titleTextfield.requestFocus();
		else okayAction();
	}

	String appendDocExtension(String fileName) {
		if (    fileName.toLowerCase().endsWith(".pdb") ||
				fileName.toLowerCase().endsWith(".prc")) {
			return fileName;
		}
		fileName = fileName + ".pdb";
		return fileName;
	}
	public String getFileName() {
		return fileName;
	}
	public String getDocTitle() {
		return docTitle;
	}
	public boolean isOkay() {
		return okay;
	}

}

