/*
 * DocFileFilter.java
 *
 * Copyright 2002 Steve Held,
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package makedocjr.editor;

import javax.swing.filechooser.*;
import java.io.File;
import java.io.FilenameFilter;


/*
 * @author Steve Held
 * @version 1.0
 */

public class DocFileFilter extends FileFilter implements FilenameFilter {

	public DocFileFilter() {
	}

	public boolean accept(File file) {
		if (file.isDirectory()) return true;
		String extension = getExtension(file.getName());
		if (extension.equals("pdb") || extension.equals("prc")) return true;
		return false;
	}

	public String getDescription() {
		return "DOC files";
	}

	/*
	* Method to get the extension of the file, in lowercase
	*/
	private String getExtension(String name) {
		int i = name.lastIndexOf('.');
		if (i > 0 &&  i < name.length() - 1) {
			return name.substring(i+1).toLowerCase();
		}
		return "";
	}

	public boolean accept(File dir, String name) {
		if (name == null) return true;
		String extension = getExtension(name);
		if (extension.equals("pdb") || extension.equals("prc")) return true;
		return false;
	}
}