/*
 * ConfirmReplaceDialog.java
 *
 * Copyright 2002 Steve Held,
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package makedocjr.editor;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;


/*
 * @author Steve Held
 * @version 1.0
 */

public class ConfirmReplaceDialog extends JDialog {
	GridBagLayout gridBagLayout1 = new GridBagLayout();
	JLabel jLabel = new JLabel();
	JButton jButtonYes = new JButton();
	JButton jButtonNo = new JButton();
	JButton jButtonAll = new JButton();
	JButton jButtonDone = new JButton();
	Component component1;
	Component component2;
	Component component3;
	Component component4;
	byte buttonPressed;
	static final byte DONE = 0;
	static final byte YES = 1;
	static final byte NO = 2;
	static final byte ALL = 3;

	public ConfirmReplaceDialog() {
		try {
			jbInit();
		}
		catch(Exception e) {
			e.printStackTrace();
		}
	}
	private void jbInit() throws Exception {
		component1 = Box.createVerticalStrut(8);
		component2 = Box.createHorizontalStrut(8);
		component3 = Box.createHorizontalStrut(8);
		component4 = Box.createHorizontalStrut(8);
		jLabel.setText("Replace this occurrence?");
		this.getContentPane().setLayout(gridBagLayout1);
		jButtonYes.setText("Yes");
		jButtonYes.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jButtonYes_actionPerformed(e);
			}
		});
		jButtonNo.setText("No");
		jButtonNo.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jButtonNo_actionPerformed(e);
			}
		});
		jButtonAll.setText("Replace All");
		jButtonAll.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jButtonAll_actionPerformed(e);
			}
		});
		jButtonDone.setText("Done");
		jButtonDone.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jButtonDone_actionPerformed(e);
			}
		});
		this.setModal(true);
		this.setTitle("Confirm replacement");
		this.getContentPane().add(jButtonYes,         new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		this.getContentPane().add(jButtonNo,         new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0
			,GridBagConstraints.SOUTHEAST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		this.getContentPane().add(jButtonAll,         new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0
			,GridBagConstraints.SOUTHEAST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		this.getContentPane().add(jButtonDone,        new GridBagConstraints(6, 2, 1, 1, 0.0, 0.0
			,GridBagConstraints.SOUTHEAST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		this.getContentPane().add(component1,      new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 15, 0), 0, 0));
		this.getContentPane().add(component2,    new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		this.getContentPane().add(component3,   new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		this.getContentPane().add(component4,  new GridBagConstraints(5, 2, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		this.getContentPane().add(jLabel,    new GridBagConstraints(0, 0, 6, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 75, 0));
	}

	public byte getButtonPressed() {
		return buttonPressed;
	}

	private void jButtonYes_actionPerformed(ActionEvent e) {
		buttonPressed = ConfirmReplaceDialog.YES;
		hide();
	}

	private void jButtonNo_actionPerformed(ActionEvent e) {
		buttonPressed = ConfirmReplaceDialog.NO;
		hide();
	}

	private void jButtonAll_actionPerformed(ActionEvent e) {
		buttonPressed = ConfirmReplaceDialog.ALL;
		hide();
	}

	private void jButtonDone_actionPerformed(ActionEvent e) {
		buttonPressed = ConfirmReplaceDialog.DONE;
		hide();
	}


}