/*
 * BookmarksDialog.java
 *
 * Copyright 2002 Steve Held,
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package makedocjr.editor;

import javax.swing.*;
import java.awt.*;
import javax.swing.border.Border;
import java.util.*;
import java.awt.event.*;
import javax.swing.event.*;
import java.beans.*;
import makedocjr.*;

/*
 * @author Steve Held
 * @version 1.0
 */

public class BookmarksDialog extends JDialog {
	JSplitPane jSplitPane1 = new JSplitPane();
	JList jList1;
	JPanel jPanel1 = new JPanel();
	GridBagLayout gridBagLayout1 = new GridBagLayout();
	JButton jButtonGoTo = new JButton();
	JButton jButtonRename = new JButton();
	Component component1;
	JButton jButtonDelete = new JButton();
	Component component2;
	Component component3;
	JButton jButtonSortAlpha = new JButton();
	Component component4;
	JButton jButtonSortLocation = new JButton();
	Component component5;
	JButton jButtonOK = new JButton();
	JButton jButtonCancel = new JButton();
	Component component6;
	MakeDocJr makeDoc;
	DefaultListModel listModel = new DefaultListModel();;
	boolean okPressed = false;
	int index; // the JList getSelectionIndex
	boolean gotoPressed; //
	int position;
	Component component7;
	JButton jButtonDeleteAll = new JButton();

	public BookmarksDialog(Frame frame, boolean modal, MakeDocJr makeDoc) {
		super(frame, modal);
		this.makeDoc = (MakeDocJr) makeDoc.clone();
		try {
			jbInit();
		}
		catch(Exception e) {
			e.printStackTrace();
		}
	}

	public BookmarksDialog(Dialog dialog, boolean modal, MakeDocJr makeDoc) {
		super(dialog, modal);
		this.makeDoc = (MakeDocJr) makeDoc.clone();
		try {
			jbInit();
		}
		catch(Exception e) {
			e.printStackTrace();
		}
	}

	private void jbInit() throws Exception {
		component6 = Box.createHorizontalStrut(8);
		component7 = Box.createVerticalStrut(8);
		this.setTitle("Edit Bookmarks");
		component1 = Box.createVerticalStrut(8);
		component2 = Box.createVerticalStrut(8);
		component3 = Box.createVerticalStrut(8);
		component4 = Box.createVerticalStrut(8);
		component5 = Box.createVerticalStrut(8);
		jPanel1.setLayout(gridBagLayout1);
		jButtonGoTo.setEnabled(false);
		jButtonGoTo.setMaximumSize(new Dimension(83, 27));
		jButtonGoTo.setMinimumSize(new Dimension(83, 27));
		jButtonGoTo.setPreferredSize(new Dimension(83, 27));
		jButtonGoTo.setText("Go To");
		jButtonGoTo.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jButtonGoTo_actionPerformed(e);
			}
		});
		jButtonRename.setEnabled(false);
		jButtonRename.setText("Rename");
		jButtonRename.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jButtonRename_actionPerformed(e);
			}
		});
		jButtonDelete.setEnabled(false);
		jButtonDelete.setMaximumSize(new Dimension(83, 27));
		jButtonDelete.setMinimumSize(new Dimension(83, 27));
		jButtonDelete.setPreferredSize(new Dimension(83, 27));
		jButtonDelete.setText("Delete");
		jButtonDelete.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jButtonDelete_actionPerformed(e);
			}
		});
		jButtonSortAlpha.setText("Sort Alphabetically");
		jButtonSortAlpha.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jButtonSortAlpha_actionPerformed(e);
			}
		});
		jButtonSortLocation.setMaximumSize(new Dimension(135, 27));
		jButtonSortLocation.setMinimumSize(new Dimension(135, 27));
		jButtonSortLocation.setPreferredSize(new Dimension(135, 27));
		jButtonSortLocation.setText("Sort by Location");
		jButtonSortLocation.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jButtonSortLocation_actionPerformed(e);
			}
		});
		jButtonOK.setMaximumSize(new Dimension(73, 27));
		jButtonOK.setMinimumSize(new Dimension(73, 27));
		jButtonOK.setPreferredSize(new Dimension(73, 27));
		jButtonOK.setText("OK");
		jButtonOK.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jButtonOK_actionPerformed(e);
			}
		});
		setListModelContents();
		jList1 = new JList(listModel);
		jList1.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		jList1.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
			public void valueChanged(ListSelectionEvent e) {
				jList1_valueChanged(e);
			}
		});
		jList1.setMaximumSize(new Dimension(135, 233));
		jList1.setMinimumSize(new Dimension(135, 233));
		JScrollPane scrollPane = new JScrollPane(jList1);
		//jList1.setModel(new DefaultListModel());
		jPanel1.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
		jButtonCancel.setText("Cancel");
		jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jButtonCancel_actionPerformed(e);
			}
		});
		scrollPane.setMinimumSize(new Dimension(115, 253));
		scrollPane.setPreferredSize(new Dimension(110, 253));
		jList1.setMaximumSize(new Dimension(135, 233));
		jList1.setMinimumSize(new Dimension(135, 233));
		jList1.setModel(listModel);
		jList1.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		jList1.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
			public void valueChanged(ListSelectionEvent e) {
				jList1_valueChanged(e);
			}
		});
		jList1.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		jButtonDeleteAll.setText("Delete All");
		jButtonDeleteAll.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jButtonDeleteAll_actionPerformed(e);
			}
		});
		this.getContentPane().add(jSplitPane1, BorderLayout.CENTER);
		jSplitPane1.add(scrollPane, JSplitPane.LEFT);
		jSplitPane1.add(jPanel1, JSplitPane.RIGHT);
		jPanel1.add(jButtonRename,       new GridBagConstraints(0, 2, 5, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(component1,       new GridBagConstraints(0, 3, 5, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(jButtonDelete,       new GridBagConstraints(0, 4, 5, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(component2,             new GridBagConstraints(0, 1, 5, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 13, 0), 0, 0));
		jPanel1.add(component3,       new GridBagConstraints(0, 5, 3, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(jButtonSortAlpha,      new GridBagConstraints(0, 8, 5, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(component4,      new GridBagConstraints(0, 9, 5, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(jButtonSortLocation,      new GridBagConstraints(0, 10, 5, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(component5,        new GridBagConstraints(0, 11, 5, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 16, 0), 0, 0));
		jPanel1.add(jButtonOK,      new GridBagConstraints(0, 12, 2, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(jButtonGoTo,     new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(jButtonCancel,     new GridBagConstraints(4, 12, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(component6,    new GridBagConstraints(2, 12, 2, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(component7,    new GridBagConstraints(4, 7, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 13, 0), 0, 0));
		jPanel1.add(jButtonDeleteAll,  new GridBagConstraints(3, 6, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
	}

	private void setListModelContents() {
		listModel.clear();
		Object[] bmArray = makeDoc.getBookmarks().toArray();
		for (int i = 0; i < bmArray.length; i++) {
			listModel.addElement(((Bookmark) bmArray[i]).getName());
		}
		jButtonDelete.setEnabled(false);
		jButtonGoTo.setEnabled(false);
		jButtonRename.setEnabled(false);
		this.repaint();
	}

	void jButtonCancel_actionPerformed(ActionEvent e) {
		this.hide();
	}

	void jButtonSortLocation_actionPerformed(ActionEvent e) {
		makeDoc.sortBookmarksByLocation();
		setListModelContents();
	}

	void jButtonSortAlpha_actionPerformed(ActionEvent e) {
		 makeDoc.sortBookmarksByName();
		 setListModelContents();
	}

	void jButtonDelete_actionPerformed(ActionEvent e) {
		 makeDoc.getBookmarks().remove(index);
		 setListModelContents();
	}

	void jButtonRename_actionPerformed(ActionEvent e) {
		 String bmName = showRenameBookmarkPane();
		 repaint();
		 if (bmName == null) return;
		 if (bmName.equals("uninitializedValue")) return;
		 if (bmName.equals("")) return;
		 bmName = limitStringAndRemoveBreaks(bmName, 15);
		 // if bmName same as bookmark name, show dialog
		 if (makeDoc.bookmarkNameExists(bmName)) {
			JOptionPane.showConfirmDialog( this, bmName + " already exists.",
										   "Bookmark naming conflict",
										   JOptionPane.DEFAULT_OPTION,
										   JOptionPane.WARNING_MESSAGE);
			this.repaint();
			return;
		 }
		 Bookmark bm = (Bookmark) makeDoc.getBookmarks().get(index);
		 bm.setName(bmName);
		 setListModelContents();
	}

	String showRenameBookmarkPane() {
		JOptionPane pane = new JOptionPane("Name: (maximum 15 characters)", JOptionPane.PLAIN_MESSAGE,
											JOptionPane.OK_CANCEL_OPTION);
		pane.setWantsInput(true);
		JDialog dialog = pane.createDialog(this, "Rename bookmark");
		dialog.show();
		// can return uninitializedValue or "" or String
		return (String)pane.getInputValue();
	}

	// Put this in a separate utility class
	// Used for textfields to limit length and remove linebreaks
	String limitStringAndRemoveBreaks(String str, int maxLength) {
		if (str == null) return null;
		char[] textArray = str.toCharArray();
		int proposedLength = textArray.length;
		if (proposedLength > maxLength) proposedLength = maxLength;
		char[] tempArray = new char[proposedLength];
		for (int i = 0; i < proposedLength; i++) {
			tempArray[i] = textArray[i];
			if (tempArray[i] == '\n') {
				tempArray[i] = ' ';
			}
		}
		return new String(tempArray);
	}

	void jList1_valueChanged(ListSelectionEvent e) {
		if (e.getValueIsAdjusting()) return;
		index = jList1.getSelectedIndex();
		if (index == -1) {
			jButtonDelete.setEnabled(false);
			jButtonGoTo.setEnabled(false);
			jButtonRename.setEnabled(false);
		} else {
			jButtonDelete.setEnabled(true);
			jButtonGoTo.setEnabled(true);
			jButtonRename.setEnabled(true);
		}
	}

	void jButtonOK_actionPerformed(ActionEvent e) {
		 okPressed = true;
		 this.hide();
	}

	public ArrayList getBookmarks() {
		return makeDoc.getBookmarks();
	}

	void jButtonGoTo_actionPerformed(ActionEvent e) {
		 Bookmark bm = (Bookmark) makeDoc.getBookmarks().get(index);
		 position = bm.getFileOffset();
		 gotoPressed = true;
		 this.hide();
	}
	public boolean getOkPressed() {
		return okPressed;
	}
	public boolean getGotoPressed() {
		return gotoPressed;
	}
	public int getPosition() {
		return position;
	}

	void jButtonDeleteAll_actionPerformed(ActionEvent e) {
		makeDoc.getBookmarks().clear();
		setListModelContents();
	}

}