/*
 * Copyright 2002 Steve Held
 * Copyright 2001 jGuru.com
 * Based on code by Scott Stanchfield (http://www.jguru.com/faq/view.jsp?EID=506602)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package net.onza.op.upswing.textdrag;

import javax.swing.JTextArea;
import javax.swing.text.Document;

/**
 * This subclass of <code>javax.swing.JTextArea</code> allows text to be
 * dragged and dropped inside the textarea.
 *
 * All constructor comments are taken from <code>javax.swing.JTextArea</code>
 * documentation.
 */
public class JDraggableTextArea extends JTextArea {

	/**
	 * Constructs a new TextArea. A default model is set, the initial string is
	 * null, and rows/columns are set to 0.
	 */
	public JDraggableTextArea() {
		new TextDragDropper(this);
	}

	/**
	 * Constructs a new TextArea with the specified text displayed. A default
	 * model is created and rows/columns are set to 0.
	 *
	 * @param text  the text to be displayed, or null
	 */
	public JDraggableTextArea(String text) {
		super(text);
		new TextDragDropper(this);
	 }

	/**
	 * Constructs a new empty TextArea with the specified number of rows and
	 * columns. A default model is created, and the initial string is null.
	 *
	 * @param rows     the number of rows >= 0
	 * @param columns  the number of columns >= 0
	 *
	 * @throws IllegalArgumentException    if the rows or columns arguments are
	 * negative.
	 */
	public JDraggableTextArea(int rows, int columns) {
		super(rows, columns);
		new TextDragDropper(this);
	}

	/**
	 * Constructs a new TextArea with the specified text and number of rows and
	 * columns. A default model is created.
	 *
	 * @param text     the text to be displayed, or null
	 * @param rows     the number of rows >= 0
	 * @param columns  the number of columns >= 0
	 *
	 * @throws IllegalArgumentException    if the rows or columns arguments are
	 * negative.
	 */
	public JDraggableTextArea(String text, int rows, int columns) {
		super(text, rows, columns);
		new TextDragDropper(this);
	}


	/**
	 * Constructs a new JTextArea with the given document model, and defaults
	 * for all of the other arguments (null, 0, 0).
	 *
	 * @param doc   the model to use
	 */
	public JDraggableTextArea(Document doc) {
		super(doc);
		new TextDragDropper(this);
	}


	/**
	 * Constructs a new JTextArea with the specified number of rows and columns,
	 * and the given model. All of the constructors feed through this
	 * constructor.
	 *
	 * @param doc   the model to use
	 * @param text     the text to be displayed, or null
	 * @param rows     the number of rows >= 0
	 * @param columns  the number of columns >= 0
	 *
	 * @throws IllegalArgumentException    if the rows or columns arguments are
	 * negative.
	 */
	public JDraggableTextArea(Document doc, String text, int rows, int columns) {
		super(doc, text, rows, columns);
		new TextDragDropper(this);
	}

}