/*
 * Copyright 2002 Steve Held
 * Copyright 2001 jGuru.com
 * Based on code by Scott Stanchfield (http://www.jguru.com/faq/view.jsp?EID=506602)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

//DragDropCaret - replacement Caret that cooperates with a dragger

package net.onza.op.upswing.textdrag;

import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.event.MouseEvent;

import javax.swing.JComponent;
import javax.swing.text.DefaultCaret;

public class DragDropCaret extends DefaultCaret {
	private boolean isDragging = false;

	public void mouseClicked(MouseEvent e) {
		if ((getComponent() != null) && getComponent().isEnabled()) {
			getComponent().requestFocus();
		}
		super.mouseClicked(e);
	}

	public void mouseDragged(MouseEvent e) {
		if (isDragging) {
			if ((getComponent() != null) && getComponent().isEnabled()) {
				getComponent().requestFocus();
			}
			moveCaret(e);
		}
	}

	public void mousePressed(MouseEvent e) {}

	public void mouseReleased(MouseEvent e) {
		if (!e.isPopupTrigger()) {
			if (isDragging)
				isDragging = false;
			else
				positionCaret(e);
		}
	}

	public void startDrag(DragGestureEvent e) {
		positionCaret((MouseEvent)e.getTriggerEvent());
		isDragging = true;
	}
}