/*
 * PreferencesDialog.java
 *
 * Copyright 2002 Steve Held,
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package makedocjr.editor;

import javax.swing.*;
import java.awt.*;
import javax.swing.border.*;
import java.io.*;
import net.onza.op.upswing.utilityfields.*;
import java.awt.event.*;

public class PreferencesDialog extends JDialog {

	Border border1;
	TitledBorder titledBorder1;
	Border border2;
	TitledBorder titledBorder2;
	Border border3;
	TitledBorder titledBorder3;
	Preferences preferences;
	JPanel jPanelTop = new JPanel();
	JTextField jTextFieldTextDir = new JTextField();
	Component component9;
	GridBagLayout gridBagLayout6 = new GridBagLayout();
	GridBagLayout gridBagLayout5 = new GridBagLayout();
	Component component11;
	Component component7;
	JPanel jPanelTextColor = new JPanel();
	GridBagLayout gridBagLayout4 = new GridBagLayout();
	JPanel jPanelColor = new JPanel();
	Component component10;
	GridBagLayout gridBagLayout3 = new GridBagLayout();
	Component component6;
	Component component5;
	GridBagLayout gridBagLayout2 = new GridBagLayout();
	Component component4;
	GridBagLayout gridBagLayout1 = new GridBagLayout();
	JPanel jPanelDirectories = new JPanel();
	Component component3;
	Component component2;
	Component component1;
	JLabel jLabelText = new JLabel();
	JButton jButtonBrowseDoc = new JButton();
	JPanel jPanelFont = new JPanel();
	DigitsOnlyTextField jTextFieldFontSize = new DigitsOnlyTextField();
	JComboBox jComboBoxFont;
	JLabel jLabelFontSize = new JLabel();
	JPanel jPanelBackgroundColor = new JPanel();
	JLabel jLabelDoc = new JLabel();
	JCheckBox jCheckBoxItalic = new JCheckBox();
	JPanel jPanelDisplay = new JPanel();
	JLabel jLabelFont = new JLabel();
	JPanel jPanelTabSize = new JPanel();
	JButton jButtonBackgroundColor = new JButton();
	JTextField jTextFieldDocDir = new JTextField();
	JButton jButtonBrowseText = new JButton();
	JPanel jPanelFilePaths = new JPanel();
	DigitsOnlyTextField jTextFieldTabSize = new DigitsOnlyTextField();
	JButton jButtonTextColor = new JButton();
	JCheckBox jCheckBoxBold = new JCheckBox();
	JLabel jLabelTabSize = new JLabel();
	JTabbedPane jTabbedPane1 = new JTabbedPane();
	JButton jButtonCancel = new JButton();
	JButton jButtonOk = new JButton();
	JPanel jPanelBottom = new JPanel();
	JFileChooser jFileChooser;
	boolean okay;

	PreferencesDialog( Frame frame, Preferences preferences,
												JFileChooser jFileChooser) {
		super(frame, "MakeDocJr Editor Preferences", true);
		this.preferences = (Preferences) preferences.clone();
		this.jFileChooser = jFileChooser;
		try {
			jbInit();
		}
		catch(Exception e) {
			e.printStackTrace();
		}
	}

	private void jbInit() throws Exception {
		border3 = BorderFactory.createEtchedBorder(Color.white,new Color(134, 134, 134));
		titledBorder3 = new TitledBorder(border3,"Where to start looking for files");
		border1 = BorderFactory.createEtchedBorder(Color.white,new Color(134, 134, 134));
		titledBorder1 = new TitledBorder(border1,"Font");
		border2 = BorderFactory.createEtchedBorder(Color.white,new Color(134, 134, 134));
		titledBorder2 = new TitledBorder(border2,"Colors");
		component9 = Box.createHorizontalStrut(8);
		component11 = Box.createVerticalStrut(8);
		component7 = Box.createVerticalStrut(8);
		component10 = Box.createHorizontalStrut(8);
		component6 = Box.createHorizontalStrut(8);
		component5 = Box.createVerticalStrut(8);
		component4 = Box.createHorizontalStrut(8);
		component3 = Box.createHorizontalStrut(8);
		component2 = Box.createVerticalStrut(8);
		component1 = Box.createHorizontalStrut(8);
		jComboBoxFont = new JComboBox(Preferences.FONTS);
		jComboBoxFont.setPreferredSize(new Dimension(145, 21));
		jComboBoxFont.setSelectedIndex(preferences.getFont());
		jTextFieldTextDir.setPreferredSize(new Dimension(193, 21));
		jTextFieldTextDir.setEditable(false);
		jTextFieldTextDir.setText(preferences.getTextFileStart().getPath());
		jPanelTextColor.setPreferredSize(new Dimension(57, 27));
		jPanelTextColor.setBackground(preferences.getForeground());
		jPanelColor.setLayout(gridBagLayout4);
		jPanelColor.setPreferredSize(new Dimension(236, 86));
		jPanelColor.setBorder(titledBorder2);
		jPanelDirectories.setBorder(titledBorder3);
		jPanelDirectories.setLayout(gridBagLayout6);
		jLabelText.setText("Text:");
		jButtonBrowseDoc.setText("...");
		jButtonBrowseDoc.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jButtonBrowseDoc_actionPerformed(e);
			}
		});
		jButtonBrowseDoc.setPreferredSize(new Dimension(21, 21));
		jPanelFont.setLayout(gridBagLayout3);
		jPanelFont.setBorder(titledBorder1);
		jTextFieldFontSize.setColumns(3);
		jTextFieldFontSize.setText(Integer.toString(preferences.getFontSize()));
		jTextFieldFontSize.setMaxDigits(2);
		jLabelFontSize.setText("Size:");
		jPanelBackgroundColor.setPreferredSize(new Dimension(57, 27));
		jPanelBackgroundColor.setBackground(preferences.getBackground());
		jLabelDoc.setText("DOC:");
		jCheckBoxItalic.setSelected(preferences.getItalic());
		jCheckBoxItalic.setText("Italic");
		jCheckBoxItalic.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jCheckBoxItalic_actionPerformed(e);
			}
		});
		jPanelDisplay.setLayout(gridBagLayout1);
		jLabelFont.setText("Font:");
		jPanelTabSize.setPreferredSize(new Dimension(107, 41));
		jPanelTabSize.setLayout(gridBagLayout5);
		jButtonBackgroundColor.setText("Background");
		jButtonBackgroundColor.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jButtonBackgroundColor_actionPerformed(e);
			}
		});
		jTextFieldDocDir.setPreferredSize(new Dimension(193, 21));
		jTextFieldDocDir.setEditable(false);
		jTextFieldDocDir.setText(preferences.getDocFileStart().getPath());
		jButtonBrowseText.setText("...");
		jButtonBrowseText.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jButtonBrowseText_actionPerformed(e);
			}
		});
		jButtonBrowseText.setPreferredSize(new Dimension(21, 21));
		jPanelFilePaths.setLayout(gridBagLayout2);
		jTextFieldTabSize.setColumns(3);
		jTextFieldTabSize.setText(Integer.toString(preferences.getTabSize()));
		jTextFieldTabSize.setMaxDigits(2);
		jButtonTextColor.setText("Text");
		jButtonTextColor.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jButtonTextColor_actionPerformed(e);
			}
		});
		jButtonTextColor.setPreferredSize(new Dimension(101, 27));
		jCheckBoxBold.setSelected(preferences.getBold());
		jCheckBoxBold.setText("Bold");
		jCheckBoxBold.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jCheckBoxBold_actionPerformed(e);
			}
		});
		jLabelTabSize.setText("Tab Size:");
		jTabbedPane1.setPreferredSize(new Dimension(400, 350));
		jButtonCancel.setText("Cancel");
		jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jButtonCancel_actionPerformed(e);
			}
		});
		jButtonOk.setPreferredSize(new Dimension(73, 27));
		jButtonOk.setText("OK");
		jButtonOk.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jButtonOk_actionPerformed(e);
			}
		});
		jComboBoxFont.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jComboBoxFont_actionPerformed(e);
			}
		});
		this.getContentPane().add(jPanelTop,  BorderLayout.NORTH);
		jPanelTop.add(jTabbedPane1, null);
		jPanelDirectories.add(jButtonBrowseText, new GridBagConstraints(4, 0, 1, 2, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelDirectories.add(jTextFieldTextDir, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelDirectories.add(jButtonBrowseDoc, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0
			,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelDirectories.add(jTextFieldDocDir, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelDirectories.add(component9, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelDirectories.add(component10, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelDirectories.add(component11, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 13, 0), 0, 0));
		jPanelDirectories.add(jLabelText, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
			,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelDirectories.add(jLabelDoc, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0
			,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jTabbedPane1.add(jPanelDisplay, "Display");
		jTabbedPane1.add(jPanelFilePaths, "File Paths");
		jPanelFilePaths.add(jPanelDirectories, new GridBagConstraints(0, 0, 1, 4, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 54, 50));
		jPanelColor.add(jButtonTextColor, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelColor.add(jButtonBackgroundColor, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelColor.add(component5, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelColor.add(component6, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelColor.add(jPanelTextColor, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelColor.add(jPanelBackgroundColor, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelDisplay.add(jPanelTabSize, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(15, 0, 0, 0), 0, 10));
		jPanelDisplay.add(jPanelColor, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
			,GridBagConstraints.SOUTHEAST, GridBagConstraints.NONE, new Insets(-32, 83, 0, 86), 193, 31));
		jPanelTabSize.add(jTextFieldTabSize, new GridBagConstraints(3, 0, GridBagConstraints.REMAINDER, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 41, 0));
		jPanelTabSize.add(jLabelTabSize, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelTabSize.add(component4, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelDisplay.add(component7, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelDisplay.add(jPanelFont, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0
			,GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(0, 27, 39, 30), 87, 24));
		jPanelFont.add(jLabelFont, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelFont.add(jComboBoxFont, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), -22, 0));
		jPanelFont.add(component1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelFont.add(component2, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelFont.add(jLabelFontSize, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelFont.add(component3, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 30, 0, 31), 0, 0));
		jPanelFont.add(jCheckBoxBold, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelFont.add(jCheckBoxItalic, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanelFont.add(jTextFieldFontSize, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0
			,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, -2, 0, 2), 0, 0));
		this.getContentPane().add(jPanelBottom,  BorderLayout.SOUTH);
		jPanelBottom.add(jButtonOk, null);
		jPanelBottom.add(jButtonCancel, null);
		this.getRootPane().setDefaultButton(jButtonOk);
	}

	Preferences getPreferences() {
		return preferences;
	}

	boolean isOkay() {
		return okay;
	}

	void jComboBoxFont_actionPerformed(ActionEvent e) {
		 preferences.setFont(jComboBoxFont.getSelectedIndex());
	}

	void jCheckBoxBold_actionPerformed(ActionEvent e) {
		 preferences.setBold(jCheckBoxBold.isSelected());
	}

	void jCheckBoxItalic_actionPerformed(ActionEvent e) {
		 preferences.setItalic(jCheckBoxItalic.isSelected());
	}

	void jButtonTextColor_actionPerformed(ActionEvent e) {
		Color col = JColorChooser.showDialog( this, "Text Color",
								   preferences.getForeground());
		if (col != null) {
			preferences.setForeground(col);
			jPanelTextColor.setBackground(col);
		}

	}

	void jButtonBackgroundColor_actionPerformed(ActionEvent e) {
		Color col = JColorChooser.showDialog( this, "Background Color",
								   preferences.getBackground());
		if (col != null) {
			preferences.setBackground(col);
			jPanelBackgroundColor.setBackground(col);
		}

	}

	void jButtonBrowseText_actionPerformed(ActionEvent e) {
		 jFileChooser.setDialogTitle("Directory to start looking for text files");
		 if (JFileChooser.APPROVE_OPTION == jFileChooser.showDialog(this, "Select")) {
			preferences.setTextFileStart(jFileChooser.getCurrentDirectory());
			jTextFieldTextDir.setText(jFileChooser.getCurrentDirectory().getPath());
		 }
	}

	void jButtonBrowseDoc_actionPerformed(ActionEvent e) {
		 jFileChooser.setDialogTitle("Directory to start looking for DOC files");
		 if (JFileChooser.APPROVE_OPTION == jFileChooser.showDialog(this, "Select")) {
			preferences.setDocFileStart(jFileChooser.getCurrentDirectory());
			jTextFieldDocDir.setText(jFileChooser.getCurrentDirectory().getPath());
		 }
	}

	void jButtonCancel_actionPerformed(ActionEvent e) {
		 this.hide();
	}

	void jButtonOk_actionPerformed(ActionEvent e) {
		 preferences.setFontSize(
							Integer.parseInt(jTextFieldFontSize.getText()));
		 preferences.setTabSize(Integer.parseInt(jTextFieldTabSize.getText()));
		 okay = true;
		 this.hide();
	}

}