/*
 * MakeDocJrEditorFrame.java
 *
 * Copyright 2002 Steve Held,
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package makedocjr.editor;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.io.*;
import javax.swing.text.*;
import java.util.*;
import java.util.zip.*;
import java.text.*;
import javax.swing.border.*;
import javax.swing.undo.*;
import makedocjr.*;
import net.onza.op.upswing.utilityfields.*;
import net.onza.op.upswing.textdrag.JDraggableTextArea;
import gnu.regexp.*;
import java.net.*;

public class MakeDocJrEditorFrame extends JFrame {

	private static final int NUMBER_OF_FILES = 5; // number of files to display to reopen
	private static final int NUMBER_OF_SEARCHES = 5; // number of find/replace searches to archive
	private static final String PROPERTY_FILE = "makedocjr.properties";
	private static final byte REFRESHED_TEXT = 0;
	private static final byte REFRESHED_DOC = 1;
	static final String ENCODE_OPTIONS = "eoptions.ser";

	JPanel contentPane;
	JMenuBar jMenuBar = new JMenuBar();
	JMenu jMenuFile = new JMenu();
	JMenuItem jMenuFileExit = new JMenuItem();
	JMenu jMenuHelp = new JMenu();
	JMenuItem jMenuHelpAbout = new JMenuItem();
	JToolBar jToolBar = new JToolBar();
	JButton newButton = new JButton();
	JButton saveButton = new JButton();
	JButton helpButton = new JButton();
	ImageIcon newImage;
	ImageIcon saveImage;
	ImageIcon helpImage;
	ImageIcon openImage;
	ImageIcon decodeImage;
	ImageIcon encodeImage;
	ImageIcon cutImage;
	ImageIcon copyImage;
	ImageIcon pasteImage;
	ImageIcon blankImage;
	ImageIcon bookmarkImage;
	ImageIcon webImage;
	ImageIcon undoImage;
	BorderLayout borderLayout1 = new BorderLayout();
	JScrollPane jScrollPane = new JScrollPane();
	JDraggableTextArea jTextArea = new JDraggableTextArea();
	JMenuItem jMenuNew = new JMenuItem();
	JMenuItem jMenuOpen = new JMenuItem();
	JMenuItem jMenuSave = new JMenuItem();
	JMenuItem jMenuSaveAs = new JMenuItem();
	JMenuItem jMenuImport = new JMenuItem();
	JMenuItem jMenuExport = new JMenuItem();
	JMenu jMenuEdit = new JMenu();
	JMenuItem jMenuCut = new JMenuItem();
	JMenuItem jMenuCopy = new JMenuItem();
	JMenuItem jMenuPaste = new JMenuItem();
	JMenuItem jMenuSelectAll = new JMenuItem();
	JMenu jMenuOptions = new JMenu();
	JButton openButton = new JButton();
	JButton decodeButton = new JButton();
	JButton encodeButton = new JButton();
	Component component2;
	Component component1;
	Component component3;
	JButton cutButton = new JButton();
	JButton copyButton = new JButton();
	JButton pasteButton = new JButton();
	Component component4;
	Component component5;
	JPopupMenu jPopupMenu = new JPopupMenu();
	JMenuItem jPopCut = new JMenuItem();
	JMenuItem jPopCopy = new JMenuItem();
	JMenuItem jPopPaste = new JMenuItem();
	JMenuItem jPopSelectAll = new JMenuItem();
	String lastPath = File.separator; // Last pull path without filename
	String currFileName = null;  // Full path with filename. null means new / untitled.
	String currDocName = null;
	String proposedDocName = null;
	String proposedFileName = null;
	boolean dirty = false;  // True means modified text.
	JFileChooser jFileChooser;
	Document document;
	MakeDocJr makeDoc;
	JMenuItem jMenuExportAs = new JMenuItem();
	JButton bookmarkButton = new JButton();
	Component component6;
	JMenu jMenuBookmark = new JMenu();
	JMenuItem jMenuBookmarkAdd = new JMenuItem();
	JMenuItem jMenuBookmarkEdit = new JMenuItem();
	JMenuItem jMenuBookmarkAuto = new JMenuItem();
	JMenuItem jMenuPreferences = new JMenuItem();
	JButton webButton = new JButton();
	Component component7;
	JMenuItem jMenuExportOptions = new JMenuItem();
	JCheckBoxMenuItem jMenuWrap = new JCheckBoxMenuItem();
	Preferences preferences;
	DocFileFilter docFileFilter = new DocFileFilter();
	JMenuItem jMenuUndo = new JMenuItem();
	JMenuItem jMenuRedo = new JMenuItem();
	UndoManager undoManager = new UndoManager();
	JMenu jMenuReopen = new JMenu();
	JMenu jMenuReimport = new JMenu();
	JMenuItem jMenuSubDoc;
	JMenuItem jMenuSubText;
	Vector textpaths = new Vector();
	Vector docpaths = new Vector();
	JPanel jPanelStatus = new JPanel();
	JLabel statusBar = new JLabel();
	GridBagLayout gridBagLayout1 = new GridBagLayout();
	JLabel colStatus = new JLabel();
	JLabel rowStatus = new JLabel();
	JMenu jMenuTools = new JMenu();
	JMenuItem jMenuWordCount = new JMenuItem();
	JMenuItem jMenuWeb = new JMenuItem();
	JButton undoButton = new JButton();
	String searchText;
	String replacementText;
	boolean ignoreCase;
	boolean searchFromTop;
	boolean searchSelectedTextOnly;
	boolean newSearch;
	int selectionStart;
	int selectionEnd;
	byte buttonPressed;
	RE re;
	REMatch rem;
	JMenuItem jMenuFindReplace = new JMenuItem();
	JMenuItem jMenuFindAgain = new JMenuItem();
	ConfirmReplaceDialog crd;
	JMenuItem jMenuHelpHelp = new JMenuItem();
	FindReplaceDialog frd = new FindReplaceDialog(this, true);

	/**Construct the frame*/
	public MakeDocJrEditorFrame(String fileName) {
		enableEvents(AWTEvent.WINDOW_EVENT_MASK);
		try {
			FileInputStream fis = new FileInputStream(Preferences.PREFS);
			ObjectInputStream ois = new ObjectInputStream(fis);
			preferences = (Preferences)ois.readObject();
			ois.close();
			fis.close();
		} catch (Exception e) {
			preferences = new Preferences();
		}
		try {
			jbInit();
		}
		catch(Exception e) {
			e.printStackTrace();
		}
		if (!fileName.equals("")) {
			if (fileName.length() > 4 &&
					( fileName.toLowerCase().endsWith(".pdb") ||
					  fileName.toLowerCase().endsWith(".prc") ))
				decode(new File(fileName));
			else
				openFile(fileName);
		}
	}

	/**Component initialization*/
	private boolean jbInit() throws Exception  {
		newImage = new ImageIcon(makedocjr.editor.MakeDocJrEditorFrame.class.getResource("new.gif"));
		saveImage = new ImageIcon(makedocjr.editor.MakeDocJrEditorFrame.class.getResource("save.gif"));
		helpImage = new ImageIcon(makedocjr.editor.MakeDocJrEditorFrame.class.getResource("help.gif"));
		openImage = new ImageIcon(makedocjr.editor.MakeDocJrEditorFrame.class.getResource("open.gif"));
		decodeImage = new ImageIcon(makedocjr.editor.MakeDocJrEditorFrame.class.getResource("pdatopc.gif"));
		encodeImage = new ImageIcon(makedocjr.editor.MakeDocJrEditorFrame.class.getResource("pctopda.gif"));
		cutImage = new ImageIcon(makedocjr.editor.MakeDocJrEditorFrame.class.getResource("cut.gif"));
		copyImage = new ImageIcon(makedocjr.editor.MakeDocJrEditorFrame.class.getResource("copy.gif"));
		pasteImage = new ImageIcon(makedocjr.editor.MakeDocJrEditorFrame.class.getResource("paste.gif"));
		blankImage = new ImageIcon(makedocjr.editor.MakeDocJrEditorFrame.class.getResource("blank.gif"));
		bookmarkImage = new ImageIcon(makedocjr.editor.MakeDocJrEditorFrame.class.getResource("bookmark.gif"));
		webImage = new ImageIcon(makedocjr.editor.MakeDocJrEditorFrame.class.getResource("web.gif"));
		undoImage = new ImageIcon(makedocjr.editor.MakeDocJrEditorFrame.class.getResource("undo.gif"));
		contentPane = (JPanel) this.getContentPane();
		component2 = Box.createVerticalStrut(8);
		component1 = Box.createHorizontalStrut(8);
		component3 = Box.createHorizontalStrut(8);
		component4 = Box.createHorizontalStrut(8);
		component5 = Box.createHorizontalStrut(8);
		document = jTextArea.getDocument();
		component6 = Box.createHorizontalStrut(8);
		component7 = Box.createHorizontalStrut(8);
		contentPane.setLayout(borderLayout1);
		this.setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
		this.setSize(new Dimension(400, 300));
		this.setTitle("MakeDocJr Editor");
		this.addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowOpened(WindowEvent e) {
				this_windowOpened(e);
			}
		});
		jMenuFile.setText("File");
		jMenuFileExit.setIcon(blankImage);
		jMenuFileExit.setText("Exit");
		jMenuFileExit.addActionListener(new ActionListener()  {
			public void actionPerformed(ActionEvent e) {
				jMenuFileExit_actionPerformed(e);
			}
		});
		jMenuHelp.setText("Help");
		jMenuHelpAbout.setText("About");
		jMenuHelpAbout.addActionListener(new ActionListener()  {
			public void actionPerformed(ActionEvent e) {
				jMenuHelpAbout_actionPerformed(e);
			}
		});
		newButton.setIcon(newImage);
		newButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				newButton_actionPerformed(e);
			}
		});
		newButton.setMaximumSize(new Dimension(51, 27));
		newButton.setMinimumSize(new Dimension(27, 27));
		newButton.setPreferredSize(new Dimension(32, 27));
		newButton.setToolTipText("New");
		saveButton.setIcon(saveImage);
		saveButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				saveButton_actionPerformed(e);
			}
		});
		saveButton.setMinimumSize(new Dimension(27, 27));
		saveButton.setPreferredSize(new Dimension(32, 27));
		saveButton.setToolTipText("Save");
		helpButton.setMinimumSize(new Dimension(27, 27));
		helpButton.setPreferredSize(new Dimension(32, 27));
		helpButton.setToolTipText("About");
		helpButton.setIcon(helpImage);
		helpButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				helpButton_actionPerformed(e);
			}
		});
		jTextArea.setBorder(new EmptyBorder(1, 4, 2, 4));
		jTextArea.setLineWrap(true);
		jTextArea.setWrapStyleWord(true);
		jTextArea.addCaretListener(new javax.swing.event.CaretListener() {
			public void caretUpdate(CaretEvent e) {
				jTextArea_caretUpdate(e);
			}
		});
		jTextArea.addMouseListener(new java.awt.event.MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				jTextArea_mousePressed(e);
			}
			public void mouseReleased(MouseEvent e) {
				jTextArea_mouseReleased(e);
			}
		});
		jMenuNew.setIcon(newImage);
		jMenuNew.setText("New");
		jMenuNew.setAccelerator(javax.swing.KeyStroke.getKeyStroke(78, java.awt.event.KeyEvent.CTRL_MASK, false));
		jMenuNew.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jMenuNew_actionPerformed(e);
			}
		});
		jMenuOpen.setIcon(openImage);
		jMenuOpen.setText("Open");
		jMenuOpen.setAccelerator(javax.swing.KeyStroke.getKeyStroke(79, java.awt.event.KeyEvent.CTRL_MASK, false));
		jMenuOpen.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jMenuOpen_actionPerformed(e);
			}
		});
		jMenuSave.setIcon(saveImage);
		jMenuSave.setText("Save");
		jMenuSave.setAccelerator(javax.swing.KeyStroke.getKeyStroke(83, java.awt.event.KeyEvent.CTRL_MASK, false));
		jMenuSave.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jMenuSave_actionPerformed(e);
			}
		});
		jMenuSaveAs.setIcon(blankImage);
		jMenuSaveAs.setText("Save As...");
		jMenuSaveAs.setAccelerator(javax.swing.KeyStroke.getKeyStroke(83, java.awt.event.KeyEvent.CTRL_MASK | java.awt.event.KeyEvent.SHIFT_MASK, false));
		jMenuSaveAs.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jMenuSaveAs_actionPerformed(e);
			}
		});
		jMenuImport.setIcon(decodeImage);
		jMenuImport.setText("Import");
		jMenuImport.setAccelerator(javax.swing.KeyStroke.getKeyStroke(68, java.awt.event.KeyEvent.CTRL_MASK, false));
		jMenuImport.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jMenuImport_actionPerformed(e);
			}
		});
		jMenuExport.setIcon(encodeImage);
		jMenuExport.setText("Export");
		jMenuExport.setAccelerator(javax.swing.KeyStroke.getKeyStroke(69, java.awt.event.KeyEvent.CTRL_MASK, false));
		jMenuExport.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jMenuExport_actionPerformed(e);
			}
		});
		jMenuEdit.setText("Edit");
		jMenuCut.setIcon(cutImage);
		jMenuCut.setText("Cut");
		jMenuCut.setAccelerator(javax.swing.KeyStroke.getKeyStroke(88, java.awt.event.KeyEvent.CTRL_MASK, false));
		jMenuCut.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jMenuCut_actionPerformed(e);
			}
		});
		jMenuCopy.setIcon(copyImage);
		jMenuCopy.setText("Copy");
		jMenuCopy.setAccelerator(javax.swing.KeyStroke.getKeyStroke(67, java.awt.event.KeyEvent.CTRL_MASK, false));
		jMenuCopy.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jMenuCopy_actionPerformed(e);
			}
		});
		jMenuPaste.setIcon(pasteImage);
		jMenuPaste.setText("Paste");
		jMenuPaste.setAccelerator(javax.swing.KeyStroke.getKeyStroke(86, java.awt.event.KeyEvent.CTRL_MASK, false));
		jMenuPaste.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jMenuPaste_actionPerformed(e);
			}
		});
		jMenuSelectAll.setIcon(blankImage);
		jMenuSelectAll.setText("Select All");
		jMenuSelectAll.setAccelerator(javax.swing.KeyStroke.getKeyStroke(65, java.awt.event.KeyEvent.CTRL_MASK, false));
		jMenuSelectAll.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jMenuSelectAll_actionPerformed(e);
			}
		});
		jMenuOptions.setText("Options");
		openButton.setMinimumSize(new Dimension(27, 27));
		openButton.setPreferredSize(new Dimension(32, 27));
		openButton.setToolTipText("Open");
		openButton.setIcon(openImage);
		openButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				openButton_actionPerformed(e);
			}
		});
		decodeButton.setMinimumSize(new Dimension(27, 27));
		decodeButton.setPreferredSize(new Dimension(32, 27));
		decodeButton.setToolTipText("Import");
		decodeButton.setIcon(decodeImage);
		decodeButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				decodeButton_actionPerformed(e);
			}
		});
		encodeButton.setMinimumSize(new Dimension(27, 27));
		encodeButton.setPreferredSize(new Dimension(32, 27));
		encodeButton.setToolTipText("Export");
		encodeButton.setIcon(encodeImage);
		encodeButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				encodeButton_actionPerformed(e);
			}
		});
		jScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		pasteButton.setMaximumSize(new Dimension(51, 27));
		pasteButton.setMinimumSize(new Dimension(27, 27));
		pasteButton.setPreferredSize(new Dimension(32, 27));
		pasteButton.setToolTipText("Paste");
		pasteButton.setIcon(pasteImage);
		pasteButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				pasteButton_actionPerformed(e);
			}
		});
		copyButton.setMaximumSize(new Dimension(51, 27));
		copyButton.setMinimumSize(new Dimension(27, 27));
		copyButton.setPreferredSize(new Dimension(32, 27));
		copyButton.setToolTipText("Copy");
		copyButton.setIcon(copyImage);
		copyButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				copyButton_actionPerformed(e);
			}
		});
		copyButton.setEnabled(false);
		cutButton.setMaximumSize(new Dimension(51, 27));
		cutButton.setMinimumSize(new Dimension(27, 27));
		cutButton.setPreferredSize(new Dimension(32, 27));
		cutButton.setToolTipText("Cut");
		cutButton.setIcon(cutImage);
		cutButton.setMnemonic('0');
		cutButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				cutButton_actionPerformed(e);
			}
		});
		cutButton.setEnabled(false);
		jPopCut.setIcon(cutImage);
		jPopCut.setText("Cut");
		jPopCut.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jPopCut_actionPerformed(e);
			}
		});
		jPopCopy.setIcon(copyImage);
		jPopCopy.setText("Copy");
		jPopCopy.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jPopCopy_actionPerformed(e);
			}
		});
		jPopPaste.setIcon(pasteImage);
		jPopPaste.setText("Paste");
		jPopPaste.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jPopPaste_actionPerformed(e);
			}
		});
		jPopSelectAll.setIcon(blankImage);
		jPopSelectAll.setText("Select All");
		jPopSelectAll.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jPopSelectAll_actionPerformed(e);
			}
		});
		document.addDocumentListener(new javax.swing.event.DocumentListener() {
			public void insertUpdate(DocumentEvent e) {
				document_insertUpdate(e);
			}
			public void removeUpdate(DocumentEvent e) {
				document_removeUpdate(e);
			}
			public void changedUpdate(DocumentEvent e) {
				document_changedUpdate(e);
			}
		});
		jMenuExportAs.setIcon(blankImage);
		jMenuExportAs.setText("Export As...");
		jMenuExportAs.setAccelerator(javax.swing.KeyStroke.getKeyStroke(69, java.awt.event.KeyEvent.CTRL_MASK | java.awt.event.KeyEvent.SHIFT_MASK, false));
		jMenuExportAs.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jMenuExportAs_actionPerformed(e);
			}
		});
		bookmarkButton.setEnabled(false);
		bookmarkButton.setMaximumSize(new Dimension(51, 27));
		bookmarkButton.setMinimumSize(new Dimension(27, 27));
		bookmarkButton.setPreferredSize(new Dimension(32, 27));
		bookmarkButton.setToolTipText("Add or edit bookmarks");
		bookmarkButton.setIcon(bookmarkImage);
		bookmarkButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				bookmarkButton_actionPerformed(e);
			}
		});
		jMenuBookmark.setText("Bookmarks");
		jMenuBookmarkAdd.setEnabled(false);
		jMenuBookmarkAdd.setText("Add");
		jMenuBookmarkAdd.setAccelerator(javax.swing.KeyStroke.getKeyStroke(66, java.awt.event.KeyEvent.CTRL_MASK, false));
		jMenuBookmarkAdd.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jMenuBookmarkAdd_actionPerformed(e);
			}
		});
		jMenuBookmarkEdit.setEnabled(false);
		jMenuBookmarkEdit.setText("Edit");
		jMenuBookmarkEdit.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jMenuBookmarkEdit_actionPerformed(e);
			}
		});
		jMenuBookmarkAuto.setEnabled(false);
		jMenuBookmarkAuto.setText("Auto Create");
		jMenuBookmarkAuto.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jMenuBookmarkAuto_actionPerformed(e);
			}
		});
		jMenuPreferences.setText("Preferences");
		jMenuPreferences.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jMenuPreferences_actionPerformed(e);
			}
		});
		contentPane.setBorder(BorderFactory.createEtchedBorder());
		webButton.setEnabled(false);
		webButton.setMaximumSize(new Dimension(51, 27));
		webButton.setMinimumSize(new Dimension(27, 27));
		webButton.setPreferredSize(new Dimension(32, 27));
		webButton.setToolTipText("Remove web effects");
		webButton.setIcon(webImage);
		webButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				webButton_actionPerformed(e);
			}
		});
		jMenuExportOptions.setText("Export Options");
		jMenuExportOptions.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jMenuExportOptions_actionPerformed(e);
			}
		});
		jMenuWrap.setSelected(true);
		jMenuWrap.setText("Wrap Lines");
		jMenuWrap.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jMenuWrap_actionPerformed(e);
			}
		});
		jMenuUndo.setEnabled(false);
		jMenuUndo.setIcon(undoImage);
		jMenuUndo.setText("Undo");
		jMenuUndo.setAccelerator(javax.swing.KeyStroke.getKeyStroke(90, java.awt.event.KeyEvent.CTRL_MASK, false));
		jMenuUndo.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jMenuUndo_actionPerformed(e);
			}
		});
		jMenuRedo.setEnabled(false);
		jMenuRedo.setIcon(blankImage);
		jMenuRedo.setText("Redo");
		jMenuRedo.setAccelerator(javax.swing.KeyStroke.getKeyStroke(89, java.awt.event.KeyEvent.CTRL_MASK, false));
		jMenuRedo.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jMenuRedo_actionPerformed(e);
			}
		});
		document.addUndoableEditListener(undoManager);
		document.addUndoableEditListener(new javax.swing.event.UndoableEditListener() {
			public void undoableEditHappened(UndoableEditEvent e) {
				document_undoableEditHappened(e);
			}
		});
		jMenuReopen.setIcon(blankImage);
		jMenuReopen.setText("Reopen");
		jMenuReimport.setIcon(blankImage);
		jMenuReimport.setText("Reimport");
		statusBar.setBorder(BorderFactory.createLoweredBevelBorder());
		statusBar.setText(" MakeDocJr Editor ");
		jPanelStatus.setLayout(gridBagLayout1);
		jPanelStatus.setPreferredSize(new Dimension(388, 19));
		colStatus.setBorder(BorderFactory.createLoweredBevelBorder());
		colStatus.setMinimumSize(new Dimension(60, 21));
		colStatus.setText(" col: 1 ");
		rowStatus.setBorder(BorderFactory.createLoweredBevelBorder());
		rowStatus.setMinimumSize(new Dimension(70, 21));
		rowStatus.setRequestFocusEnabled(false);
		rowStatus.setText(" line: 1 ");
		jMenuTools.setText("Tools");
		jMenuWordCount.setEnabled(false);
		jMenuWordCount.setIcon(blankImage);
		jMenuWordCount.setText("Word Count");
		jMenuWordCount.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jMenuWordCount_actionPerformed(e);
			}
		});
		jMenuWeb.setEnabled(false);
		jMenuWeb.setIcon(webImage);
		jMenuWeb.setText("Remove Web Effects");
		jMenuWeb.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jMenuWeb_actionPerformed(e);
			}
		});
		undoButton.setEnabled(false);
		undoButton.setMaximumSize(new Dimension(51, 27));
		undoButton.setMinimumSize(new Dimension(27, 27));
		undoButton.setPreferredSize(new Dimension(32, 27));
		undoButton.setToolTipText("Undo");
		undoButton.setIcon(undoImage);
		undoButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				undoButton_actionPerformed(e);
			}
		});
		jMenuFindReplace.setText("Find/Replace");
		jMenuFindReplace.setAccelerator(javax.swing.KeyStroke.getKeyStroke(70, java.awt.event.KeyEvent.CTRL_MASK, false));
		jMenuFindReplace.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jMenuFindReplace_actionPerformed(e);
			}
		});
		jMenuFindAgain.setText("Find Again");
		jMenuFindAgain.setAccelerator(javax.swing.KeyStroke.getKeyStroke(114, 0, false));
		jMenuFindAgain.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jMenuFindAgain_actionPerformed(e);
			}
		});
		jMenuHelpHelp.setText("Help");
		jMenuHelpHelp.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jMenuHelpHelp_actionPerformed(e);
			}
		});
		jToolBar.add(newButton);
		jToolBar.add(openButton, null);
		jToolBar.add(saveButton);
		jToolBar.add(component1, null);
		jMenuFile.add(jMenuNew);
		jMenuFile.add(jMenuOpen);
		jMenuFile.add(jMenuReopen);
		jMenuFile.addSeparator();
		jMenuFile.add(jMenuSave);
		jMenuFile.add(jMenuSaveAs);
		jMenuFile.addSeparator();
		jMenuFile.add(jMenuImport);
		jMenuFile.add(jMenuReimport);
		jMenuFile.addSeparator();
		jMenuFile.add(jMenuExport);
		jMenuFile.add(jMenuExportAs);
		jMenuFile.addSeparator();
		jMenuFile.add(jMenuFileExit);
		jMenuHelp.add(jMenuHelpHelp);
		jMenuHelp.add(jMenuHelpAbout);
		jMenuBar.add(jMenuFile);
		jMenuBar.add(jMenuEdit);
		jMenuBar.add(jMenuBookmark);
		jMenuBar.add(jMenuTools);
		jMenuBar.add(jMenuOptions);
		jMenuBar.add(jMenuHelp);
		this.setJMenuBar(jMenuBar);
		contentPane.add(jToolBar, BorderLayout.NORTH);
		contentPane.add(jScrollPane, BorderLayout.CENTER);
		contentPane.add(jPanelStatus, BorderLayout.SOUTH);
		jPanelStatus.add(statusBar,          new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0
			,GridBagConstraints.EAST, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		jPanelStatus.add(colStatus,            new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
			,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		jPanelStatus.add(rowStatus,             new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
			,GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 5, 0));
		jScrollPane.getViewport().add(jTextArea, null);
		jMenuEdit.add(jMenuUndo);
		jMenuEdit.add(jMenuRedo);
		jMenuEdit.addSeparator();
		jMenuEdit.add(jMenuCut);
		jMenuEdit.add(jMenuCopy);
		jMenuEdit.add(jMenuPaste);
		jMenuEdit.add(jMenuSelectAll);
		jMenuEdit.addSeparator();
		jMenuEdit.add(jMenuFindReplace);
		jMenuEdit.add(jMenuFindAgain);
		jMenuOptions.add(jMenuWrap);
		jMenuOptions.addSeparator();
		jMenuOptions.add(jMenuExportOptions);
		jMenuOptions.add(jMenuPreferences);
		jToolBar.add(decodeButton, null);
		jToolBar.add(encodeButton, null);
		jToolBar.add(component3, null);
		jToolBar.add(undoButton, null);
		jToolBar.add(cutButton, null);
		jToolBar.add(copyButton, null);
		jToolBar.add(pasteButton, null);
		jToolBar.add(component5, null);
		jToolBar.add(bookmarkButton, null);
		jToolBar.add(component6, null);
		jToolBar.add(webButton, null);
		jToolBar.add(component7, null);
		jToolBar.add(helpButton);
		jToolBar.add(component4, null);
		jToolBar.add(component2, null);
		jPopupMenu.add(jPopCut);
		jPopupMenu.add(jPopCopy);
		jPopupMenu.add(jPopPaste);
		jPopupMenu.add(jPopSelectAll);
		jMenuBookmark.add(jMenuBookmarkAdd);
		jMenuBookmark.add(jMenuBookmarkEdit);
		jMenuBookmark.addSeparator();
		jMenuBookmark.add(jMenuBookmarkAuto);
		jMenuTools.add(jMenuWeb);
		jMenuTools.add(jMenuWordCount);
		jMenuCopy.setEnabled(false);
		jMenuCut.setEnabled(false);
		jPopCopy.setEnabled(false);
		jPopCut.setEnabled(false);
		docNotEmpty(false);
		jFileChooser = new JFileChooser(System.getProperty("user.dir"));
		jTextArea.setText("");
		makeDoc = new MakeDocJr();
		jTextArea.getCaret().setBlinkRate(500);
		setPreferences(false);
		readProperties();
		configureMenu();
		FileInputStream fis = null;
		ObjectInputStream ois = null;
		try {
			fis = new FileInputStream( MakeDocJrEditorFrame.ENCODE_OPTIONS );
			ois = new ObjectInputStream(fis);
			makeDoc.setEncodeOptions((EncodeOptions)ois.readObject());
		} catch (Exception e) {
			makeDoc.setEncodeOptions(new EncodeOptions());
		} finally {
			if (ois != null) ois.close();
			if (fis != null) fis.close();
		}
		return true;
	}

	void newFile() {
		if (okToAbandon()) {
			jTextArea.setText("");
			// clear the current filename and set the file as clean:
			currFileName = null;
			currDocName = null;
			dirty = false;
			statusBar.setText(" MakeDocJr Editor ");
			docNotEmpty(false);
			makeDoc = new MakeDocJr();
			jTextArea.requestFocus();
		}
	}

	void openFile() {
		if (!okToAbandon()) {
			return;
		}
		jFileChooser.setDialogTitle(null);
		jFileChooser.setAcceptAllFileFilterUsed(true);
		if (currFileName == null)
		   jFileChooser.setCurrentDirectory(preferences.getTextFileStart());
		// Use the OPEN version of the dialog, test return for Approve/Cancel
		if (JFileChooser.APPROVE_OPTION == jFileChooser.showOpenDialog(this)) {

			// Call openFile to attempt to load the text from file into JTextArea
			openFile(jFileChooser.getSelectedFile().getPath());
		}
			//repaints menu after item is selected
		this.repaint();
		jTextArea.requestFocus();
	}

	// Open named file; read text from file into jTextArea1; report to statusBar.
	void openFile(String fileName) {
		try {
			// Open a file of the given name.
			File file = new File(fileName);

			// Get the size of the opened file.
			int size = (int)file.length();

			// Set to zero a counter for counting the number of
			// characters that have been read from the file.
			int chars_read = 0;

			// Create an input reader based on the file, so we can read its data.
			// FileReader handles international character encoding conversions.
			FileReader in = new FileReader(file);

			// Create a character array of the size of the file,
			// to use as a data buffer, into which we will read
			// the text data.
			char[] data = new char[size];

			// Read all available characters into the buffer.
			while(in.ready()) {

				// Increment the count for each character read,
				// and accumulate them in the data buffer.
				chars_read += in.read(data, chars_read, size - chars_read);
			}
			in.close();

			// Create a temporary string containing the data,
			// and set the string into the JTextArea.
			setText(data);
			// Cache the currently opened filename for use at save time...
			currFileName = fileName;
			currDocName = null;
			// ...and mark the edit session as being clean
			dirty = false;
			makeDoc = new MakeDocJr();
			configureButtons(MakeDocJrEditorFrame.REFRESHED_TEXT);
			jTextArea.setCaretPosition(0);
			// Display the name of the opened directory+file in the statusBar.
			statusBar.setText(" Opened " + fileName + " ");
			addTextPath(currFileName);
			configureMenu();
		} catch (IOException e) {
			statusBar.setText(" Error opening " + fileName + " ");
		}
	}

	void decode() {
		if (!okToAbandon()) {
			return;
		}
		jFileChooser.setDialogTitle("Decode");
		jFileChooser.setFileFilter(docFileFilter);
		if (currDocName == null)
		   jFileChooser.setCurrentDirectory(preferences.getDocFileStart());
		// Use the OPEN version of the dialog, test return for Approve/Cancel
		if (JFileChooser.APPROVE_OPTION == jFileChooser.showOpenDialog(this)) {
			decode(jFileChooser.getSelectedFile());
		}
			//repaints menu after item is selected
		this.repaint();
		jTextArea.requestFocus();
	}

	void decode(File source) {
		if (!source.exists()) {
			statusBar.setText(" Error opening " + source.getPath() + " ");
			return;
		}
		makeDoc = new MakeDocJr();
		try {
			makeDoc.decode(source);
		} catch (DataFormatException dfe) {
			repaint();
			JOptionPane.showMessageDialog(null,
						"Could not decode " + source.getName(),
						"Error", JOptionPane.ERROR_MESSAGE);
			return;
		} catch (FileNotFoundException fnfe) { // found by JFileChooser
		} catch (IOException ioe) {
			statusBar.setText(" Error opening " + source.getPath() + " ");
		}
		setText(makeDoc.getText());
		currDocName = source.getAbsolutePath();
		currFileName = null;
		dirty = false;
		setBookmarkPositions();
		configureButtons(MakeDocJrEditorFrame.REFRESHED_DOC);
		jTextArea.setCaretPosition(0);
		statusBar.setText(" Decoded " + source.getPath() + " ");
		addDocPath(currDocName);
		configureMenu();
	}

	// Save current file; handle not yet having a filename; report to statusBar.
	boolean saveFile() {

		// Handle the case where we don't have a file name yet.
		if (currFileName == null) {
			return saveAsFile();
		}

		try {
			// Open a file of the current name.
			File file = new File (currFileName);

			// Create an output writer that will write to that file.
			// FileWriter handles international characters encoding conversions.
			FileWriter out = new FileWriter(file);
			out.write(this.getText());
			out.close();
			dirty = false;

			// Display the name of the saved directory+file in the statusBar.
			statusBar.setText(" Saved to " + currFileName + " ");
			addTextPath(currFileName);
			configureMenu();
			configureButtons(MakeDocJrEditorFrame.REFRESHED_TEXT);
			jTextArea.requestFocus();
			return true;
		} catch (IOException e) {
			statusBar.setText(" Error saving " + currFileName + " ");
		}
		jTextArea.requestFocus();
		return false;
	}

	// Save current file, asking user for new destination name.
	// Report to statuBar.
	boolean saveAsFile() {
		jFileChooser.setDialogTitle(null);
		jFileChooser.setAcceptAllFileFilterUsed(true);
		if (currFileName == null)
			jFileChooser.setCurrentDirectory(preferences.getTextFileStart());
		// Use the SAVE version of the dialog, test return for Approve/Cancel
		if (JFileChooser.APPROVE_OPTION == jFileChooser.showSaveDialog(this)) {
			// Set the current file name to the user's selection,
			// then do a regular saveFile
			File file = jFileChooser.getSelectedFile();
			try {
				if (!file.createNewFile()) {
					this.repaint();
					if (JOptionPane.NO_OPTION == JOptionPane.showConfirmDialog(this,
							"File " + file.getPath() + " already exists. \n" +
							"Would you like to overwrite it with your new text?",
							"Warning",
							JOptionPane.YES_NO_OPTION,
							JOptionPane.WARNING_MESSAGE)) {
						this.repaint();
						return false;
					}
				}
			} catch (IOException ioe) {
				statusBar.setText(" I/O Error saving " + file.getPath() + " ");
				this.repaint();
				jTextArea.requestFocus();
				return false;
			}
			currFileName = file.getPath();
			//repaints menu after item is selected
			this.repaint();
			jTextArea.requestFocus();
			return saveFile();
		}
		else {
			this.repaint();
			jTextArea.requestFocus();
			return false;
		}
	}

	void encodeFile() {
		if (jTextArea.getText() == "")
			return;
		if (currDocName == null || makeDoc.getTitle() == null)
			encodeAsFile();
		else {
			File file = new File(currDocName);
			encode(file);
		}
	}

	void encodeAsFile() {
		String text = jTextArea.getText();
		if (text == "")
			return;
		jFileChooser.setFileFilter(docFileFilter);
		jFileChooser.setDialogTitle("Encode");
		if (currDocName == null)
			jFileChooser.setCurrentDirectory(preferences.getDocFileStart());
		// set title automatically
		if (makeDoc.getTitle() == null) {
			int documentLength = document.getLength();
			byte titleLength = 0;
			if (documentLength < EncodeDialog.MAX_TITLE_LENGTH)
				titleLength = (byte) documentLength;
			else
				titleLength = EncodeDialog.MAX_TITLE_LENGTH;
			int firstLineBreak = text.indexOf(0x0a);
			if ((firstLineBreak < titleLength) && (firstLineBreak > 0))
				titleLength = (byte) firstLineBreak;
			makeDoc.setTitle(text.substring(0, titleLength));
		}
		EncodeDialog ed = new EncodeDialog(this, true, makeDoc, jFileChooser);
		ed.pack();
		Dimension dlgSize = ed.getSize();
		Dimension frmSize = getSize();
		Point loc = getLocation();
		ed.setLocation((frmSize.width - dlgSize.width) / 2 +
						loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
		ed.setVisible(true);
		if (ed.isOkay()) {
			makeDoc.setTitle(ed.getDocTitle());
			proposedDocName = ed.getFileName();
			File file = new File(proposedDocName);
			try {
				if (!file.createNewFile()) {
					this.repaint();
					if (JOptionPane.NO_OPTION == JOptionPane.showConfirmDialog(this,
							"File " + file.getPath() + " already exists. \n" +
							"Would you like to overwrite it with your new text?",
							"Warning",
							JOptionPane.YES_NO_OPTION,
							JOptionPane.WARNING_MESSAGE)) {
						this.repaint();
						proposedDocName = null;
						ed.dispose();
						return;
					}
				}
			} catch (IOException ioe) {
				statusBar.setText(" I/O Error encoding " + file.getPath() + " ");
				this.repaint();
				proposedDocName = null;
				encodeButton.setEnabled(false);
				jMenuExport.setEnabled(false);
				jTextArea.requestFocus();
				ed.dispose();
				return;
			}
			encode(file);
		}
		ed.dispose();
	}

	private void encode(File file) {
		makeDoc.setText(jTextArea.getText());
		try {
			makeDoc.encode(file);
			dirty = false;
			currDocName = file.getPath();
			statusBar.setText(" Exported as " + currDocName + " ");
			addDocPath(currDocName);
			configureMenu();
			configureButtons(MakeDocJrEditorFrame.REFRESHED_DOC);
		} catch (Exception e) {
			statusBar.setText(" Error exporting " + currDocName + " ");
			currDocName = null;
		}
		jTextArea.requestFocus();
	}

	void help() {
		String s = null;
		URL helpURL = null;
		JEditorPane regexHelpPane = null;
		try {
			s = "file:"
				+ System.getProperty("user.dir")
				+ System.getProperty("file.separator")
				+ "help.html";
			helpURL = new URL(s);
			regexHelpPane = new JEditorPane(helpURL);
			regexHelpPane.setEditable(false);
			JScrollPane editorScrollPane = new JScrollPane(regexHelpPane);
			editorScrollPane.setVerticalScrollBarPolicy(
					JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
			JDialog jd = new JDialog(this, "MakeDocJr Editor Help", false);
			jd.getContentPane().add(editorScrollPane);
			jd.setSize(new Dimension(450, 400));
			jd.setVisible(true);
		}
		catch (Exception ex) { // malformed url or io
			JOptionPane.showMessageDialog(this,
						"Could not find the file \"help.html\"",
						"Missing help file.", JOptionPane.ERROR_MESSAGE);
		}
	}

	void helpAbout() {
		MakeDocJrEditorFrame_AboutBox dlg = new MakeDocJrEditorFrame_AboutBox(this);
		Dimension dlgSize = dlg.getPreferredSize();
		Dimension frmSize = getSize();
		Point loc = getLocation();
		dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
		dlg.setModal(true);
		dlg.show();
		jTextArea.requestFocus();
	}

	void findReplace() {
		frd.setSearchFromCursor(true);
		String selectedText = jTextArea.getSelectedText();
		if (selectedText != null) {
			int start = jTextArea.getSelectionStart();
			int end = jTextArea.getSelectionEnd();
			boolean multiline = false;
			try {
				int startLine = jTextArea.getLineOfOffset(start);
				int endLine = jTextArea.getLineOfOffset(end);
				if (startLine != endLine)
					multiline = true;
			}
			catch (Exception ex) {
				// should never happen
			}

			// see if more than one line; if so search selected text,
			// else set as text to search
			if (multiline) {
				frd.setSearchSelectedText(true);
			} else {
				frd.setTextToFind(selectedText);
				frd.setSearchSelectedText(false);
			}
		} else {
			frd.setSearchSelectedText(false);
			// disable "search selected text"
		}
		frd.setIgnoreCase(ignoreCase);
		frd.setSearchFromTop(searchFromTop);
		frd.pack();
		Dimension dlgSize = frd.getSize();
		Dimension frmSize = getSize();
		Point loc = getLocation();
		frd.setLocation((frmSize.width - dlgSize.width) / 2 +
						loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
		frd.setVisible(true);

		buttonPressed = frd.getButtonPressed();
		if (buttonPressed != FindReplaceDialog.CANCEL) {
			searchText = frd.getTextToFind();
			replacementText = frd.getReplacementText();
			ignoreCase = frd.getIgnoreCase();
			searchSelectedTextOnly = frd.getSearchSelectedText();
			searchFromTop = frd.getSearchFromTop();
			newSearch = true;
		}
		switch (buttonPressed) {
			case FindReplaceDialog.FIND :
				findText();
				break;
			case FindReplaceDialog.REPLACE :
				replaceText();
				break;
			case FindReplaceDialog.BOOKMARK_ALL :
				bookmarkAll();
				break;
			case FindReplaceDialog.CANCEL :
				frd.hide();
		}
		this.repaint();
		jTextArea.requestFocus();
	}

	/**File | Exit action performed*/
	public void jMenuFileExit_actionPerformed(ActionEvent e) {
		if (okToAbandon()) {
			writeProperties();
			System.exit(0);
		}
	}
	/**Help | About action performed*/
	public void jMenuHelpAbout_actionPerformed(ActionEvent e) {
		helpAbout();
	}
	/**Overridden so we can exit when window is closed*/
	protected void processWindowEvent(WindowEvent e) {
		super.processWindowEvent(e);
		if (e.getID() == WindowEvent.WINDOW_CLOSING) {
			jMenuFileExit_actionPerformed(null);
		}
	}

	// Check if file is dirty.
	// If so get user to make a "Save? yes/no/cancel" decision.
	boolean okToAbandon() {
		if (!dirty || document.getLength() == 0) {
			return true;
		}
		int value =  JOptionPane.showConfirmDialog(this, "Save changes?",
								"Text has been modified.", JOptionPane.YES_NO_CANCEL_OPTION) ;
		switch (value) {
			case JOptionPane.YES_OPTION:
				// yes, please save changes
				// if file was decoded, return encodeFile() instead
				return saveFile();
			case JOptionPane.NO_OPTION:
				// no, abandon edits
				// i.e. return true without saving
				return true;
			case JOptionPane.CANCEL_OPTION:
			default:
		   // cancel
		   return false;
		}
	}


	void newButton_actionPerformed(ActionEvent e) {
		newFile();
	}

	void jMenuPaste_actionPerformed(ActionEvent e) {
		jTextArea.paste();
		jTextArea.requestFocus();
	}

	void jMenuCut_actionPerformed(ActionEvent e) {
		jTextArea.cut();
		jTextArea.requestFocus();
	}

	void jMenuCopy_actionPerformed(ActionEvent e) {
		jTextArea.copy();
		jTextArea.requestFocus();
	}

	void cutButton_actionPerformed(ActionEvent e) {
		jTextArea.cut();
		jTextArea.requestFocus();
	}

	void copyButton_actionPerformed(ActionEvent e) {
		jTextArea.copy();
		jTextArea.requestFocus();
	}

	void pasteButton_actionPerformed(ActionEvent e) {
		jTextArea.paste();
		jTextArea.requestFocus();
	}

	void jMenuSelectAll_actionPerformed(ActionEvent e) {
		jTextArea.selectAll();
	}

	void jPopSelectAll_actionPerformed(ActionEvent e) {
		jTextArea.selectAll();
	}

	void jPopPaste_actionPerformed(ActionEvent e) {
		jTextArea.paste();
		jTextArea.requestFocus();
	}

	void jPopCopy_actionPerformed(ActionEvent e) {
		jTextArea.copy();
		jTextArea.requestFocus();
	}

	void jPopCut_actionPerformed(ActionEvent e) {
		jTextArea.cut();
		jTextArea.requestFocus();
	}

	// helper function to move a rectangle onto the screen
	private Rectangle ensureRectIsVisible(Rectangle bounds) {
		Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
		return new Rectangle(   Math.max(0,
								Math.min(size.width - bounds.width,
								bounds.x)),
								Math.max(0,
								Math.min(size.height - bounds.height,
								bounds.y)),
								bounds.width,
								bounds.height);
	}

	void jTextArea_mousePressed(MouseEvent e) {
		maybeShowPopup(e);
	}

	void jTextArea_mouseReleased(MouseEvent e) {
		maybeShowPopup(e);
	}

	private void maybeShowPopup(MouseEvent e) {
		if (e.isPopupTrigger()) {

			// show popup menu
			jPopupMenu.show((Component)e.getSource(), e.getX(), e.getY());

			// determine boundaries
			Point point = jPopupMenu.getLocationOnScreen();
			Dimension size = jPopupMenu.getSize();
			Rectangle oldRect =
			new Rectangle(point.x, point.y, size.width, size.height);

			// helper function to move oldRect completely
			// onto screen (desktop) if necessary
			Rectangle newRect = ensureRectIsVisible(oldRect);

			// rects differ, need moving
			if(!oldRect.equals(newRect)){
				Window window = SwingUtilities.getWindowAncestor(jPopupMenu);
				if(window != null){
					window.setLocation(newRect.x, newRect.y);
				}
			}
		}
	}

	void jMenuNew_actionPerformed(ActionEvent e) {
		newFile();
	}

	void jMenuOpen_actionPerformed(ActionEvent e) {
		openFile();
	}

	void jMenuSave_actionPerformed(ActionEvent e) {
		saveFile();
	}

	void jMenuSaveAs_actionPerformed(ActionEvent e) {
		saveAsFile();
	}

	void saveButton_actionPerformed(ActionEvent e) {
		saveFile();
	}

	void openButton_actionPerformed(ActionEvent e) {
		openFile();
	}

	void helpButton_actionPerformed(ActionEvent e) {
		help();
	}

	void this_windowOpened(WindowEvent e) {
		jTextArea.requestFocus();
	}

	void document_changedUpdate(DocumentEvent e) {
		dirty = true;
	}

	void document_insertUpdate(DocumentEvent e) {
		dirty = true;
		docNotEmpty(true);
		int offset = e.getOffset();
	}

	void document_removeUpdate(DocumentEvent e) {
		dirty = true;
		if (document.getLength() == 0) {
			docNotEmpty(false);
		} else docNotEmpty(true);
	}

	void jTextArea_caretUpdate(CaretEvent e) {
		// enable selectable buttons/menus
		canSelect(jTextArea.getSelectedText() != null);

		// update status bar
		int pos = jTextArea.getCaretPosition();
		// gets the current Row
		try {
			int line = jTextArea.getLineOfOffset(pos);
			// people like to count starting at one
			int line1 = line + 1;
			rowStatus.setText(" line: " + line1);
			// gets the current Column
			int column = pos - jTextArea.getLineStartOffset(line) + 1;
			colStatus.setText(" col: " + column);
		} catch (BadLocationException ble) {
			// should never happen
		}
	}

	void canSelect(boolean b) {
		copyButton.setEnabled(b);
		cutButton.setEnabled(b);
		jMenuCopy.setEnabled(b);
		jMenuCut.setEnabled(b);
		jPopCopy.setEnabled(b);
		jPopCut.setEnabled(b);
	}

	void docNotEmpty(boolean b) {
		encodeButton.setEnabled(b);
		saveButton.setEnabled(b);
		jMenuExport.setEnabled(b);
		jMenuExportAs.setEnabled(b);
		jMenuSave.setEnabled(b);
		jMenuSaveAs.setEnabled(b);
		bookmarkButton.setEnabled(b);
		jMenuBookmarkAdd.setEnabled(b);
		jMenuBookmarkAuto.setEnabled(b);
		webButton.setEnabled(b);
		jMenuWeb.setEnabled(b);
		jMenuWordCount.setEnabled(b);
	}

	void configureButtons(byte type) {
		switch (type) {
			case MakeDocJrEditorFrame.REFRESHED_DOC:
				encodeButton.setEnabled(false);
				saveButton.setEnabled(true);
				jMenuExport.setEnabled(false);
				jMenuSave.setEnabled(true);
				break;
			case MakeDocJrEditorFrame.REFRESHED_TEXT:
				encodeButton.setEnabled(true);
				saveButton.setEnabled(false);
				jMenuExport.setEnabled(true);
				jMenuSave.setEnabled(false);
				break;
		}
		jMenuExportAs.setEnabled(true);
		jMenuSaveAs.setEnabled(true);
	}

	void decodeButton_actionPerformed(ActionEvent e) {
		decode();
	}

	void jMenuImport_actionPerformed(ActionEvent e) {
		decode();
	}

	void encodeButton_actionPerformed(ActionEvent e) {
		encodeFile();
	}

	void jMenuExport_actionPerformed(ActionEvent e) {
		encodeFile();
	}

	void jMenuExportAs_actionPerformed(ActionEvent e) {
		encodeAsFile();
	}

	void setText(String s) {
		// convert 0D0A to 0A
		byte[] buffer = s.getBytes();
		byte[] destBuffer = new byte[(buffer.length)];
		int k, j;
		for(j = k = 0; j < buffer.length; j++, k++) {
			// copy each byte
			destBuffer[k] = buffer[j];

			if(destBuffer[k] == 0x0D) {
				// if next is LF, then drop CR
				if(j < buffer.length - 1 && buffer[j + 1] == 0x0A) {
					k--;
				}
			}
		}
		byte[] buf = new byte[k];
		System.arraycopy(destBuffer, 0, buf, 0, k);
		jTextArea.setText(new String(buf));
		docNotEmpty(true);
	}

	void setText(char[] buffer) {
		// convert 0D0A to 0A
		char[] destBuffer = new char[(buffer.length)];
		int k, j;
		for(j = k = 0; j < buffer.length; j++, k++) {
			// copy each char
			destBuffer[k] = buffer[j];

			if(destBuffer[k] == '\015') {
				// if next is LF, then drop CR
				if(j < buffer.length - 1 && buffer[j + 1] == '\012') {
					k--;
				}
			}
		}
		char[] buf = new char[k];
		System.arraycopy(destBuffer, 0, buf, 0, k);
		jTextArea.setText(new String(buf));
		docNotEmpty(true);
	}

	// convert back to DOS file
	String getText() {
		String text = jTextArea.getText();
		if (MakeDocJr.getEolType() != PilotDocRecord.EOLCRLF) {
			return text;
		}
		byte[] buffer = text.getBytes();
		byte[] destBuffer = new byte[(buffer.length * 2)];
		int k, j;
		for(j = k = 0; j < buffer.length; j++, k++) {
			// copy each byte
			destBuffer[k] = buffer[j];

			if(destBuffer[k] == 0x0A) {
				destBuffer[k] = 0x0D;
				destBuffer[++k] = 0x0A;
			}
		}
		byte[] buf = new byte[k];
		System.arraycopy(destBuffer, 0, buf, 0, k);
		return new String(buf);
	}

	// converts the raw bookmark fileOffsets to Positions
	private void setBookmarkPositions() {
		boolean hasBookmarks = true;
		int size = makeDoc.getBookmarks().size();
		if ( size == 0 ) {
			hasBookmarks = false;
		}
		for (int i = 0; i < size; i++) {
			try {
				int off = ((Bookmark)makeDoc.getBookmarks().get(i)).getFileOffset();
				((Bookmark)makeDoc.getBookmarks().get(i)).setPosition(document.createPosition(off));
			} catch (BadLocationException ble) {
				makeDoc.getBookmarks().remove(i);
				--size;
			}
		}
		jMenuBookmarkEdit.setEnabled(hasBookmarks);
	}

	void jMenuBookmarkAdd_actionPerformed(ActionEvent e) {
		addBookmark();
		jTextArea.requestFocus();
	}

	String showAddBookmarkOptionPane() {
		JOptionPane pane = new JOptionPane("Name: (maximum 15 characters)", JOptionPane.PLAIN_MESSAGE,
											JOptionPane.OK_CANCEL_OPTION);
		pane.setWantsInput(true);
		pane.setInitialSelectionValue(
				limitStringAndRemoveBreaks(jTextArea.getSelectedText(), 15)); // Configure

		JDialog dialog = pane.createDialog(this, "Add a bookmark");
		dialog.show();
		// can return uninitializedValue or "" or String
		return (String)pane.getInputValue();
	}

	// Put this in a separate utility class
	// Used for textfields to limit length and remove linebreaks
	String limitStringAndRemoveBreaks(String str, int maxLength) {
		if (str == null)
			return null;
		char[] textArray = str.toCharArray();
		int proposedLength = textArray.length;
		if (proposedLength > maxLength)
			proposedLength = maxLength;
		char[] tempArray = new char[proposedLength];
		for (int i = 0; i < proposedLength; i++) {
			tempArray[i] = textArray[i];
			if (tempArray[i] == '\n') {
				tempArray[i] = ' ';
			}
		}
		return new String(tempArray);
	}

	void addBookmark() {
		String bmName = showAddBookmarkOptionPane();
		repaint();
		if (bmName == null || bmName.equals("uninitializedValue") || bmName.equals(""))
			return;
		if (makeDoc.bookmarkNameExists(bmName)) {
			JOptionPane.showConfirmDialog( this, bmName + " already exists.",
										   "Bookmark naming conflict",
										   JOptionPane.DEFAULT_OPTION,
										   JOptionPane.WARNING_MESSAGE);
			this.repaint();
			return;
		}
		try {
			bmName = limitStringAndRemoveBreaks(bmName, 15);
			// if bmName same as bookmark name, show dialog
			Bookmark bm = new Bookmark();
			bm.setName(bmName);
			bm.setPosition(document.createPosition(jTextArea.getCaretPosition()));
			makeDoc.addBookmark(bm);
			jMenuBookmarkEdit.setEnabled(true);
			dirty = true;
		} catch (BadLocationException ble) {} // bookmark won't be added, so no worry
	}

	void bookmarkButton_actionPerformed(ActionEvent e) {
		if (jTextArea.getSelectedText() != null)
			addBookmark();
		else if (makeDoc.getBookmarks().isEmpty())
			addBookmark();
		else
			editBookmarks();
		jTextArea.requestFocus();
	}

	void jMenuBookmarkEdit_actionPerformed(ActionEvent e) {
		if (makeDoc.getBookmarks().isEmpty())
			return;
		editBookmarks();
	}

	void jMenuExportOptions_actionPerformed(ActionEvent e) {
		EncodeOptionsDialog eod = new EncodeOptionsDialog(this, true, makeDoc);
		eod.pack();
		Dimension dlgSize = eod.getSize();
		Dimension frmSize = this.getSize();
		Point loc = this.getLocation();
		eod.setLocation((frmSize.width - dlgSize.width) / 2 +
						loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
		eod.setVisible(true);
		this.repaint();
	}

	void editBookmarks() {
		BookmarksDialog bmd = new BookmarksDialog(this, true, makeDoc);
		bmd.pack();
		Dimension dlgSize = bmd.getSize();
		Dimension frmSize = this.getSize();
		Point loc = this.getLocation();
		bmd.setLocation((frmSize.width - dlgSize.width) / 2 +
						loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
		bmd.setVisible(true);
		this.repaint();
		if (bmd.getOkPressed()) {
			makeDoc.setBookmarks(bmd.getBookmarks());
			if (makeDoc.getBookmarks().isEmpty())
				jMenuBookmarkEdit.setEnabled(false);
		} else if (bmd.getGotoPressed()) {
			if (bmd.getPosition() < jTextArea.getCaretPosition())
				jTextArea.setCaretPosition(bmd.getPosition());
			else {
				try {
					jTextArea.setCaretPosition(document.getLength());
					Rectangle rec = jTextArea.modelToView(document.getLength());
					if (rec != null)
						jTextArea.scrollRectToVisible(rec);
					jTextArea.setCaretPosition(bmd.getPosition());
				} catch (BadLocationException ble) {
					jTextArea.setCaretPosition(bmd.getPosition());
				}
			}
		}
		bmd.dispose();
	}

	void jMenuBookmarkAuto_actionPerformed(ActionEvent e) {
		JOptionPane pane = new JOptionPane( "Bookmarks will be created \n" +
											"where lines begin with:",
											JOptionPane.PLAIN_MESSAGE,
											JOptionPane.OK_CANCEL_OPTION);
		pane.setWantsInput(true);
		if (makeDoc.getEncodeOptions().getAutoBookmark() == null) {
		   pane.setInitialSelectionValue(
				limitStringAndRemoveBreaks(jTextArea.getSelectedText(), 25)); // Configure
		} else {
			pane.setInitialSelectionValue(makeDoc.getEncodeOptions().getAutoBookmark());
		}
		JDialog dialog = pane.createDialog(this, "Auto bookmark");
		dialog.show();
		makeDoc.getEncodeOptions().setAutoBookmark((String)pane.getInputValue());
		if ((String)pane.getInputValue() != "")
			dirty = true;
	}

	void webButton_actionPerformed(ActionEvent e) {
		removeWebEffects();
	}

	void jMenuWeb_actionPerformed(ActionEvent e) {
		removeWebEffects();
	}

	void removeWebEffects() {
		 char[] textArray = jTextArea.getText().trim().toCharArray();
		 char[] newTextArray = new char[textArray.length];
		 int newSize = 0;
		 boolean linebreak = false; // occurrence of a newline char
		 boolean blankline = false; // 2nd newline, occurs on blank line
		 boolean prevSpace = false; // true is space before linebreak
		 int i, j;
		 for (i = j = 0; i < textArray.length; i++, newSize = j++ + 1) {
			// since text was trimmed, will have text initially
			 newTextArray[j] = textArray[i];
			 if (linebreak) {
				if (newTextArray[j] == ' ')
					j--;
				else if (newTextArray[j] == '\n') {
					if (blankline)
						j--; // prevents more than 2 linebreaks
					blankline = true;
				} else {
					// if char before a single linebreak was a space, remove \n,
					// else replace \n with a space.
					if (!blankline) {
						if (prevSpace)
							newTextArray[--j] = textArray[i];
						else
							newTextArray[j-1] = ' ';
					}
					linebreak = false;
					blankline = false;
				}
			 } else {
				if (newTextArray[j] == '\n') {
					linebreak = true;
					if (j > 0 && newTextArray[j-1] == ' ')
						prevSpace = true;
					else
						prevSpace = false;
				}
			 }

		 }
		 jTextArea.setText(new String(newTextArray, 0, newSize));
		 jTextArea.setCaretPosition(0);
		 jTextArea.requestFocus();
	}

	void jMenuWrap_actionPerformed(ActionEvent e) {
		 jTextArea.setLineWrap(jMenuWrap.isSelected());
		 jTextArea.requestFocus();
	}

	void jMenuPreferences_actionPerformed(ActionEvent e) {
		PreferencesDialog pd = new PreferencesDialog(this, preferences, jFileChooser);
		pd.pack();
		Dimension dlgSize = pd.getSize();
		Dimension frmSize = this.getSize();
		Point loc = this.getLocation();
		pd.setLocation((frmSize.width - dlgSize.width) / 2 +
						loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
		pd.setVisible(true);
		if (pd.isOkay()) {
			preferences = pd.getPreferences();
			setPreferences(true);
		}
		pd.dispose();
		this.repaint();
	}

	void setPreferences(boolean serialize) {
		jTextArea.setFont( new Font( Preferences.FONTS[preferences.getFont()],
							((preferences.getBold()? Font.BOLD : 0) |
							(preferences.getItalic()? Font.ITALIC : 0)),
							preferences.getFontSize()));
		jTextArea.setTabSize(preferences.getTabSize());
		jTextArea.setBackground(preferences.getBackground());
		jTextArea.setForeground(preferences.getForeground());
		jTextArea.setCaretColor(preferences.getForeground());
		// java 1.3 bug workaround - have to setText again
		boolean isDirty = dirty;
		int cp = jTextArea.getCaretPosition();
		jTextArea.setText(jTextArea.getText());
		jTextArea.setCaretPosition(cp);
		dirty = isDirty;
		if (serialize) {
			FileOutputStream fos = null;
			ObjectOutputStream oos = null;
			try {
				fos = new FileOutputStream(Preferences.PREFS);
				oos = new ObjectOutputStream(fos);
				oos.writeObject(preferences);
				oos.flush();
			} catch (Exception e) {
				statusBar.setText("Unable to save preferences to disk");
			} finally {
				try {
					oos.close();
					fos.close();
				} catch (Exception e) {} // null pointer most likely
			}
		}
	}

	void undoButton_actionPerformed(ActionEvent e) {
		undoAction();
	}

	void jMenuUndo_actionPerformed(ActionEvent e) {
		undoAction();
	}

	void undoAction() {
		if (undoManager.canUndo()) {
			undoManager.undo();
			jMenuRedo.setEnabled(true);
			boolean canUndo = undoManager.canUndo();
			jMenuUndo.setEnabled(canUndo);
			undoButton.setEnabled(canUndo);
		}
	}

	void jMenuRedo_actionPerformed(ActionEvent e) {
		if (undoManager.canRedo()) {
			undoManager.redo();
			jMenuUndo.setEnabled(true);
			undoButton.setEnabled(true);
			boolean canRedo = undoManager.canRedo();
			jMenuRedo.setEnabled(canRedo);
		}
	}

	void document_undoableEditHappened(UndoableEditEvent e) {
		jMenuUndo.setEnabled(true);
		undoButton.setEnabled(true);
		jMenuRedo.setEnabled(false);
	}

	void addTextPath(String path) {
		if (textpaths.contains(path)) // move to top
			textpaths.remove(path);
		textpaths.add(0, path);
		if (textpaths.size() > NUMBER_OF_FILES)
			textpaths.remove(NUMBER_OF_FILES);
	}

	void addDocPath(String path) {
		if (docpaths.contains(path)) // move to top
			docpaths.remove(path);
		docpaths.add(0, path);
		if (docpaths.size() > NUMBER_OF_FILES)
			docpaths.remove(NUMBER_OF_FILES);
	}

	void configureMenu() {
		JMenuItem jMenuSubText = new JMenuItem();
		if (textpaths.isEmpty()) {
			jMenuSubText.setText("empty");
			jMenuSubText.setEnabled(false);
			jMenuReopen.add(jMenuSubText);
		} else {
			// enumerate through vector, adding JMenuItems
			jMenuReopen.removeAll();
			Enumeration enum = textpaths.elements();
			while (enum.hasMoreElements()) {
				jMenuSubText = new JMenuItem();
				jMenuSubText.setText((String)enum.nextElement());
				jMenuSubText.addActionListener(new ActionListener()  {
					public void actionPerformed(ActionEvent e) {
						jMenuSubText_actionPerformed(e);
					}
				});
				jMenuReopen.add(jMenuSubText);
			}
		}
		JMenuItem jMenuSubDoc = new JMenuItem();
		if (docpaths.isEmpty()) {
			jMenuSubDoc.setText("empty");
			jMenuSubDoc.setEnabled(false);
			jMenuReimport.add(jMenuSubDoc);
		} else {
			// enumerate through vector, adding JMenuItems
			jMenuReimport.removeAll();
			Enumeration enum = docpaths.elements();
			while (enum.hasMoreElements()) {
				jMenuSubDoc = new JMenuItem();
				jMenuSubDoc.setText((String)enum.nextElement());
				jMenuSubDoc.addActionListener(new ActionListener()  {
					public void actionPerformed(ActionEvent e) {
						jMenuSubDoc_actionPerformed(e);
					}
				});
				jMenuReimport.add(jMenuSubDoc);
			}
		}
	}

	void jMenuSubText_actionPerformed(ActionEvent e) {
		openFile(((JMenuItem)e.getSource()).getText());
	}

	void jMenuSubDoc_actionPerformed(ActionEvent e) {
		decode(new File(((JMenuItem)e.getSource()).getText()));;
	}

	void readProperties() {
		BufferedInputStream bis = null;
		try {
			Properties props = new Properties();
			File f = new File(PROPERTY_FILE);
			if (!f.exists())
				return;
			bis = new BufferedInputStream(new FileInputStream(f));
			props.load(bis);
			// get property names as Enumeration, load values into arrays, then vectors
			String[] dp = new String[NUMBER_OF_FILES]; // holder for docpaths
			String[] tp = new String[NUMBER_OF_FILES]; // holder for textpaths
			Enumeration enum = props.propertyNames();
			while (enum.hasMoreElements()) {
				String s = (String) enum.nextElement();
				if (s.startsWith("d")) {
					int index = Integer.parseInt(s.substring(1, s.length()));
					dp[index] = (String) props.getProperty(s);
				} else if (s.startsWith("t")) {
					int index = Integer.parseInt(s.substring(1, s.length()));
					tp[index] = (String) props.getProperty(s);
				}
			}
			for (int i = 0; i < dp.length; i++) {
				if (dp[i] != null)
					docpaths.add(dp[i]);
			}
			for (int i = 0; i < tp.length; i++) {
				if (tp[i] != null)
					textpaths.add(tp[i]);
			}
		} catch (Exception e) { // do nothing
		} finally {
			try {
				bis.close();
			} catch (Exception e) {}
		}
	}

	void writeProperties() {
		BufferedOutputStream bos = null;
		try{
			Properties props = new Properties();
			Object[] o = docpaths.toArray();
			for (int i = 0; i < o.length; i++) {
				props.setProperty("d"+i, (String) o[i]);
			}
			o = textpaths.toArray();
			for (int i = 0; i < o.length; i++) {
				props.setProperty("t"+i, (String) o[i]);
			}
			File f = new File(PROPERTY_FILE);
			bos = new BufferedOutputStream(new FileOutputStream(f));
			props.store(bos, "This is a history of your most recent files. " +
					"Please do not edit this file; but you may delete it.");
		} catch (Exception e) { // do nothing
		} finally {
			try {
				bos.close();
			} catch (Exception e) {}
		}
	}

	void wordCount() {
		boolean hadNonWhiteSpace = false;
		int numWords = 0;
		char[] character = jTextArea.getText().toCharArray();
		for (int i = 0; i < character.length; i++) {
			if (Character.isWhitespace(character[i])) {
				if (hadNonWhiteSpace)
					numWords++;
				hadNonWhiteSpace = false;
			} else {
				hadNonWhiteSpace = true;
			}
		}
		if (hadNonWhiteSpace) numWords++;
		JOptionPane.showMessageDialog(  this,
				"Number of words: " + NumberFormat.getInstance().format(numWords)
				+ "\nText size in bytes: "
				+ NumberFormat.getInstance().format(document.getLength()),
				"MakeDocJrEditor",
				JOptionPane.INFORMATION_MESSAGE);
		this.repaint();
	}

	void jMenuWordCount_actionPerformed(ActionEvent e) {
		wordCount();
	}

	private boolean findText() {
		boolean textFound = true;
		// search for text
		try {
			rem = null;
			re = new RE( searchText,
						(RE.REG_MULTILINE | (ignoreCase?RE.REG_ICASE:0) ) );

			if (searchSelectedTextOnly) {
				// set up start and stop positions for subsequent searches
				if (newSearch) {
					selectionStart = jTextArea.getSelectionStart();
					selectionEnd = jTextArea.getSelectionEnd();
					jTextArea.setCaretPosition(selectionStart);
				}
				// need to use positions for any replacements
				rem = re.getMatch( jTextArea.getText(0, selectionEnd),
												jTextArea.getCaretPosition() );

			} else if (searchFromTop) {
				rem = re.getMatch(jTextArea.getText(), 0);
			} else { // search from cursor
				rem = re.getMatch(jTextArea.getText(), jTextArea.getCaretPosition());
			}
			// if found, highlight, enable findAgain, and return true
			if (rem != null) {
				jTextArea.select(rem.getStartIndex(), rem.getEndIndex());
				// textFound = true
			// else dialog text cannot be found
			} else {
				JOptionPane.showMessageDialog(this, "A string matching your regex " +
								searchText + " was not found.",
								"Search failed",
								JOptionPane.INFORMATION_MESSAGE);
				textFound = false;
			}
		} catch (REException ree) {
			JOptionPane.showMessageDialog( this,
					"Error in your regex " + searchText +
					"\nUsually caused by not escaping special characters.",
					"RegEx Error",
					JOptionPane.ERROR_MESSAGE);
			textFound = false;
		} catch (BadLocationException ble) {
			textFound = false;
			// should never happen
		}
		return textFound;
	}

	private boolean findAgain() {
		searchFromTop = false;
		newSearch = false;
		return findText();
	}

	private void replaceText() {
		// search for text
		try {
			rem = null;
			String selectionText = null;
			re = new RE( searchText,
						(RE.REG_MULTILINE | (ignoreCase?RE.REG_ICASE:0) ) );

			if (searchSelectedTextOnly) {
				// set up start and stop positions for subsequent searches
				if (newSearch) {
//					selectionStart = jTextArea.getSelectionStart();
					selectionEnd = jTextArea.getSelectionEnd();
				}
				// need to use positions for any replacements
				selectionStart = jTextArea.getSelectionStart();
				selectionText = jTextArea.getText(0, selectionEnd);
			} else if (searchFromTop) {
				selectionStart = 0;
				selectionText = jTextArea.getText();
				selectionEnd = selectionText.length();
			} else { // search from cursor
				selectionStart = jTextArea.getSelectionStart();
				selectionText = jTextArea.getText();
				selectionEnd = selectionText.length();
			}
			rem = re.getMatch(selectionText, selectionStart);
			// if found, highlight, enable findAgain, and return true
			if (rem != null) {
				jTextArea.select(rem.getStartIndex(), rem.getEndIndex());
				createConfirmReplaceDialog();
			// else dialog text cannot be found
			} else {
				JOptionPane.showMessageDialog(this, "A string matching your regex " +
								searchText + " was not found.",
								"Search failed",
								JOptionPane.INFORMATION_MESSAGE);
			}
		} catch (REException ree) {
			JOptionPane.showMessageDialog( this,
					"Error in your regex " + searchText +
					"\nUsually caused by not escaping special characters.",
					"RegEx Error",
					JOptionPane.ERROR_MESSAGE);
		} catch (BadLocationException ble) {
					// should never happen
		}
	}

	private void createConfirmReplaceDialog() {
		repaint();
		if (crd == null) {
			crd = new ConfirmReplaceDialog();
			crd.pack();
			Dimension dlgSize = crd.getSize();
			Dimension frmSize = this.getSize();
			Point loc = this.getLocation();
			crd.setLocation((frmSize.width - dlgSize.width) / 2 +
						loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
			crd.setVisible(true);
		} else {
			crd.show();
		}
		byte value = crd.getButtonPressed();
		crd.hide();
		switch (value) {
			case ConfirmReplaceDialog.YES :
				replaceYes();
				break;
			case ConfirmReplaceDialog.NO :
				replaceNo();
				break;
			case ConfirmReplaceDialog.ALL :
				replaceAll();
				break;
		}
	}

	private void replaceYes() {
		String selectedText = jTextArea.getSelectedText();
		String newText = re.substitute(selectedText,
							replacementText);
		jTextArea.cut();
		jTextArea.insert(newText, jTextArea.getCaretPosition());
		selectionEnd = selectionEnd +
								newText.length() - selectedText.length();
		searchFromTop = false;
		newSearch = false;
		replaceText();
	}

	private void replaceNo() {
		searchFromTop = false;
		newSearch = false;
		int cp = jTextArea.getCaretPosition();
		if (cp != jTextArea.getText().length()) {
			jTextArea.setCaretPosition(++cp);
			replaceText();
		}
	}

	private void replaceAll() {
		jTextArea.select(selectionStart, selectionEnd);
		String newText = re.substituteAll(jTextArea.getSelectedText(),
							replacementText);
		jTextArea.cut();
		jTextArea.insert(newText, jTextArea.getCaretPosition());
	}

	void jMenuFindReplace_actionPerformed(ActionEvent e) {
		findReplace();
	}

	void jMenuFindAgain_actionPerformed(ActionEvent e) {
		findAgain();
	}

	private void bookmarkAll() {
		// search for text
		try {
			REMatch[] rems = null;
			String selectionText = null;
			re = new RE( searchText,
						(RE.REG_MULTILINE | (ignoreCase?RE.REG_ICASE:0) ) );
			if (searchSelectedTextOnly) {
				selectionStart = jTextArea.getSelectionStart();
				selectionEnd = jTextArea.getSelectionEnd();
				selectionText = jTextArea.getText(0, selectionEnd);
				// (BadLocationException ble) - should never happen
			} else if (searchFromTop) {
				selectionStart = 0;
				selectionText = jTextArea.getText();
				selectionEnd = selectionText.length();
			} else { // search from cursor
				selectionStart = jTextArea.getSelectionStart();
				selectionText = jTextArea.getText();
				selectionEnd = selectionText.length();
			}
			rems = re.getAllMatches(selectionText, selectionStart);
			// if found, get location and create a bookmark title based on text found
			if (rems != null) {
				for (int i=0; i<rems.length; i++) {
					int start = rems[i].getStartIndex();
					int length = rems[i].getEndIndex() - start;
					String bmName = null;
					if ( !replacementText.equals("") ) {
						bmName = rems[i].substituteInto(replacementText);
					} else {
						bmName = jTextArea.getText(start, length).trim();
					}
					bmName = limitStringAndRemoveBreaks(bmName, 15);
					Bookmark bm = new Bookmark();
					bm.setName(bmName);
					bm.setPosition(document.createPosition(start));
					makeDoc.addBookmark(bm);
					jMenuBookmarkEdit.setEnabled(true);
					dirty = true;
					// (BadLocationException ble) - bookmark won't be added, so no worry
				}
			// else dialog text cannot be found
			} else {
				JOptionPane.showMessageDialog(this, "A string matching your regex " +
								searchText + " was not found.",
								"Search failed",
								JOptionPane.INFORMATION_MESSAGE);
			}
		} catch (REException ree) {
			JOptionPane.showMessageDialog( this,
					"Error in your regex " + searchText +
					"\nUsually caused by not escaping special characters.",
					"RegEx Error",
					JOptionPane.ERROR_MESSAGE);
		} catch (BadLocationException ble) {
					// should never happen or won't matter if does
		}

	}

	void jMenuHelpHelp_actionPerformed(ActionEvent e) {
		help();
	}

}
