/*
 * EncodeOptionsDialog.java
 *
 * Copyright 2002 Steve Held,
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package makedocjr.editor;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.border.*;
import javax.swing.JDialog;
import java.util.EventObject;
import java.util.ArrayList;
import java.io.*;
import makedocjr.*;

/*
 * @author Steve Held
 * @version 1.0
 */

public class EncodeOptionsDialog extends JDialog {

	JPanel jPanel1 = new JPanel();
	GridBagLayout gridBagLayout1 = new GridBagLayout();
	JCheckBox jCheckBoxCompressText = new JCheckBox();
	JCheckBox jCheckBoxMakePrivate = new JCheckBox();
	JLabel jLabelDocType = new JLabel();
	final static String[] docTypes = {"Generic", "TealDoc"};
	JComboBox jComboBoxDocType = new JComboBox(docTypes);
	JLabel jLabelDocCat = new JLabel();
	final static String[] categories = {"0", "1", "2", "3", "4", "5", "6", "7", "8", "9",
							 "10", "11", "12", "13", "14", "15"};
	JComboBox jComboBoxDocCat = new JComboBox(categories);
	Component component4;
	Component component5;
	JButton jButtonOK = new JButton();
	JButton jButtonCancel = new JButton();
	JButton jButtonDefault = new JButton();
	Component component3;
	TitledBorder titledBorder1;
	MakeDocJr makeDoc;
	EncodeOptions encodeOptions;
	boolean compress;
	boolean makePrivate;
	int docID;
	byte category;
	ArrayList encodeOptionsDialogListeners = new ArrayList();
	String serializedName = "eoptions.ser";

	public EncodeOptionsDialog(JDialog jdialog, boolean modal, MakeDocJr makeDoc) {
		super(jdialog, modal);
		this.makeDoc = makeDoc;
		try {
			jbInit();
		}
		catch(Exception e) {
			e.printStackTrace();
		}
	}

	public EncodeOptionsDialog(Frame frame, boolean modal, MakeDocJr makeDoc) {
		super(frame, modal);
		this.makeDoc = makeDoc;
		try {
			jbInit();
		}
		catch(Exception e) {
			e.printStackTrace();
		}
	}

	private void jbInit() throws Exception {
		encodeOptions = makeDoc.getEncodeOptions();
		compress = encodeOptions.getCompress();
		makePrivate = encodeOptions.getMakePrivate();
		docID = encodeOptions.getDocID();
		category = encodeOptions.getCategory();
		component4 = Box.createVerticalStrut(8);
		component5 = Box.createVerticalStrut(8);
		component3 = Box.createHorizontalStrut(8);
		titledBorder1 = new TitledBorder("");
		this.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
		this.setTitle("Export Options");
		jPanel1.setLayout(gridBagLayout1);
		jCheckBoxCompressText.setSelected(compress);
		jCheckBoxCompressText.setText("Compress Text");
		jCheckBoxCompressText.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jCheckBoxCompressText_actionPerformed(e);
			}
		});
		jCheckBoxMakePrivate.setSelected(makePrivate);
		jCheckBoxMakePrivate.setText("Make Private");
		jCheckBoxMakePrivate.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jCheckBoxMakePrivate_actionPerformed(e);
			}
		});
		jLabelDocType.setRequestFocusEnabled(false);
		jLabelDocType.setText("Document Type: ");
		jLabelDocCat.setRequestFocusEnabled(false);
		jLabelDocCat.setText("Document Category: ");
		jButtonOK.setText("OK");
		jButtonOK.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jButtonOK_actionPerformed(e);
			}
		});
		jButtonCancel.setText("Cancel");
		jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jButtonCancel_actionPerformed(e);
			}
		});
		jButtonDefault.setText("Set As Default");
		jButtonDefault.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jButtonDefault_actionPerformed(e);
			}
		});
		jPanel1.setMaximumSize(new Dimension(362, 162));
		jPanel1.setSize(new Dimension(362, 149));
		jPanel1.setMinimumSize(new Dimension(362, 162));
		jPanel1.setPreferredSize(new Dimension(362, 182));
		if (docID == DatabaseHeader.ReaderID) {
			jComboBoxDocType.setSelectedIndex(0);
		} else {
			jComboBoxDocType.setSelectedIndex(1);
		}
		jComboBoxDocCat.setSelectedIndex(category);
		jComboBoxDocCat.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jComboBoxDocCat_actionPerformed(e);
			}
		});
		jComboBoxDocType.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				jComboBoxDocType_actionPerformed(e);
			}
		});
		jPanel1.add(jLabelDocType,                                                  new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0
			,GridBagConstraints.SOUTHWEST, GridBagConstraints.NONE, new Insets(0, 1, 0, 0), 0, 0));
		jPanel1.add(jComboBoxDocType,                                                 new GridBagConstraints(0, 1, 8, 1, 0.0, 0.0
			,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(jLabelDocCat,                                          new GridBagConstraints(0, 3, 6, 1, 0.0, 0.0
			,GridBagConstraints.SOUTHWEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(jComboBoxDocCat,                                         new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0
			,GridBagConstraints.SOUTHWEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(component4,                                         new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(component5,                                           new GridBagConstraints(0, 5, 3, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 33, 0), 0, 0));
		jPanel1.add(jButtonOK,                                     new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 7), 21, 0));
		jPanel1.add(jButtonCancel,                          new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(component3,                           new GridBagConstraints(3, 6, 1, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 43), 0, 0));
		jPanel1.add(jCheckBoxCompressText,                    new GridBagConstraints(5, 0, 2, 2, 0.0, 0.0
			,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 2), 0, 0));
		jPanel1.add(jCheckBoxMakePrivate,                new GridBagConstraints(6, 2, 1, 2, 0.0, 0.0
			,GridBagConstraints.SOUTHWEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 4), 0, 0));
		jPanel1.add(jButtonDefault,       new GridBagConstraints(4, 6, 3, 1, 0.0, 0.0
			,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, -1, 0, 5), 0, 0));
		this.getContentPane().add(jPanel1,  BorderLayout.CENTER);
		this.getRootPane().setDefaultButton(jButtonOK);
	}

	private void setOptions() {
		encodeOptions.setCategory(category);
		encodeOptions.setCompress(compress);
		encodeOptions.setDocID(docID);
		encodeOptions.setMakePrivate(makePrivate);
	}

	void jButtonDefault_actionPerformed(ActionEvent e) {
		setOptions();
		setDefaultOptions();
		this.dispose();
	}

	void jButtonCancel_actionPerformed(ActionEvent e) {
		this.dispose();
	}

	void jButtonOK_actionPerformed(ActionEvent e) {
		setOptions();
		this.dispose();
	}

	void jComboBoxDocType_actionPerformed(ActionEvent e) {
		int id = jComboBoxDocType.getSelectedIndex();
		if (id == 0) docID = DatabaseHeader.ReaderID;
		else docID = DatabaseHeader.TealDocID;
	}

	void jComboBoxDocCat_actionPerformed(ActionEvent e) {
		category = (byte) jComboBoxDocCat.getSelectedIndex();
	}

	void jCheckBoxCompressText_actionPerformed(ActionEvent e) {
		compress = jCheckBoxCompressText.isSelected();
	}

	void jCheckBoxMakePrivate_actionPerformed(ActionEvent e) {
		makePrivate = jCheckBoxMakePrivate.isSelected();
	}

	void setDefaultOptions() {
		FileOutputStream fos = null;
		ObjectOutputStream oos = null;
		try {
			fos = new FileOutputStream(serializedName);
			oos = new ObjectOutputStream(fos);
			oos.writeObject(encodeOptions);
			oos.flush();
		} catch (Exception e) { // FileNotFoundException, IOException
			JOptionPane.showMessageDialog(null, "Sorry, unable to save your options.",
											"I/O Error", JOptionPane.ERROR_MESSAGE);
		} finally {
			try {
				if (oos != null) oos.close();
				if (fos != null) fos.close();
			} catch (IOException ioe) {}
		}
		JOptionPane.showMessageDialog(null, "Your options have been saved as "
				+ "your default options.");
	}
}
