/*
 * Decompiled with CFR 0.152.
 */
package net.onza.op.upswing.utilityfields;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public final class FiniteTextField
extends JTextField {
    public FiniteTextField() {
    }

    public FiniteTextField(int cols) {
        super(cols);
    }

    public FiniteTextField(String text) {
        super(text);
    }

    public FiniteTextField(String text, int columns) {
        super(text, columns);
    }

    public void setMaxLength(int maxLength) {
        FiniteTextDocument.maxLength = maxLength;
    }

    public int getMaxLength() {
        return FiniteTextDocument.maxLength;
    }

    protected Document createDefaultModel() {
        return new FiniteTextDocument();
    }

    static class FiniteTextDocument
    extends PlainDocument {
        static int maxLength;

        FiniteTextDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            int i;
            char[] temp;
            int insertLength;
            int presentLength = this.getLength();
            if (str == null) {
                return;
            }
            if (maxLength > 0 && (offs >= maxLength || presentLength >= maxLength)) {
                return;
            }
            char[] textToInsert = str.toCharArray();
            int proposedLength = presentLength + textToInsert.length;
            if (proposedLength > maxLength) {
                insertLength = maxLength - presentLength;
                temp = new char[insertLength];
                i = 0;
                while (i < insertLength) {
                    temp[i] = textToInsert[i];
                    if (temp[i] == '\n') {
                        temp[i] = 32;
                    }
                    ++i;
                }
            } else {
                insertLength = textToInsert.length;
                temp = new char[insertLength];
                i = 0;
                while (i < insertLength) {
                    temp[i] = textToInsert[i];
                    if (temp[i] == '\n') {
                        temp[i] = 32;
                    }
                    ++i;
                }
            }
            char[] textWillInsert = new char[insertLength];
            System.arraycopy(temp, 0, textWillInsert, 0, insertLength);
            super.insertString(offs, new String(textWillInsert), a);
        }
    }
}

