/*
 * Decompiled with CFR 0.152.
 */
package net.onza.op.upswing.textdrag;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import net.onza.op.upswing.textdrag.DragDropCaret;

public class TextDragDropper
implements DragGestureListener,
DragSourceListener,
DropTargetListener {
    private DragSource dragSource;
    private DropTarget dropTarget;
    private DragGestureRecognizer recognizer;
    private DragDropCaret caret;
    private JTextComponent textComponent;
    private boolean isLeftMB = false;
    private int start = 0;
    private int end = 0;
    private boolean isCopy = false;

    public TextDragDropper(JTextComponent textComponent) {
        this.textComponent = textComponent;
        this.textComponent.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                TextDragDropper.this.isLeftMB = SwingUtilities.isLeftMouseButton(e);
            }
        });
        this.dragSource = new DragSource();
        this.dropTarget = new DropTarget(textComponent, 3, this);
        this.recognizer = this.dragSource.createDefaultDragGestureRecognizer(textComponent, 3, this);
        this.caret = new DragDropCaret();
        textComponent.setCaret(this.caret);
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
        if (dsde.getDropSuccess()) {
            if (this.start != this.end) {
                this.textComponent.setCaretPosition(this.start);
                this.textComponent.moveCaretPosition(this.end);
            }
            if (!this.isCopy) {
                this.textComponent.replaceSelection("");
            }
        }
    }

    public void dragEnter(DragSourceDragEvent dsde) {
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        if (dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            dtde.acceptDrag(3);
        } else {
            dtde.rejectDrag();
        }
    }

    public void dragExit(DragSourceEvent dse) {
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
        if (!this.isLeftMB) {
            return;
        }
        int n = this.textComponent.viewToModel(dge.getDragOrigin());
        if (n > this.textComponent.getSelectionStart() && n <= this.textComponent.getSelectionEnd()) {
            String selectedItem = this.textComponent.getSelectedText();
            MouseEvent e = (MouseEvent)dge.getTriggerEvent();
            if (e.isAltDown()) {
                return;
            }
            this.isCopy = e.isControlDown();
            dge.startDrag(this.isCopy ? DragSource.DefaultCopyDrop : DragSource.DefaultMoveDrop, new StringSelection(selectedItem), this);
        } else {
            this.caret.startDrag(dge);
        }
    }

    public void dragOver(DragSourceDragEvent dsde) {
    }

    public void dragOver(DropTargetDragEvent dtde) {
    }

    public void drop(DropTargetDropEvent dtde) {
        this.start = this.textComponent.getSelectionStart();
        this.end = this.textComponent.getSelectionEnd();
        try {
            if (dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                Transferable tr = dtde.getTransferable();
                dtde.acceptDrop(2);
                String s = (String)tr.getTransferData(DataFlavor.stringFlavor);
                int n = this.textComponent.viewToModel(dtde.getLocation());
                Document doc = this.textComponent.getDocument();
                int len = this.end - this.start;
                if (n < this.start) {
                    doc.insertString(n, s, null);
                    doc.remove(this.end, len);
                    this.textComponent.setCaretPosition(n);
                    this.textComponent.moveCaretPosition(n + len);
                } else if (n > this.end) {
                    doc.insertString(n, s, null);
                    doc.remove(this.start, len);
                    this.textComponent.setCaretPosition(n - len);
                    this.textComponent.moveCaretPosition(n);
                } else {
                    doc.insertString(this.start, s, null);
                    doc.remove(this.start, len);
                    this.textComponent.setCaretPosition(this.start);
                    this.textComponent.moveCaretPosition(this.end);
                }
                dtde.dropComplete(false);
            } else {
                dtde.rejectDrop();
            }
        }
        catch (IOException e) {
            dtde.rejectDrop();
        }
        catch (UnsupportedFlavorException e) {
            dtde.rejectDrop();
        }
        catch (BadLocationException e) {
            dtde.rejectDrop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    protected JTextComponent getTextComponent() {
        return this.textComponent;
    }

    protected void setTextComponent(JTextComponent textComponent) {
        this.textComponent = textComponent;
    }

    protected int getStart() {
        return this.start;
    }

    protected void setStart(int start) {
        this.start = start;
    }

    protected DragGestureRecognizer getRecognizer() {
        return this.recognizer;
    }

    protected void setRecognizer(DragGestureRecognizer recognizer) {
        this.recognizer = recognizer;
    }

    protected boolean getIsLeftMB() {
        return this.isLeftMB;
    }

    protected void setIsLeftMB(boolean isLeftMB) {
        this.isLeftMB = isLeftMB;
    }

    protected boolean getIsCopy() {
        return this.isCopy;
    }

    protected void setIsCopy(boolean isCopy) {
        this.isCopy = isCopy;
    }

    protected int getEnd() {
        return this.end;
    }

    protected void setEnd(int end) {
        this.end = end;
    }

    protected DropTarget getDropTarget() {
        return this.dropTarget;
    }

    protected void setDropTarget(DropTarget dropTarget) {
        this.dropTarget = dropTarget;
    }

    protected DragSource getDragSource() {
        return this.dragSource;
    }

    protected void setDragSource(DragSource dragSource) {
        this.dragSource = dragSource;
    }

    protected DragDropCaret getCaret() {
        return this.caret;
    }

    protected void setCaret(DragDropCaret caret) {
        this.caret = caret;
    }
}

