/*
 * Decompiled with CFR 0.152.
 */
package makedocjr.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

public class FindReplaceDialog
extends JDialog {
    static final byte CANCEL = 0;
    static final byte FIND = 1;
    static final byte REPLACE = 2;
    static final byte BOOKMARK_ALL = 3;
    private static final int MAX_LIST_SIZE = 5;
    JPanel leftPanel = new JPanel();
    JPanel buttonsPanel = new JPanel();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    JButton findButton = new JButton();
    JPanel optionsPanel = new JPanel();
    TitledBorder titledBorder1;
    JCheckBox ignoreCaseCheckBox = new JCheckBox();
    JPanel searchPanel = new JPanel();
    String[] lastTextToReplace = new String[]{""};
    JComboBox replaceTextField = new JComboBox<String>(this.lastTextToReplace);
    String[] lastTextToFind = new String[]{""};
    JComboBox findTextField = new JComboBox<String>(this.lastTextToFind);
    JLabel replaceLabel = new JLabel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel findLabel = new JLabel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    GridBagLayout gridBagLayout4 = new GridBagLayout();
    JButton replaceButton = new JButton();
    JButton bookmarkAllButton = new JButton();
    Component component1;
    Component component2;
    JButton cancelButton = new JButton();
    boolean ignoreCase;
    boolean searchSelectedText;
    boolean searchFromTop;
    byte buttonPressed;
    JButton regexHelpButton = new JButton();
    Component component3;
    JRadioButton jRadioSearchStart = new JRadioButton();
    JRadioButton jRadioSearchCursor = new JRadioButton();
    JRadioButton jRadioSearchSelected = new JRadioButton();
    ButtonGroup buttonGroupSearch = new ButtonGroup();

    public FindReplaceDialog(Frame frame, boolean modal) {
        super(frame, modal);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public FindReplaceDialog(Dialog dialog, boolean modal) {
        super(dialog, modal);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), "Options");
        this.component1 = Box.createVerticalStrut(8);
        this.component2 = Box.createVerticalStrut(8);
        this.component3 = Box.createVerticalStrut(8);
        this.buttonsPanel.setLayout(this.gridBagLayout3);
        this.findButton.setPreferredSize(new Dimension(107, 27));
        this.findButton.setSelected(true);
        this.findButton.setText("Find");
        this.findButton.setDefaultCapable(true);
        this.findButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindReplaceDialog.this.findButton_actionPerformed(e);
            }
        });
        this.optionsPanel.setBorder(this.titledBorder1);
        this.optionsPanel.setLayout(this.gridBagLayout4);
        this.ignoreCaseCheckBox.setText("Ignore case");
        this.searchPanel.setLayout(this.gridBagLayout1);
        this.replaceLabel.setText("Replace with:");
        this.findLabel.setText("RegEx to find:");
        this.leftPanel.setLayout(this.gridBagLayout2);
        this.replaceButton.setPreferredSize(new Dimension(107, 27));
        this.replaceButton.setText("Replace...");
        this.replaceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindReplaceDialog.this.replaceButton_actionPerformed(e);
            }
        });
        this.bookmarkAllButton.setText("Bookmark All");
        this.bookmarkAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindReplaceDialog.this.bookmarkAllButton_actionPerformed(e);
            }
        });
        this.setModal(true);
        this.setTitle("Find/Replace");
        this.cancelButton.setPreferredSize(new Dimension(107, 27));
        this.cancelButton.setText("Close");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindReplaceDialog.this.cancelButton_actionPerformed(e);
            }
        });
        this.findTextField.setPreferredSize(new Dimension(200, 21));
        this.findTextField.setEditable(true);
        this.replaceTextField.setPreferredSize(new Dimension(200, 21));
        this.replaceTextField.setEditable(true);
        this.regexHelpButton.setPreferredSize(new Dimension(107, 27));
        this.regexHelpButton.setText("RegEx Help");
        this.regexHelpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindReplaceDialog.this.regexHelpButton_actionPerformed(e);
            }
        });
        this.jRadioSearchStart.setText("Search from start of file");
        this.jRadioSearchCursor.setText("Search from cursor postion");
        this.jRadioSearchSelected.setText("Search only selected text");
        this.leftPanel.add((Component)this.searchPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.searchPanel.add((Component)this.findLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.searchPanel.add((Component)this.findTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.searchPanel.add((Component)this.replaceLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.searchPanel.add((Component)this.replaceTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.leftPanel.add((Component)this.optionsPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.optionsPanel.add((Component)this.ignoreCaseCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.optionsPanel.add((Component)this.jRadioSearchStart, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.optionsPanel.add((Component)this.jRadioSearchCursor, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), -8, 0));
        this.optionsPanel.add((Component)this.jRadioSearchSelected, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.buttonsPanel, "Center");
        this.buttonsPanel.add((Component)this.findButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.buttonsPanel.add((Component)this.replaceButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.buttonsPanel.add((Component)this.bookmarkAllButton, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.buttonsPanel.add(this.component1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 7, 0), 0, 0));
        this.buttonsPanel.add(this.component2, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 8, 0), 0, 0));
        this.buttonsPanel.add((Component)this.cancelButton, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 15, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.buttonsPanel.add((Component)this.regexHelpButton, new GridBagConstraints(0, 8, 1, 1, 0.0, 1.0, 15, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.buttonsPanel.add(this.component3, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 46, 0), 0, 0));
        this.getContentPane().add((Component)this.leftPanel, "West");
        this.getRootPane().setDefaultButton(this.findButton);
        this.buttonGroupSearch.add(this.jRadioSearchCursor);
        this.buttonGroupSearch.add(this.jRadioSearchStart);
        this.buttonGroupSearch.add(this.jRadioSearchSelected);
    }

    public String getTextToFind() {
        return (String)this.findTextField.getItemAt(0);
    }

    public void setTextToFind(String textToFind) {
        this.findTextField.getEditor().setItem(textToFind);
    }

    public String getReplacementText() {
        return (String)this.replaceTextField.getItemAt(0);
    }

    public void setReplacementText(String replacementText) {
        this.replaceTextField.getEditor().setItem(replacementText);
    }

    public boolean getIgnoreCase() {
        return this.ignoreCaseCheckBox.isSelected();
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCaseCheckBox.setSelected(ignoreCase);
    }

    public boolean getSearchSelectedText() {
        return this.jRadioSearchSelected.isSelected();
    }

    public void setSearchSelectedText(boolean searchSelectedText) {
        this.jRadioSearchSelected.setEnabled(searchSelectedText);
        this.jRadioSearchSelected.setSelected(searchSelectedText);
    }

    public boolean getSearchFromTop() {
        return this.jRadioSearchStart.isSelected();
    }

    public void setSearchFromTop(boolean searchFromTop) {
        this.jRadioSearchStart.setSelected(searchFromTop);
    }

    public void setSearchFromCursor(boolean searchFromCursor) {
        this.jRadioSearchCursor.setSelected(searchFromCursor);
    }

    public byte getButtonPressed() {
        return this.buttonPressed;
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        this.buttonPressed = 0;
        this.hide();
    }

    void regexHelpButton_actionPerformed(ActionEvent e) {
        String s = null;
        URL helpURL = null;
        JEditorPane regexHelpPane = null;
        try {
            s = String.valueOf(String.valueOf(new StringBuffer("file:").append(System.getProperty("user.dir")).append(System.getProperty("file.separator")).append("regexsyntax.html")));
            helpURL = new URL(s);
            regexHelpPane = new JEditorPane(helpURL);
            regexHelpPane.setEditable(false);
            JScrollPane editorScrollPane = new JScrollPane(regexHelpPane);
            editorScrollPane.setVerticalScrollBarPolicy(22);
            JDialog jd = new JDialog(this, "RegEx Help", false);
            jd.getContentPane().add(editorScrollPane);
            ((Component)jd).setSize(new Dimension(450, 400));
            ((Component)jd).setVisible(true);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Could not find the file \"regexsyntax.html\"", "Missing help file.", 0);
        }
    }

    void findButton_actionPerformed(ActionEvent e) {
        if (!this.validateSearchText()) {
            return;
        }
        this.buttonPressed = 1;
        this.hide();
    }

    void replaceButton_actionPerformed(ActionEvent e) {
        if (!this.validateSearchText()) {
            return;
        }
        this.updateReplaceList();
        this.buttonPressed = (byte)2;
        this.hide();
    }

    void bookmarkAllButton_actionPerformed(ActionEvent e) {
        if (!this.validateSearchText()) {
            return;
        }
        this.updateReplaceList();
        this.buttonPressed = (byte)3;
        this.hide();
    }

    private boolean validateSearchText() {
        String searchText = (String)this.findTextField.getEditor().getItem();
        if (searchText == null || searchText.equals("")) {
            JOptionPane.showMessageDialog(this, "Cannot search for a blank regex.", "Search Error", 0);
            return false;
        }
        this.findTextField.removeItem(searchText);
        this.findTextField.insertItemAt(searchText, 0);
        if (this.findTextField.getItemCount() > 5) {
            this.findTextField.removeItemAt(5);
        }
        return true;
    }

    private void updateReplaceList() {
        String replaceText = (String)this.replaceTextField.getEditor().getItem();
        this.replaceTextField.removeItem(replaceText);
        this.replaceTextField.insertItemAt(replaceText, 0);
        if (this.replaceTextField.getItemCount() > 5) {
            this.replaceTextField.removeItemAt(5);
        }
    }

    static {
        CANCEL = 0;
        FIND = 1;
        REPLACE = (byte)2;
        BOOKMARK_ALL = (byte)3;
        MAX_LIST_SIZE = 5;
    }
}

