/*
 * Decompiled with CFR 0.152.
 */
package makedocjr.editor;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import makedocjr.MakeDocJr;
import makedocjr.editor.EncodeOptionsDialog;
import net.onza.op.upswing.utilityfields.FiniteTextField;
import net.onza.op.upswing.utilityfields.SingleLineTextField;

public class EncodeDialog
extends JDialog {
    public static final byte MAX_TITLE_LENGTH = 31;
    JPanel jPanel1 = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel fileLabel = new JLabel();
    SingleLineTextField fileTextfield = new SingleLineTextField();
    JButton browseButton = new JButton();
    JLabel titleLabel = new JLabel();
    FiniteTextField titleTextfield = new FiniteTextField();
    JButton optionsButton = new JButton();
    Component component1;
    Component component4;
    Component component5;
    JButton okButton = new JButton();
    JButton cancelButton = new JButton();
    Component component2;
    MakeDocJr makeDoc;
    JFileChooser jFileChooser;
    String fileName;
    String docTitle;
    boolean okay;

    public EncodeDialog(Frame frame, boolean modal, MakeDocJr makeDoc, JFileChooser jFileChooser) {
        super(frame, modal);
        this.makeDoc = makeDoc;
        this.jFileChooser = jFileChooser;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public EncodeDialog(Dialog dialog, boolean modal, MakeDocJr makeDoc, JFileChooser jFileChooser) {
        super(dialog, modal);
        this.makeDoc = makeDoc;
        this.jFileChooser = jFileChooser;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.titleTextfield.setMaxLength(31);
        this.component1 = Box.createVerticalStrut(8);
        this.component4 = Box.createVerticalStrut(8);
        this.component5 = Box.createHorizontalStrut(8);
        this.component2 = Box.createHorizontalStrut(8);
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.fileLabel.setText("File Name: ");
        this.fileTextfield.setMinimumSize(new Dimension(180, 21));
        this.fileTextfield.setPreferredSize(new Dimension(180, 21));
        this.fileTextfield.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EncodeDialog.this.fileTextfield_actionPerformed(e);
            }
        });
        this.browseButton.setText("Browse...");
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EncodeDialog.this.browseButton_actionPerformed(e);
            }
        });
        this.titleLabel.setText("Title: ");
        this.optionsButton.setText("Options");
        this.optionsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EncodeDialog.this.optionsButton_actionPerformed(e);
            }
        });
        this.titleTextfield.setMinimumSize(new Dimension(180, 21));
        this.titleTextfield.setPreferredSize(new Dimension(180, 21));
        this.titleTextfield.setText(this.makeDoc.getTitle());
        this.titleTextfield.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EncodeDialog.this.titleTextfield_actionPerformed(e);
            }
        });
        this.setTitle("Export");
        this.setModal(true);
        this.okButton.setSelected(true);
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EncodeDialog.this.okButton_actionPerformed(e);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EncodeDialog.this.cancelButton_actionPerformed(e);
            }
        });
        this.jPanel1.setMaximumSize(new Dimension(376, 171));
        this.jPanel1.setMinimumSize(new Dimension(376, 171));
        this.jPanel1.setPreferredSize(new Dimension(376, 171));
        this.jPanel1.add((Component)this.titleTextfield, new GridBagConstraints(1, 3, 3, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.titleLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add(this.component1, new GridBagConstraints(1, 2, 3, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 19, 0), 0, 0));
        this.jPanel1.add(this.component4, new GridBagConstraints(5, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 27, 0), 0, 0));
        this.jPanel1.add(this.component5, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.browseButton, new GridBagConstraints(5, 0, 1, 3, 0.0, 0.0, 12, 0, new Insets(-1, 0, 1, 0), 0, 0));
        this.jPanel1.add((Component)this.fileTextfield, new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0, 15, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.okButton, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 19, 0));
        this.jPanel1.add((Component)this.optionsButton, new GridBagConstraints(5, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add(this.component2, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.cancelButton, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, -1, 0, 1), 0, 0));
        this.jPanel1.add((Component)this.fileLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.jPanel1, "Center");
    }

    void optionsButton_actionPerformed(ActionEvent e) {
        EncodeOptionsDialog eod = new EncodeOptionsDialog(this, true, this.makeDoc);
        eod.pack();
        Dimension dlgSize = eod.getSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        ((Component)eod).setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        ((Component)eod).setVisible(true);
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    void okButton_actionPerformed(ActionEvent e) {
        this.okayAction();
    }

    void browseButton_actionPerformed(ActionEvent e) {
        if (this.jFileChooser.showSaveDialog(this) == 0) {
            this.fileTextfield.setText(this.appendDocExtension(this.jFileChooser.getSelectedFile().getPath()));
            this.repaint();
            if (!this.titleTextfield.getText().equals("")) {
                this.titleTextfield.requestFocus();
            } else {
                this.okButton.requestFocus();
            }
        }
    }

    private void okayAction() {
        if (this.titleTextfield.getText() == null || this.titleTextfield.getText().equals("") || this.fileTextfield.getText() == null || this.fileTextfield.getText().trim().equals("")) {
            return;
        }
        this.fileName = this.appendDocExtension(this.fileTextfield.getText().trim());
        this.docTitle = this.titleTextfield.getText();
        this.okay = true;
        this.hide();
    }

    void titleTextfield_actionPerformed(ActionEvent e) {
        if (this.fileTextfield.getText().equals("")) {
            this.fileTextfield.requestFocus();
        } else {
            this.okayAction();
        }
    }

    void fileTextfield_actionPerformed(ActionEvent e) {
        if (this.titleTextfield.getText().equals("")) {
            this.titleTextfield.requestFocus();
        } else {
            this.okayAction();
        }
    }

    String appendDocExtension(String fileName) {
        if (fileName.toLowerCase().endsWith(".pdb") || fileName.toLowerCase().endsWith(".prc")) {
            return fileName;
        }
        fileName = String.valueOf(String.valueOf(fileName)).concat(".pdb");
        return fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getDocTitle() {
        return this.docTitle;
    }

    public boolean isOkay() {
        return this.okay;
    }

    static {
        MAX_TITLE_LENGTH = (byte)31;
    }
}

