/*
 * Decompiled with CFR 0.152.
 */
package makedocjr;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class RecordIndex {
    public int fileOffset = -1;
    public byte attribute = 0;
    public static final byte PRIVATE = 16;
    public int uniqueID = 0;

    public static int getSize() {
        return 8;
    }

    public void read(DataInput di) throws IOException {
        this.fileOffset = di.readInt();
        this.attribute = di.readByte();
        this.uniqueID = ((0xFF & di.readByte()) << 16) + ((0xFF & di.readByte()) << 8) + (di.readByte() & 0xFF);
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.fileOffset);
        out.write(this.attribute);
        out.write((byte)(this.uniqueID >> 16));
        out.write((byte)(this.uniqueID >> 8));
        out.write((byte)this.uniqueID);
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer(">> Record Index <<\nfileOffset = ").append(this.fileOffset).append("\nattribute = ").append(this.attribute).append("\nuniqueID = ").append(this.uniqueID)));
    }

    static {
        PRIVATE = (byte)16;
    }
}

