/*
 * Decompiled with CFR 0.152.
 */
package makedocjr;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.zip.DataFormatException;
import makedocjr.Bookmark;
import makedocjr.DatabaseHeader;
import makedocjr.DocumentHeader;
import makedocjr.EncodeOptions;
import makedocjr.PilotDocRecord;
import makedocjr.RecordIndex;

public class MakeDocJr
implements Cloneable {
    static int eolType;
    static final byte[] CRLF;
    static final byte[] CR;
    static final byte[] LF;
    private EncodeOptions encodeOptions;
    private String title = null;
    private byte[] textArray = null;
    private ArrayList bookmarks = new ArrayList();

    public MakeDocJr() {
        String eol = System.getProperty("line.separator");
        eolType = Arrays.equals(eol.getBytes(), CRLF) ? 3 : (Arrays.equals(eol.getBytes(), CR) ? 2 : 1);
        this.encodeOptions = new EncodeOptions();
    }

    public MakeDocJr(EncodeOptions encodeOptions) {
        String eol = System.getProperty("line.separator");
        eolType = Arrays.equals(eol.getBytes(), CRLF) ? 3 : (Arrays.equals(eol.getBytes(), CR) ? 2 : 1);
        this.encodeOptions = encodeOptions;
    }

    public void decode(File source) throws DataFormatException, FileNotFoundException, IOException {
        boolean compressed;
        RandomAccessFile fin = new RandomAccessFile(source, "r");
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DatabaseHeader dbHeader = new DatabaseHeader();
        try {
            dbHeader.read(fin);
        }
        catch (DataFormatException dfe) {
            throw new DataFormatException(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(source.getName()))).append(" is not a ").append("supported file format."))));
        }
        if (dbHeader.creatorID != 1380270436 && dbHeader.creatorID != 1416381539 || dbHeader.typeID != 1413830772) {
            try {
                fin.close();
                bout.close();
            }
            catch (IOException dfe) {
                // empty catch block
            }
            throw new DataFormatException(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(source.getName()))).append(" is not a ").append("supported file format."))));
        }
        this.encodeOptions.docID = dbHeader.creatorID;
        RecordIndex[] ri = new RecordIndex[dbHeader.numRecords];
        for (int i = 0; i < dbHeader.numRecords; ++i) {
            ri[i] = new RecordIndex();
            ri[i].read(fin);
        }
        byte privateAttribute = (byte)(ri[0].attribute & 0x10);
        this.encodeOptions.makePrivate = privateAttribute == 16;
        this.encodeOptions.category = (byte)(ri[0].attribute & 0xF);
        DocumentHeader docHeader = new DocumentHeader();
        fin.seek(ri[0].fileOffset);
        docHeader.read(fin);
        this.encodeOptions.compress = compressed = docHeader.version == 2;
        for (int i = 1; i <= docHeader.numRecords; ++i) {
            int dwRecLen = i == ri.length - 1 ? (int)fin.length() - ri[i].fileOffset : ri[i + 1].fileOffset - ri[i].fileOffset;
            fin.seek(ri[i].fileOffset);
            PilotDocRecord textBuffer = new PilotDocRecord(dwRecLen);
            fin.read(textBuffer.buf);
            if (compressed) {
                textBuffer.decompress();
            }
            if (eolType != 1) {
                textBuffer.convertEOL(eolType);
            }
            bout.write(textBuffer.buf);
        }
        this.textArray = bout.toByteArray();
        try {
            bout.close();
        }
        catch (IOException i) {
            // empty catch block
        }
        this.title = dbHeader.name;
        this.bookmarks.clear();
        if (docHeader.numRecords + 1 < dbHeader.numRecords) {
            for (int i = docHeader.numRecords + 1; i < dbHeader.numRecords; ++i) {
                Bookmark bm = new Bookmark();
                fin.seek(ri[i].fileOffset);
                bm.read(fin);
                this.bookmarks.add(bm);
            }
        }
        try {
            fin.close();
        }
        catch (IOException iOException) {}
    }

    public void encode(File destinationFile) throws IOException {
        boolean processBookmarks = false;
        boolean deletePilotDoc = false;
        PilotDocRecord textBuffer = null;
        RandomAccessFile fout = null;
        DocumentHeader docHeader = new DocumentHeader();
        int attribute = 0;
        if (this.encodeOptions.makePrivate) {
            attribute = (byte)(attribute | 0x10);
        }
        docHeader.storyLen = this.textArray.length;
        textBuffer = new PilotDocRecord(docHeader.storyLen);
        textBuffer.buf = this.textArray;
        destinationFile.delete();
        fout = new RandomAccessFile(destinationFile, "rw");
        docHeader.storyLen = textBuffer.convertEOL();
        if (this.encodeOptions.unwrap) {
            docHeader.storyLen = textBuffer.unwrap(this.encodeOptions.lineLength);
        }
        if (this.encodeOptions.compressEOL) {
            docHeader.storyLen = textBuffer.compressEOL();
        }
        byte[] uncompressedBuffer = new byte[textBuffer.length()];
        System.arraycopy(textBuffer.buf, 0, uncompressedBuffer, 0, textBuffer.length());
        String uncompressedText = new String(uncompressedBuffer);
        if (this.bookmarks.size() > 0) {
            processBookmarks = true;
        }
        if (this.encodeOptions.autoBookmark != null) {
            processBookmarks = true;
            int found = 0;
            while ((found = uncompressedText.indexOf(this.encodeOptions.autoBookmark, found)) > 0) {
                if (uncompressedText.charAt(found - 1) == '\n') {
                    int curCharPos;
                    Bookmark bm = new Bookmark();
                    bm.setFileOffset(found);
                    for (curCharPos = found += this.encodeOptions.autoBookmark.length(); curCharPos < uncompressedText.length(); ++curCharPos) {
                        if (uncompressedText.charAt(curCharPos) != '\n') continue;
                        while (Character.isWhitespace(uncompressedText.charAt(found))) {
                            ++found;
                        }
                        bm.setName(uncompressedText.substring(found, curCharPos));
                        this.bookmarks.add(bm);
                        break;
                    }
                    found = curCharPos;
                    continue;
                }
                ++found;
            }
        }
        DatabaseHeader dbHeader = new DatabaseHeader();
        dbHeader.name = this.title;
        dbHeader.setModificationDate();
        dbHeader.creatorID = this.encodeOptions.docID;
        dbHeader.typeID = 1413830772;
        docHeader.version = (short)(this.encodeOptions.compress ? 2 : 1);
        docHeader.recordSize = (short)4096;
        docHeader.numRecords = (short)(docHeader.storyLen / 4096);
        if (docHeader.numRecords * 4096 < docHeader.storyLen) {
            docHeader.numRecords = (short)(docHeader.numRecords + 1);
        }
        dbHeader.numRecords = processBookmarks ? (short)(docHeader.numRecords + 1 + this.bookmarks.size()) : (short)(docHeader.numRecords + 1);
        dbHeader.write(fout);
        int bookMarkIndex = docHeader.numRecords + 1;
        RecordIndex[] ri = new RecordIndex[dbHeader.numRecords];
        ri[0] = new RecordIndex();
        ri[0].attribute = (byte)(attribute | this.encodeOptions.category);
        ri[0].write(fout);
        for (int i = 1; i < dbHeader.numRecords; ++i) {
            ri[i] = new RecordIndex();
            ri[i].fileOffset = 0;
            ri[i].write(fout);
        }
        ri[0].fileOffset = (int)fout.getFilePointer();
        docHeader.write(fout);
        int totalCompressedBytes = 0;
        int processed = 0;
        int compressed = 0;
        int original = 0;
        for (int recNum = 1; recNum <= docHeader.numRecords; ++recNum) {
            ri[recNum].fileOffset = (int)fout.getFilePointer();
            original = docHeader.recordSize;
            if (original + processed > uncompressedBuffer.length) {
                original = uncompressedBuffer.length - processed;
            }
            textBuffer.assign(uncompressedBuffer, original, processed);
            processed += original;
            if (this.encodeOptions.compress) {
                compressed = textBuffer.compress();
                totalCompressedBytes += compressed;
            }
            fout.write(textBuffer.buf);
        }
        if (processBookmarks) {
            if (this.encodeOptions.sortBookmarks == 1) {
                this.sortBookmarksByLocation();
            } else if (this.encodeOptions.sortBookmarks == 2) {
                this.sortBookmarksByName();
            }
            for (int bm = 0; bm < this.bookmarks.size(); ++bm) {
                if (((Bookmark)this.bookmarks.get(bm)).getFileOffset() == -1) {
                    deletePilotDoc = true;
                    continue;
                }
                ri[bookMarkIndex + bm].fileOffset = (int)fout.getFilePointer();
                ((Bookmark)this.bookmarks.get(bm)).write(fout);
            }
        }
        fout.seek(DatabaseHeader.getSize());
        for (int i = 0; i < ri.length; ++i) {
            ri[i].write(fout);
        }
        fout.close();
        if (deletePilotDoc) {
            destinationFile.delete();
        }
    }

    public EncodeOptions getEncodeOptions() {
        return this.encodeOptions;
    }

    public void setEncodeOptions(EncodeOptions encodeOptions) {
        this.encodeOptions = encodeOptions;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title.length() > 31 ? title.substring(0, 31) : title;
    }

    public String getText() {
        return new String(this.textArray);
    }

    public void setText(String text) {
        this.textArray = text.getBytes();
    }

    public void setText(String text, String encoding) throws UnsupportedEncodingException {
        this.textArray = text.getBytes(encoding);
    }

    public byte[] getTextArray() {
        return this.textArray;
    }

    public void setText(byte[] textArray) {
        this.textArray = textArray;
    }

    public void addBookmark(Bookmark bm) {
        this.bookmarks.add(bm);
    }

    public void removeBookmark(Bookmark bm) {
        ((AbstractCollection)this.bookmarks).remove(bm);
    }

    public ArrayList getBookmarks() {
        return this.bookmarks;
    }

    public void setBookmarks(ArrayList bookmarks) {
        if (bookmarks == null) {
            this.bookmarks.clear();
        } else {
            this.bookmarks = bookmarks;
        }
    }

    public void sortBookmarksByLocation() {
        for (int i = 0; i < this.bookmarks.size(); ++i) {
            ((Bookmark)this.bookmarks.get(i)).setCompareNamesNotLocation(false);
        }
        Collections.sort(this.bookmarks);
    }

    public void sortBookmarksByName() {
        for (int i = 0; i < this.bookmarks.size(); ++i) {
            ((Bookmark)this.bookmarks.get(i)).setCompareNamesNotLocation(true);
        }
        Collections.sort(this.bookmarks);
    }

    public boolean bookmarkNameExists(String bookmarkName) {
        if (this.bookmarks == null) {
            return false;
        }
        for (int i = 0; i < this.bookmarks.size(); ++i) {
            if (!bookmarkName.equals(((Bookmark)this.bookmarks.get(i)).getName())) continue;
            return true;
        }
        return false;
    }

    public static int getEolType() {
        return eolType;
    }

    public Object clone() {
        MakeDocJr mdj = new MakeDocJr();
        if (this.textArray != null) {
            mdj.textArray = (byte[])this.textArray.clone();
        }
        for (int i = 0; i < this.bookmarks.size(); ++i) {
            mdj.addBookmark(new Bookmark((Bookmark)this.bookmarks.get(i)));
        }
        mdj.encodeOptions = (EncodeOptions)this.encodeOptions.clone();
        return mdj;
    }

    static {
        CRLF = new byte[]{13, 10};
        CR = new byte[]{13};
        LF = new byte[]{10};
    }
}

