/*
 * Decompiled with CFR 0.152.
 */
package makedocjr;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.zip.DataFormatException;

public class DatabaseHeader {
    public static final int TealDocID = 1416381539;
    public static final int ReaderID = 1380270436;
    public static final int TEXt = 1413830772;
    public String name = "";
    public short attribute = 0;
    public short version = 0;
    public int creationDate = 0;
    public int modificationDate = 0;
    public int lastBackupDate = 0;
    public int modificationNumber = 0;
    public int appInfoID = 0;
    public int sortInfoID = 0;
    public int typeID = 0;
    public int creatorID = 0;
    public int uniqueIDSeed = 0;
    public int nextRecordListID = 0;
    public short numRecords = 0;
    private static final long SecondsSince1904 = 2082844800L;

    DatabaseHeader() {
        Calendar cl = Calendar.getInstance();
        Date now = new Date();
        this.modificationDate = this.creationDate = (int)((now.getTime() + (long)cl.get(15) + (long)cl.get(16)) / (long)1000 + 2082844800L);
    }

    public static int getSize() {
        return 78;
    }

    public void read(DataInput di) throws DataFormatException, IOException {
        byte[] b = new byte[32];
        di.readFully(b);
        this.name = new String(b);
        int i = this.name.indexOf(0);
        if (i == -1) {
            throw new DataFormatException();
        }
        this.name = this.name.substring(0, i);
        this.attribute = di.readShort();
        this.version = di.readShort();
        this.creationDate = di.readInt();
        this.modificationDate = di.readInt();
        this.lastBackupDate = di.readInt();
        this.modificationNumber = di.readInt();
        this.appInfoID = di.readInt();
        this.sortInfoID = di.readInt();
        this.typeID = di.readInt();
        this.creatorID = di.readInt();
        this.uniqueIDSeed = di.readInt();
        this.nextRecordListID = di.readInt();
        this.numRecords = di.readShort();
    }

    public void write(DataOutput out) throws IOException {
        byte[] b = new byte[32];
        b[b.length - 1] = 0;
        byte[] bName = this.name.getBytes();
        for (int x = 0; x < b.length - 1; ++x) {
            b[x] = x < bName.length ? bName[x] : (byte)0;
        }
        if (bName.length >= b.length) {
            b[b.length - 2] = 46;
            b[b.length - 3] = 46;
            b[b.length - 4] = 46;
        }
        out.write(b);
        out.writeShort(this.attribute);
        out.writeShort(this.version);
        out.writeInt(this.creationDate);
        out.writeInt(this.modificationDate);
        out.writeInt(this.lastBackupDate);
        out.writeInt(this.modificationNumber);
        out.writeInt(this.appInfoID);
        out.writeInt(this.sortInfoID);
        out.writeInt(this.typeID);
        out.writeInt(this.creatorID);
        out.writeInt(this.uniqueIDSeed);
        out.writeInt(this.nextRecordListID);
        out.writeShort(this.numRecords);
    }

    public String toString() {
        char[] creatorIDa = new char[]{(char)(this.creatorID >> 24 & 0xFF), (char)(this.creatorID >> 16 & 0xFF), (char)(this.creatorID >> 8 & 0xFF), (char)(this.creatorID & 0xFF)};
        char[] typeIDa = new char[]{(char)(this.typeID >> 24 & 0xFF), (char)(this.typeID >> 16 & 0xFF), (char)(this.typeID >> 8 & 0xFF), (char)(this.typeID & 0xFF)};
        return String.valueOf(String.valueOf(new StringBuffer(">> DatabaseHeader <<\nname = `").append(this.name).append("`").append("\nattribute = ").append(this.attribute).append("\nversion = ").append(this.version).append("\ncreationDate = ").append(this.creationDate).append("\nmodificationDate = ").append(this.modificationDate).append("\nlastBackupDate = ").append(this.lastBackupDate).append("\nmodificationNumber = ").append(this.modificationNumber).append("\nappInfoID = ").append(this.appInfoID).append("\nsortInfoID = ").append(this.sortInfoID).append("\ntypeID = ").append(this.typeID).append(" 0x").append(Integer.toHexString(this.typeID)).append(" `").append(new String(typeIDa)).append("`").append("\ncreatorID = ").append(this.creatorID).append(" 0x").append(Integer.toHexString(this.creatorID)).append(" `").append(new String(creatorIDa)).append("`").append("\nuniqueIDSeed = ").append(this.uniqueIDSeed).append("\nnextRecordListID = ").append(this.nextRecordListID).append("\nnumRecords = ").append(this.numRecords)));
    }

    public void setModificationDate() {
        Calendar cl = Calendar.getInstance();
        Date now = new Date();
        this.modificationDate = (int)((now.getTime() + (long)cl.get(15) + (long)cl.get(16)) / (long)1000 + 2082844800L);
    }

    public Date getModificationDate() {
        Calendar cl = Calendar.getInstance();
        long temp = new Integer(this.modificationDate).longValue();
        if (temp < (long)0) {
            temp += 0x100000000L;
        }
        return new Date((temp - 2082844800L) * (long)1000 - (long)cl.get(15) - (long)cl.get(16));
    }

    public Date getCreationDate() {
        Calendar cl = Calendar.getInstance();
        long temp = new Integer(this.creationDate).longValue();
        if (temp < (long)0) {
            temp += 0x100000000L;
        }
        return new Date((temp - 2082844800L) * (long)1000 - (long)cl.get(15) - (long)cl.get(16));
    }

    public static int convertStringToTypeID(String typeID) {
        byte[] typeIDa = typeID.getBytes();
        return ((0xFF & typeIDa[0]) << 24) + ((0xFF & typeIDa[1]) << 16) + ((0xFF & typeIDa[2]) << 8) + (0xFF & typeIDa[3]);
    }

    public static String convertIntToStringTypeID(int typeID) {
        char[] typeIDa = new char[]{(char)(typeID >> 24 & 0xFF), (char)(typeID >> 16 & 0xFF), (char)(typeID >> 8 & 0xFF), (char)(typeID & 0xFF)};
        return new String(typeIDa);
    }

    public static int convertStringToCreatorID(String creatorID) {
        byte[] creatorIDa = creatorID.getBytes();
        return ((0xFF & creatorIDa[0]) << 24) + ((0xFF & creatorIDa[1]) << 16) + ((0xFF & creatorIDa[2]) << 8) + (0xFF & creatorIDa[3]);
    }

    public static String convertIntToStringCreatorID(int creatorID) {
        char[] creatorIDa = new char[]{(char)(creatorID >> 24 & 0xFF), (char)(creatorID >> 16 & 0xFF), (char)(creatorID >> 8 & 0xFF), (char)(creatorID & 0xFF)};
        return new String(creatorIDa);
    }

    static {
        TealDocID = 1416381539;
        ReaderID = 1380270436;
        TEXt = 1413830772;
        SecondsSince1904 = 2082844800L;
    }
}

