/*
 * Decompiled with CFR 0.152.
 */
package makedocjr;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.swing.text.Position;

public class Bookmark
implements Comparable {
    private String name = "";
    private int fileOffset = -1;
    private boolean compareNamesNotLocation = false;
    private Position position;

    public Bookmark() {
    }

    public Bookmark(Bookmark bmk) {
        this.name = bmk.name;
        this.position = bmk.position;
        this.fileOffset = bmk.fileOffset;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getFileOffset() {
        if (this.position != null) {
            this.fileOffset = this.position.getOffset();
        }
        return this.fileOffset;
    }

    public void setFileOffset(int fileOffset) {
        this.fileOffset = fileOffset;
    }

    public static int getSize() {
        return 20;
    }

    public void read(DataInput di) throws IOException {
        byte[] b = new byte[16];
        di.readFully(b);
        this.name = new String(b);
        int i = this.name.indexOf(0);
        if (i >= 0) {
            this.name = this.name.substring(0, i);
        }
        this.fileOffset = di.readInt();
    }

    public void write(DataOutput out) throws IOException {
        byte[] b = new byte[16];
        byte[] bName = this.name.getBytes();
        for (int x = 0; x < b.length; ++x) {
            b[x] = x < bName.length ? bName[x] : (byte)0;
        }
        out.write(b);
        if (this.position != null) {
            this.fileOffset = this.position.getOffset();
        }
        out.writeInt(this.fileOffset);
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer(">> Bookmark <<\nname = `").append(this.name).append("`\nfileOffset = ").append(this.fileOffset)));
    }

    void setCompareNamesNotLocation(boolean compareNamesNotLocation) {
        this.compareNamesNotLocation = compareNamesNotLocation;
    }

    public int compareTo(Object o) {
        Bookmark bm = (Bookmark)o;
        if (!this.compareNamesNotLocation) {
            return this.getFileOffset() < bm.getFileOffset() ? -1 : (this.getFileOffset() == bm.getFileOffset() ? 0 : 1);
        }
        return this.name.toLowerCase().compareTo(bm.name.toLowerCase());
    }

    public void setPosition(Position position) {
        this.position = position;
    }
}

