/*
 * Decompiled with CFR 0.152.
 */
package net.onza.op.upswing.utilityfields;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public final class SingleLineTextField
extends JTextField {
    public SingleLineTextField() {
    }

    public SingleLineTextField(int cols) {
        super(cols);
    }

    public SingleLineTextField(String text) {
        super(text);
    }

    public SingleLineTextField(String text, int columns) {
        super(text, columns);
    }

    protected Document createDefaultModel() {
        return new SingleLineDocument();
    }

    static class SingleLineDocument
    extends PlainDocument {
        SingleLineDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            char[] textToInsert = str.toCharArray();
            int insertLength = textToInsert.length;
            char[] temp = new char[insertLength];
            int i = 0;
            while (i < insertLength) {
                temp[i] = textToInsert[i];
                if (temp[i] == '\n') {
                    temp[i] = 32;
                }
                ++i;
            }
            char[] textWillInsert = new char[insertLength];
            System.arraycopy(temp, 0, textWillInsert, 0, insertLength);
            super.insertString(offs, new String(textWillInsert), a);
        }
    }
}

