/*
 * Decompiled with CFR 0.152.
 */
package net.onza.op.upswing.utilityfields;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public final class DigitsOnlyTextField
extends JTextField {
    public DigitsOnlyTextField() {
    }

    public DigitsOnlyTextField(int cols) {
        super(cols);
    }

    public DigitsOnlyTextField(String text) {
        super(text);
    }

    public DigitsOnlyTextField(String text, int columns) {
        super(text, columns);
    }

    public void setMaxDigits(int maxDigits) {
        if (maxDigits < 0) {
            return;
        }
        DigitsOnlyDocument.maxDigits = maxDigits;
    }

    public int getMaxDigits() {
        return DigitsOnlyDocument.maxDigits;
    }

    protected Document createDefaultModel() {
        return new DigitsOnlyDocument();
    }

    static class DigitsOnlyDocument
    extends PlainDocument {
        static int maxDigits;

        DigitsOnlyDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (maxDigits > 0 && offs >= maxDigits) {
                return;
            }
            char[] numbers = str.toCharArray();
            char[] numbersOnly = new char[numbers.length];
            int j = 0;
            int i = 0;
            while (i < numbers.length) {
                numbersOnly[j] = numbers[i];
                if (!Character.isDigit(numbers[i])) {
                    --j;
                }
                ++i;
                ++j;
            }
            int totalDigits = offs + j;
            if (maxDigits != 0) {
                j = totalDigits > maxDigits ? maxDigits - offs : j;
            }
            char[] temp = new char[j];
            System.arraycopy(numbersOnly, 0, temp, 0, j);
            super.insertString(offs, new String(temp), a);
        }
    }
}

