/*
 * Decompiled with CFR 0.152.
 */
package makedocjr.editor;

import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REMatch;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.DataFormatException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.undo.UndoManager;
import makedocjr.Bookmark;
import makedocjr.EncodeOptions;
import makedocjr.MakeDocJr;
import makedocjr.editor.BookmarksDialog;
import makedocjr.editor.ConfirmReplaceDialog;
import makedocjr.editor.DocFileFilter;
import makedocjr.editor.EncodeDialog;
import makedocjr.editor.EncodeOptionsDialog;
import makedocjr.editor.FindReplaceDialog;
import makedocjr.editor.MakeDocJrEditorFrame_AboutBox;
import makedocjr.editor.Preferences;
import makedocjr.editor.PreferencesDialog;
import net.onza.op.upswing.textdrag.JDraggableTextArea;

public class MakeDocJrEditorFrame
extends JFrame {
    private static final int NUMBER_OF_FILES = 5;
    private static final int NUMBER_OF_SEARCHES = 5;
    private static final String PROPERTY_FILE = "makedocjr.properties";
    private static final byte REFRESHED_TEXT = 0;
    private static final byte REFRESHED_DOC = 1;
    static final String ENCODE_OPTIONS = "eoptions.ser";
    JPanel contentPane;
    JMenuBar jMenuBar = new JMenuBar();
    JMenu jMenuFile = new JMenu();
    JMenuItem jMenuFileExit = new JMenuItem();
    JMenu jMenuHelp = new JMenu();
    JMenuItem jMenuHelpAbout = new JMenuItem();
    JToolBar jToolBar = new JToolBar();
    JButton newButton = new JButton();
    JButton saveButton = new JButton();
    JButton helpButton = new JButton();
    ImageIcon newImage;
    ImageIcon saveImage;
    ImageIcon helpImage;
    ImageIcon openImage;
    ImageIcon decodeImage;
    ImageIcon encodeImage;
    ImageIcon cutImage;
    ImageIcon copyImage;
    ImageIcon pasteImage;
    ImageIcon blankImage;
    ImageIcon bookmarkImage;
    ImageIcon webImage;
    ImageIcon undoImage;
    BorderLayout borderLayout1 = new BorderLayout();
    JScrollPane jScrollPane = new JScrollPane();
    JDraggableTextArea jTextArea = new JDraggableTextArea();
    JMenuItem jMenuNew = new JMenuItem();
    JMenuItem jMenuOpen = new JMenuItem();
    JMenuItem jMenuSave = new JMenuItem();
    JMenuItem jMenuSaveAs = new JMenuItem();
    JMenuItem jMenuImport = new JMenuItem();
    JMenuItem jMenuExport = new JMenuItem();
    JMenu jMenuEdit = new JMenu();
    JMenuItem jMenuCut = new JMenuItem();
    JMenuItem jMenuCopy = new JMenuItem();
    JMenuItem jMenuPaste = new JMenuItem();
    JMenuItem jMenuSelectAll = new JMenuItem();
    JMenu jMenuOptions = new JMenu();
    JButton openButton = new JButton();
    JButton decodeButton = new JButton();
    JButton encodeButton = new JButton();
    Component component2;
    Component component1;
    Component component3;
    JButton cutButton = new JButton();
    JButton copyButton = new JButton();
    JButton pasteButton = new JButton();
    Component component4;
    Component component5;
    JPopupMenu jPopupMenu = new JPopupMenu();
    JMenuItem jPopCut = new JMenuItem();
    JMenuItem jPopCopy = new JMenuItem();
    JMenuItem jPopPaste = new JMenuItem();
    JMenuItem jPopSelectAll = new JMenuItem();
    String lastPath = File.separator;
    String currFileName = null;
    String currDocName = null;
    String proposedDocName = null;
    String proposedFileName = null;
    boolean dirty = false;
    JFileChooser jFileChooser;
    Document document;
    MakeDocJr makeDoc;
    JMenuItem jMenuExportAs = new JMenuItem();
    JButton bookmarkButton = new JButton();
    Component component6;
    JMenu jMenuBookmark = new JMenu();
    JMenuItem jMenuBookmarkAdd = new JMenuItem();
    JMenuItem jMenuBookmarkEdit = new JMenuItem();
    JMenuItem jMenuBookmarkAuto = new JMenuItem();
    JMenuItem jMenuPreferences = new JMenuItem();
    JButton webButton = new JButton();
    Component component7;
    JMenuItem jMenuExportOptions = new JMenuItem();
    JCheckBoxMenuItem jMenuWrap = new JCheckBoxMenuItem();
    Preferences preferences;
    DocFileFilter docFileFilter = new DocFileFilter();
    JMenuItem jMenuUndo = new JMenuItem();
    JMenuItem jMenuRedo = new JMenuItem();
    UndoManager undoManager = new UndoManager();
    JMenu jMenuReopen = new JMenu();
    JMenu jMenuReimport = new JMenu();
    JMenuItem jMenuSubDoc;
    JMenuItem jMenuSubText;
    Vector textpaths = new Vector();
    Vector docpaths = new Vector();
    JPanel jPanelStatus = new JPanel();
    JLabel statusBar = new JLabel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel colStatus = new JLabel();
    JLabel rowStatus = new JLabel();
    JMenu jMenuTools = new JMenu();
    JMenuItem jMenuWordCount = new JMenuItem();
    JMenuItem jMenuWeb = new JMenuItem();
    JButton undoButton = new JButton();
    String searchText;
    String replacementText;
    boolean ignoreCase;
    boolean searchFromTop;
    boolean searchSelectedTextOnly;
    boolean newSearch;
    int selectionStart;
    int selectionEnd;
    byte buttonPressed;
    RE re;
    REMatch rem;
    JMenuItem jMenuFindReplace = new JMenuItem();
    JMenuItem jMenuFindAgain = new JMenuItem();
    ConfirmReplaceDialog crd;
    JMenuItem jMenuHelpHelp = new JMenuItem();
    FindReplaceDialog frd = new FindReplaceDialog((Frame)this, true);
    static Class class$makedocjr$editor$MakeDocJrEditorFrame;

    public MakeDocJrEditorFrame(String fileName) {
        this.enableEvents(64L);
        try {
            FileInputStream fis = new FileInputStream("prefs.ser");
            ObjectInputStream ois = new ObjectInputStream(fis);
            this.preferences = (Preferences)ois.readObject();
            ois.close();
            fis.close();
        }
        catch (Exception e) {
            this.preferences = new Preferences();
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!fileName.equals("")) {
            if (fileName.length() > 4 && (fileName.toLowerCase().endsWith(".pdb") || fileName.toLowerCase().endsWith(".prc"))) {
                this.decode(new File(fileName));
            } else {
                this.openFile(fileName);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean jbInit() throws Exception {
        FileInputStream fis;
        block7: {
            this.newImage = new ImageIcon((class$makedocjr$editor$MakeDocJrEditorFrame == null ? (class$makedocjr$editor$MakeDocJrEditorFrame = MakeDocJrEditorFrame.class$("makedocjr.editor.MakeDocJrEditorFrame")) : class$makedocjr$editor$MakeDocJrEditorFrame).getResource("new.gif"));
            this.saveImage = new ImageIcon((class$makedocjr$editor$MakeDocJrEditorFrame == null ? (class$makedocjr$editor$MakeDocJrEditorFrame = MakeDocJrEditorFrame.class$("makedocjr.editor.MakeDocJrEditorFrame")) : class$makedocjr$editor$MakeDocJrEditorFrame).getResource("save.gif"));
            this.helpImage = new ImageIcon((class$makedocjr$editor$MakeDocJrEditorFrame == null ? (class$makedocjr$editor$MakeDocJrEditorFrame = MakeDocJrEditorFrame.class$("makedocjr.editor.MakeDocJrEditorFrame")) : class$makedocjr$editor$MakeDocJrEditorFrame).getResource("help.gif"));
            this.openImage = new ImageIcon((class$makedocjr$editor$MakeDocJrEditorFrame == null ? (class$makedocjr$editor$MakeDocJrEditorFrame = MakeDocJrEditorFrame.class$("makedocjr.editor.MakeDocJrEditorFrame")) : class$makedocjr$editor$MakeDocJrEditorFrame).getResource("open.gif"));
            this.decodeImage = new ImageIcon((class$makedocjr$editor$MakeDocJrEditorFrame == null ? (class$makedocjr$editor$MakeDocJrEditorFrame = MakeDocJrEditorFrame.class$("makedocjr.editor.MakeDocJrEditorFrame")) : class$makedocjr$editor$MakeDocJrEditorFrame).getResource("pdatopc.gif"));
            this.encodeImage = new ImageIcon((class$makedocjr$editor$MakeDocJrEditorFrame == null ? (class$makedocjr$editor$MakeDocJrEditorFrame = MakeDocJrEditorFrame.class$("makedocjr.editor.MakeDocJrEditorFrame")) : class$makedocjr$editor$MakeDocJrEditorFrame).getResource("pctopda.gif"));
            this.cutImage = new ImageIcon((class$makedocjr$editor$MakeDocJrEditorFrame == null ? (class$makedocjr$editor$MakeDocJrEditorFrame = MakeDocJrEditorFrame.class$("makedocjr.editor.MakeDocJrEditorFrame")) : class$makedocjr$editor$MakeDocJrEditorFrame).getResource("cut.gif"));
            this.copyImage = new ImageIcon((class$makedocjr$editor$MakeDocJrEditorFrame == null ? (class$makedocjr$editor$MakeDocJrEditorFrame = MakeDocJrEditorFrame.class$("makedocjr.editor.MakeDocJrEditorFrame")) : class$makedocjr$editor$MakeDocJrEditorFrame).getResource("copy.gif"));
            this.pasteImage = new ImageIcon((class$makedocjr$editor$MakeDocJrEditorFrame == null ? (class$makedocjr$editor$MakeDocJrEditorFrame = MakeDocJrEditorFrame.class$("makedocjr.editor.MakeDocJrEditorFrame")) : class$makedocjr$editor$MakeDocJrEditorFrame).getResource("paste.gif"));
            this.blankImage = new ImageIcon((class$makedocjr$editor$MakeDocJrEditorFrame == null ? (class$makedocjr$editor$MakeDocJrEditorFrame = MakeDocJrEditorFrame.class$("makedocjr.editor.MakeDocJrEditorFrame")) : class$makedocjr$editor$MakeDocJrEditorFrame).getResource("blank.gif"));
            this.bookmarkImage = new ImageIcon((class$makedocjr$editor$MakeDocJrEditorFrame == null ? (class$makedocjr$editor$MakeDocJrEditorFrame = MakeDocJrEditorFrame.class$("makedocjr.editor.MakeDocJrEditorFrame")) : class$makedocjr$editor$MakeDocJrEditorFrame).getResource("bookmark.gif"));
            this.webImage = new ImageIcon((class$makedocjr$editor$MakeDocJrEditorFrame == null ? (class$makedocjr$editor$MakeDocJrEditorFrame = MakeDocJrEditorFrame.class$("makedocjr.editor.MakeDocJrEditorFrame")) : class$makedocjr$editor$MakeDocJrEditorFrame).getResource("web.gif"));
            this.undoImage = new ImageIcon((class$makedocjr$editor$MakeDocJrEditorFrame == null ? (class$makedocjr$editor$MakeDocJrEditorFrame = MakeDocJrEditorFrame.class$("makedocjr.editor.MakeDocJrEditorFrame")) : class$makedocjr$editor$MakeDocJrEditorFrame).getResource("undo.gif"));
            this.contentPane = (JPanel)this.getContentPane();
            this.component2 = Box.createVerticalStrut(8);
            this.component1 = Box.createHorizontalStrut(8);
            this.component3 = Box.createHorizontalStrut(8);
            this.component4 = Box.createHorizontalStrut(8);
            this.component5 = Box.createHorizontalStrut(8);
            this.document = this.jTextArea.getDocument();
            this.component6 = Box.createHorizontalStrut(8);
            this.component7 = Box.createHorizontalStrut(8);
            this.contentPane.setLayout(this.borderLayout1);
            this.setDefaultCloseOperation(0);
            ((Component)this).setSize(new Dimension(400, 300));
            this.setTitle("MakeDocJr Editor");
            this.addWindowListener(new WindowAdapter(){

                public void windowOpened(WindowEvent e) {
                    MakeDocJrEditorFrame.this.this_windowOpened(e);
                }
            });
            this.jMenuFile.setText("File");
            this.jMenuFileExit.setIcon(this.blankImage);
            this.jMenuFileExit.setText("Exit");
            this.jMenuFileExit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.jMenuFileExit_actionPerformed(e);
                }
            });
            this.jMenuHelp.setText("Help");
            this.jMenuHelpAbout.setText("About");
            this.jMenuHelpAbout.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.jMenuHelpAbout_actionPerformed(e);
                }
            });
            this.newButton.setIcon(this.newImage);
            this.newButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.newButton_actionPerformed(e);
                }
            });
            this.newButton.setMaximumSize(new Dimension(51, 27));
            this.newButton.setMinimumSize(new Dimension(27, 27));
            this.newButton.setPreferredSize(new Dimension(32, 27));
            this.newButton.setToolTipText("New");
            this.saveButton.setIcon(this.saveImage);
            this.saveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.saveButton_actionPerformed(e);
                }
            });
            this.saveButton.setMinimumSize(new Dimension(27, 27));
            this.saveButton.setPreferredSize(new Dimension(32, 27));
            this.saveButton.setToolTipText("Save");
            this.helpButton.setMinimumSize(new Dimension(27, 27));
            this.helpButton.setPreferredSize(new Dimension(32, 27));
            this.helpButton.setToolTipText("About");
            this.helpButton.setIcon(this.helpImage);
            this.helpButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.helpButton_actionPerformed(e);
                }
            });
            this.jTextArea.setBorder(new EmptyBorder(1, 4, 2, 4));
            this.jTextArea.setLineWrap(true);
            this.jTextArea.setWrapStyleWord(true);
            this.jTextArea.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    MakeDocJrEditorFrame.this.jTextArea_caretUpdate(e);
                }
            });
            this.jTextArea.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    MakeDocJrEditorFrame.this.jTextArea_mousePressed(e);
                }

                public void mouseReleased(MouseEvent e) {
                    MakeDocJrEditorFrame.this.jTextArea_mouseReleased(e);
                }
            });
            this.jMenuNew.setIcon(this.newImage);
            this.jMenuNew.setText("New");
            this.jMenuNew.setAccelerator(KeyStroke.getKeyStroke(78, 2, false));
            this.jMenuNew.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.jMenuNew_actionPerformed(e);
                }
            });
            this.jMenuOpen.setIcon(this.openImage);
            this.jMenuOpen.setText("Open");
            this.jMenuOpen.setAccelerator(KeyStroke.getKeyStroke(79, 2, false));
            this.jMenuOpen.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.jMenuOpen_actionPerformed(e);
                }
            });
            this.jMenuSave.setIcon(this.saveImage);
            this.jMenuSave.setText("Save");
            this.jMenuSave.setAccelerator(KeyStroke.getKeyStroke(83, 2, false));
            this.jMenuSave.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.jMenuSave_actionPerformed(e);
                }
            });
            this.jMenuSaveAs.setIcon(this.blankImage);
            this.jMenuSaveAs.setText("Save As...");
            this.jMenuSaveAs.setAccelerator(KeyStroke.getKeyStroke(83, 3, false));
            this.jMenuSaveAs.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.jMenuSaveAs_actionPerformed(e);
                }
            });
            this.jMenuImport.setIcon(this.decodeImage);
            this.jMenuImport.setText("Import");
            this.jMenuImport.setAccelerator(KeyStroke.getKeyStroke(68, 2, false));
            this.jMenuImport.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.jMenuImport_actionPerformed(e);
                }
            });
            this.jMenuExport.setIcon(this.encodeImage);
            this.jMenuExport.setText("Export");
            this.jMenuExport.setAccelerator(KeyStroke.getKeyStroke(69, 2, false));
            this.jMenuExport.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.jMenuExport_actionPerformed(e);
                }
            });
            this.jMenuEdit.setText("Edit");
            this.jMenuCut.setIcon(this.cutImage);
            this.jMenuCut.setText("Cut");
            this.jMenuCut.setAccelerator(KeyStroke.getKeyStroke(88, 2, false));
            this.jMenuCut.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.jMenuCut_actionPerformed(e);
                }
            });
            this.jMenuCopy.setIcon(this.copyImage);
            this.jMenuCopy.setText("Copy");
            this.jMenuCopy.setAccelerator(KeyStroke.getKeyStroke(67, 2, false));
            this.jMenuCopy.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.jMenuCopy_actionPerformed(e);
                }
            });
            this.jMenuPaste.setIcon(this.pasteImage);
            this.jMenuPaste.setText("Paste");
            this.jMenuPaste.setAccelerator(KeyStroke.getKeyStroke(86, 2, false));
            this.jMenuPaste.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.jMenuPaste_actionPerformed(e);
                }
            });
            this.jMenuSelectAll.setIcon(this.blankImage);
            this.jMenuSelectAll.setText("Select All");
            this.jMenuSelectAll.setAccelerator(KeyStroke.getKeyStroke(65, 2, false));
            this.jMenuSelectAll.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.jMenuSelectAll_actionPerformed(e);
                }
            });
            this.jMenuOptions.setText("Options");
            this.openButton.setMinimumSize(new Dimension(27, 27));
            this.openButton.setPreferredSize(new Dimension(32, 27));
            this.openButton.setToolTipText("Open");
            this.openButton.setIcon(this.openImage);
            this.openButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.openButton_actionPerformed(e);
                }
            });
            this.decodeButton.setMinimumSize(new Dimension(27, 27));
            this.decodeButton.setPreferredSize(new Dimension(32, 27));
            this.decodeButton.setToolTipText("Import");
            this.decodeButton.setIcon(this.decodeImage);
            this.decodeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.decodeButton_actionPerformed(e);
                }
            });
            this.encodeButton.setMinimumSize(new Dimension(27, 27));
            this.encodeButton.setPreferredSize(new Dimension(32, 27));
            this.encodeButton.setToolTipText("Export");
            this.encodeButton.setIcon(this.encodeImage);
            this.encodeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.encodeButton_actionPerformed(e);
                }
            });
            this.jScrollPane.setVerticalScrollBarPolicy(22);
            this.pasteButton.setMaximumSize(new Dimension(51, 27));
            this.pasteButton.setMinimumSize(new Dimension(27, 27));
            this.pasteButton.setPreferredSize(new Dimension(32, 27));
            this.pasteButton.setToolTipText("Paste");
            this.pasteButton.setIcon(this.pasteImage);
            this.pasteButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.pasteButton_actionPerformed(e);
                }
            });
            this.copyButton.setMaximumSize(new Dimension(51, 27));
            this.copyButton.setMinimumSize(new Dimension(27, 27));
            this.copyButton.setPreferredSize(new Dimension(32, 27));
            this.copyButton.setToolTipText("Copy");
            this.copyButton.setIcon(this.copyImage);
            this.copyButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.copyButton_actionPerformed(e);
                }
            });
            this.copyButton.setEnabled(false);
            this.cutButton.setMaximumSize(new Dimension(51, 27));
            this.cutButton.setMinimumSize(new Dimension(27, 27));
            this.cutButton.setPreferredSize(new Dimension(32, 27));
            this.cutButton.setToolTipText("Cut");
            this.cutButton.setIcon(this.cutImage);
            this.cutButton.setMnemonic('0');
            this.cutButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.cutButton_actionPerformed(e);
                }
            });
            this.cutButton.setEnabled(false);
            this.jPopCut.setIcon(this.cutImage);
            this.jPopCut.setText("Cut");
            this.jPopCut.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.jPopCut_actionPerformed(e);
                }
            });
            this.jPopCopy.setIcon(this.copyImage);
            this.jPopCopy.setText("Copy");
            this.jPopCopy.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.jPopCopy_actionPerformed(e);
                }
            });
            this.jPopPaste.setIcon(this.pasteImage);
            this.jPopPaste.setText("Paste");
            this.jPopPaste.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.jPopPaste_actionPerformed(e);
                }
            });
            this.jPopSelectAll.setIcon(this.blankImage);
            this.jPopSelectAll.setText("Select All");
            this.jPopSelectAll.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.jPopSelectAll_actionPerformed(e);
                }
            });
            this.document.addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent e) {
                    MakeDocJrEditorFrame.this.document_insertUpdate(e);
                }

                public void removeUpdate(DocumentEvent e) {
                    MakeDocJrEditorFrame.this.document_removeUpdate(e);
                }

                public void changedUpdate(DocumentEvent e) {
                    MakeDocJrEditorFrame.this.document_changedUpdate(e);
                }
            });
            this.jMenuExportAs.setIcon(this.blankImage);
            this.jMenuExportAs.setText("Export As...");
            this.jMenuExportAs.setAccelerator(KeyStroke.getKeyStroke(69, 3, false));
            this.jMenuExportAs.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.jMenuExportAs_actionPerformed(e);
                }
            });
            this.bookmarkButton.setEnabled(false);
            this.bookmarkButton.setMaximumSize(new Dimension(51, 27));
            this.bookmarkButton.setMinimumSize(new Dimension(27, 27));
            this.bookmarkButton.setPreferredSize(new Dimension(32, 27));
            this.bookmarkButton.setToolTipText("Add or edit bookmarks");
            this.bookmarkButton.setIcon(this.bookmarkImage);
            this.bookmarkButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.bookmarkButton_actionPerformed(e);
                }
            });
            this.jMenuBookmark.setText("Bookmarks");
            this.jMenuBookmarkAdd.setEnabled(false);
            this.jMenuBookmarkAdd.setText("Add");
            this.jMenuBookmarkAdd.setAccelerator(KeyStroke.getKeyStroke(66, 2, false));
            this.jMenuBookmarkAdd.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.jMenuBookmarkAdd_actionPerformed(e);
                }
            });
            this.jMenuBookmarkEdit.setEnabled(false);
            this.jMenuBookmarkEdit.setText("Edit");
            this.jMenuBookmarkEdit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.jMenuBookmarkEdit_actionPerformed(e);
                }
            });
            this.jMenuBookmarkAuto.setEnabled(false);
            this.jMenuBookmarkAuto.setText("Auto Create");
            this.jMenuBookmarkAuto.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.jMenuBookmarkAuto_actionPerformed(e);
                }
            });
            this.jMenuPreferences.setText("Preferences");
            this.jMenuPreferences.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.jMenuPreferences_actionPerformed(e);
                }
            });
            this.contentPane.setBorder(BorderFactory.createEtchedBorder());
            this.webButton.setEnabled(false);
            this.webButton.setMaximumSize(new Dimension(51, 27));
            this.webButton.setMinimumSize(new Dimension(27, 27));
            this.webButton.setPreferredSize(new Dimension(32, 27));
            this.webButton.setToolTipText("Remove web effects");
            this.webButton.setIcon(this.webImage);
            this.webButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.webButton_actionPerformed(e);
                }
            });
            this.jMenuExportOptions.setText("Export Options");
            this.jMenuExportOptions.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.jMenuExportOptions_actionPerformed(e);
                }
            });
            this.jMenuWrap.setSelected(true);
            this.jMenuWrap.setText("Wrap Lines");
            this.jMenuWrap.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.jMenuWrap_actionPerformed(e);
                }
            });
            this.jMenuUndo.setEnabled(false);
            this.jMenuUndo.setIcon(this.undoImage);
            this.jMenuUndo.setText("Undo");
            this.jMenuUndo.setAccelerator(KeyStroke.getKeyStroke(90, 2, false));
            this.jMenuUndo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.jMenuUndo_actionPerformed(e);
                }
            });
            this.jMenuRedo.setEnabled(false);
            this.jMenuRedo.setIcon(this.blankImage);
            this.jMenuRedo.setText("Redo");
            this.jMenuRedo.setAccelerator(KeyStroke.getKeyStroke(89, 2, false));
            this.jMenuRedo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.jMenuRedo_actionPerformed(e);
                }
            });
            this.document.addUndoableEditListener(this.undoManager);
            this.document.addUndoableEditListener(new UndoableEditListener(){

                public void undoableEditHappened(UndoableEditEvent e) {
                    MakeDocJrEditorFrame.this.document_undoableEditHappened(e);
                }
            });
            this.jMenuReopen.setIcon(this.blankImage);
            this.jMenuReopen.setText("Reopen");
            this.jMenuReimport.setIcon(this.blankImage);
            this.jMenuReimport.setText("Reimport");
            this.statusBar.setBorder(BorderFactory.createLoweredBevelBorder());
            this.statusBar.setText(" MakeDocJr Editor ");
            this.jPanelStatus.setLayout(this.gridBagLayout1);
            this.jPanelStatus.setPreferredSize(new Dimension(388, 19));
            this.colStatus.setBorder(BorderFactory.createLoweredBevelBorder());
            this.colStatus.setMinimumSize(new Dimension(60, 21));
            this.colStatus.setText(" col: 1 ");
            this.rowStatus.setBorder(BorderFactory.createLoweredBevelBorder());
            this.rowStatus.setMinimumSize(new Dimension(70, 21));
            this.rowStatus.setRequestFocusEnabled(false);
            this.rowStatus.setText(" line: 1 ");
            this.jMenuTools.setText("Tools");
            this.jMenuWordCount.setEnabled(false);
            this.jMenuWordCount.setIcon(this.blankImage);
            this.jMenuWordCount.setText("Word Count");
            this.jMenuWordCount.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.jMenuWordCount_actionPerformed(e);
                }
            });
            this.jMenuWeb.setEnabled(false);
            this.jMenuWeb.setIcon(this.webImage);
            this.jMenuWeb.setText("Remove Web Effects");
            this.jMenuWeb.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.jMenuWeb_actionPerformed(e);
                }
            });
            this.undoButton.setEnabled(false);
            this.undoButton.setMaximumSize(new Dimension(51, 27));
            this.undoButton.setMinimumSize(new Dimension(27, 27));
            this.undoButton.setPreferredSize(new Dimension(32, 27));
            this.undoButton.setToolTipText("Undo");
            this.undoButton.setIcon(this.undoImage);
            this.undoButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.undoButton_actionPerformed(e);
                }
            });
            this.jMenuFindReplace.setText("Find/Replace");
            this.jMenuFindReplace.setAccelerator(KeyStroke.getKeyStroke(70, 2, false));
            this.jMenuFindReplace.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.jMenuFindReplace_actionPerformed(e);
                }
            });
            this.jMenuFindAgain.setText("Find Again");
            this.jMenuFindAgain.setAccelerator(KeyStroke.getKeyStroke(114, 0, false));
            this.jMenuFindAgain.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.jMenuFindAgain_actionPerformed(e);
                }
            });
            this.jMenuHelpHelp.setText("Help");
            this.jMenuHelpHelp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MakeDocJrEditorFrame.this.jMenuHelpHelp_actionPerformed(e);
                }
            });
            this.jToolBar.add(this.newButton);
            this.jToolBar.add((Component)this.openButton, null);
            this.jToolBar.add(this.saveButton);
            this.jToolBar.add(this.component1, null);
            this.jMenuFile.add(this.jMenuNew);
            this.jMenuFile.add(this.jMenuOpen);
            this.jMenuFile.add(this.jMenuReopen);
            this.jMenuFile.addSeparator();
            this.jMenuFile.add(this.jMenuSave);
            this.jMenuFile.add(this.jMenuSaveAs);
            this.jMenuFile.addSeparator();
            this.jMenuFile.add(this.jMenuImport);
            this.jMenuFile.add(this.jMenuReimport);
            this.jMenuFile.addSeparator();
            this.jMenuFile.add(this.jMenuExport);
            this.jMenuFile.add(this.jMenuExportAs);
            this.jMenuFile.addSeparator();
            this.jMenuFile.add(this.jMenuFileExit);
            this.jMenuHelp.add(this.jMenuHelpHelp);
            this.jMenuHelp.add(this.jMenuHelpAbout);
            this.jMenuBar.add(this.jMenuFile);
            this.jMenuBar.add(this.jMenuEdit);
            this.jMenuBar.add(this.jMenuBookmark);
            this.jMenuBar.add(this.jMenuTools);
            this.jMenuBar.add(this.jMenuOptions);
            this.jMenuBar.add(this.jMenuHelp);
            this.setJMenuBar(this.jMenuBar);
            this.contentPane.add((Component)this.jToolBar, "North");
            this.contentPane.add((Component)this.jScrollPane, "Center");
            this.contentPane.add((Component)this.jPanelStatus, "South");
            this.jPanelStatus.add((Component)this.statusBar, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanelStatus.add((Component)this.colStatus, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanelStatus.add((Component)this.rowStatus, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 5, 0));
            this.jScrollPane.getViewport().add((Component)this.jTextArea, null);
            this.jMenuEdit.add(this.jMenuUndo);
            this.jMenuEdit.add(this.jMenuRedo);
            this.jMenuEdit.addSeparator();
            this.jMenuEdit.add(this.jMenuCut);
            this.jMenuEdit.add(this.jMenuCopy);
            this.jMenuEdit.add(this.jMenuPaste);
            this.jMenuEdit.add(this.jMenuSelectAll);
            this.jMenuEdit.addSeparator();
            this.jMenuEdit.add(this.jMenuFindReplace);
            this.jMenuEdit.add(this.jMenuFindAgain);
            this.jMenuOptions.add(this.jMenuWrap);
            this.jMenuOptions.addSeparator();
            this.jMenuOptions.add(this.jMenuExportOptions);
            this.jMenuOptions.add(this.jMenuPreferences);
            this.jToolBar.add((Component)this.decodeButton, null);
            this.jToolBar.add((Component)this.encodeButton, null);
            this.jToolBar.add(this.component3, null);
            this.jToolBar.add((Component)this.undoButton, null);
            this.jToolBar.add((Component)this.cutButton, null);
            this.jToolBar.add((Component)this.copyButton, null);
            this.jToolBar.add((Component)this.pasteButton, null);
            this.jToolBar.add(this.component5, null);
            this.jToolBar.add((Component)this.bookmarkButton, null);
            this.jToolBar.add(this.component6, null);
            this.jToolBar.add((Component)this.webButton, null);
            this.jToolBar.add(this.component7, null);
            this.jToolBar.add(this.helpButton);
            this.jToolBar.add(this.component4, null);
            this.jToolBar.add(this.component2, null);
            this.jPopupMenu.add(this.jPopCut);
            this.jPopupMenu.add(this.jPopCopy);
            this.jPopupMenu.add(this.jPopPaste);
            this.jPopupMenu.add(this.jPopSelectAll);
            this.jMenuBookmark.add(this.jMenuBookmarkAdd);
            this.jMenuBookmark.add(this.jMenuBookmarkEdit);
            this.jMenuBookmark.addSeparator();
            this.jMenuBookmark.add(this.jMenuBookmarkAuto);
            this.jMenuTools.add(this.jMenuWeb);
            this.jMenuTools.add(this.jMenuWordCount);
            this.jMenuCopy.setEnabled(false);
            this.jMenuCut.setEnabled(false);
            this.jPopCopy.setEnabled(false);
            this.jPopCut.setEnabled(false);
            this.docNotEmpty(false);
            this.jFileChooser = new JFileChooser(System.getProperty("user.dir"));
            this.jTextArea.setText("");
            this.makeDoc = new MakeDocJr();
            this.jTextArea.getCaret().setBlinkRate(500);
            this.setPreferences(false);
            this.readProperties();
            this.configureMenu();
            fis = null;
            ObjectInputStream ois = null;
            try {
                try {
                    fis = new FileInputStream(ENCODE_OPTIONS);
                    ois = new ObjectInputStream(fis);
                    this.makeDoc.setEncodeOptions((EncodeOptions)ois.readObject());
                }
                catch (Exception e) {
                    this.makeDoc.setEncodeOptions(new EncodeOptions());
                    Object var5_4 = null;
                    if (ois != null) {
                        ois.close();
                    }
                    if (fis == null) return true;
                    fis.close();
                    return true;
                }
                Object var5_3 = null;
                if (ois == null) break block7;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (ois != null) {
                    ois.close();
                }
                if (fis == null) throw throwable;
                fis.close();
                throw throwable;
            }
            ois.close();
        }
        if (fis == null) return true;
        fis.close();
        return true;
    }

    void newFile() {
        if (this.okToAbandon()) {
            this.jTextArea.setText("");
            this.currFileName = null;
            this.currDocName = null;
            this.dirty = false;
            this.statusBar.setText(" MakeDocJr Editor ");
            this.docNotEmpty(false);
            this.makeDoc = new MakeDocJr();
            this.jTextArea.requestFocus();
        }
    }

    void openFile() {
        if (!this.okToAbandon()) {
            return;
        }
        this.jFileChooser.setDialogTitle(null);
        this.jFileChooser.setAcceptAllFileFilterUsed(true);
        if (this.currFileName == null) {
            this.jFileChooser.setCurrentDirectory(this.preferences.getTextFileStart());
        }
        if (this.jFileChooser.showOpenDialog(this) == 0) {
            this.openFile(this.jFileChooser.getSelectedFile().getPath());
        }
        this.repaint();
        this.jTextArea.requestFocus();
    }

    void openFile(String fileName) {
        try {
            File file = new File(fileName);
            int size = (int)file.length();
            int chars_read = 0;
            FileReader in = new FileReader(file);
            char[] data = new char[size];
            while (in.ready()) {
                chars_read += in.read(data, chars_read, size - chars_read);
            }
            in.close();
            this.setText(data);
            this.currFileName = fileName;
            this.currDocName = null;
            this.dirty = false;
            this.makeDoc = new MakeDocJr();
            this.configureButtons((byte)0);
            this.jTextArea.setCaretPosition(0);
            this.statusBar.setText(String.valueOf(String.valueOf(new StringBuffer(" Opened ").append(fileName).append(" "))));
            this.addTextPath(this.currFileName);
            this.configureMenu();
        }
        catch (IOException e) {
            this.statusBar.setText(String.valueOf(String.valueOf(new StringBuffer(" Error opening ").append(fileName).append(" "))));
        }
    }

    void decode() {
        if (!this.okToAbandon()) {
            return;
        }
        this.jFileChooser.setDialogTitle("Decode");
        this.jFileChooser.setFileFilter(this.docFileFilter);
        if (this.currDocName == null) {
            this.jFileChooser.setCurrentDirectory(this.preferences.getDocFileStart());
        }
        if (this.jFileChooser.showOpenDialog(this) == 0) {
            this.decode(this.jFileChooser.getSelectedFile());
        }
        this.repaint();
        this.jTextArea.requestFocus();
    }

    void decode(File source) {
        if (!source.exists()) {
            this.statusBar.setText(String.valueOf(String.valueOf(new StringBuffer(" Error opening ").append(source.getPath()).append(" "))));
            return;
        }
        this.makeDoc = new MakeDocJr();
        try {
            this.makeDoc.decode(source);
        }
        catch (DataFormatException dfe) {
            this.repaint();
            JOptionPane.showMessageDialog(null, "Could not decode ".concat(String.valueOf(String.valueOf(source.getName()))), "Error", 0);
            return;
        }
        catch (FileNotFoundException dfe) {
        }
        catch (IOException ioe) {
            this.statusBar.setText(String.valueOf(String.valueOf(new StringBuffer(" Error opening ").append(source.getPath()).append(" "))));
        }
        this.setText(this.makeDoc.getText());
        this.currDocName = source.getAbsolutePath();
        this.currFileName = null;
        this.dirty = false;
        this.setBookmarkPositions();
        this.configureButtons((byte)1);
        this.jTextArea.setCaretPosition(0);
        this.statusBar.setText(String.valueOf(String.valueOf(new StringBuffer(" Decoded ").append(source.getPath()).append(" "))));
        this.addDocPath(this.currDocName);
        this.configureMenu();
    }

    boolean saveFile() {
        if (this.currFileName == null) {
            return this.saveAsFile();
        }
        try {
            File file = new File(this.currFileName);
            FileWriter out = new FileWriter(file);
            out.write(this.getText());
            out.close();
            this.dirty = false;
            this.statusBar.setText(String.valueOf(String.valueOf(new StringBuffer(" Saved to ").append(this.currFileName).append(" "))));
            this.addTextPath(this.currFileName);
            this.configureMenu();
            this.configureButtons((byte)0);
            this.jTextArea.requestFocus();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.statusBar.setText(String.valueOf(String.valueOf(new StringBuffer(" Error saving ").append(this.currFileName).append(" "))));
            this.jTextArea.requestFocus();
            return false;
        }
    }

    boolean saveAsFile() {
        this.jFileChooser.setDialogTitle(null);
        this.jFileChooser.setAcceptAllFileFilterUsed(true);
        if (this.currFileName == null) {
            this.jFileChooser.setCurrentDirectory(this.preferences.getTextFileStart());
        }
        if (this.jFileChooser.showSaveDialog(this) == 0) {
            File file = this.jFileChooser.getSelectedFile();
            try {
                if (!file.createNewFile()) {
                    this.repaint();
                    if (1 == JOptionPane.showConfirmDialog(this, String.valueOf(String.valueOf(new StringBuffer("File ").append(file.getPath()).append(" already exists. \n").append("Would you like to overwrite it with your new text?"))), "Warning", 0, 2)) {
                        this.repaint();
                        boolean bl = false;
                        return bl;
                    }
                }
            }
            catch (IOException ioe) {
                this.statusBar.setText(String.valueOf(String.valueOf(new StringBuffer(" I/O Error saving ").append(file.getPath()).append(" "))));
                this.repaint();
                this.jTextArea.requestFocus();
                boolean bl = false;
                return bl;
            }
            this.currFileName = file.getPath();
            this.repaint();
            this.jTextArea.requestFocus();
            return this.saveFile();
        }
        this.repaint();
        this.jTextArea.requestFocus();
        return false;
    }

    void encodeFile() {
        if (this.jTextArea.getText() == "") {
            return;
        }
        if (this.currDocName == null || this.makeDoc.getTitle() == null) {
            this.encodeAsFile();
        } else {
            File file = new File(this.currDocName);
            this.encode(file);
        }
    }

    void encodeAsFile() {
        String text = this.jTextArea.getText();
        if (text == "") {
            return;
        }
        this.jFileChooser.setFileFilter(this.docFileFilter);
        this.jFileChooser.setDialogTitle("Encode");
        if (this.currDocName == null) {
            this.jFileChooser.setCurrentDirectory(this.preferences.getDocFileStart());
        }
        if (this.makeDoc.getTitle() == null) {
            int documentLength = this.document.getLength();
            int titleLength = 0;
            titleLength = documentLength < 31 ? (int)((byte)documentLength) : 31;
            int firstLineBreak = text.indexOf(10);
            if (firstLineBreak < titleLength && firstLineBreak > 0) {
                titleLength = (byte)firstLineBreak;
            }
            this.makeDoc.setTitle(text.substring(0, titleLength));
        }
        EncodeDialog ed = new EncodeDialog((Frame)this, true, this.makeDoc, this.jFileChooser);
        ed.pack();
        Dimension dlgSize = ed.getSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        ((Component)ed).setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        ((Component)ed).setVisible(true);
        if (ed.isOkay()) {
            this.makeDoc.setTitle(ed.getDocTitle());
            this.proposedDocName = ed.getFileName();
            File file = new File(this.proposedDocName);
            try {
                if (!file.createNewFile()) {
                    this.repaint();
                    if (1 == JOptionPane.showConfirmDialog(this, String.valueOf(String.valueOf(new StringBuffer("File ").append(file.getPath()).append(" already exists. \n").append("Would you like to overwrite it with your new text?"))), "Warning", 0, 2)) {
                        this.repaint();
                        this.proposedDocName = null;
                        ed.dispose();
                        return;
                    }
                }
            }
            catch (IOException ioe) {
                this.statusBar.setText(String.valueOf(String.valueOf(new StringBuffer(" I/O Error encoding ").append(file.getPath()).append(" "))));
                this.repaint();
                this.proposedDocName = null;
                this.encodeButton.setEnabled(false);
                this.jMenuExport.setEnabled(false);
                this.jTextArea.requestFocus();
                ed.dispose();
                return;
            }
            this.encode(file);
        }
        ed.dispose();
    }

    private void encode(File file) {
        this.makeDoc.setText(this.jTextArea.getText());
        try {
            this.makeDoc.encode(file);
            this.dirty = false;
            this.currDocName = file.getPath();
            this.statusBar.setText(String.valueOf(String.valueOf(new StringBuffer(" Exported as ").append(this.currDocName).append(" "))));
            this.addDocPath(this.currDocName);
            this.configureMenu();
            this.configureButtons((byte)1);
        }
        catch (Exception e) {
            this.statusBar.setText(String.valueOf(String.valueOf(new StringBuffer(" Error exporting ").append(this.currDocName).append(" "))));
            this.currDocName = null;
        }
        this.jTextArea.requestFocus();
    }

    void help() {
        String s = null;
        URL helpURL = null;
        JEditorPane regexHelpPane = null;
        try {
            s = String.valueOf(String.valueOf(new StringBuffer("file:").append(System.getProperty("user.dir")).append(System.getProperty("file.separator")).append("help.html")));
            helpURL = new URL(s);
            regexHelpPane = new JEditorPane(helpURL);
            regexHelpPane.setEditable(false);
            JScrollPane editorScrollPane = new JScrollPane(regexHelpPane);
            editorScrollPane.setVerticalScrollBarPolicy(22);
            JDialog jd = new JDialog(this, "MakeDocJr Editor Help", false);
            jd.getContentPane().add(editorScrollPane);
            ((Component)jd).setSize(new Dimension(450, 400));
            ((Component)jd).setVisible(true);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Could not find the file \"help.html\"", "Missing help file.", 0);
        }
    }

    void helpAbout() {
        MakeDocJrEditorFrame_AboutBox dlg = new MakeDocJrEditorFrame_AboutBox(this);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        ((Component)dlg).setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.show();
        this.jTextArea.requestFocus();
    }

    void findReplace() {
        this.frd.setSearchFromCursor(true);
        String selectedText = this.jTextArea.getSelectedText();
        if (selectedText != null) {
            int start = this.jTextArea.getSelectionStart();
            int end = this.jTextArea.getSelectionEnd();
            boolean multiline = false;
            try {
                int startLine = this.jTextArea.getLineOfOffset(start);
                int endLine = this.jTextArea.getLineOfOffset(end);
                if (startLine != endLine) {
                    multiline = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (multiline) {
                this.frd.setSearchSelectedText(true);
            } else {
                this.frd.setTextToFind(selectedText);
                this.frd.setSearchSelectedText(false);
            }
        } else {
            this.frd.setSearchSelectedText(false);
        }
        this.frd.setIgnoreCase(this.ignoreCase);
        this.frd.setSearchFromTop(this.searchFromTop);
        this.frd.pack();
        Dimension dlgSize = this.frd.getSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        ((Component)this.frd).setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        ((Component)this.frd).setVisible(true);
        this.buttonPressed = this.frd.getButtonPressed();
        if (this.buttonPressed != 0) {
            this.searchText = this.frd.getTextToFind();
            this.replacementText = this.frd.getReplacementText();
            this.ignoreCase = this.frd.getIgnoreCase();
            this.searchSelectedTextOnly = this.frd.getSearchSelectedText();
            this.searchFromTop = this.frd.getSearchFromTop();
            this.newSearch = true;
        }
        switch (this.buttonPressed) {
            case 1: {
                this.findText();
                break;
            }
            case 2: {
                this.replaceText();
                break;
            }
            case 3: {
                this.bookmarkAll();
                break;
            }
            case 0: {
                this.frd.hide();
            }
        }
        this.repaint();
        this.jTextArea.requestFocus();
    }

    public void jMenuFileExit_actionPerformed(ActionEvent e) {
        if (this.okToAbandon()) {
            this.writeProperties();
            System.exit(0);
        }
    }

    public void jMenuHelpAbout_actionPerformed(ActionEvent e) {
        this.helpAbout();
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.jMenuFileExit_actionPerformed(null);
        }
    }

    boolean okToAbandon() {
        if (!this.dirty || this.document.getLength() == 0) {
            return true;
        }
        int value = JOptionPane.showConfirmDialog(this, "Save changes?", "Text has been modified.", 1);
        switch (value) {
            case 0: {
                return this.saveFile();
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    void newButton_actionPerformed(ActionEvent e) {
        this.newFile();
    }

    void jMenuPaste_actionPerformed(ActionEvent e) {
        this.jTextArea.paste();
        this.jTextArea.requestFocus();
    }

    void jMenuCut_actionPerformed(ActionEvent e) {
        this.jTextArea.cut();
        this.jTextArea.requestFocus();
    }

    void jMenuCopy_actionPerformed(ActionEvent e) {
        this.jTextArea.copy();
        this.jTextArea.requestFocus();
    }

    void cutButton_actionPerformed(ActionEvent e) {
        this.jTextArea.cut();
        this.jTextArea.requestFocus();
    }

    void copyButton_actionPerformed(ActionEvent e) {
        this.jTextArea.copy();
        this.jTextArea.requestFocus();
    }

    void pasteButton_actionPerformed(ActionEvent e) {
        this.jTextArea.paste();
        this.jTextArea.requestFocus();
    }

    void jMenuSelectAll_actionPerformed(ActionEvent e) {
        this.jTextArea.selectAll();
    }

    void jPopSelectAll_actionPerformed(ActionEvent e) {
        this.jTextArea.selectAll();
    }

    void jPopPaste_actionPerformed(ActionEvent e) {
        this.jTextArea.paste();
        this.jTextArea.requestFocus();
    }

    void jPopCopy_actionPerformed(ActionEvent e) {
        this.jTextArea.copy();
        this.jTextArea.requestFocus();
    }

    void jPopCut_actionPerformed(ActionEvent e) {
        this.jTextArea.cut();
        this.jTextArea.requestFocus();
    }

    private Rectangle ensureRectIsVisible(Rectangle bounds) {
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        return new Rectangle(Math.max(0, Math.min(size.width - bounds.width, bounds.x)), Math.max(0, Math.min(size.height - bounds.height, bounds.y)), bounds.width, bounds.height);
    }

    void jTextArea_mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    void jTextArea_mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            Window window;
            this.jPopupMenu.show((Component)e.getSource(), e.getX(), e.getY());
            Point point = this.jPopupMenu.getLocationOnScreen();
            Dimension size = this.jPopupMenu.getSize();
            Rectangle oldRect = new Rectangle(point.x, point.y, size.width, size.height);
            Rectangle newRect = this.ensureRectIsVisible(oldRect);
            if (!oldRect.equals(newRect) && (window = SwingUtilities.getWindowAncestor(this.jPopupMenu)) != null) {
                ((Component)window).setLocation(newRect.x, newRect.y);
            }
        }
    }

    void jMenuNew_actionPerformed(ActionEvent e) {
        this.newFile();
    }

    void jMenuOpen_actionPerformed(ActionEvent e) {
        this.openFile();
    }

    void jMenuSave_actionPerformed(ActionEvent e) {
        this.saveFile();
    }

    void jMenuSaveAs_actionPerformed(ActionEvent e) {
        this.saveAsFile();
    }

    void saveButton_actionPerformed(ActionEvent e) {
        this.saveFile();
    }

    void openButton_actionPerformed(ActionEvent e) {
        this.openFile();
    }

    void helpButton_actionPerformed(ActionEvent e) {
        this.help();
    }

    void this_windowOpened(WindowEvent e) {
        this.jTextArea.requestFocus();
    }

    void document_changedUpdate(DocumentEvent e) {
        this.dirty = true;
    }

    void document_insertUpdate(DocumentEvent e) {
        this.dirty = true;
        this.docNotEmpty(true);
        int offset = e.getOffset();
    }

    void document_removeUpdate(DocumentEvent e) {
        this.dirty = true;
        if (this.document.getLength() == 0) {
            this.docNotEmpty(false);
        } else {
            this.docNotEmpty(true);
        }
    }

    void jTextArea_caretUpdate(CaretEvent e) {
        this.canSelect(this.jTextArea.getSelectedText() != null);
        int pos = this.jTextArea.getCaretPosition();
        try {
            int line = this.jTextArea.getLineOfOffset(pos);
            int line1 = line + 1;
            this.rowStatus.setText(" line: ".concat(String.valueOf(String.valueOf(line1))));
            int column = pos - this.jTextArea.getLineStartOffset(line) + 1;
            this.colStatus.setText(" col: ".concat(String.valueOf(String.valueOf(column))));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    void canSelect(boolean b) {
        this.copyButton.setEnabled(b);
        this.cutButton.setEnabled(b);
        this.jMenuCopy.setEnabled(b);
        this.jMenuCut.setEnabled(b);
        this.jPopCopy.setEnabled(b);
        this.jPopCut.setEnabled(b);
    }

    void docNotEmpty(boolean b) {
        this.encodeButton.setEnabled(b);
        this.saveButton.setEnabled(b);
        this.jMenuExport.setEnabled(b);
        this.jMenuExportAs.setEnabled(b);
        this.jMenuSave.setEnabled(b);
        this.jMenuSaveAs.setEnabled(b);
        this.bookmarkButton.setEnabled(b);
        this.jMenuBookmarkAdd.setEnabled(b);
        this.jMenuBookmarkAuto.setEnabled(b);
        this.webButton.setEnabled(b);
        this.jMenuWeb.setEnabled(b);
        this.jMenuWordCount.setEnabled(b);
    }

    void configureButtons(byte type) {
        switch (type) {
            case 1: {
                this.encodeButton.setEnabled(false);
                this.saveButton.setEnabled(true);
                this.jMenuExport.setEnabled(false);
                this.jMenuSave.setEnabled(true);
                break;
            }
            case 0: {
                this.encodeButton.setEnabled(true);
                this.saveButton.setEnabled(false);
                this.jMenuExport.setEnabled(true);
                this.jMenuSave.setEnabled(false);
            }
        }
        this.jMenuExportAs.setEnabled(true);
        this.jMenuSaveAs.setEnabled(true);
    }

    void decodeButton_actionPerformed(ActionEvent e) {
        this.decode();
    }

    void jMenuImport_actionPerformed(ActionEvent e) {
        this.decode();
    }

    void encodeButton_actionPerformed(ActionEvent e) {
        this.encodeFile();
    }

    void jMenuExport_actionPerformed(ActionEvent e) {
        this.encodeFile();
    }

    void jMenuExportAs_actionPerformed(ActionEvent e) {
        this.encodeAsFile();
    }

    void setText(String s) {
        byte[] buffer = s.getBytes();
        byte[] destBuffer = new byte[buffer.length];
        int k = 0;
        int j = 0;
        while (j < buffer.length) {
            destBuffer[k] = buffer[j];
            if (destBuffer[k] == 13 && j < buffer.length - 1 && buffer[j + 1] == 10) {
                --k;
            }
            ++j;
            ++k;
        }
        byte[] buf = new byte[k];
        System.arraycopy(destBuffer, 0, buf, 0, k);
        this.jTextArea.setText(new String(buf));
        this.docNotEmpty(true);
    }

    void setText(char[] buffer) {
        char[] destBuffer = new char[buffer.length];
        int k = 0;
        int j = 0;
        while (j < buffer.length) {
            destBuffer[k] = buffer[j];
            if (destBuffer[k] == '\r' && j < buffer.length - 1 && buffer[j + 1] == '\n') {
                --k;
            }
            ++j;
            ++k;
        }
        char[] buf = new char[k];
        System.arraycopy(destBuffer, 0, buf, 0, k);
        this.jTextArea.setText(new String(buf));
        this.docNotEmpty(true);
    }

    String getText() {
        String text = this.jTextArea.getText();
        if (MakeDocJr.getEolType() != 3) {
            return text;
        }
        byte[] buffer = text.getBytes();
        byte[] destBuffer = new byte[buffer.length * 2];
        int k = 0;
        int j = 0;
        while (j < buffer.length) {
            destBuffer[k] = buffer[j];
            if (destBuffer[k] == 10) {
                destBuffer[k] = 13;
                destBuffer[++k] = 10;
            }
            ++j;
            ++k;
        }
        byte[] buf = new byte[k];
        System.arraycopy(destBuffer, 0, buf, 0, k);
        return new String(buf);
    }

    private void setBookmarkPositions() {
        boolean hasBookmarks = true;
        int size = this.makeDoc.getBookmarks().size();
        if (size == 0) {
            hasBookmarks = false;
        }
        for (int i = 0; i < size; ++i) {
            try {
                int off = ((Bookmark)this.makeDoc.getBookmarks().get(i)).getFileOffset();
                ((Bookmark)this.makeDoc.getBookmarks().get(i)).setPosition(this.document.createPosition(off));
                continue;
            }
            catch (BadLocationException ble) {
                this.makeDoc.getBookmarks().remove(i);
                --size;
            }
        }
        this.jMenuBookmarkEdit.setEnabled(hasBookmarks);
    }

    void jMenuBookmarkAdd_actionPerformed(ActionEvent e) {
        this.addBookmark();
        this.jTextArea.requestFocus();
    }

    String showAddBookmarkOptionPane() {
        JOptionPane pane = new JOptionPane("Name: (maximum 15 characters)", -1, 2);
        pane.setWantsInput(true);
        pane.setInitialSelectionValue(this.limitStringAndRemoveBreaks(this.jTextArea.getSelectedText(), 15));
        JDialog dialog = pane.createDialog(this, "Add a bookmark");
        dialog.show();
        return (String)pane.getInputValue();
    }

    String limitStringAndRemoveBreaks(String str, int maxLength) {
        if (str == null) {
            return null;
        }
        char[] textArray = str.toCharArray();
        int proposedLength = textArray.length;
        if (proposedLength > maxLength) {
            proposedLength = maxLength;
        }
        char[] tempArray = new char[proposedLength];
        for (int i = 0; i < proposedLength; ++i) {
            tempArray[i] = textArray[i];
            if (tempArray[i] != '\n') continue;
            tempArray[i] = 32;
        }
        return new String(tempArray);
    }

    void addBookmark() {
        String bmName = this.showAddBookmarkOptionPane();
        this.repaint();
        if (bmName == null || bmName.equals("uninitializedValue") || bmName.equals("")) {
            return;
        }
        if (this.makeDoc.bookmarkNameExists(bmName)) {
            JOptionPane.showConfirmDialog(this, String.valueOf(String.valueOf(bmName)).concat(" already exists."), "Bookmark naming conflict", -1, 2);
            this.repaint();
            return;
        }
        try {
            bmName = this.limitStringAndRemoveBreaks(bmName, 15);
            Bookmark bm = new Bookmark();
            bm.setName(bmName);
            bm.setPosition(this.document.createPosition(this.jTextArea.getCaretPosition()));
            this.makeDoc.addBookmark(bm);
            this.jMenuBookmarkEdit.setEnabled(true);
            this.dirty = true;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    void bookmarkButton_actionPerformed(ActionEvent e) {
        if (this.jTextArea.getSelectedText() != null) {
            this.addBookmark();
        } else if (this.makeDoc.getBookmarks().isEmpty()) {
            this.addBookmark();
        } else {
            this.editBookmarks();
        }
        this.jTextArea.requestFocus();
    }

    void jMenuBookmarkEdit_actionPerformed(ActionEvent e) {
        if (this.makeDoc.getBookmarks().isEmpty()) {
            return;
        }
        this.editBookmarks();
    }

    void jMenuExportOptions_actionPerformed(ActionEvent e) {
        EncodeOptionsDialog eod = new EncodeOptionsDialog((Frame)this, true, this.makeDoc);
        eod.pack();
        Dimension dlgSize = eod.getSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        ((Component)eod).setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        ((Component)eod).setVisible(true);
        this.repaint();
    }

    void editBookmarks() {
        BookmarksDialog bmd = new BookmarksDialog((Frame)this, true, this.makeDoc);
        bmd.pack();
        Dimension dlgSize = bmd.getSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        ((Component)bmd).setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        ((Component)bmd).setVisible(true);
        this.repaint();
        if (bmd.getOkPressed()) {
            this.makeDoc.setBookmarks(bmd.getBookmarks());
            if (this.makeDoc.getBookmarks().isEmpty()) {
                this.jMenuBookmarkEdit.setEnabled(false);
            }
        } else if (bmd.getGotoPressed()) {
            if (bmd.getPosition() < this.jTextArea.getCaretPosition()) {
                this.jTextArea.setCaretPosition(bmd.getPosition());
            } else {
                try {
                    this.jTextArea.setCaretPosition(this.document.getLength());
                    Rectangle rec = this.jTextArea.modelToView(this.document.getLength());
                    if (rec != null) {
                        this.jTextArea.scrollRectToVisible(rec);
                    }
                    this.jTextArea.setCaretPosition(bmd.getPosition());
                }
                catch (BadLocationException ble) {
                    this.jTextArea.setCaretPosition(bmd.getPosition());
                }
            }
        }
        bmd.dispose();
    }

    void jMenuBookmarkAuto_actionPerformed(ActionEvent e) {
        JOptionPane pane = new JOptionPane("Bookmarks will be created \nwhere lines begin with:", -1, 2);
        pane.setWantsInput(true);
        if (this.makeDoc.getEncodeOptions().getAutoBookmark() == null) {
            pane.setInitialSelectionValue(this.limitStringAndRemoveBreaks(this.jTextArea.getSelectedText(), 25));
        } else {
            pane.setInitialSelectionValue(this.makeDoc.getEncodeOptions().getAutoBookmark());
        }
        JDialog dialog = pane.createDialog(this, "Auto bookmark");
        dialog.show();
        this.makeDoc.getEncodeOptions().setAutoBookmark((String)pane.getInputValue());
        if ((String)pane.getInputValue() != "") {
            this.dirty = true;
        }
    }

    void webButton_actionPerformed(ActionEvent e) {
        this.removeWebEffects();
    }

    void jMenuWeb_actionPerformed(ActionEvent e) {
        this.removeWebEffects();
    }

    void removeWebEffects() {
        char[] textArray = this.jTextArea.getText().trim().toCharArray();
        char[] newTextArray = new char[textArray.length];
        int newSize = 0;
        boolean linebreak = false;
        boolean blankline = false;
        boolean prevSpace = false;
        int j = 0;
        int i = 0;
        while (i < textArray.length) {
            newTextArray[j] = textArray[i];
            if (linebreak) {
                if (newTextArray[j] != ' ') {
                    if (newTextArray[j] == '\n') {
                        if (blankline) {
                            --j;
                        }
                        blankline = true;
                    } else {
                        if (!blankline) {
                            if (prevSpace) {
                                newTextArray[--j] = textArray[i];
                            } else {
                                newTextArray[j - 1] = 32;
                            }
                        }
                        linebreak = false;
                        blankline = false;
                    }
                }
            } else if (newTextArray[j] == '\n') {
                linebreak = true;
                prevSpace = j > 0 && newTextArray[j - 1] == ' ';
            }
            ++i;
            int n = --j;
            ++j;
            newSize = n + 1;
        }
        this.jTextArea.setText(new String(newTextArray, 0, newSize));
        this.jTextArea.setCaretPosition(0);
        this.jTextArea.requestFocus();
    }

    void jMenuWrap_actionPerformed(ActionEvent e) {
        this.jTextArea.setLineWrap(this.jMenuWrap.isSelected());
        this.jTextArea.requestFocus();
    }

    void jMenuPreferences_actionPerformed(ActionEvent e) {
        PreferencesDialog pd = new PreferencesDialog((Frame)this, this.preferences, this.jFileChooser);
        pd.pack();
        Dimension dlgSize = pd.getSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        ((Component)pd).setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        ((Component)pd).setVisible(true);
        if (pd.isOkay()) {
            this.preferences = pd.getPreferences();
            this.setPreferences(true);
        }
        pd.dispose();
        this.repaint();
    }

    /*
     * Loose catch block
     */
    void setPreferences(boolean serialize) {
        block9: {
            this.jTextArea.setFont(new Font(Preferences.FONTS[this.preferences.getFont()], (this.preferences.getBold() ? 1 : 0) | (this.preferences.getItalic() ? 2 : 0), this.preferences.getFontSize()));
            this.jTextArea.setTabSize(this.preferences.getTabSize());
            this.jTextArea.setBackground(this.preferences.getBackground());
            this.jTextArea.setForeground(this.preferences.getForeground());
            this.jTextArea.setCaretColor(this.preferences.getForeground());
            boolean isDirty = this.dirty;
            int cp = this.jTextArea.getCaretPosition();
            this.jTextArea.setText(this.jTextArea.getText());
            this.jTextArea.setCaretPosition(cp);
            this.dirty = isDirty;
            if (serialize) {
                FileOutputStream fos = null;
                ObjectOutputStream oos = null;
                fos = new FileOutputStream("prefs.ser");
                oos = new ObjectOutputStream(fos);
                oos.writeObject(this.preferences);
                oos.flush();
                Object var8_6 = null;
                try {
                    oos.close();
                    fos.close();
                }
                catch (Exception exception) {}
                break block9;
                {
                    catch (Exception e) {
                        this.statusBar.setText("Unable to save preferences to disk");
                        Object var8_7 = null;
                        try {
                            oos.close();
                            fos.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    try {
                        oos.close();
                        fos.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    void undoButton_actionPerformed(ActionEvent e) {
        this.undoAction();
    }

    void jMenuUndo_actionPerformed(ActionEvent e) {
        this.undoAction();
    }

    void undoAction() {
        if (this.undoManager.canUndo()) {
            this.undoManager.undo();
            this.jMenuRedo.setEnabled(true);
            boolean canUndo = this.undoManager.canUndo();
            this.jMenuUndo.setEnabled(canUndo);
            this.undoButton.setEnabled(canUndo);
        }
    }

    void jMenuRedo_actionPerformed(ActionEvent e) {
        if (this.undoManager.canRedo()) {
            this.undoManager.redo();
            this.jMenuUndo.setEnabled(true);
            this.undoButton.setEnabled(true);
            boolean canRedo = this.undoManager.canRedo();
            this.jMenuRedo.setEnabled(canRedo);
        }
    }

    void document_undoableEditHappened(UndoableEditEvent e) {
        this.jMenuUndo.setEnabled(true);
        this.undoButton.setEnabled(true);
        this.jMenuRedo.setEnabled(false);
    }

    void addTextPath(String path) {
        if (this.textpaths.contains(path)) {
            this.textpaths.remove(path);
        }
        this.textpaths.add(0, path);
        if (this.textpaths.size() > 5) {
            this.textpaths.remove(5);
        }
    }

    void addDocPath(String path) {
        if (this.docpaths.contains(path)) {
            this.docpaths.remove(path);
        }
        this.docpaths.add(0, path);
        if (this.docpaths.size() > 5) {
            this.docpaths.remove(5);
        }
    }

    void configureMenu() {
        JMenuItem jMenuSubText = new JMenuItem();
        if (this.textpaths.isEmpty()) {
            jMenuSubText.setText("empty");
            jMenuSubText.setEnabled(false);
            this.jMenuReopen.add(jMenuSubText);
        } else {
            this.jMenuReopen.removeAll();
            Enumeration enumeration = this.textpaths.elements();
            while (enumeration.hasMoreElements()) {
                jMenuSubText = new JMenuItem();
                jMenuSubText.setText((String)enumeration.nextElement());
                jMenuSubText.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        MakeDocJrEditorFrame.this.jMenuSubText_actionPerformed(e);
                    }
                });
                this.jMenuReopen.add(jMenuSubText);
            }
        }
        JMenuItem jMenuSubDoc = new JMenuItem();
        if (this.docpaths.isEmpty()) {
            jMenuSubDoc.setText("empty");
            jMenuSubDoc.setEnabled(false);
            this.jMenuReimport.add(jMenuSubDoc);
        } else {
            this.jMenuReimport.removeAll();
            Enumeration enumeration = this.docpaths.elements();
            while (enumeration.hasMoreElements()) {
                jMenuSubDoc = new JMenuItem();
                jMenuSubDoc.setText((String)enumeration.nextElement());
                jMenuSubDoc.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        MakeDocJrEditorFrame.this.jMenuSubDoc_actionPerformed(e);
                    }
                });
                this.jMenuReimport.add(jMenuSubDoc);
            }
        }
    }

    void jMenuSubText_actionPerformed(ActionEvent e) {
        this.openFile(((JMenuItem)e.getSource()).getText());
    }

    void jMenuSubDoc_actionPerformed(ActionEvent e) {
        this.decode(new File(((JMenuItem)e.getSource()).getText()));
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void readProperties() {
        block16: {
            block15: {
                bis = null;
                try {
                    try {
                        props = new Properties();
                        f = new File("makedocjr.properties");
                        if (!f.exists()) {
                            var10_5 = null;
                            break block15;
                        }
                        bis = new BufferedInputStream(new FileInputStream(f));
                        props.load(bis);
                        dp = new String[5];
                        tp = new String[5];
                        enum = props.propertyNames();
                        while (enum.hasMoreElements()) {
                            s = (String)enum.nextElement();
                            if (s.startsWith("d")) {
                                index = Integer.parseInt(s.substring(1, s.length()));
                                dp[index] = props.getProperty(s);
                                continue;
                            }
                            if (!s.startsWith("t")) continue;
                            index = Integer.parseInt(s.substring(1, s.length()));
                            tp[index] = props.getProperty(s);
                        }
                        for (i = 0; i < dp.length; ++i) {
                            if (dp[i] == null) continue;
                            this.docpaths.add(dp[i]);
                        }
                        for (i = 0; i < tp.length; ++i) {
                            if (tp[i] == null) continue;
                            this.textpaths.add(tp[i]);
                        }
                        break block16;
                    }
                    catch (Exception var2_3) {
                        var10_7 = null;
                        try {
                            bis.close();
                            return;
                        }
                        catch (Exception var11_11) {
                            return;
                        }
                    }
                }
                catch (Throwable var9_19) {
                    var10_8 = null;
                    ** try [egrp 2[TRYBLOCK] [2 : 274->281)] { 
lbl48:
                    // 1 sources

                    bis.close();
                    throw var9_19;
lbl50:
                    // 1 sources

                    catch (Exception var11_12) {
                        // empty catch block
                    }
                    throw var9_19;
                }
            }
            ** try [egrp 2[TRYBLOCK] [2 : 274->281)] { 
lbl55:
            // 1 sources

            bis.close();
            return;
lbl57:
            // 1 sources

            catch (Exception var11_9) {
                // empty catch block
            }
            return;
        }
        var10_6 = null;
        try {}
        catch (Exception var11_10) {}
        bis.close();
        return;
    }

    /*
     * Loose catch block
     */
    void writeProperties() {
        block10: {
            int i;
            FilterOutputStream bos = null;
            Properties props = new Properties();
            Object[] o = this.docpaths.toArray();
            for (i = 0; i < o.length; ++i) {
                props.setProperty("d".concat(String.valueOf(String.valueOf(i))), (String)o[i]);
            }
            o = this.textpaths.toArray();
            for (i = 0; i < o.length; ++i) {
                props.setProperty("t".concat(String.valueOf(String.valueOf(i))), (String)o[i]);
            }
            File f = new File(PROPERTY_FILE);
            bos = new BufferedOutputStream(new FileOutputStream(f));
            props.store(bos, "This is a history of your most recent files. Please do not edit this file; but you may delete it.");
            Object var6_7 = null;
            try {
                bos.close();
            }
            catch (Exception exception) {}
            break block10;
            {
                catch (Exception exception) {
                    Object var6_8 = null;
                    try {
                        bos.close();
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                try {
                    bos.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    void wordCount() {
        boolean hadNonWhiteSpace = false;
        int numWords = 0;
        char[] character = this.jTextArea.getText().toCharArray();
        for (int i = 0; i < character.length; ++i) {
            if (Character.isWhitespace(character[i])) {
                if (hadNonWhiteSpace) {
                    ++numWords;
                }
                hadNonWhiteSpace = false;
                continue;
            }
            hadNonWhiteSpace = true;
        }
        if (hadNonWhiteSpace) {
            ++numWords;
        }
        JOptionPane.showMessageDialog(this, String.valueOf(String.valueOf(new StringBuffer("Number of words: ").append(NumberFormat.getInstance().format(numWords)).append("\nText size in bytes: ").append(NumberFormat.getInstance().format(this.document.getLength())))), "MakeDocJrEditor", 1);
        this.repaint();
    }

    void jMenuWordCount_actionPerformed(ActionEvent e) {
        this.wordCount();
    }

    private boolean findText() {
        boolean textFound = true;
        try {
            this.rem = null;
            this.re = new RE(this.searchText, 8 | (this.ignoreCase ? 2 : 0));
            if (this.searchSelectedTextOnly) {
                if (this.newSearch) {
                    this.selectionStart = this.jTextArea.getSelectionStart();
                    this.selectionEnd = this.jTextArea.getSelectionEnd();
                    this.jTextArea.setCaretPosition(this.selectionStart);
                }
                this.rem = this.re.getMatch(this.jTextArea.getText(0, this.selectionEnd), this.jTextArea.getCaretPosition());
            } else {
                this.rem = this.searchFromTop ? this.re.getMatch(this.jTextArea.getText(), 0) : this.re.getMatch(this.jTextArea.getText(), this.jTextArea.getCaretPosition());
            }
            if (this.rem != null) {
                this.jTextArea.select(this.rem.getStartIndex(), this.rem.getEndIndex());
            } else {
                JOptionPane.showMessageDialog(this, String.valueOf(String.valueOf(new StringBuffer("A string matching your regex ").append(this.searchText).append(" was not found."))), "Search failed", 1);
                textFound = false;
            }
        }
        catch (REException ree) {
            JOptionPane.showMessageDialog(this, String.valueOf(String.valueOf(new StringBuffer("Error in your regex ").append(this.searchText).append("\nUsually caused by not escaping special characters."))), "RegEx Error", 0);
            textFound = false;
        }
        catch (BadLocationException ble) {
            textFound = false;
        }
        return textFound;
    }

    private boolean findAgain() {
        this.searchFromTop = false;
        this.newSearch = false;
        return this.findText();
    }

    private void replaceText() {
        try {
            this.rem = null;
            String selectionText = null;
            this.re = new RE(this.searchText, 8 | (this.ignoreCase ? 2 : 0));
            if (this.searchSelectedTextOnly) {
                if (this.newSearch) {
                    this.selectionEnd = this.jTextArea.getSelectionEnd();
                }
                this.selectionStart = this.jTextArea.getSelectionStart();
                selectionText = this.jTextArea.getText(0, this.selectionEnd);
            } else if (this.searchFromTop) {
                this.selectionStart = 0;
                selectionText = this.jTextArea.getText();
                this.selectionEnd = selectionText.length();
            } else {
                this.selectionStart = this.jTextArea.getSelectionStart();
                selectionText = this.jTextArea.getText();
                this.selectionEnd = selectionText.length();
            }
            this.rem = this.re.getMatch(selectionText, this.selectionStart);
            if (this.rem != null) {
                this.jTextArea.select(this.rem.getStartIndex(), this.rem.getEndIndex());
                this.createConfirmReplaceDialog();
            } else {
                JOptionPane.showMessageDialog(this, String.valueOf(String.valueOf(new StringBuffer("A string matching your regex ").append(this.searchText).append(" was not found."))), "Search failed", 1);
            }
        }
        catch (REException ree) {
            JOptionPane.showMessageDialog(this, String.valueOf(String.valueOf(new StringBuffer("Error in your regex ").append(this.searchText).append("\nUsually caused by not escaping special characters."))), "RegEx Error", 0);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void createConfirmReplaceDialog() {
        this.repaint();
        if (this.crd == null) {
            this.crd = new ConfirmReplaceDialog();
            this.crd.pack();
            Dimension dlgSize = this.crd.getSize();
            Dimension frmSize = this.getSize();
            Point loc = this.getLocation();
            ((Component)this.crd).setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
            ((Component)this.crd).setVisible(true);
        } else {
            this.crd.show();
        }
        byte value = this.crd.getButtonPressed();
        this.crd.hide();
        switch (value) {
            case 1: {
                this.replaceYes();
                break;
            }
            case 2: {
                this.replaceNo();
                break;
            }
            case 3: {
                this.replaceAll();
            }
        }
    }

    private void replaceYes() {
        String selectedText = this.jTextArea.getSelectedText();
        String newText = this.re.substitute(selectedText, this.replacementText);
        this.jTextArea.cut();
        this.jTextArea.insert(newText, this.jTextArea.getCaretPosition());
        this.selectionEnd = this.selectionEnd + newText.length() - selectedText.length();
        this.searchFromTop = false;
        this.newSearch = false;
        this.replaceText();
    }

    private void replaceNo() {
        this.searchFromTop = false;
        this.newSearch = false;
        int cp = this.jTextArea.getCaretPosition();
        if (cp != this.jTextArea.getText().length()) {
            this.jTextArea.setCaretPosition(++cp);
            this.replaceText();
        }
    }

    private void replaceAll() {
        this.jTextArea.select(this.selectionStart, this.selectionEnd);
        String newText = this.re.substituteAll(this.jTextArea.getSelectedText(), this.replacementText);
        this.jTextArea.cut();
        this.jTextArea.insert(newText, this.jTextArea.getCaretPosition());
    }

    void jMenuFindReplace_actionPerformed(ActionEvent e) {
        this.findReplace();
    }

    void jMenuFindAgain_actionPerformed(ActionEvent e) {
        this.findAgain();
    }

    private void bookmarkAll() {
        try {
            REMatch[] rems = null;
            String selectionText = null;
            this.re = new RE(this.searchText, 8 | (this.ignoreCase ? 2 : 0));
            if (this.searchSelectedTextOnly) {
                this.selectionStart = this.jTextArea.getSelectionStart();
                this.selectionEnd = this.jTextArea.getSelectionEnd();
                selectionText = this.jTextArea.getText(0, this.selectionEnd);
            } else if (this.searchFromTop) {
                this.selectionStart = 0;
                selectionText = this.jTextArea.getText();
                this.selectionEnd = selectionText.length();
            } else {
                this.selectionStart = this.jTextArea.getSelectionStart();
                selectionText = this.jTextArea.getText();
                this.selectionEnd = selectionText.length();
            }
            rems = this.re.getAllMatches(selectionText, this.selectionStart);
            if (rems != null) {
                for (int i = 0; i < rems.length; ++i) {
                    int start = rems[i].getStartIndex();
                    int length = rems[i].getEndIndex() - start;
                    String bmName = null;
                    bmName = !this.replacementText.equals("") ? rems[i].substituteInto(this.replacementText) : this.jTextArea.getText(start, length).trim();
                    bmName = this.limitStringAndRemoveBreaks(bmName, 15);
                    Bookmark bm = new Bookmark();
                    bm.setName(bmName);
                    bm.setPosition(this.document.createPosition(start));
                    this.makeDoc.addBookmark(bm);
                    this.jMenuBookmarkEdit.setEnabled(true);
                    this.dirty = true;
                }
            } else {
                JOptionPane.showMessageDialog(this, String.valueOf(String.valueOf(new StringBuffer("A string matching your regex ").append(this.searchText).append(" was not found."))), "Search failed", 1);
            }
        }
        catch (REException ree) {
            JOptionPane.showMessageDialog(this, String.valueOf(String.valueOf(new StringBuffer("Error in your regex ").append(this.searchText).append("\nUsually caused by not escaping special characters."))), "RegEx Error", 0);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    void jMenuHelpHelp_actionPerformed(ActionEvent e) {
        this.help();
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }

    static {
        NUMBER_OF_FILES = 5;
        NUMBER_OF_SEARCHES = 5;
        PROPERTY_FILE = PROPERTY_FILE;
        REFRESHED_TEXT = 0;
        REFRESHED_DOC = 1;
        ENCODE_OPTIONS = ENCODE_OPTIONS;
    }
}

