/*
 * Decompiled with CFR 0.152.
 */
package makedocjr.editor;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import makedocjr.Bookmark;
import makedocjr.MakeDocJr;

public class BookmarksDialog
extends JDialog {
    JSplitPane jSplitPane1 = new JSplitPane();
    JList jList1;
    JPanel jPanel1 = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JButton jButtonGoTo = new JButton();
    JButton jButtonRename = new JButton();
    Component component1;
    JButton jButtonDelete = new JButton();
    Component component2;
    Component component3;
    JButton jButtonSortAlpha = new JButton();
    Component component4;
    JButton jButtonSortLocation = new JButton();
    Component component5;
    JButton jButtonOK = new JButton();
    JButton jButtonCancel = new JButton();
    Component component6;
    MakeDocJr makeDoc;
    DefaultListModel listModel = new DefaultListModel();
    boolean okPressed = false;
    int index;
    boolean gotoPressed;
    int position;
    Component component7;
    JButton jButtonDeleteAll = new JButton();

    public BookmarksDialog(Frame frame, boolean modal, MakeDocJr makeDoc) {
        super(frame, modal);
        this.makeDoc = (MakeDocJr)makeDoc.clone();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BookmarksDialog(Dialog dialog, boolean modal, MakeDocJr makeDoc) {
        super(dialog, modal);
        this.makeDoc = (MakeDocJr)makeDoc.clone();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.component6 = Box.createHorizontalStrut(8);
        this.component7 = Box.createVerticalStrut(8);
        this.setTitle("Edit Bookmarks");
        this.component1 = Box.createVerticalStrut(8);
        this.component2 = Box.createVerticalStrut(8);
        this.component3 = Box.createVerticalStrut(8);
        this.component4 = Box.createVerticalStrut(8);
        this.component5 = Box.createVerticalStrut(8);
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.jButtonGoTo.setEnabled(false);
        this.jButtonGoTo.setMaximumSize(new Dimension(83, 27));
        this.jButtonGoTo.setMinimumSize(new Dimension(83, 27));
        this.jButtonGoTo.setPreferredSize(new Dimension(83, 27));
        this.jButtonGoTo.setText("Go To");
        this.jButtonGoTo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BookmarksDialog.this.jButtonGoTo_actionPerformed(e);
            }
        });
        this.jButtonRename.setEnabled(false);
        this.jButtonRename.setText("Rename");
        this.jButtonRename.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BookmarksDialog.this.jButtonRename_actionPerformed(e);
            }
        });
        this.jButtonDelete.setEnabled(false);
        this.jButtonDelete.setMaximumSize(new Dimension(83, 27));
        this.jButtonDelete.setMinimumSize(new Dimension(83, 27));
        this.jButtonDelete.setPreferredSize(new Dimension(83, 27));
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BookmarksDialog.this.jButtonDelete_actionPerformed(e);
            }
        });
        this.jButtonSortAlpha.setText("Sort Alphabetically");
        this.jButtonSortAlpha.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BookmarksDialog.this.jButtonSortAlpha_actionPerformed(e);
            }
        });
        this.jButtonSortLocation.setMaximumSize(new Dimension(135, 27));
        this.jButtonSortLocation.setMinimumSize(new Dimension(135, 27));
        this.jButtonSortLocation.setPreferredSize(new Dimension(135, 27));
        this.jButtonSortLocation.setText("Sort by Location");
        this.jButtonSortLocation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BookmarksDialog.this.jButtonSortLocation_actionPerformed(e);
            }
        });
        this.jButtonOK.setMaximumSize(new Dimension(73, 27));
        this.jButtonOK.setMinimumSize(new Dimension(73, 27));
        this.jButtonOK.setPreferredSize(new Dimension(73, 27));
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BookmarksDialog.this.jButtonOK_actionPerformed(e);
            }
        });
        this.setListModelContents();
        this.jList1 = new JList(this.listModel);
        this.jList1.setSelectionMode(0);
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                BookmarksDialog.this.jList1_valueChanged(e);
            }
        });
        this.jList1.setMaximumSize(new Dimension(135, 233));
        this.jList1.setMinimumSize(new Dimension(135, 233));
        JScrollPane scrollPane = new JScrollPane(this.jList1);
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BookmarksDialog.this.jButtonCancel_actionPerformed(e);
            }
        });
        scrollPane.setMinimumSize(new Dimension(115, 253));
        scrollPane.setPreferredSize(new Dimension(110, 253));
        this.jList1.setMaximumSize(new Dimension(135, 233));
        this.jList1.setMinimumSize(new Dimension(135, 233));
        this.jList1.setModel(this.listModel);
        this.jList1.setSelectionMode(0);
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                BookmarksDialog.this.jList1_valueChanged(e);
            }
        });
        this.jList1.setSelectionMode(0);
        this.jButtonDeleteAll.setText("Delete All");
        this.jButtonDeleteAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BookmarksDialog.this.jButtonDeleteAll_actionPerformed(e);
            }
        });
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.jSplitPane1.add((Component)scrollPane, "left");
        this.jSplitPane1.add((Component)this.jPanel1, "right");
        this.jPanel1.add((Component)this.jButtonRename, new GridBagConstraints(0, 2, 5, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add(this.component1, new GridBagConstraints(0, 3, 5, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jButtonDelete, new GridBagConstraints(0, 4, 5, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add(this.component2, new GridBagConstraints(0, 1, 5, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 13, 0), 0, 0));
        this.jPanel1.add(this.component3, new GridBagConstraints(0, 5, 3, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jButtonSortAlpha, new GridBagConstraints(0, 8, 5, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add(this.component4, new GridBagConstraints(0, 9, 5, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jButtonSortLocation, new GridBagConstraints(0, 10, 5, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add(this.component5, new GridBagConstraints(0, 11, 5, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 16, 0), 0, 0));
        this.jPanel1.add((Component)this.jButtonOK, new GridBagConstraints(0, 12, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jButtonGoTo, new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jButtonCancel, new GridBagConstraints(4, 12, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add(this.component6, new GridBagConstraints(2, 12, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add(this.component7, new GridBagConstraints(4, 7, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 13, 0), 0, 0));
        this.jPanel1.add((Component)this.jButtonDeleteAll, new GridBagConstraints(3, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void setListModelContents() {
        this.listModel.clear();
        Object[] bmArray = this.makeDoc.getBookmarks().toArray();
        for (int i = 0; i < bmArray.length; ++i) {
            this.listModel.addElement(((Bookmark)bmArray[i]).getName());
        }
        this.jButtonDelete.setEnabled(false);
        this.jButtonGoTo.setEnabled(false);
        this.jButtonRename.setEnabled(false);
        this.repaint();
    }

    void jButtonCancel_actionPerformed(ActionEvent e) {
        this.hide();
    }

    void jButtonSortLocation_actionPerformed(ActionEvent e) {
        this.makeDoc.sortBookmarksByLocation();
        this.setListModelContents();
    }

    void jButtonSortAlpha_actionPerformed(ActionEvent e) {
        this.makeDoc.sortBookmarksByName();
        this.setListModelContents();
    }

    void jButtonDelete_actionPerformed(ActionEvent e) {
        this.makeDoc.getBookmarks().remove(this.index);
        this.setListModelContents();
    }

    void jButtonRename_actionPerformed(ActionEvent e) {
        String bmName = this.showRenameBookmarkPane();
        this.repaint();
        if (bmName == null) {
            return;
        }
        if (bmName.equals("uninitializedValue")) {
            return;
        }
        if (bmName.equals("")) {
            return;
        }
        if (this.makeDoc.bookmarkNameExists(bmName = this.limitStringAndRemoveBreaks(bmName, 15))) {
            JOptionPane.showConfirmDialog(this, String.valueOf(String.valueOf(bmName)).concat(" already exists."), "Bookmark naming conflict", -1, 2);
            this.repaint();
            return;
        }
        Bookmark bm = (Bookmark)this.makeDoc.getBookmarks().get(this.index);
        bm.setName(bmName);
        this.setListModelContents();
    }

    String showRenameBookmarkPane() {
        JOptionPane pane = new JOptionPane("Name: (maximum 15 characters)", -1, 2);
        pane.setWantsInput(true);
        JDialog dialog = pane.createDialog(this, "Rename bookmark");
        dialog.show();
        return (String)pane.getInputValue();
    }

    String limitStringAndRemoveBreaks(String str, int maxLength) {
        if (str == null) {
            return null;
        }
        char[] textArray = str.toCharArray();
        int proposedLength = textArray.length;
        if (proposedLength > maxLength) {
            proposedLength = maxLength;
        }
        char[] tempArray = new char[proposedLength];
        for (int i = 0; i < proposedLength; ++i) {
            tempArray[i] = textArray[i];
            if (tempArray[i] != '\n') continue;
            tempArray[i] = 32;
        }
        return new String(tempArray);
    }

    void jList1_valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.index = this.jList1.getSelectedIndex();
        if (this.index == -1) {
            this.jButtonDelete.setEnabled(false);
            this.jButtonGoTo.setEnabled(false);
            this.jButtonRename.setEnabled(false);
        } else {
            this.jButtonDelete.setEnabled(true);
            this.jButtonGoTo.setEnabled(true);
            this.jButtonRename.setEnabled(true);
        }
    }

    void jButtonOK_actionPerformed(ActionEvent e) {
        this.okPressed = true;
        this.hide();
    }

    public ArrayList getBookmarks() {
        return this.makeDoc.getBookmarks();
    }

    void jButtonGoTo_actionPerformed(ActionEvent e) {
        Bookmark bm = (Bookmark)this.makeDoc.getBookmarks().get(this.index);
        this.position = bm.getFileOffset();
        this.gotoPressed = true;
        this.hide();
    }

    public boolean getOkPressed() {
        return this.okPressed;
    }

    public boolean getGotoPressed() {
        return this.gotoPressed;
    }

    public int getPosition() {
        return this.position;
    }

    void jButtonDeleteAll_actionPerformed(ActionEvent e) {
        this.makeDoc.getBookmarks().clear();
        this.setListModelContents();
    }
}

