/*
 * Decompiled with CFR 0.152.
 */
package makedocjr;

public class PilotDocRecord {
    static final int DISP_BITS = 11;
    static final int COUNT_BITS = 3;
    static final int DEF_LEN = 4096;
    public static final int EOLLF = 1;
    public static final int EOLCR = 2;
    public static final int EOLCRLF = 3;
    byte[] buf = null;
    private byte[] destBuf = null;
    private int destIndex = 0;
    private boolean space = false;

    PilotDocRecord() {
        this(4096);
    }

    PilotDocRecord(int size) {
        this.buf = new byte[size];
    }

    public int length() {
        return this.buf.length;
    }

    public int removeBinary() {
        this.destBuf = new byte[this.buf.length * 3 / 2];
        int k = 0;
        int j = 0;
        while (j < this.buf.length) {
            this.destBuf[k] = this.buf[j];
            if (this.destBuf[k] >= 0 && this.destBuf[k] < 9) {
                --k;
            }
            ++j;
            ++k;
        }
        this.assign(this.destBuf, k);
        return k;
    }

    public int convertEOL(int eolType) {
        this.destBuf = new byte[this.buf.length * 3 / 2];
        int k = 0;
        int j = 0;
        while (j < this.buf.length) {
            this.destBuf[k] = this.buf[j];
            if (this.destBuf[k] == 10) {
                if (eolType == 3) {
                    this.destBuf[k++] = 13;
                    this.destBuf[k] = 10;
                } else {
                    this.destBuf[k] = 13;
                }
            }
            ++j;
            ++k;
        }
        this.assign(this.destBuf, k);
        return k;
    }

    public int convertEOL() {
        this.destBuf = new byte[this.buf.length * 3 / 2];
        int k = 0;
        int j = 0;
        while (j < this.buf.length) {
            this.destBuf[k] = this.buf[j];
            if (this.destBuf[k] == 13) {
                if (j < this.buf.length - 1 && this.buf[j + 1] == 10) {
                    --k;
                } else {
                    this.destBuf[k] = 10;
                }
            }
            ++j;
            ++k;
        }
        this.assign(this.destBuf, k);
        return k;
    }

    public int unwrap(int lineLength) {
        this.destBuf = new byte[this.buf.length * 3 / 2];
        int lastLFpos = -1;
        int k = 0;
        int j = 0;
        while (j < this.buf.length) {
            this.destBuf[k] = this.buf[j];
            if (this.destBuf[k] == 10) {
                boolean patternFound = false;
                if (!patternFound) {
                    patternFound = true;
                    int x = lastLFpos + 1;
                    for (int y = k - 1; x < y; ++x, --y) {
                        if (this.destBuf[x] == this.destBuf[y]) continue;
                        patternFound = false;
                        break;
                    }
                    if (patternFound && lastLFpos > -1) {
                        this.destBuf[lastLFpos] = 10;
                    }
                }
                if (!patternFound && k - lastLFpos > lineLength && this.destBuf[k - 1] != 32 && this.destBuf[k - 1] != 10) {
                    this.destBuf[k] = 32;
                }
                lastLFpos = --k;
            }
            ++j;
            ++k;
        }
        this.assign(this.destBuf, k);
        return k;
    }

    public int compressEOL() {
        this.destBuf = new byte[this.buf.length * 3 / 2];
        int k = 0;
        int j = 0;
        while (j < this.buf.length) {
            this.destBuf[k] = this.buf[j];
            if (k > 0 && this.destBuf[k] == 10 && this.destBuf[k - 1] == 10) {
                --k;
            }
            ++j;
            ++k;
        }
        this.assign(this.destBuf, k);
        return k;
    }

    public int decompress() {
        this.destBuf = new byte[8192];
        this.destIndex = 0;
        int i = 0;
        int j = 0;
        while (j < this.buf.length) {
            int c;
            if ((c = this.buf[j++] & 0xFF) > 0 && c < 9) {
                while (c-- > 0) {
                    this.destBuf[this.destIndex++] = this.buf[j++];
                }
                continue;
            }
            if (c < 128) {
                this.destBuf[this.destIndex++] = (byte)c;
                continue;
            }
            if (c >= 192) {
                this.destBuf[this.destIndex++] = 32;
                this.destBuf[this.destIndex++] = (byte)(c ^ 0x80);
                continue;
            }
            c <<= 8;
            int m = ((c += this.buf[j++] & 0xFF) & 0x3FFF) >> 3;
            int n = c & 7;
            n += 3;
            while (n-- > 0) {
                this.destBuf[this.destIndex] = this.destBuf[this.destIndex - m];
                ++this.destIndex;
            }
        }
        this.assign(this.destBuf, this.destIndex);
        return this.destIndex;
    }

    public int compress() {
        int hit = 0;
        int prevHit = 0;
        int testHead = 0;
        int testTail = 1;
        int end = this.buf.length;
        this.space = false;
        this.destBuf = new byte[this.buf.length * 3 / 2];
        this.destIndex = 0;
        String src = new String(this.buf);
        String testStr = "";
        while (testHead != end) {
            if (testHead - prevHit > 2047) {
                prevHit = testHead - 2047;
            }
            if ((hit = src.indexOf(testStr = src.substring(testHead, testTail), prevHit)) == -1 || hit == testHead || testTail - testHead > 10 || testTail == end) {
                if (testTail - testHead < 4) {
                    this.issue(this.buf[testHead]);
                    ++testHead;
                } else {
                    if (this.space) {
                        this.destBuf[this.destIndex++] = 32;
                        this.space = false;
                    }
                    int dist = testHead - prevHit;
                    int compound = (dist << 3) + testTail - testHead - 4;
                    this.destBuf[this.destIndex++] = (byte)(128 + (compound >> 8));
                    this.destBuf[this.destIndex++] = (byte)(compound & 0xFF);
                    testHead = testTail - 1;
                }
                prevHit = 0;
            } else {
                prevHit = hit;
            }
            if (testTail == end) {
                --testTail;
            }
            ++testTail;
        }
        if (this.space) {
            this.destBuf[this.destIndex++] = 32;
        }
        int k = 0;
        int i = 0;
        while (i < this.destIndex) {
            this.destBuf[k] = this.destBuf[i];
            int destTemp = this.destBuf[k] & 0xFF;
            if (destTemp >= 128 && destTemp < 192) {
                this.destBuf[++k] = this.destBuf[++i];
            } else if (this.destBuf[k] == 1) {
                this.destBuf[k + 1] = this.destBuf[i + 1];
                while (i + 2 < this.destIndex && this.destBuf[i + 2] == 1 && this.destBuf[k] < 8) {
                    int n = k;
                    this.destBuf[n] = (byte)(this.destBuf[n] + 1);
                    this.destBuf[k + this.destBuf[k]] = this.destBuf[i + 3];
                    i += 2;
                }
                k += this.destBuf[k];
                ++i;
            }
            ++i;
            ++k;
        }
        this.assign(this.destBuf, k);
        return k;
    }

    private void issue(byte src) {
        byte iSrc = src;
        if (this.space) {
            if (iSrc >= 64 && iSrc <= 127) {
                this.destBuf[this.destIndex++] = (byte)(iSrc ^ 0x80);
            } else {
                this.destBuf[this.destIndex++] = 32;
                if (iSrc < 128 && (iSrc == 0 || iSrc > 8)) {
                    this.destBuf[this.destIndex++] = src;
                } else {
                    this.destBuf[this.destIndex++] = 1;
                    this.destBuf[this.destIndex++] = src;
                }
            }
            this.space = false;
        } else if (src == 32) {
            this.space = true;
        } else if (iSrc < 128 && (iSrc == 0 || iSrc > 8)) {
            this.destBuf[this.destIndex++] = src;
        } else {
            this.destBuf[this.destIndex++] = 1;
            this.destBuf[this.destIndex++] = src;
        }
    }

    public void assign(byte[] b, int n) {
        this.buf = new byte[n];
        System.arraycopy(b, 0, this.buf, 0, n);
    }

    public void assign(byte[] b, int n, int offset) {
        this.buf = new byte[n];
        System.arraycopy(b, offset, this.buf, 0, n);
    }

    static {
        DISP_BITS = 11;
        COUNT_BITS = 3;
        DEF_LEN = 4096;
        EOLLF = 1;
        EOLCR = 2;
        EOLCRLF = 3;
    }
}

