/*
 * Decompiled with CFR 0.152.
 */
package makedocjr;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DocumentHeader {
    public static final short UNCOMPRESSED = 1;
    public static final short COMPRESSED = 2;
    public static final short textRecordSize = 4096;
    public short version = 0;
    public short spare = 0;
    public int storyLen = 0;
    public short numRecords = 0;
    public short recordSize = (short)4096;
    public int position = 0;

    public static int getSize() {
        return 16;
    }

    public void read(DataInput di) throws IOException {
        this.version = di.readShort();
        this.spare = di.readShort();
        this.storyLen = di.readInt();
        this.numRecords = di.readShort();
        this.recordSize = di.readShort();
        this.position = di.readInt();
    }

    public void write(DataOutput out) throws IOException {
        out.writeShort(this.version);
        out.writeShort(this.spare);
        out.writeInt(this.storyLen);
        out.writeShort(this.numRecords);
        out.writeShort(this.recordSize);
        out.writeInt(this.position);
    }

    public boolean isCompressed() {
        return this.version == 2;
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer(">> DocumentHeader <<\nversion = ").append(this.version).append("\nspare = ").append(this.spare).append("\nstoryLen = ").append(this.storyLen).append("\nnumRecords = ").append(this.numRecords).append("\nRecSize = ").append(this.recordSize).append("\nposition = ").append(this.position)));
    }

    static {
        UNCOMPRESSED = 1;
        COMPRESSED = (short)2;
        textRecordSize = (short)4096;
    }
}

