#include <System/SysAll.h>
#include <UI/UIAll.h>

#define TEMPO 12
#define TAPTEMPO 18
#define TIMENUM 13
#define TIMEDEN 14
#define STRONGBEATS 17
#define METON 15
#define METOFF 16
#define METLIGHT 19
#define METSOUND 20

#define OBJ(label) (FrmGetObjectPtr(form,FrmGetObjectIndex(form,label)))

Word notefreqs[12]={523,554,587,622,659,698,740,784,831,880,932,988};
Word tempo=120,timenum=4,timeden=4,strongbeats=2,ticksperbeat;

Word num(FieldType *fld) {
  if(StrLen(FldGetTextPtr(fld))>0)
    return(StrAToI(FldGetTextPtr(fld)));
  return(1);
}

Boolean eventhandled(EventType *eventP) {
  return(false);
}

void settext(FieldType *fld,const char *text, Byte size) {
  VoidPtr m;
  VoidHand h;
  Ptr s;
  h=MemHandleNew(size);
  m=MemHandleLock(h);
  s=(Ptr)m;
  StrCopy(s,text);
  MemHandleUnlock(h);
  FldSetTextHandle(fld,(Handle)h);
}

void resettext(FieldType *fld,const char *text) {
  VoidPtr m;
  VoidHand h;
  Ptr s;
  h=(VoidHand)FldGetTextHandle(fld);
  FldSetTextHandle(fld,NULL);
  m=MemHandleLock(h);
  s=(Ptr)m;
  StrCopy(s,text);
  MemHandleUnlock(h);
  FldSetTextHandle(fld,(Handle)h);
}

DWord PilotMain( Word cmd, Ptr cmdPBP, Word launchFlags )
{
  FormType *form;
  EventType event;
  SndCommandType sndcmd;
  Byte playingtune=0,beatcount=0,i,metlight=0,metsound=1;
  DWord nexttick=0,halftick=0,lasttap=0,numtaps=0,curtick;
  RectangleType highrect,midrect,lowrect,*r;
  char tempostr[4];

  if (cmd == sysAppLaunchCmdNormalLaunch) {
    form=FrmInitForm(0);
    FrmSetEventHandler(form,&eventhandled);
    settext(OBJ(TEMPO),"120",4);
    settext(OBJ(TIMENUM),"4",3);
    settext(OBJ(TIMEDEN),"4",3);
    settext(OBJ(STRONGBEATS),"2",2);
    CtlSetValue(OBJ(METOFF),1);
    CtlSetValue(OBJ(METSOUND),1);
    RctSetRectangle(&highrect,0,0,160,160);
    RctSetRectangle(&midrect,80,0,80,160);
    RctSetRectangle(&lowrect,0,0,80,160);
    FrmDrawForm(form);
    FrmSetActiveForm(form);
    do {
      curtick=TimGetTicks();
      EvtGetEvent( &event, (nexttick==0&&halftick==0)?-1:((nexttick>curtick||halftick>curtick)?((halftick>curtick)?(halftick-curtick):(nexttick-curtick)):(0)) );
      curtick=TimGetTicks();
      if(event.eType==ctlEnterEvent) {
        if(event.data.ctlEnter.controlID <12) {
          sndcmd.cmd=sndCmdNoteOn;
          sndcmd.param1=60+event.data.ctlEnter.controlID;
          sndcmd.param2=10000;
          sndcmd.param3=127;
          SndDoCmd(NULL,&sndcmd,0);
          playingtune=1;
        }
        if(event.data.ctlEnter.controlID == TAPTEMPO) {
          if(curtick-lasttap<SysTicksPerSecond()*3) {
            ticksperbeat=(ticksperbeat*numtaps+curtick-lasttap)/(numtaps+1);
            numtaps++;
            tempo=SysTicksPerSecond()*4*60/ticksperbeat/timeden;
            StrIToA(tempostr,tempo);
            resettext(OBJ(TEMPO),tempostr);
            FldDrawField(OBJ(TEMPO));
            if(nexttick-curtick<ticksperbeat/2)
              nexttick=curtick;
            else
              nexttick=curtick+ticksperbeat;
          } else
            numtaps=0;
          lasttap=curtick;
        }
      }
      if(event.eType==ctlSelectEvent || event.eType==ctlExitEvent) {
        if(playingtune) {
          sndcmd.cmd=sndCmdQuiet;
          sndcmd.param1=sndcmd.param2=sndcmd.param3=0;
          SndDoCmd(NULL,&sndcmd,0);
          playingtune=0;
        }
      }
      if(event.eType==ctlSelectEvent && event.data.ctlSelect.controlID==METON) {
        tempo=num(OBJ(TEMPO));
        timenum=num(OBJ(TIMENUM));
        timeden=num(OBJ(TIMEDEN));
        strongbeats=num(OBJ(STRONGBEATS));
        if(tempo==0 || timeden==0) {
          CtlSetValue(OBJ(METON),0);
          CtlSetValue(OBJ(METOFF),1);
        } else
          ticksperbeat=SysTicksPerSecond()*4*60/tempo/timeden;
        beatcount=0;
        nexttick=curtick;
      }
      if(halftick&&halftick<curtick) {
        halftick=0;
      }
      if(CtlGetValue(OBJ(METON))==0) {
        nexttick=0;
      } else {
        if(nexttick<curtick) {
          if(metsound) {
            if(playingtune==0) {
              sndcmd.cmd=sndCmdNoteOn;
              sndcmd.param2=10;
              if(beatcount==0) {
                sndcmd.param1=110;
                sndcmd.param3=110;
              } else {
                sndcmd.param1=105;
                sndcmd.param3=50;
                for(i=1;i<strongbeats;i++)
                  if((timenum*i+strongbeats-1)/strongbeats==beatcount)
                    sndcmd.param3=95;
              }
              SndDoCmd(NULL,&sndcmd,0);
            }
          }
          if(metlight) {
            if(beatcount==0) {
              r=&highrect;
            } else {
              r=&lowrect;
              for(i=1;i<strongbeats;i++)
                if((timenum*i+strongbeats-1)/strongbeats==beatcount)
                  r=&midrect;
            }
            WinEraseWindow();
            FrmDrawForm(form);
            WinDrawRectangle(r,0);
            halftick=(ticksperbeat>20)?(nexttick+10):(nexttick+ticksperbeat/2);
	  }            
          nexttick+=ticksperbeat;
          if(++beatcount>=timenum)
            beatcount=0;
        }
      }     
      if(event.eType==ctlSelectEvent && event.data.ctlSelect.controlID==METOFF) {
        WinEraseWindow();
        FrmDrawForm(form);
      }
      if(event.eType==ctlSelectEvent && event.data.ctlSelect.controlID==METLIGHT)
        metlight=!metlight;
      if(event.eType==ctlSelectEvent && event.data.ctlSelect.controlID==METSOUND)
        metsound=!metsound;
      CtlSetValue(OBJ(METLIGHT),metlight);
      CtlSetValue(OBJ(METSOUND),metsound);
      SysHandleEvent( &event );
      FrmDispatchEvent(&event);
    } while (event.eType != appStopEvent);
    FrmDeleteForm(form);
  }
  return;
}
