/******************************************************************************\
   Go81 Plays the game of go on PalmOS devices.
   Copyright (C) 2002-2004 Tapani Raiko

    this program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    this program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS for A PARTICULAR PURPOSE.  See the
    GNU General public License for more details.

    You should have received a copy of the GNU General public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
\******************************************************************************/
#ifndef Go81_h_included
#define Go81_h_included




#include "intset.h"

#define Go81AppID    'Go81'   
#define Go81DBType   'Data'   // 0x64415441 in hexadecimal

#define RECORD_INDEX_BOARD 0


#define BITMAPSIZE         (datab.boardsize==9 ? 15 : 11)
#define BITMAPSIZE_MARK     5
#define XOFFSET (datab.boardsize==9 ? 3 : 0)
//((160-datab.boardsize*BITMAPSIZE)/(int)2)
#define YOFFSET (datab.boardsize==9 ? 3 : 0)
//((160-datab.boardsize*BITMAPSIZE)/(int)2)
#define XOFFSET_MARK (XOFFSET+(BITMAPSIZE-BITMAPSIZE_MARK)/(int)2)
#define YOFFSET_MARK (YOFFSET+(BITMAPSIZE-BITMAPSIZE_MARK)/(int)2)
#define OFFSET_X_SCORE 60
#define OFFSET_Y_SCORE 147
#define OFFSET_X_CAPTURED 148
#define OFFSET_Y_CAPTURED 96

#define X2CHAR(x) ('A'+x+(x>7))
#define Y2INT(y) (datab.boardsize-y)


//Go81.cpp
void DrawBitmap(int bitmapID, int x, int y);
void WriteScore(int blackp, int whitep, float komi);


// utils
void my_memcpy(char *where,char *what,int howmuch);
void my_strcpy(char *where,char *what,int howmuch);
void my_memset(char *where,char what,int howmuch);

#ifndef _CONSOLE
  int rand(void); 
  #define RAND_MAX sysRandomMax
#endif






// Go81.h : main header file for the Go81 application
//

//#define DEFAULT_SIZE    10
//#define DEFAULT_HANDICAP  0

#define GO_EMPTY  0
#define GO_BORDER 1
#define GO_BLACK  2
#define GO_WHITE  3
#define COMP_COL(x) ((x) > 1 ? 5 - (x) : x)

#define GO_MARGI 2
#ifdef _CONSOLE
#define GO_LOGBOARDTABLESIZE 5
#define MAXBOARDSIZE   19
#define GO_MAX_N_GROUPS 300
#define INTSETMEMORY 5000
#else
#define GO_LOGBOARDTABLESIZE 4
#define MAXBOARDSIZE   13
#define GO_MAX_N_GROUPS 100
#define INTSETMEMORY 2000
#endif
#define GO_BOARDTABLESIZE (1 << GO_LOGBOARDTABLESIZE)
#define XY2POINT(x, y) ((x) + GO_MARGI + (((y) + GO_MARGI) << GO_LOGBOARDTABLESIZE))
#define POINT2X(p) ((p & (GO_BOARDTABLESIZE-1)) - GO_MARGI)
#define POINT2Y(p) ((p >> GO_LOGBOARDTABLESIZE) - GO_MARGI)
#define GO_MAXBOARDSIZE (GO_BOARDTABLESIZE - 2 * GO_MARGI)

// order matters
#define GO_PASS -1
#define GO_UNDECIDED -2
#define GO_NO_KO -3

#define POINT_PASS (XY2POINT(GO_PASS, GO_PASS))
#define POINT_UNDECIDED (XY2POINT(GO_UNDECIDED, GO_UNDECIDED))
#define POINT_NO_KO (XY2POINT(GO_NO_KO, GO_NO_KO))
#define POINT_RESIGN (XY2POINT(GO_PASS, GO_NO_KO))
#define POINT_NOT_HEALTHY (XY2POINT(GO_NO_KO, GO_PASS))
#define POINT_MIN_ONBOARD (XY2POINT(0,0))

#define ONOFF_SLOW            1
#define ONOFF_FUTUREFORALL    2


#define AGENT_NOTHING_TO_ANALYZE -777

#define LIBERTIES_FOR_TACTICAL_SAFETY 4

#define WORTHLIBE_TO_WORTH 1.7

// order is used!
#define GO_MOVE_PASS       0
#define GO_MOVE_NORMAL     1
#define GO_MOVE_CAPTURE    2
#define GO_MOVE_BENSON     3
#define GO_MOVE_SUICIDE    4
#define GO_MOVE_KO         5
#define GO_MOVE_SINGLESTONESUICIDE    6
#define GO_MOVE_UNEMPTY    7

#define GO_SUICIDE_ALLOWED true
#define GO_PASS_ALLOWED    true

// number of moves (-1) before taking something into use
#ifdef _CONSOLE
#define NMOVES_SLOW (-1)
#define NMOVES_VITAL (-1)
#define NMOVES_BENSON (-1)
#define NMOVES_NOPASSING (datab.boardsize*4-9)
#else
#define NMOVES_SLOW (datab.boardsize*2-9)
#define NMOVES_VITAL (datab.boardsize*3-9)
#define NMOVES_BENSON (datab.boardsize*4-9)
#define NMOVES_NOPASSING (datab.boardsize*4-9)
#endif

#define NFUTMOVES 200


// hood
#define HOOD_NORMAL      0
#define HOOD_OWNEYE      1
#define HOOD_OTHEREYE    2
#define HOOD_FUSEKI      3
#define HOOD_EMPTY3OR4   4
#define HOOD_EMPTY2OR5PLUS 5
#define HOOD_EMPTY1      6
#define HOOD_33AFTER44   7
#define HOOD_OWNTIGER    8
#define HOOD_OTHERTIGER  9
#define HOOD_ILLEGAL     10
#define HOOD_OUTDATED    11
#define HOOD_CUT_2ND_ROW 12

#define HISTORY_BLACK       0
#define HISTORY_WHITE       1 
#define HISTORY_EMPTY_BLACK 2
#define HISTORY_EMPTY_WHITE 3
#define HISTORY_OTHER       4

// order matters
#define STATUS_UNINITIALIZED 0
#define STATUS_STARTING      1
#define STATUS_CONTINUING    2
#define STATUS_PLAYING       3
#define STATUS_SCORE_ESTIMATED   4
#define STATUS_PLEASE_SCORE  5
#define STATUS_PALM2PASSED   6
#define STATUS_PASSED        7
#define STATUS_SCORING       8
#define STATUS_SCORED        9
#define STATUS_RESCORE       10

// group status
#define GS_UNKNOWN      0
#define GS_BENSON_ALIVE 1

#define COUNTING_CHINESE  0
#define COUNTING_JAPANESE 1
#define COUNTING_IGNORE   2

// Go81.cpp:

class Go81Database
{
public:
    char board[MAXBOARDSIZE*MAXBOARDSIZE];
    char turn;
    char status;
    int latest;
    int nmoves;
    int npasses;
    int current_ko_point;
    char blackplayer;
    char whiteplayer;
    char boardsize;
    signed char komi;
    char handicap;
    char counting;
    int prisoners_black;
    int prisoners_white;
};



static const lint Dir[8] = {-1, -GO_BOARDTABLESIZE, +1, +GO_BOARDTABLESIZE, 
                    -GO_BOARDTABLESIZE-1,-GO_BOARDTABLESIZE+1, +GO_BOARDTABLESIZE-1, +GO_BOARDTABLESIZE+1};

// player
class Player
{
public:
	Player();
	Player(int _color, char _human, int _onoff);
	void InitPlayer(int _color, char _human, int _onoff);
	~Player();
	int color;
	char human;
	class Agent *agent;
};



//GoAgent:
static int ScoreGame(char counting, lint *bscore, lint *wscore);
static lint ScoreMoveFuture(char origturn, lint origpoint);

class Group
{
public:
  Group();
  ~Group();
  Group &operator=(const Group &g);
  void Clean();
  lint AddLiberty(lint i);
  lint RemoveLiberty(lint i);
  lint AddLiberties(class IntSet *il);

  lint x;
  lint y;
  lint color;
  lint size;
  lint libe;
  lint status;
  class IntSet *stones, *liberties, *neighbours;
};


class Agent
{
public:
  Agent();
  Agent(lint _size, lint _color, lint _onoff);
  void InitAgent(lint _size, lint _color, lint _onoff);
  void Copy(const Agent &a);
  void CleanUpAgent();
  lint SelectPoint(lint turn, char slow, lint latest);
  lint GetAgentColor();
  void Benson(char bcolor, int **benson);

  lint MoveType(lint x, lint y, lint cont);
  bool IsLegal(lint x, lint y, lint cont);
  lint PlaceStone(lint x, lint y, lint cont);
  lint AgentInitBoard();
  lint GetCont(lint x, lint y);
  
  lint captured[GO_WHITE + 1];
  lint current_ko_point;
  lint onoff;
  char hoodtype[GO_BOARDTABLESIZE*GO_BOARDTABLESIZE];
  char movetype[GO_BOARDTABLESIZE*GO_BOARDTABLESIZE];
  float worth1[GO_BOARDTABLESIZE*GO_BOARDTABLESIZE];
  void SetCaptured(int bla, int whi);
  void GetCaptured(int *bla, int *whi);

  // private:
  lint SetCont(lint x, lint y, lint cont);
  lint UpdateCont(lint newg, lint oldg);
  lint CaptureGroup(lint pris);
  lint IsSimpleEye(lint x, lint y, lint cont);
  lint WhatIfHere(lint x, lint y, lint ifcolor, float *worth_libe, lint *liberties, lint *size,
                  lint *_libe_enemy);
  lint LibertiesIfHereMoreAccurate(lint s, lint turn);                
  void UpdateWorth1(lint turn, lint x, lint y);
  void AllowPlayingInSurviversLastLiberty();
  bool IsHealthy(lint x, lint y, lint color, int *benson);
  bool IsVital(lint point, lint gro);
  bool IsSafe(lint x, lint y, lint color, int *benson);
  void BorderVitalCheck(lint x,lint y);
  void CountNeutralSizes();
  
  lint size;
  char contents[GO_BOARDTABLESIZE*GO_BOARDTABLESIZE];
  class Group group[GO_MAX_N_GROUPS];
//  0..ngroups used
  lint temp_ko, ngroups;
  class IntSet *removed_groups;
  lint color;
};

bool legal(lint movetype);

int HoodType(Agent *agent, lint x, lint y, lint turn, lint *points);

#endif













































