#include "maxfreq.h"


void
maxfreq::node::remove()
{
	if (right)
		right->left = left;
	if (left->children == this)
		left->children = right;
	else
		left->right = right;

	//printf("Removing node %d\n", index);
}


void
maxfreq::node::addbefore(node *n)
{
	right = n;
	left = n->left;
	if (left->children == n)
		left->children = this;
	else
		left->right = this;
	n->left = this;
}

void
maxfreq::node::wedge(node *r)
{
	children = r->children;
	left = r;
	right = NULL;
	if (children)
		children->left = this;
	r->children = this;
}


maxfreq::maxfreq(uint32_t s) : m_nodes(s)
{
	for (uint32_t i = 0; i < s; i++)
		m_nodes[i].index = i;
	m_root.locked = true;
}


void
maxfreq::purge(node *n)
{
	node *cnext;
	for (node *c = n->children; c ; c = cnext) {
		cnext = c->right;
		if (c->freq() >= n->freq()) {
			c->merge(n);
			c->remove();
			c->addbefore(n);
			purge(c);
		}
		else
			break;
	}
	if (n->disposable()) n->remove();
}

void
maxfreq::clean(uint32_t i)
{
	//printf("Clean %d\n", i);
	node *n = &m_nodes[i];
	n->locked = false;

	while (n && n->disposable()) {
		node *r = n->left;
		if (r->children != n) r = NULL;
		n->remove();
		n = r;
	}
}

void
maxfreq::add(uint32_t i, double v)
{
	node *n = &m_nodes[i];
	n->sum = v;
	n->count = 1;
	n->wedge(&m_root);
	purge(n);
}
