#ifndef BORDER_H
#define BORDER_H

#include <stdint.h>
#include <vector>
#include "queue.h"
#include <algorithm>
#include <limits>

struct border {
	double min, max, score;
	int32_t index;
};

struct work {
	work() : min(std::numeric_limits<double>::max()), max(std::numeric_limits<double>::min()), sum(0), count(0) {}

	uint32_t ind;
	double min, max;
	double sum;
	uint32_t count;

	void add(double s) {sum += s; count++; min = std::min(min, sum / count); max = std::max(max, sum / count);}

	TAILQ_ENTRY(work) active;
};

TAILQ_HEAD(worklist, work);

typedef std::vector<work> workvector;
typedef std::vector<border> bordervector;


#endif
