#ifndef MAXFREQ_H
#define MAXFREQ_H

#include <stdint.h>
#include "queue.h"
#include <vector>

class maxfreq {
	public:
		maxfreq(uint32_t s);
		
		struct node {
			node() : locked(false), left(NULL), right(NULL), children(NULL) {}

			bool leaf() const {return children == NULL;}
			bool disposable() const {return leaf() && !locked;}

			double freq() const {return sum / count;}
			void merge(node *n)  {sum += n->sum; count += n->count;}

			void remove();
			void addbefore(node *n);
			void wedge(node *r);

			uint32_t index;

			bool locked;

			double sum;
			uint32_t count;

			node *left;
			node *right;
			node *children;
		};

		void lock(uint32_t i)  {m_nodes[i].locked = true;}
		void clean(uint32_t i);  
		void add(uint32_t i, double v);

		const node * max() {return m_root.children;}

	protected:
		void purge(node *n);
		void clean(node *n);

		typedef std::vector<node> nodevector;

		nodevector m_nodes;
		node m_root;
};

#endif
