#ifndef MINER_H
#define MINER_H

#include "itemset.h"
#include "seq_tree.h"
#include "dataset.h"
#include <list>
#include <limits>


struct params {
	params() : sup_threshold(0) {}
	uint32_t sup_threshold;

	struct rob {
		rob() : la(std::numeric_limits<double>::min()), threshold(0), set(false) {}
		double la;
		double threshold;
		bool set;
	} free, ts, ndi;
};



class miner {
	public:
		miner(const dataset & d, const params & p);
		~miner() {seq_tree::clean(&m_lattice);}

		void mine();

		itemsetvector itemsets();

	protected:
		typedef seq_tree::tree<uint32_t, itemset *> lattice;

		typedef std::list<lattice *> latticelist;
		typedef std::vector<lattice *> latticevector;

		void test(const uintvector & items, latticelist & cands);

		void expand(lattice *l, latticelist & cands);
		void expand(const latticelist & cands, latticelist & out);
		void init(latticelist & cands);

		lattice m_lattice;
		const dataset & m_data;
		struct params m_params;
		uint32_t m_itemcnt;
};

#endif
