#include "measure.h"
#include <math.h>

static uint32_t
bitcount(uint32_t i)
{
	i = i - ((i >> 1) & 0x55555555);
	i = (i & 0x33333333) + ((i >> 2) & 0x33333333);
	return ((i + (i >> 4) & 0xF0F0F0F) * 0x1010101) >> 24;
}



long double inline
term(uint32_t c, double la)
{
	if (c == 0) return 0;
	return 1 - exp(c*la);
}


long double
robustness_free(double la, const uintvector & cont)
{
	long double ret = 1;

	for (uint32_t i = 1; i < cont.size(); i *= 2)
		ret *= term(cont[cont.size() - i - 1], la);
	
	return ret;
}

long double
robustness_ts(double la, const uintvector & cont)
{
	long double ret = 1;

	for (uint32_t i = 0; i < cont.size(); i++)
		ret *= term(cont[i], la);

	return ret;
}

long double
robustness_ndi(double la, const uintvector & cont)
{
	long double ret1 = 1;
	long double ret2 = 1;
	for (uint32_t i = 0; i < cont.size(); i++)
		if (bitcount(i) % 2)
			ret1 *= term(cont[i], la);
		else
			ret2 *= term(cont[i], la);


	return 1 - (1 - ret1)*(1 - ret2);
}

