#include "itemset.h"


void
itemset::fillsup(uintvector & v, uint32_t index, uint32_t s, uint32_t d)  const
{
	v[index] = m_support;
	for (uint32_t i = s; i < m_items.size(); i++)
		m_parents[i]->fillsup(v, index - (1 << (i + d)), i, d + 1);
}


void
itemset::qie(uintvector & v) const
{
	for (uint32_t l = 2; l <= v.size(); l *= 2)
		for (uint32_t i = 0; i < v.size(); i += l)
			for (uint32_t j = 0; j < l / 2; j++)
				v[i + j] -= v[i + j + l / 2];
}


void
itemset::print(FILE *out, const char *format) const
{
	while (*format) {
		if (*format != '%') {
			fputc(*format, out);
			format++;
			continue;
		}
		format++;

		switch(*format) {
			case 'i':
				if (m_items.size() > 0)
					fprintf(out, "%u", m_items[0]);
				for (uint32_t i = 1; i < m_items.size(); i++)
					fprintf(out, " %u", m_items[i]);
				format++;
				break;
			case 't':
				fprintf(out, "%u", m_support);
				format++;
				break;
			case 'f':
				fprintf(out, "%Lf", m_free);
				format++;
				break;
			case 's':
				fprintf(out, "%Lf", m_ts);
				format++;
				break;
			case 'n':
				fprintf(out, "%Lf", m_ndi);
				format++;
				break;
			case 0:
				break;
			default:
				fputc(*format, out);
				format++;
				break;
		}
	}
	fprintf(out, "\n");
}
