#ifndef GRAPH_H
#define GRAPH_H

#include <stdint.h>
#include <stdio.h>
#include <vector>

#include <boost/graph/graph_traits.hpp>
#include <boost/graph/subgraph.hpp>
#include <boost/graph/adjacency_list.hpp>


typedef double weight_t;

/*
struct density {
	weight_w;
	uint32_t ind;

	bool operator < (const density & a) const {return w < a.w;}
};
*/

typedef std::vector<weight_t> weightvector;
typedef std::vector<uint32_t> intvector;
typedef std::vector<bool> boolvector;

//typedef std::vector<density> densityvector;


typedef boost::adjacency_list<
	boost::vecS,
	boost::vecS,
	boost::undirectedS,
	boost::property<boost::vertex_name_t, uint32_t>,
	boost::property<boost::edge_weight_t, weight_t,
	boost::property<boost::edge_index_t, int>
	> > graph;


typedef boost::graph_traits<graph>::edge_iterator eiterator;
typedef boost::graph_traits<graph>::out_edge_iterator oiterator;
typedef boost::graph_traits<graph>::vertex_iterator viterator;
typedef boost::graph_traits<graph>::adjacency_iterator aiterator;

typedef boost::graph_traits<graph>::vertex_descriptor vertex;
typedef std::vector<vertex> vertexvector;

typedef boost::property_map<graph, boost::vertex_name_t>::type namemap;
typedef boost::property_map<graph, boost::vertex_index_t>::type indexmap;
typedef boost::property_map<graph, boost::edge_weight_t>::type weightmap;


graph* read(const char *name, bool weighted, bool duplicate);

void order(graph & g, weightvector & w, intvector & ord);
double vertexweights(graph & g, weightvector & w);

struct compinfo {
	compinfo() : totalw(0) {}
	struct edge {
		uint32_t i, j;
		weight_t w;
	};

	typedef std::vector<edge> edgelist;
		
	weightvector w;
	weightvector innerw;
	edgelist edges;
	vertexvector vertices;
	weight_t totalw;
};

void init(graph & g, compinfo & c);
void split(const compinfo & c, const boolvector & cut, compinfo & pos, compinfo & neg);
void set(graph & g, const compinfo & c, intvector & out, uint32_t v);


std::pair<double, uint32_t> compact(graph & g, const compinfo & c, double alpha, boolvector & cut);

void print(FILE *out, graph & g, const weightvector & w, const intvector & ord);
void print(FILE *out, graph & g, const intvector & ord, const intvector & groups);





#endif
