#ifndef BORDER_H
#define BORDER_H

#include <stdint.h>
#include <vector>

struct block {
	double s;
	uint32_t size;

	double freq() const {return s / size;};

	bool operator <= (const block & a) const {return s * a.size <= a.s * size;}

	void operator += (const block & a) {s += a.s; size += a.size;}
};

typedef std::vector<block> blockvector;


template <class W>
void
border(const W & w, blockvector & out)
{
	blockvector h(w.size());
	uint32_t hs = 0;

	for (uint32_t i = 0; i < w.size(); i++) {
		h[hs].s = w[i];
		h[hs].size = 1;
		hs++;

		while (hs > 1 && h[hs - 1] <= h[hs - 2]) {
			h[hs - 2] += h[hs - 1];
			hs--;
		}

		out[i] = h[hs - 1];
	}
}

#endif
