#include "order.h"
#include <map>
#include <limits>


struct node {
	uint32_t index;
	double weight;
};

typedef std::multimap<double, node> nodemap;
typedef std::vector<nodemap::iterator> nodevector;
typedef std::vector<bool> boolvector;

uintvector
order(const graph & g, const uintvector & seed)
{
	boolvector active(g.size(), true);
	nodemap nm;
	nodevector nv(g.size());
	uintvector perm(g.size());

	for (uint32_t i = 0; i < nv.size(); i++) {
		node n;
		n.index = i;
		n.weight = g.wdeg(i);

		nv[i] = nm.insert(std::make_pair(n.weight, n));
	}

	// Remove seeds
	for (uint32_t i = 0; i < seed.size(); i++) {
		uint32_t s = seed[i];
		nm.erase(nv[s]);
		active[s] = false;
		perm[s] = i;
	}

	for (int32_t i = nv.size() - 1; i >= int32_t(seed.size()); i--) {
		node n = nm.begin()->second;
		uint32_t s = n.index;
		nm.erase(nm.begin());
		active[s] = false;
		perm[s] = i;

		for (uint32_t j = 0; j < g.nbhdsize(s); j++) {
			uint32_t t = g.nbhd(s, j);
			if (!active[t]) continue;
			node m = nv[t]->second;
			m.weight -= g.weight(s, j);
			nm.erase(nv[t]);
			nv[t] = nm.insert(std::make_pair(m.weight, m));
		}
	}
	return perm;
}
