#include "graph.h"
#include <algorithm>
#include <string>
#include <iostream>
#include <sstream>

void
graph::readweighted(FILE *f)
{
	uint32_t cnt = 0;
	uint32_t a, b;
	double r;
	m_minid = 1;


	while (fscanf(f, "%d%d%lf", &a, &b, &r) == 3) {
		cnt = std::max(cnt, a);
		cnt = std::max(cnt, b);
		if (a == 0 || b == 0) m_minid = 0;
	}

	cnt -= m_minid;

	uintvector d(cnt + 1);
	doublevector w(cnt + 1);

	rewind(f);
	while (fscanf(f, "%d%d%lf", &a, &b, &r) == 3) {
		d[a - m_minid]++;
		w[a - m_minid]+=r;
		//d[b]++;
	}

	m_nodes.resize(cnt + 1);
	for (uint32_t i = 0; i <= cnt; i++) {
		m_nodes[i].edges.reserve(d[i]);
		m_nodes[i].weights.assign(d[i], 1);
		m_nodes[i].relevance.reserve(d[i]);
		std::stringstream ss;
		ss << (i + m_minid);
		m_nodes[i].label = ss.str();
	}

	rewind(f);
	while (fscanf(f, "%d%d%lf", &a, &b, &r) == 3) {
		m_nodes[a - m_minid].edges.push_back(b - m_minid);
		m_nodes[a - m_minid].relevance.push_back(r / w[a - m_minid]);
	}
}

void
graph::read(FILE *f)
{
	uint32_t cnt = 0;
	uint32_t a, b;
	m_minid = 1;

	while (fscanf(f, "%d%d", &a, &b) == 2) {
		cnt = std::max(cnt, a);
		cnt = std::max(cnt, b);
		if (a == 0 || b == 0) m_minid = 0;
	}

	cnt -= m_minid;

	uintvector d(cnt + 1);

	rewind(f);
	while (fscanf(f, "%d%d", &a, &b) == 2) {
		d[a - m_minid]++;
		//d[b]++;
	}

	m_nodes.resize(cnt + 1);
	for (uint32_t i = 0; i <= cnt; i++) {
		m_nodes[i].edges.reserve(d[i]);
		m_nodes[i].weights.assign(d[i], 1);
		if (d[i] > 0)
			m_nodes[i].relevance.assign(d[i], 1.0 / d[i]);
		std::stringstream ss;
		ss << (i + m_minid);
		m_nodes[i].label = ss.str();
	}

	rewind(f);
	while (fscanf(f, "%d%d", &a, &b) == 2) {
		m_nodes[a - m_minid].edges.push_back(b - m_minid);
		//m_nodes[b].edges.push_back(a);
	}
}

void
graph::permute(const uintvector & p)
{
	for (uint32_t i = 0; i < size(); i++) {
		for (uint32_t j = 0; j < nbhdsize(i); j++)
			nbhd(i, j) = p[nbhd(i, j)];
	}

	nodevector temp(size());

	for (uint32_t i = 0; i < size(); i++)
		temp[p[i]].swap(m_nodes[i]);

	temp.swap(m_nodes);
}

void
graph::update_pre()
{
	for (uint32_t i = 0; i < size(); i++) {
		m_nodes[i].prew = 0;
		m_nodes[i].prevar = 0;
		m_nodes[i].predeg = 0;
		for (uint32_t j = 0; j < nbhdsize(i); j++) {
			//printf("%d %d %d %f\n", i, nbhd(i, j), j, weight(i, j));
			if (nbhd(i, j) < i) {
				m_nodes[i].prew += weight(i, j);
				m_nodes[i].prevar += weight(i, j)*weight(i, j);
				m_nodes[i].predeg++;
			}
		}
	}
}

void
graph::print_pre() const
{
	double w = 0;
	double f = 1;
	uint32_t k = 0;
	for (uint32_t i = 1; i < size(); i++) {
		if (w / f > m_nodes[i].prew / i) k++; 
		w = m_nodes[i].prew;
		f = i; 
		//printf("%f\n", m_nodes[i].prew / i);
		printf("%e\n", w / f);
	}
	printf("%d\n", k);
}

void
graph::set_weights_normalized(const doublevector & w)
{
	for (uint32_t i = 0; i < size(); i++) {
		wdeg(i) = 0;
		for (uint32_t j = 0; j < nbhdsize(i); j++) {
			uint32_t k = nbhd(i, j);
			weight(i, j) = w[i] / nbhdsize(i) + w[k] / nbhdsize(k);
			wdeg(i) += weight(i, j);
		}
	}
}
void
graph::set_weights_sum(const doublevector & w)
{
	for (uint32_t i = 0; i < size(); i++) {
		wdeg(i) = 0;
		for (uint32_t j = 0; j < nbhdsize(i); j++) {
			uint32_t k = nbhd(i, j);
			weight(i, j) = w[i] + w[k];
			wdeg(i) += weight(i, j);
		}
	}
}
void
graph::set_weights_min(const doublevector & w)
{
	for (uint32_t i = 0; i < size(); i++) {
		wdeg(i) = 0;
		for (uint32_t j = 0; j < nbhdsize(i); j++) {
			uint32_t k = nbhd(i, j);
			weight(i, j) = std::min(w[i], w[k]);
			wdeg(i) += weight(i, j);
		}
	}
}



void
graph::prwr(doublevector & out, double alpha, const uintvector & seed, uint32_t cnt) const
{
	out.assign(size(), 0);
	doublevector t = out;
	for (uint32_t k = 0; k < cnt; k++) {
		t.assign(size(), 0);

		//step
		for (uint32_t i = 0; i < out.size(); i++) {
			for (uint32_t j = 0; j < nbhdsize(i); j++)
				t[nbhd(i, j)] += relevance(i, j)*out[i];
		}

		// normalize
		double s = 0;
		for (uint32_t i = 0; i < out.size(); i++)
			s += t[i];
		if (s == 0) s = 1; // Cheap trick
		for (uint32_t i = 0; i < out.size(); i++)
			t[i] *= (1 - alpha) / s;
		
		// restart
		for (uint32_t i = 0; i < seed.size(); i++)
			t[seed[i]] += alpha / seed.size();


		out.swap(t);
	}
}
