%avRowColE = calcRankError(DX,DY)
%
%Calculates an average row and column cumulative rank distribution function
%errors of randomized DY compared to original DX. The result is a vector
%where the first value is the average result for rows and the second for
%columns. A small rank cdf error means that the rows or columns have
%approximately the same values as the original matrix. Theoretically the
%maximum is near 2 (but this a non-real-life extremity). 

function avRowColE = calcRankError(DX,DY)

X = getScaledRankMatrixWithFixedEqualValues(DX);
Y = getScaledRankMatrixWithFixedEqualValues(DY);

if(isfield(DX,'elem2row')) %sparse
    n = numel(DX.elem2row);
%     X=sparse(double(DX.elem2row),double(DX.elem2col),(1:n)/n,DX.rows,DX.cols);
%     Y=sparse(double(DY.elem2row),double(DY.elem2col),(1:n)/n,DY.rows,DY.cols);
else
    n=numel(DX.pos2elem);
%     X=double(DX.pos2elem)/n; 
%     Y=double(DY.pos2elem)/n;
end

colE = calcColumnErrorDistr(X,Y);
rowE = calcColumnErrorDistr(X',Y');

avRowColE = [full(sum(rowE)/n)  full(sum(colE)/n)];
end

function colE = calcColumnErrorDistr(X,Y)
X = sort(X); Y = sort(Y);
colE = sum(abs(X-Y));
end
