% d = calcRankDist(DX,DY)
%
% Calculates a distance between two rank discretizations DX and DY. The
% distance resembles scaled Frobenius distance. For full permutation matrix
% the distance is approximately sqrt(2) for full matrices. 

function d = calcRankDist(DX,DY)

X = getScaledRankMatrixWithFixedEqualValues(DX);
Y = getScaledRankMatrixWithFixedEqualValues(DY);

if(isfield(DX,'elem2row')) %sparse    
    n = numel(DX.elem2row);    
    %X = sparse(double(DX.elem2row),double(DX.elem2col),1:n,DX.rows,DX.cols);
    %Y = sparse(double(DY.elem2row),double(DY.elem2col),1:n,DY.rows,DY.cols);
    d = sqrt(sum(nonzeros(X-Y).^2)/n) / std(nonzeros(X));
    
    ind = sub2ind(size(X),double(DX.elem2row),double(DX.elem2col));
    zeroInY = Y(ind) == 0;
    
    d = mean(zeroInY) * sqrt(2) + mean(~zeroInY) * sqrt(sum((X(ind(~zeroInY)) - Y(ind(~zeroInY))).^2)/sum(~zeroInY))/std(nonzeros(X));
    
else
    n = numel(DX.pos2elem);
    %X = double(DX.pos2elem)/n; 
    %Y = double(DY.pos2elem)/n;    
    d = sqrt(mean((X(:)-Y(:)).^2)) / std(X(:));
end
end
