% d = calcRankDiff(DX,DY)
%
% Calculates a simple difference between discretizations DX and DY. 
%
% It is the proportion of elements (ranks) in DY that are not in the same
% place as in DX, thus being in range [0,1] for full matrices - value of 1
% means that the matrices are fully different and that DY is well randomized. 
%
%For sparse matrices only the nonzero elements in X are considered.

function d = calcRankDiff(DX,DY)

if(isfield(DX,'elem2row')) %sparse
    n = numel(DX.elem2row);   
    Y=sparse(double(DY.elem2row),double(DY.elem2col),1:n,DY.rows,DY.cols);    
    d = full(mean((1:n)' ~= Y(sub2ind(size(Y),double(DX.elem2row),double(DX.elem2col)))));
else
    d = mean(DX.pos2elem(:) ~= DY.pos2elem(:));
end
end
