/*
 * Decompiled with CFR 0.152.
 */
import gnu.trove.TLongIntHashMap;

public class SwapParse {
    private long realChanges;
    private long attempts;
    private long rows;
    private int[] elem2row;
    private int[] elem2col;
    private int[][] elem2rowIndexRange;
    private int[][] elem2colIndexRange;

    private long elemLongPosition(long l, long l2) {
        return l + this.rows * l2;
    }

    public long getRealChanges() {
        return this.realChanges;
    }

    public long getAttempts() {
        return this.attempts;
    }

    public double getAcceptanceRate() {
        return (double)this.realChanges / (double)this.attempts;
    }

    public int[] getElem2Row() {
        return this.elem2row;
    }

    public int[] getElem2Col() {
        return this.elem2col;
    }

    public int[][] getElem2RowIndexRange() {
        return this.elem2rowIndexRange;
    }

    public int[][] getElem2ColIndexRange() {
        return this.elem2colIndexRange;
    }

    public SwapParse(int[] nArray, int[] nArray2, int[][] nArray3, int[][] nArray4, long l, long l2, MersenneTwisterFast mersenneTwisterFast) {
        this.attempts = l2;
        this.rows = l;
        this.elem2row = nArray;
        this.elem2col = nArray2;
        this.elem2rowIndexRange = nArray3;
        this.elem2colIndexRange = nArray4;
        int n = nArray.length;
        TLongIntHashMap tLongIntHashMap = new TLongIntHashMap(2 * n);
        for (int i = 0; i < n; ++i) {
            tLongIntHashMap.put(this.elemLongPosition(nArray[i], nArray2[i]), i);
        }
        for (long i = 0L; i < l2; ++i) {
            int n2;
            int n3;
            boolean bl;
            boolean bl2;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            if (mersenneTwisterFast.nextInt(2) == 0) {
                n9 = mersenneTwisterFast.nextInt(n);
                n8 = nArray3[n9][0] + mersenneTwisterFast.nextInt(nArray3[n9][1] - nArray3[n9][0] + 1);
                n7 = nArray[n9];
                n6 = nArray[n8];
                n5 = nArray2[n9];
                n4 = nArray2[n8];
                if (n7 == n6 || n5 == n4 || nArray3[n8][0] > n9 || n9 > nArray3[n8][1]) continue;
                bl2 = tLongIntHashMap.containsKey(this.elemLongPosition(n7, n4));
                bl = tLongIntHashMap.containsKey(this.elemLongPosition(n6, n5));
                if (!bl2 && !bl) {
                    this.performSparseRowSwap(tLongIntHashMap, n9, n8, n7, n6, n5, n4);
                    continue;
                }
                if (!bl2 || !bl || nArray4[n3 = tLongIntHashMap.get(this.elemLongPosition(n7, n4))][0] > (n2 = tLongIntHashMap.get(this.elemLongPosition(n6, n5))) || n2 > nArray4[n3][1] || nArray4[n2][0] > n3 || n3 > nArray4[n2][1]) continue;
                this.performFullSwap(tLongIntHashMap, n9, n8, n3, n2, n7, n6, n5, n4);
                continue;
            }
            n9 = mersenneTwisterFast.nextInt(n);
            n8 = nArray4[n9][0] + mersenneTwisterFast.nextInt(nArray4[n9][1] - nArray4[n9][0] + 1);
            n7 = nArray[n9];
            n6 = nArray[n8];
            n5 = nArray2[n9];
            n4 = nArray2[n8];
            if (n7 == n6 || n4 == n5 || nArray4[n8][0] > n9 || n9 > nArray4[n8][1]) continue;
            bl2 = tLongIntHashMap.containsKey(this.elemLongPosition(n7, n4));
            bl = tLongIntHashMap.containsKey(this.elemLongPosition(n6, n5));
            if (!bl2 && !bl) {
                this.performSparseColSwap(tLongIntHashMap, n9, n8, n7, n6, n4, n5);
                continue;
            }
            if (!bl2 || !bl || nArray3[n3 = tLongIntHashMap.get(this.elemLongPosition(n7, n4))][0] > (n2 = tLongIntHashMap.get(this.elemLongPosition(n6, n5))) || n2 > nArray3[n3][1] || nArray3[n2][0] > n3 || n3 > nArray3[n2][1]) continue;
            this.performFullSwap(tLongIntHashMap, n3, n2, n9, n8, n7, n6, n4, n5);
        }
    }

    private void performFullSwap(TLongIntHashMap tLongIntHashMap, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.elem2row[n] = n6;
        this.elem2row[n2] = n5;
        this.elem2col[n3] = n7;
        this.elem2col[n4] = n8;
        tLongIntHashMap.put(this.elemLongPosition(n5, n7), n3);
        tLongIntHashMap.put(this.elemLongPosition(n5, n8), n2);
        tLongIntHashMap.put(this.elemLongPosition(n6, n7), n);
        tLongIntHashMap.put(this.elemLongPosition(n6, n8), n4);
        int[] nArray = this.elem2rowIndexRange[n];
        this.elem2rowIndexRange[n] = this.elem2rowIndexRange[n2];
        this.elem2rowIndexRange[n2] = nArray;
        nArray = this.elem2colIndexRange[n3];
        this.elem2colIndexRange[n3] = this.elem2colIndexRange[n4];
        this.elem2colIndexRange[n4] = nArray;
        ++this.realChanges;
    }

    private void performSparseRowSwap(TLongIntHashMap tLongIntHashMap, int n, int n2, int n3, int n4, int n5, int n6) {
        this.elem2row[n] = n4;
        this.elem2row[n2] = n3;
        tLongIntHashMap.remove(this.elemLongPosition(n3, n5));
        tLongIntHashMap.put(this.elemLongPosition(n3, n6), n2);
        tLongIntHashMap.put(this.elemLongPosition(n4, n5), n);
        tLongIntHashMap.remove(this.elemLongPosition(n4, n6));
        int[] nArray = this.elem2rowIndexRange[n];
        this.elem2rowIndexRange[n] = this.elem2rowIndexRange[n2];
        this.elem2rowIndexRange[n2] = nArray;
        ++this.realChanges;
    }

    private void performSparseColSwap(TLongIntHashMap tLongIntHashMap, int n, int n2, int n3, int n4, int n5, int n6) {
        this.elem2col[n] = n5;
        this.elem2col[n2] = n6;
        tLongIntHashMap.put(this.elemLongPosition(n3, n5), n);
        tLongIntHashMap.remove(this.elemLongPosition(n3, n6));
        tLongIntHashMap.put(this.elemLongPosition(n4, n6), n2);
        tLongIntHashMap.remove(this.elemLongPosition(n4, n5));
        int[] nArray = this.elem2colIndexRange[n];
        this.elem2colIndexRange[n] = this.elem2colIndexRange[n2];
        this.elem2colIndexRange[n2] = nArray;
        ++this.realChanges;
    }
}

