public class ModSwap extends LocalModificatorGreedyRotation{  
    private int rowClasses, colClasses;
    private int[] RD, RCN, RCI; //row: discretized matrix, elems in class, index of each element in each class
    private int[][] RCIR, RCIC; //row: rows and cols of elems in classes   
    private int[] CD, CCN, CCI; //col: discretized matrix, elems in class, index of each element in each class
    private int[][] CCIR, CCIC; //col: rows and cols of elems in classes   
    
    public ModSwap(int rowClasses, int colClasses) { setParams(rowClasses, colClasses); }
    public ModSwap(int classes) { this(classes, classes); }
    public ModSwap() { hasParams = false; }
    public void setParams(int rowClasses, int colClasses) { this.rowClasses = rowClasses; this.colClasses = colClasses; hasParams = true; }
    public String getParams() { return "" + rowClasses + "," + colClasses; }
    
    public void init(double[][] A){
        super.init(A);
        
        RD = new int[size];
        RCN = new int[rowClasses];
        RCI = new int[size]; 

        CD = new int[size];
        CCN = new int[colClasses];
        CCI = new int[size]; 
        
        //discretization
        int k = 0;
        for(int col = 0; col < cs; col++){
            for(int row = 0; row < rs; row++){
                RD[k] = Math.min(rowClasses-1, (int)(rowClasses*A[row][col]));
                RCI[k] = RCN[RD[k]]++;
                CD[k] = Math.min(colClasses-1, (int)(colClasses*A[row][col]));
                CCI[k] = CCN[CD[k]]++;
                P[row][col] = k++;
            }
        }
        
        //init data structures for classes
        
        RCIR = new int[rowClasses][];
        RCIC = new int[rowClasses][];
        
        CCIR = new int[colClasses][];
        CCIC = new int[colClasses][];


        for(int i = 0; i < rowClasses; i++){
            RCIR[i] = new int[RCN[i]];
            RCIC[i] = new int[RCN[i]];
        }

        for(int i = 0; i < colClasses; i++){
            CCIR[i] = new int[CCN[i]];
            CCIC[i] = new int[CCN[i]];
        }
        
        for(int row = 0; row < rs; row++){
            for(int col = 0; col < cs; col++){
                RCIR[RD[P[row][col]]][RCI[P[row][col]]] = row;
                RCIC[RD[P[row][col]]][RCI[P[row][col]]] = col;
                
                CCIR[CD[P[row][col]]][CCI[P[row][col]]] = row;
                CCIC[CD[P[row][col]]][CCI[P[row][col]]] = col;
            }
        }  
        
    }    
    
    public boolean select(){
        if(rowClasses < colClasses){
            int elem = randGen.nextInt(size);
            rows[0] = elem % rs;
            cols[0] = elem / rs;
            
            int colClass = CD[P[rows[0]][cols[0]]];
            elem = randGen.nextInt(CCN[colClass]);
            rows[1] = CCIR[colClass][elem];
            cols[1] = CCIC[colClass][elem];
            
            return updateSelection() && RD[P[rows[0]][cols[1]]] == RD[P[rows[1]][cols[0]]];
        } 
        else{            
            int elem = randGen.nextInt(size);
            rows[0] = elem % rs;
            cols[1] = elem / rs;
            
            int rowClass = RD[P[rows[0]][cols[1]]];
            elem = randGen.nextInt(RCN[rowClass]);
            rows[1] = RCIR[rowClass][elem];
            cols[0] = RCIC[rowClass][elem];
            
            return updateSelection() && CD[P[rows[0]][cols[0]]] == CD[P[rows[1]][cols[1]]];
        }
    }
    
    public void perform(){
        super.perform();        

        for(int row : rows){
            for(int col : cols){
                int p = P[row][col];
                RCIR[RD[p]][RCI[p]] = row;
                RCIC[RD[p]][RCI[p]] = col;

                CCIR[CD[p]][CCI[p]] = row;
                CCIC[CD[p]][CCI[p]] = col;
            }
        }
    }    
}
